/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.toolbox;

import fable.framework.logging.FableLogger;
import fable.framework.toolbox.TypedText;
import java.text.DecimalFormat;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Composite;

public class FloatText
extends TypedText {
    protected Float fieldValue = null;
    protected Float minValue;
    protected Float maxValue;
    protected boolean maxIsIncluded = false;
    protected boolean minIsIncluded = false;
    private Logger logger;

    public FloatText(Composite parent, int style) {
        super(parent, style);
    }

    public FloatText(Composite parent, int style, String LabelText) {
        super(parent, style, LabelText);
        this.logger = FableLogger.getLogger();
    }

    public FloatText(Composite parent, int style, String LabelText, float minValue, float maxValue) {
        this(parent, style, LabelText);
        this.setMinValue(minValue, true);
        this.setMaxValue(maxValue, true);
    }

    public Float getValue() {
        return this.fieldValue;
    }

    public void setMaxValue(float max, boolean bIsInclude) {
        this.maxIsIncluded = bIsInclude;
        this.maxValue = new Float(max);
    }

    public void setMinValue(float min, boolean bIsInclude) {
        this.minIsIncluded = bIsInclude;
        this.minValue = new Float(min);
    }

    @Override
    public boolean set_Text(String txt) {
        return super.set_Text(txt);
    }

    @Override
    public String getText() {
        new DecimalFormat();
        String s = this.getTextField().getText();
        return s;
    }

    @Override
    public boolean checkValue(String str) {
        boolean bok;
        block17: {
            bok = true;
            if (str != null && !str.equals("")) {
                this._errorMessage = "Field should contain a float value ";
                try {
                    this.fieldValue = Float.valueOf(str);
                    if (this.maxValue != null && this.minValue != null) {
                        if (this.minIsIncluded && this.maxIsIncluded) {
                            bok = Float.compare(this.fieldValue.floatValue(), this.minValue.floatValue()) >= 0 && Float.compare(this.fieldValue.floatValue(), this.maxValue.floatValue()) <= 0;
                            this._errorMessage = String.valueOf(this._errorMessage) + "between " + this.minValue + " and " + this.maxValue;
                        } else if (!this.minIsIncluded && this.maxIsIncluded) {
                            bok = Float.compare(this.fieldValue.floatValue(), this.minValue.floatValue()) > 0 && Float.compare(this.fieldValue.floatValue(), this.maxValue.floatValue()) <= 0;
                            this._errorMessage = String.valueOf(this._errorMessage) + " greater than " + this.minValue + " and less or equal to " + this.maxValue;
                        } else if (this.minIsIncluded && !this.maxIsIncluded) {
                            bok = Float.compare(this.fieldValue.floatValue(), this.minValue.floatValue()) >= 0 && Float.compare(this.fieldValue.floatValue(), this.maxValue.floatValue()) < 0;
                            this._errorMessage = String.valueOf(this._errorMessage) + " greater or equal to " + this.minValue + " and less than " + this.maxValue;
                        } else if (!this.minIsIncluded && !this.maxIsIncluded) {
                            bok = Float.compare(this.fieldValue.floatValue(), this.minValue.floatValue()) > 0 && Float.compare(this.fieldValue.floatValue(), this.maxValue.floatValue()) < 0;
                            this._errorMessage = String.valueOf(this._errorMessage) + " greater than " + this.minValue + " and less than " + this.maxValue;
                        }
                        break block17;
                    }
                    if (this.minValue != null && this.maxValue == null) {
                        if (this.minIsIncluded) {
                            bok = Float.compare(this.fieldValue.floatValue(), this.minValue.floatValue()) >= 0;
                            this._errorMessage = String.valueOf(this._errorMessage) + " greater or equal to " + this.minValue;
                        } else {
                            bok = Float.compare(this.fieldValue.floatValue(), this.minValue.floatValue()) > 0;
                            this._errorMessage = String.valueOf(this._errorMessage) + " greater than " + this.minValue;
                        }
                        break block17;
                    }
                    if (this.minValue != null || this.maxValue == null) break block17;
                    if (this.maxIsIncluded) {
                        bok = Float.compare(this.fieldValue.floatValue(), this.maxValue.floatValue()) <= 0;
                        this._errorMessage = String.valueOf(this._errorMessage) + " and less or equal to " + this.maxValue;
                        break block17;
                    }
                    bok = Float.compare(this.fieldValue.floatValue(), this.maxValue.floatValue()) < 0;
                    this._errorMessage = String.valueOf(this._errorMessage) + " less than " + this.maxValue;
                }
                catch (NumberFormatException e) {
                    bok = false;
                    this.logger.error((Object)e.getMessage());
                }
            } else if (this._isRequiredField) {
                bok = false;
            }
        }
        return bok;
    }

    @Override
    protected String getErrorFormatDescription() {
        return this._errorMessage;
    }

    public void setText(String string) {
        this.set_Text(string);
    }
}

