/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.toolbox;

import fable.framework.logging.FableLogger;
import fable.framework.toolbox.ExceptionMessageDialog;
import java.io.File;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

public class FableUtils {
    public static final String LS = System.getProperty("line.separator");

    public static String generateIDMessage(Object object, String msg) {
        String id;
        if (object == null) {
            return msg;
        }
        if (object instanceof String) {
            id = (String)object;
        } else if (object instanceof Class) {
            try {
                id = ((Class)object).getName();
            }
            catch (Throwable throwable) {
                id = object.toString();
            }
        } else {
            try {
                id = object.getClass().getName();
            }
            catch (Throwable throwable) {
                id = object.toString();
            }
        }
        if (id.length() == 0) {
            return msg;
        }
        if (msg == null) {
            return id;
        }
        return String.valueOf(id) + ": " + msg;
    }

    public static void excTraceMsg(Object id, final String msg, final Throwable t) {
        final String throwableName = t instanceof Error ? "Error" : "Exception";
        String fullMsg = String.valueOf(msg) + LS + LS + throwableName + ": " + t + LS + "Message: " + t.getMessage();
        FableLogger.error(FableUtils.generateIDMessage(id, fullMsg), t);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ExceptionMessageDialog.openException(null, throwableName, msg, t);
            }
        });
    }

    public static void excMsg(Object id, String msg, Throwable t) {
        final String throwableName = t instanceof Error ? "Error" : "Exception";
        final String fullMsg = String.valueOf(msg) + LS + LS + throwableName + ": " + t + LS + "Message: " + t.getMessage();
        FableLogger.error(FableUtils.generateIDMessage(id, fullMsg), t);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError(null, (String)throwableName, (String)fullMsg);
            }
        });
    }

    public static void excNoTraceMsg(Object id, String msg, Throwable t) {
        final String throwableName = t instanceof Error ? "Error" : "Exception";
        final String fullMsg = String.valueOf(msg) + LS + LS + throwableName + ": " + t + LS + "Message: " + t.getMessage();
        FableLogger.error(FableUtils.generateIDMessage(id, fullMsg));
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError(null, (String)throwableName, (String)fullMsg);
            }
        });
    }

    public static void errMsg(Object id, final String msg) {
        FableLogger.error(FableUtils.generateIDMessage(id, msg));
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError(null, (String)"Error", (String)msg);
            }
        });
    }

    public static void warnMsg(Object id, final String msg) {
        FableLogger.warn(FableUtils.generateIDMessage(id, msg));
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning(null, (String)"Warning", (String)msg);
            }
        });
    }

    public static void infoMsg(Object id, final String msg) {
        FableLogger.info(FableUtils.generateIDMessage(id, msg));
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation(null, (String)"Info", (String)msg);
            }
        });
    }

    public static boolean confirmMsg(Object id, String msg) {
        boolean confirm = false;
        confirm = MessageDialog.openConfirm(null, (String)"Confirm", (String)msg);
        return confirm;
    }

    public static String getShortName(String fileName) {
        File file = new File(fileName);
        if (file == null) {
            return null;
        }
        return file.getName();
    }

    public static String getExtension(File file) {
        return FableUtils.getExtension(file.getName());
    }

    public static String getExtension(String fileName) {
        String ext = null;
        int i = fileName.lastIndexOf(46);
        if (i > 0 && i < fileName.length() - 1) {
            ext = fileName.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static String changeFileExtension(String fileName, String newExtension) {
        if (fileName == null || newExtension == null) {
            return null;
        }
        int lastDot = fileName.lastIndexOf(".");
        if (lastDot != -1) {
            return String.valueOf(fileName.substring(0, lastDot)) + newExtension;
        }
        return String.valueOf(fileName) + newExtension;
    }

    public static int questionMsg(String message) {
        String[] buttons = new String[]{"OK", "Cancel", "No"};
        MessageDialog dialog = new MessageDialog(null, "Question", null, message, 3, buttons, 0);
        return dialog.open();
    }
}

