/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.imageprint;

import fable.framework.imageprint.ImagePrintUtils;
import fable.framework.imageprint.PrintSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ImagePrintSetupDialog
extends Dialog {
    private static final int TEXT_WIDTH = 75;
    private static final int CANVAS_BORDER = 10;
    private static final Point CANVAS_SIZE = new Point(300, 300);
    private Point canvasSize = CANVAS_SIZE;
    public static final String[][] hAlignNames = new String[][]{{"Left", Integer.toString(16384)}, {"Center", Integer.toString(0x1000000)}, {"Right", Integer.toString(131072)}, {"Fill", Integer.toString(4)}};
    public static final String[][] vAlignNames = new String[][]{{"Top", Integer.toString(128)}, {"Center", Integer.toString(0x1000000)}, {"Bottom", Integer.toString(1024)}, {"Fill", Integer.toString(4)}};
    private PrintSettings settings;
    private Image image;
    private Canvas canvas;
    private Text leftText;
    private Text rightText;
    private Text topText;
    private Text bottomText;
    private Combo hAlignCombo;
    private Combo vAlignCombo;
    private Button landscapeButton;
    private Button portraitButton;
    private boolean success = false;

    public ImagePrintSetupDialog(Shell parent, Image image, PrintSettings settings) {
        this(parent, 2144, image, settings);
    }

    public ImagePrintSetupDialog(Shell parent, int style, Image image, PrintSettings settings) {
        super(parent, style);
        this.image = image != null ? new Image(image.getDevice(), image, 0) : null;
        this.settings = settings != null ? settings.clone() : new PrintSettings();
    }

    public PrintSettings open() {
        Display display = this.getParent().getDisplay();
        Shell shell = new Shell(this.getParent(), this.getStyle() | 0x10);
        shell.setText("Print Setup");
        this.createContents(shell);
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (this.image != null && !this.image.isDisposed()) {
            this.image.dispose();
            this.image = null;
        }
        if (this.success) {
            return this.settings;
        }
        return null;
    }

    private void createContents(final Shell shell) {
        int val;
        GridLayout grid = new GridLayout();
        grid.numColumns = 1;
        shell.setLayout((Layout)grid);
        Composite top = new Composite((Composite)shell, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)top);
        grid = new GridLayout();
        grid.numColumns = 2;
        top.setLayout((Layout)grid);
        Composite controls = new Composite(top, 0);
        GridDataFactory.fillDefaults().applyTo((Control)controls);
        grid = new GridLayout();
        grid.numColumns = 1;
        controls.setLayout((Layout)grid);
        Composite preview = new Composite(top, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)preview);
        grid = new GridLayout();
        grid.numColumns = 1;
        preview.setLayout((Layout)grid);
        if (this.image != null) {
            this.canvas = new Canvas(preview, 2048);
            GridDataFactory.fillDefaults().grab(true, true).hint(this.canvasSize).applyTo((Control)this.canvas);
            this.canvas.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent ev) {
                    ImagePrintSetupDialog.this.paint(ev);
                }
            });
        }
        Group group = new Group(controls, 0);
        group.setText("Margins");
        grid = new GridLayout();
        grid.numColumns = 4;
        group.setLayout((Layout)grid);
        GridDataFactory.fillDefaults().applyTo((Control)group);
        Label label = new Label((Composite)group, 0);
        label.setText("Left");
        this.leftText = new Text((Composite)group, 133124);
        this.leftText.setText(this.settings.getLeftString());
        this.leftText.setToolTipText("Set the left margin");
        GridDataFactory.fillDefaults().hint(75, -1).applyTo((Control)this.leftText);
        this.leftText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                String text = ImagePrintSetupDialog.this.leftText.getText();
                PrintSettings.ValueWithUnits vwu = ImagePrintSetupDialog.this.settings.parseUnitsString(text);
                PrintSettings.ValueWithUnits vwu1 = ImagePrintSetupDialog.this.settings.scaleToInches(vwu);
                ImagePrintSetupDialog.this.settings.setLeft(vwu1.getVal());
                ImagePrintSetupDialog.this.leftText.setText(ImagePrintSetupDialog.this.settings.getLeftString());
                ImagePrintSetupDialog.this.canvas.redraw();
            }
        });
        label = new Label((Composite)group, 0);
        label.setText("Right");
        this.rightText = new Text((Composite)group, 133124);
        this.rightText.setText(this.settings.getRightString());
        this.rightText.setToolTipText("Set the right margin");
        GridDataFactory.fillDefaults().hint(75, -1).applyTo((Control)this.rightText);
        this.rightText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                String text = ImagePrintSetupDialog.this.rightText.getText();
                PrintSettings.ValueWithUnits vwu = ImagePrintSetupDialog.this.settings.parseUnitsString(text);
                PrintSettings.ValueWithUnits vwu1 = ImagePrintSetupDialog.this.settings.scaleToInches(vwu);
                ImagePrintSetupDialog.this.settings.setRight(vwu1.getVal());
                ImagePrintSetupDialog.this.rightText.setText(ImagePrintSetupDialog.this.settings.getRightString());
                ImagePrintSetupDialog.this.canvas.redraw();
            }
        });
        label = new Label((Composite)group, 0);
        label.setText("Top");
        this.topText = new Text((Composite)group, 133124);
        this.topText.setText(this.settings.getTopString());
        this.topText.setToolTipText("Set the top margin");
        GridDataFactory.fillDefaults().hint(75, -1).applyTo((Control)this.topText);
        this.topText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                String text = ImagePrintSetupDialog.this.topText.getText();
                PrintSettings.ValueWithUnits vwu = ImagePrintSetupDialog.this.settings.parseUnitsString(text);
                PrintSettings.ValueWithUnits vwu1 = ImagePrintSetupDialog.this.settings.scaleToInches(vwu);
                ImagePrintSetupDialog.this.settings.setTop(vwu1.getVal());
                ImagePrintSetupDialog.this.topText.setText(ImagePrintSetupDialog.this.settings.getTopString());
                ImagePrintSetupDialog.this.canvas.redraw();
            }
        });
        label = new Label((Composite)group, 0);
        label.setText("Bottom");
        this.bottomText = new Text((Composite)group, 133124);
        this.bottomText.setText(this.settings.getBottomString());
        this.bottomText.setToolTipText("Set the bottom margin");
        GridDataFactory.fillDefaults().hint(75, -1).applyTo((Control)this.bottomText);
        this.bottomText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                String text = ImagePrintSetupDialog.this.bottomText.getText();
                PrintSettings.ValueWithUnits vwu = ImagePrintSetupDialog.this.settings.parseUnitsString(text);
                PrintSettings.ValueWithUnits vwu1 = ImagePrintSetupDialog.this.settings.scaleToInches(vwu);
                ImagePrintSetupDialog.this.settings.setBottom(vwu1.getVal());
                ImagePrintSetupDialog.this.bottomText.setText(ImagePrintSetupDialog.this.settings.getBottomString());
                ImagePrintSetupDialog.this.canvas.redraw();
            }
        });
        group = new Group(controls, 0);
        group.setText("Alignment");
        grid = new GridLayout();
        grid.numColumns = 2;
        group.setLayout((Layout)grid);
        GridDataFactory.fillDefaults().applyTo((Control)group);
        label = new Label((Composite)group, 0);
        label.setText("Horizontal");
        this.hAlignCombo = new Combo((Composite)group, 0);
        this.hAlignCombo.setToolTipText("Set the horizontal alignment");
        GridDataFactory.fillDefaults().hint(75, -1).applyTo((Control)this.hAlignCombo);
        int len = hAlignNames.length;
        int curItem = -1;
        String[] items = new String[len];
        int i = 0;
        while (i < len) {
            items[i] = hAlignNames[i][0];
            val = Integer.parseInt(hAlignNames[i][1]);
            if (val == this.settings.getHorizontalAlign()) {
                curItem = i;
            }
            ++i;
        }
        this.hAlignCombo.setItems(items);
        this.hAlignCombo.select(curItem);
        this.hAlignCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = ImagePrintSetupDialog.this.hAlignCombo.getSelectionIndex();
                int val = Integer.parseInt(hAlignNames[idx][1]);
                ImagePrintSetupDialog.this.settings.setHorizontalAlign(val);
                ImagePrintSetupDialog.this.canvas.redraw();
            }
        });
        label = new Label((Composite)group, 0);
        label.setText("Vertical");
        this.vAlignCombo = new Combo((Composite)group, 0);
        this.vAlignCombo.setToolTipText("Set the horizontal alignment");
        GridDataFactory.fillDefaults().hint(75, -1).applyTo((Control)this.vAlignCombo);
        len = vAlignNames.length;
        items = new String[len];
        i = 0;
        while (i < len) {
            items[i] = vAlignNames[i][0];
            val = Integer.parseInt(vAlignNames[i][1]);
            if (val == this.settings.getVerticalAlign()) {
                curItem = i;
            }
            ++i;
        }
        this.vAlignCombo.setItems(items);
        this.vAlignCombo.select(curItem);
        this.vAlignCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = ImagePrintSetupDialog.this.vAlignCombo.getSelectionIndex();
                int val = Integer.parseInt(vAlignNames[idx][1]);
                ImagePrintSetupDialog.this.settings.setVerticalAlign(val);
                ImagePrintSetupDialog.this.canvas.redraw();
            }
        });
        group = new Group(controls, 0);
        group.setText("Units");
        grid = new GridLayout();
        grid.numColumns = 3;
        group.setLayout((Layout)grid);
        GridDataFactory.fillDefaults().applyTo((Control)group);
        Button button = new Button((Composite)group, 16);
        button.setText("in");
        button.setToolTipText("Set default units to inches");
        button.setSelection(this.settings.getUnits() == PrintSettings.Units.INCH);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImagePrintSetupDialog.this.settings.setUnits(PrintSettings.Units.INCH);
                ImagePrintSetupDialog.this.resetMarginStrings();
            }
        });
        button = new Button((Composite)group, 16);
        button.setText("cm");
        button.setToolTipText("Set default units to centimeters");
        button.setSelection(this.settings.getUnits() == PrintSettings.Units.CENTIMETER);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImagePrintSetupDialog.this.settings.setUnits(PrintSettings.Units.CENTIMETER);
                ImagePrintSetupDialog.this.resetMarginStrings();
            }
        });
        button = new Button((Composite)group, 16);
        button.setText("mm");
        button.setSelection(this.settings.getUnits() == PrintSettings.Units.MILLIMETER);
        button.setToolTipText("Set default units to millimeters");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImagePrintSetupDialog.this.settings.setUnits(PrintSettings.Units.MILLIMETER);
                ImagePrintSetupDialog.this.resetMarginStrings();
            }
        });
        group = new Group(controls, 0);
        group.setText("Orientation");
        grid = new GridLayout();
        grid.numColumns = 2;
        group.setLayout((Layout)grid);
        GridDataFactory.fillDefaults().applyTo((Control)group);
        this.portraitButton = new Button((Composite)group, 16);
        this.portraitButton.setText("Portrait");
        this.portraitButton.setToolTipText("Use Portrait for the preview");
        this.portraitButton.setSelection(this.settings.getOrientation() != PrintSettings.Orientation.LANDSCAPE);
        this.portraitButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImagePrintSetupDialog.this.settings.setOrientation(PrintSettings.Orientation.PORTRAIT);
                ImagePrintSetupDialog.this.canvas.redraw();
            }
        });
        this.landscapeButton = new Button((Composite)group, 16);
        this.landscapeButton.setText("Landscape");
        this.landscapeButton.setToolTipText("Use Portrait for the preview");
        this.landscapeButton.setSelection(this.settings.getOrientation() == PrintSettings.Orientation.LANDSCAPE);
        this.landscapeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImagePrintSetupDialog.this.settings.setOrientation(PrintSettings.Orientation.LANDSCAPE);
                ImagePrintSetupDialog.this.canvas.redraw();
            }
        });
        label = new Label((Composite)group, 0);
        label.setText("Note: The orientation is for the preview\nThe printer orientation will still have to\nbe set for the printer when you print.");
        GridDataFactory.fillDefaults().span(new Point(2, 1)).applyTo((Control)label);
        Composite composite = new Composite(controls, 0);
        grid = new GridLayout();
        grid.numColumns = 2;
        composite.setLayout((Layout)grid);
        GridDataFactory.fillDefaults().applyTo((Control)composite);
        button = new Button(composite, 8);
        button.setText("Select Printer");
        button.setToolTipText("Select a printer (Will not actually print)");
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)composite);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                PrintDialog dialog = new PrintDialog(shell);
                PrinterData printerData = dialog.open();
                if (printerData == null) {
                    return;
                }
                ImagePrintSetupDialog.this.settings.setPrinterData(printerData);
                ImagePrintSetupDialog.this.canvas.redraw();
            }
        });
        button = new Button(composite, 8);
        button.setText("Print");
        button.setToolTipText("Print now");
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)composite);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                ImagePrintUtils.dialogPrintImage(shell, ImagePrintSetupDialog.this.image, shell.getDisplay().getDPI(), ImagePrintSetupDialog.this.settings);
            }
        });
        Composite bottom = new Composite((Composite)shell, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)bottom);
        FormLayout form = new FormLayout();
        bottom.setLayout((Layout)form);
        Button cancelButton = new Button(bottom, 8);
        FormData cancelData = new FormData();
        cancelData.top = new FormAttachment((Control)group, 8);
        cancelData.right = new FormAttachment(100, -4);
        cancelButton.setLayoutData((Object)cancelData);
        cancelButton.setText("&Cancel");
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                ImagePrintSetupDialog.this.success = false;
                shell.close();
            }
        });
        Button okButton = new Button(bottom, 8);
        FormData okData = new FormData();
        okData.top = new FormAttachment((Control)group, 8);
        okData.right = new FormAttachment((Control)cancelButton, -8);
        okButton.setLayoutData((Object)okData);
        okButton.setText("&OK");
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                ImagePrintSetupDialog.this.success = true;
                shell.close();
            }
        });
    }

    private void resetMarginStrings() {
        this.leftText.setText(this.settings.getLeftString());
        this.rightText.setText(this.settings.getRightString());
        this.topText.setText(this.settings.getTopString());
        this.bottomText.setText(this.settings.getBottomString());
    }

    private void paint(PaintEvent ev) {
        GC gc = ev.gc;
        Rectangle canvasBounds = this.canvas.getClientArea();
        canvasBounds.x += 10;
        canvasBounds.y += 10;
        canvasBounds.width -= 20;
        canvasBounds.height -= 20;
        ImagePrintUtils.paintPreview(gc, this.canvas, canvasBounds, this.image, this.settings);
    }

    public Point getCanvasSize() {
        return this.canvasSize;
    }

    public void setCanvasSize(Point canvasSize) {
        this.canvasSize = canvasSize;
    }
}

