/*
 * Decompiled with CFR 0.152.
 */
package fable.fitallb.actions;

import fable.fitallb.Activator;
import fable.fitallb.editors.FitAllB;
import fable.fitallb.editors.FitAllBeditor;
import fable.fitallb.editors.ProgramThread;
import fable.fitallb.internal.FitAllBException;
import fable.fitallb.internal.IVarKeys;
import fable.framework.toolbox.FableUtils;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class RunAction
extends Action
implements IWorkbenchWindowActionDelegate,
IViewActionDelegate,
IEditorActionDelegate {
    private static final String ID = "fable.fitallb.actionLaunch";
    IWorkbenchWindow window;
    FitAllB fitallb;
    private String currentDirectory = null;
    private String fileName = null;
    private FitAllBeditor currentEditor = null;
    protected String programName;
    public static int ANSWER_YES = 0;
    public static int ANSWER_CANCEL = 1;

    public void dispose() {
    }

    public RunAction() {
        this.setImageDescriptor(Activator.getImageDescriptor("icons/run.gif"));
        this.setToolTipText("Run fitallb with active input editor");
        this.setText("Run Fitallb");
        this.programName = IVarKeys.MODE_FITALLB;
    }

    public void init(IWorkbenchWindow windowArg) {
        this.window = windowArg;
        this.setImageDescriptor(Activator.getImageDescriptor("icons/run.gif"));
        this.setText("Run Fitallb");
        this.setToolTipText("Run Fitallb with current input editor");
        this.setId(ID);
    }

    public void run(IAction action) {
        this.launchFitallB();
    }

    private void launchFitallB() {
        int answer = 0;
        if (this.currentDirectory != null && this.fileName != null) {
            answer = this.confirmSave();
            if (answer != ANSWER_CANCEL) {
                try {
                    this.fitallb = new FitAllB();
                    this.fitallb.setProgram(this.programName);
                    this.fitallb.setCurrentDirectory(this.currentDirectory);
                    this.fitallb.setInputFile(this.fileName);
                    this.fitallb.setEndOfProgram(false);
                    if (FableUtils.confirmMsg((Object)((Object)this), (String)("Do you want to run " + IVarKeys.getProgramScriptName(this.programName) + " in the current directory " + this.currentDirectory + " with the current file " + this.fileName + " ?"))) {
                        Job job = new Job(String.valueOf(IVarKeys.getProgramScriptName(this.programName)) + " -i " + this.fileName){
                            ProgramThread p;
                            {
                                this.p = new ProgramThread("FitAllb -i " + RunAction.this.fileName, RunAction.this.fitallb);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            protected IStatus run(IProgressMonitor monitor) {
                                monitor.beginTask("Work in progresss for " + IVarKeys.getProgramScriptName(RunAction.this.programName) + " with input file " + RunAction.this.fileName, -1);
                                this.p.start();
                                while (!RunAction.this.fitallb.hasFinished()) {
                                    1 var2_2 = this;
                                    synchronized (var2_2) {
                                        try {
                                            ((Object)((Object)this)).wait(1000L);
                                        }
                                        catch (InterruptedException e) {
                                            e.printStackTrace();
                                        }
                                        if (monitor.isCanceled()) {
                                            File kill = new File(RunAction.this.fitallb.getKillFile());
                                            try {
                                                kill.createNewFile();
                                            }
                                            catch (IOException e) {
                                                FableUtils.excNoTraceMsg((Object)((Object)this), (String)"Error creating a file to kill  Fitallb", (Throwable)e);
                                            }
                                            monitor.subTask("A cancel operation has been required. \nPlease wait while program is ending...");
                                        }
                                    }
                                }
                                if (monitor.isCanceled()) {
                                    monitor.done();
                                    return Status.CANCEL_STATUS;
                                }
                                monitor.done();
                                return Status.OK_STATUS;
                            }
                        };
                        job.setUser(true);
                        job.schedule();
                    }
                }
                catch (FitAllBException e) {
                    FableUtils.errMsg((Object)ID, (String)e.getMessage());
                }
            }
        } else {
            FableUtils.errMsg((Object)((Object)this), (String)"FitAllb cannot be launched. Filename or current directory not found");
        }
    }

    private int confirmSave() {
        int answer = ANSWER_YES;
        if (this.currentEditor != null && this.currentEditor.isDirty() && (answer = FableUtils.questionMsg((String)("'" + this.fileName + "' has changed.\n\n" + "Do you want to save it before running ?"))) == ANSWER_YES) {
            this.currentEditor.doSave(null);
        }
        return answer;
    }

    public void run() {
        this.currentEditor = this.getActiveEditor();
        if (this.currentEditor != null) {
            this.fileName = this.currentEditor.getFileName();
            this.currentDirectory = this.currentEditor.getCurrentDirectory();
        }
        this.launchFitallB();
    }

    private FitAllBeditor getActiveEditor() {
        IEditorPart part;
        IWorkbenchPage page;
        FitAllBeditor fitalb = null;
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (part = page.getActiveEditor()) instanceof FitAllBeditor) {
            fitalb = (FitAllBeditor)part;
        }
        return fitalb;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection sSelection;
        Object first;
        if (selection instanceof IStructuredSelection && (first = (sSelection = (IStructuredSelection)selection).getFirstElement()) instanceof org.eclipse.core.internal.resources.File) {
            File file = ((org.eclipse.core.internal.resources.File)first).getLocation().toFile();
            this.fileName = file.getName();
            this.currentDirectory = file.getParent();
        }
    }

    public void init(IViewPart view) {
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        if (targetEditor instanceof FitAllBeditor) {
            this.currentEditor = (FitAllBeditor)targetEditor;
            this.fileName = this.currentEditor.getFileName();
            this.currentDirectory = this.currentEditor.getCurrentDirectory();
        } else {
            this.currentDirectory = null;
            this.fileName = null;
            this.currentEditor = null;
        }
    }
}

