/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.util.BitSet;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.export._Exporter;
import org.jmol.g3d.Font3D;
import org.jmol.modelset.Atom;
import org.jmol.shape.Text;

public class _MayaExporter
extends _Exporter {
    private int nBalls = 0;
    private int nCyl = 0;
    private String name;
    private String id;

    public _MayaExporter() {
        this.use2dBondOrderCalculation = false;
    }

    public void getHeader() {
        this.output.append("//  Maya ASCII 8.5 scene\n");
        this.output.append("//  Name: ball_stripped.ma\n");
        this.output.append("//  Last modified: Thu, Jul 5, 2007 10:25:55 PM\n");
        this.output.append("//  Codeset: UTF-8\n");
        this.output.append("requires maya \"8.5\";\n");
        this.output.append("currentUnit -l centimeter -a degree -t film;\n");
        this.output.append("fileInfo \"application\" \"maya\";\n");
        this.output.append("fileInfo \"product\" \"Maya Unlimited 8.5\";\n");
        this.output.append("fileInfo \"version\" \"8.5\";\n");
        this.output.append("fileInfo \"cutIdentifier\" \"200612170012-692032\";\n");
        this.output.append("fileInfo \"osv\" \"Mac OS X 10.4.9\";  \n");
    }

    public void getFooter() {
    }

    public void renderAtom(Atom atom, short s) {
        ++this.nBalls;
        this.name = "nurbsSphere" + this.nBalls;
        this.id = "nurbsSphereShape" + this.nBalls;
        this.output.append("createNode transform -n \"" + this.name + "\";\n");
        this.setAttr("t", atom);
        this.output.append("createNode nurbsSurface -n \"" + this.id + "\" -p \"" + this.name + "\";\n");
        this.addAttr();
        this.output.append("createNode makeNurbSphere -n \"make" + this.name + "\";\n");
        this.output.append(" setAttr \".ax\" -type \"double3\" 0 1 0;\n");
        this.setAttr("r", (float)atom.getMadAtom() / 2000.0f);
        this.setAttr("s", 4);
        this.setAttr("nsp", 3);
        this.addConnect();
    }

    public void fillCylinder(Point3f point3f, Point3f point3f2, short s, short s2, byte by, int n, int n2) {
        if (s == s2) {
            this.renderCylinder(point3f, point3f2, s, by, n);
            return;
        }
        this.tempV2.set(point3f2);
        this.tempV2.add(point3f);
        this.tempV2.scale(0.5f);
        this.tempP1.set(this.tempV2);
        this.renderCylinder(point3f, this.tempP1, s, by, n);
        this.renderCylinder(this.tempP1, point3f2, s2, by, n);
    }

    public void renderCylinder(Point3f point3f, Point3f point3f2, short s, byte by, int n) {
        ++this.nCyl;
        this.name = "nurbsCylinder" + this.nCyl;
        this.id = "nurbsCylinderShape" + this.nCyl;
        this.output.append(" createNode transform -n \"" + this.name + "\";\n");
        float f = point3f.distance(point3f2);
        this.tempV1.set(point3f2);
        this.tempV1.add(point3f);
        this.tempV1.scale(0.5f);
        this.setAttr("t", this.tempV1);
        this.tempV1.sub(point3f);
        this.setAttr("r", this.getRotation(this.tempV1));
        this.output.append(" createNode nurbsSurface -n \"" + this.id + "\" -p \"" + this.name + "\";\n");
        this.addAttr();
        this.output.append("createNode makeNurbCylinder -n \"make" + this.name + "\";\n");
        this.output.append(" setAttr \".ax\" -type \"double3\" 0 1 0;\n");
        float f2 = (float)n / 2000.0f;
        this.setAttr("r", f2);
        this.setAttr("s", 4);
        this.setAttr("hr", f / f2);
        this.addConnect();
    }

    private void setAttr(String string, float f) {
        this.output.append(" setAttr \"." + string + "\" " + f + ";\n");
    }

    private void setAttr(String string, int n) {
        this.output.append(" setAttr \"." + string + "\" " + n + ";\n");
    }

    private void setAttr(String string, Tuple3f tuple3f) {
        this.output.append(" setAttr \"." + string + "\" -type \"double3\" " + tuple3f.x + " " + tuple3f.y + " " + tuple3f.z + ";\n");
    }

    private void addAttr() {
        this.output.append(" setAttr -k off \".v\";\n");
        this.output.append(" setAttr \".vir\" yes;\n");
        this.output.append(" setAttr \".vif\" yes;\n");
        this.output.append(" setAttr \".tw\" yes;\n");
        this.output.append(" setAttr \".covm[0]\"  0 1 1;\n");
        this.output.append(" setAttr \".cdvm[0]\"  0 1 1;\n");
    }

    private void addConnect() {
        this.output.append(" connectAttr \"make" + this.name + ".os\" \"" + this.id + ".cr\";\n");
        this.output.append("connectAttr \"" + this.id + ".iog\" \":initialShadingGroup.dsm\" -na;\n");
    }

    public void renderIsosurface(Point3f[] point3fArray, short s, short[] sArray, Vector3f[] vector3fArray, int[][] nArray, BitSet bitSet, int n, int n2) {
    }

    public void renderText(Text text) {
    }

    public void drawString(short s, String string, Font3D font3D, int n, int n2, int n3, int n4) {
    }

    public void fillCylinder(short s, byte by, int n, Point3f point3f, Point3f point3f2) {
    }

    public void fillScreenedCircleCentered(short s, int n, int n2, int n3, int n4) {
    }

    public void drawPixel(short s, int n, int n2, int n3) {
    }

    public void drawTextPixel(int n, int n2, int n3, int n4) {
    }

    public void fillTriangle(short s, Point3f point3f, Point3f point3f2, Point3f point3f3) {
    }

    public void fillCone(short s, byte by, int n, Point3f point3f, Point3f point3f2) {
    }

    public void fillSphereCentered(short s, int n, Point3f point3f) {
    }

    public void plotText(int n, int n2, int n3, int n4, String string, Font3D font3D) {
    }

    public void fillHermite(short s, int n, int n2, int n3, int n4, Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4) {
    }

    public void drawHermite(short s, int n, Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4) {
    }

    public void drawHermite(short s, boolean bl, boolean bl2, int n, Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4, Point3f point3f5, Point3f point3f6, Point3f point3f7, Point3f point3f8, int n2) {
    }
}

