/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.ui.navigator.IExtensionActivationListener;
import org.eclipse.ui.navigator.INavigatorActivationService;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorViewerDescriptor;

public class VisibilityAssistant
implements IExtensionActivationListener {
    private final INavigatorViewerDescriptor viewerDescriptor;
    private final Set programmaticVisibilityBindings = new HashSet();
    private final Set programmaticRootBindings = new HashSet();
    private final ListenerList listeners = new ListenerList();
    private final INavigatorActivationService activationService;

    public VisibilityAssistant(INavigatorViewerDescriptor aViewerDescriptor, INavigatorActivationService anActivationService) {
        Assert.isNotNull((Object)aViewerDescriptor);
        this.viewerDescriptor = aViewerDescriptor;
        this.activationService = anActivationService;
        this.activationService.addExtensionActivationListener(this);
    }

    public void dispose() {
        this.activationService.removeExtensionActivationListener(this);
    }

    public void bindExtensions(String[] theExtensions, boolean isRoot) {
        if (theExtensions == null) {
            return;
        }
        int i = 0;
        while (i < theExtensions.length) {
            this.programmaticVisibilityBindings.add(theExtensions[i]);
            if (isRoot) {
                this.programmaticRootBindings.add(theExtensions[i]);
            }
            ++i;
        }
        this.notifyClients();
    }

    public void addListener(VisibilityListener aListener) {
        this.listeners.add((Object)aListener);
    }

    public void removeListener(VisibilityListener aListener) {
        this.listeners.remove((Object)aListener);
    }

    private void notifyClients() {
        Object[] clients = this.listeners.getListeners();
        int i = 0;
        while (i < clients.length) {
            ((VisibilityListener)clients[i]).onVisibilityOrActivationChange();
            ++i;
        }
    }

    public boolean isVisibleAndActive(INavigatorContentDescriptor aContentDescriptor) {
        return this.isActive(aContentDescriptor) && this.isVisible(aContentDescriptor);
    }

    public boolean isActive(INavigatorContentDescriptor aContentDescriptor) {
        return this.activationService.isNavigatorExtensionActive(aContentDescriptor.getId());
    }

    public boolean isActive(String aContentExtensionId) {
        return this.activationService.isNavigatorExtensionActive(aContentExtensionId);
    }

    public boolean isVisible(INavigatorContentDescriptor aContentDescriptor) {
        return this.programmaticVisibilityBindings.contains(aContentDescriptor.getId()) || this.viewerDescriptor.isVisibleContentExtension(aContentDescriptor.getId());
    }

    public boolean isVisible(String aContentExtensionId) {
        return this.programmaticVisibilityBindings.contains(aContentExtensionId) || this.viewerDescriptor.isVisibleContentExtension(aContentExtensionId);
    }

    public boolean isRootExtension(String aContentExtensionId) {
        return this.programmaticRootBindings.contains(aContentExtensionId) || this.viewerDescriptor.isRootExtension(aContentExtensionId);
    }

    public void onExtensionActivation(String aViewerId, String[] theNavigatorExtensionIds, boolean isActive) {
        if (aViewerId.equals(this.viewerDescriptor.getViewerId())) {
            this.notifyClients();
        }
    }

    public static interface VisibilityListener {
        public void onVisibilityOrActivationChange();
    }
}

