/*
 * Decompiled with CFR 0.152.
 */
package fable.python.views;

import fable.framework.views.FableIOConsole;
import fable.python.jep.FableJep;
import fable.python.views.PythonPlotView;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import jep.Jep;
import jep.JepException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;

public class PythonConsole {
    static FableIOConsole pythonConsole;
    RunConsoleThread runConsoleThread = new RunConsoleThread();
    Jep jep = null;
    boolean consoleError = false;

    public PythonConsole() {
        pythonConsole = new FableIOConsole("Python Console");
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{pythonConsole});
    }

    public void run() {
        new Thread(this.runConsoleThread).start();
    }

    void evaluateCommand(String command) {
        if (this.jep == null) {
            pythonConsole.displayOut("There is no Jep Python object, please fix the problem and then try again !");
        } else {
            boolean plotCommand = false;
            if (command.length() > 7 && command.substring(0, 7).equalsIgnoreCase("plot.1d")) {
                String arrayToPlot = command.substring(command.indexOf(40) + 1, command.indexOf(41));
                this.plotArray(arrayToPlot);
                plotCommand = true;
            }
            if (!plotCommand) {
                try {
                    this.jep.eval("mystdout.clear()");
                    this.jep.eval(command);
                    this.jep.eval("res=mystdout.stdouttext");
                    this.jep.eval(null);
                    String commandOut = (String)this.jep.getValue("res");
                    pythonConsole.displayOut(commandOut);
                }
                catch (JepException e) {
                    pythonConsole.displayError(String.valueOf(e.getMessage().substring(e.getMessage().indexOf(62) + 3)) + "\n");
                }
            }
        }
    }

    private void plotArray(String _arrayName) {
        final String arrayName = _arrayName;
        try {
            this.jep.eval("res = " + arrayName + ".astype(numpy.float32).tostring()");
            final float[] arrayData = this.jep.getValue_floatarray("res");
            if (!Display.getDefault().isDisposed()) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            PythonPlotView pythonPlot = (PythonPlotView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.python.views.PythonPlotView", "0", 1);
                            if (pythonPlot != null) {
                                pythonPlot.plotArray(arrayName, arrayData);
                            }
                        }
                        catch (PartInitException e2) {
                            e2.printStackTrace();
                        }
                    }
                });
            }
        }
        catch (JepException e) {
            pythonConsole.displayError(String.valueOf(e.getMessage().substring(e.getMessage().indexOf(62) + 3)) + "\n");
        }
    }

    class RunConsoleThread
    implements Runnable {
        final Runtime runtime = Runtime.getRuntime();
        String outputMessage;

        RunConsoleThread() {
        }

        @Override
        public void run() {
            try {
                PythonConsole.this.jep = new FableJep().getJep();
                PythonConsole.this.jep.setInteractive(true);
                PythonConsole.this.jep.eval("import sys\n");
                PythonConsole.this.jep.eval("class mystdout:\n\tdef write(self, text):\n\t\tself.stdouttext += text\n\tdef clear(self):\n\t\tself.stdouttext = \"\"\n");
                PythonConsole.this.jep.eval("mystdout=mystdout()\n");
                PythonConsole.this.jep.eval("sys.stdout=mystdout");
                PythonConsole.this.jep.eval(null);
            }
            catch (JepException e) {
                e.printStackTrace();
            }
            pythonConsole.getInputStream();
            BufferedReader in = null;
            try {
                in = new BufferedReader(new InputStreamReader((InputStream)pythonConsole.getInputStream(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e1) {
                e1.printStackTrace();
            }
            String scriptFile = null;
            File file = null;
            FileInputStream fileStream = null;
            BufferedReader bufferedStream = null;
            boolean scriptInput = false;
            boolean scriptCommand = false;
            while (!PythonConsole.this.consoleError) {
                try {
                    String str = "";
                    String command = "";
                    int indent = 0;
                    scriptCommand = false;
                    if (!scriptInput) {
                        pythonConsole.displayOut(">>> ");
                        str = in.readLine();
                    } else {
                        str = bufferedStream.readLine();
                        if (str == null) {
                            str = "";
                            scriptInput = false;
                        }
                        pythonConsole.displayOut(String.valueOf(scriptFile) + ":>>> " + str + "\n");
                    }
                    if (str != null && str.length() > 10 && str.substring(0, 10).equals("script.run") && (file = new File(scriptFile = str.substring(str.indexOf(40) + 1, str.indexOf(41)))).exists()) {
                        fileStream = new FileInputStream(file);
                        bufferedStream = new BufferedReader(new InputStreamReader(fileStream));
                        if (fileStream.available() > 0) {
                            scriptInput = true;
                            scriptCommand = true;
                        }
                    }
                    if (scriptCommand) continue;
                    command = String.valueOf(str) + "\n";
                    if (str != null && str.length() > 1 && str.charAt(str.length() - 1) == ':') {
                        ++indent;
                    }
                    while (indent != 0) {
                        int noSpaces = 0;
                        if (!scriptInput) {
                            pythonConsole.displayOut("... ");
                            str = in.readLine();
                        } else {
                            str = bufferedStream.readLine();
                            if (str == null) {
                                str = "";
                                scriptInput = false;
                            }
                            pythonConsole.displayOut(String.valueOf(scriptFile) + ":... " + str + "\n");
                        }
                        command = String.valueOf(command) + str + "\n";
                        int i = 0;
                        while (i < str.length()) {
                            if (str.charAt(i) != ' ') break;
                            ++noSpaces;
                            ++i;
                        }
                        indent = noSpaces / 4;
                    }
                    PythonConsole.this.evaluateCommand(command);
                }
                catch (IOException iOException) {
                    PythonConsole.this.consoleError = true;
                }
            }
        }
    }
}

