/*
 * Decompiled with CFR 0.152.
 */
package fable.fitallb.wizard;

import fable.fitallb.Activator;
import fable.fitallb.editors.FitAllB;
import fable.fitallb.wizard.FitallbInputWizardPage1;
import fable.fitallb.wizard.IInputPage;
import fable.fitallb.wizard.InputWizard;
import fable.framework.toolbox.FloatText;
import fable.framework.toolbox.FloatTextAppender;
import fable.framework.toolbox.TypedText;
import java.io.BufferedWriter;
import java.io.IOException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class OutlierRejectionPageFarField
extends WizardPage
implements IInputPage {
    private FloatTextAppender skip;
    private FloatText min_refl;
    private FloatText overlap;
    private Button rejMultiYes;
    private Button rejMultiNo;
    private FloatText rej_ia;
    private FloatText rej_vol;
    private FloatText rej_median;
    private FloatText rej_resmean;
    private FitAllB fitAllB;

    protected OutlierRejectionPageFarField(String pageName, FitAllB fit) {
        super(pageName);
        this.setTitle("Outlier Rejection - Far-field detector");
        this.setDescription("Set first detector option for outlier rejection here.");
        this.fitAllB = fit;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        GridData gd = new GridData(768);
        container.setLayoutData((Object)gd);
        Label label = new Label(container, 0);
        label.setText("Skip:");
        this.skip = new FloatTextAppender(container, 0, " ");
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.skip.setLayoutData((Object)gd);
        label = new Label(container, 0);
        label.setText("Minimum Number of Reflections [1, inf]:");
        this.min_refl = new FloatText(container, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.min_refl.setLayoutData((Object)gd);
        label = new Label(container, 0);
        label.setText("Overlap:");
        this.overlap = new FloatText(container, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.overlap.setLayoutData((Object)gd);
        label = new Label(container, 0);
        label.setText("Reject peaks assigned to multiple grains:");
        this.rejMultiYes = new Button(container, 16);
        this.rejMultiYes.setText("Yes");
        this.rejMultiNo = new Button(container, 16);
        this.rejMultiNo.setText("No");
        label = new Label(container, 0);
        label.setText("Outlier Rejection Limits In Term Of :");
        gd = new GridData(770);
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        label = new Label(container, 0);
        label.setText("Gvector Misorientations ]0,inf] [deg]:");
        this.rej_ia = new FloatText(container, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.rej_ia.setLayoutData((Object)gd);
        label = new Label(container, 0);
        label.setText("Volume/Intensity Based Rejection [3,inf]:");
        this.rej_vol = new FloatText(container, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.rej_vol.setLayoutData((Object)gd);
        label = new Label(container, 0);
        label.setText("Robust Residual Based Rejection [1,inf]:");
        this.rej_median = new FloatText(container, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.rej_median.setLayoutData((Object)gd);
        label = new Label(container, 0);
        label.setText("Average Residual [3,inf]:");
        this.rej_resmean = new FloatText(container, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.rej_resmean.setLayoutData((Object)gd);
        this.setData();
        this.setControl((Control)container);
        this.initialize();
        this.dialogChanged();
    }

    private void setData() {
        this.skip.getTextField().setData((Object)"skip");
        this.overlap.getTextField().setData((Object)"overlap");
        this.min_refl.getTextField().setData((Object)"min_refl");
        this.rejMultiYes.setData((Object)"rej_multi");
        this.rejMultiYes.setData("rej_multi", (Object)"1");
        this.rejMultiNo.setData((Object)"rej_multi");
        this.rejMultiNo.setData("rej_multi", (Object)"0");
        this.rej_ia.getTextField().setData((Object)"rej_ia");
        this.rej_vol.getTextField().setData((Object)"rej_vol");
        this.rej_median.getTextField().setData((Object)"rej_resmedian");
        this.rej_resmean.getTextField().setData((Object)"rej_resmean");
    }

    private void initialize() {
        this.fitAllB = ((InputWizard)this.getWizard()).getFitAllB();
        this.setTooltipText();
        this.initialize((Composite)this.getControl());
    }

    private void setTooltipText() {
        this.skip.setToolTipText("skip: skip refinement of the named grains from the grainspotter.log, \nvalues in {1,2,...}, default: None");
        this.overlap.setToolTipText("overlap: fraction of identical peaks assigned to grains before merging is considered, \nvalue in ]0;1], default: 1 (no merging)");
        this.min_refl.setToolTipText("min_refl: minimum number of reflections to considered refinement meaningful, \nvalue in [1,inf], default: 9");
        this.rejMultiYes.setToolTipText("rej_multi: reject peaks assigned to multiple grains (0=no/1=yes), \ndefault: 1");
        this.rejMultiNo.setToolTipText("rej_multi: reject peaks assigned to multiple grains (0=no/1=yes),\ndefault: 1");
        this.rej_ia.setToolTipText("rej_ia: outlier rejection limit [deg] for gvector misorientations, value in ]0;inf], \ndefault: 0.2 (undeformed material)");
        this.rej_vol.setToolTipText("rej_vol: outlier limit for volume/intensity based rejection, \nvalue in [3;inf], default: 5");
        this.rej_median.setToolTipText("rej_resmedian: outlier limit for robust residual based rejection, \nvalue in [1;inf], default: 5");
        this.rej_resmean.setToolTipText("rej_resmean: outlier rejection limit in terms of average residual, \nvalue in [3;inf], default: 10");
    }

    private void dialogChanged() {
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getSkip() {
        return this.skip.getText();
    }

    public String getMin_refl() {
        return this.min_refl.getText();
    }

    public String getOverlap() {
        return this.overlap.getText();
    }

    public boolean getRejMultiYes() {
        return this.rejMultiYes.getSelection();
    }

    public String getRej_ia() {
        return this.rej_ia.getText();
    }

    public String getRej_vol() {
        return this.rej_vol.getText();
    }

    public String getRej_median() {
        return this.rej_median.getText();
    }

    public String getRej_resmean() {
        return this.rej_resmean.getText();
    }

    public IWizardPage getNextPage() {
        FitallbInputWizardPage1 page = ((InputWizard)this.getWizard()).getPage1();
        if (page.getNumberOfDetectors() != 2) {
            return ((InputWizard)this.getWizard()).getFitPage();
        }
        return super.getNextPage();
    }

    private void initialize(Composite container) {
        IPreferenceStore preferences = Activator.getDefault().getPreferenceStore();
        Control[] children = container.getChildren();
        int i = 0;
        while (i < children.length) {
            Float preferredValue;
            Text text;
            String key;
            if (children[i] instanceof Composite && !(children[i] instanceof TypedText)) {
                this.initialize((Composite)children[i]);
            } else if (children[i] instanceof Button) {
                Button child = (Button)children[i];
                if ((child.getStyle() & 0x10) != 0 && (key = (String)child.getData()) != null) {
                    int preferredValue2 = preferences.getInt(key);
                    String value = (String)child.getData(key);
                    if (value != null) {
                        child.setSelection(value.equals(String.valueOf(preferredValue2)));
                    }
                }
            } else if (children[i] instanceof Text) {
                String preferredValue3;
                text = (Text)children[i];
                key = (String)text.getData();
                if (key != null && (preferredValue3 = preferences.getString(key)) != null) {
                    text.setText(preferredValue3);
                }
            } else if (children[i] instanceof Group) {
                this.initialize((Composite)((Group)children[i]));
            } else if (children[i] instanceof FloatTextAppender) {
                String preferredValue4;
                text = (FloatTextAppender)children[i];
                key = (String)text.getTextField().getData();
                if (key != null && (preferredValue4 = preferences.getString(key)) != null && !preferredValue4.trim().equals("")) {
                    text.setText(preferredValue4);
                }
            } else if (children[i] instanceof FloatText && (key = (String)(text = (FloatText)children[i]).getTextField().getData()) != null && (preferredValue = Float.valueOf(preferences.getFloat(key))) != null) {
                text.setText(preferredValue.toString());
            }
            ++i;
        }
    }

    @Override
    public void writePage(BufferedWriter writer) throws IOException {
        writer.write("#Outlier rejection - First Detector (far-field)");
        writer.newLine();
        if (this.getSkip() != null && this.getSkip().trim().length() > 0) {
            writer.write("skip " + this.getSkip());
            writer.newLine();
        }
        if (this.getMin_refl() != null && this.getMin_refl().trim().length() > 0) {
            writer.write("min_refl " + this.getMin_refl());
            writer.newLine();
        }
        if (this.getOverlap() != null && this.getOverlap().trim().length() > 0) {
            writer.write("overlap " + this.getOverlap());
            writer.newLine();
        }
        writer.write("rej_multi " + (this.getRejMultiYes() ? "1" : "0"));
        writer.newLine();
        if (this.getRej_ia() != null && this.getRej_ia().trim().length() > 0) {
            writer.write("rej_ia " + this.getRej_ia());
            writer.newLine();
        }
        if (this.getRej_vol() != null && this.getRej_vol().trim().length() > 0) {
            writer.write("rej_vol " + this.getRej_vol());
            writer.newLine();
        }
        if (this.getRej_median() != null && this.getRej_median().trim().length() > 0) {
            writer.write("rej_resmedian " + this.getRej_median());
            writer.newLine();
        }
        if (this.getRej_resmean() != null && this.getRej_resmean().trim().length() > 0) {
            writer.write("rej_resmean " + this.getRej_resmean());
            writer.newLine();
        }
    }
}

