/*
 * Decompiled with CFR 0.152.
 */
package fable.fitallb.wizard;

import fable.fitallb.editors.FitAllB;
import fable.fitallb.internal.IVarKeys;
import fable.fitallb.wizard.CommonRequiredKeysPage2;
import fable.fitallb.wizard.IInputPage;
import fable.fitallb.wizard.InputWizard;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class FitallbInputWizardPage1
extends WizardPage
implements IInputPage {
    private Text containerText;
    private Text fileText;
    private ISelection selection;
    private Text title;
    private Button farfield;
    private Button nearfield;
    private Button modeFitallb;
    private Button modeFitGlobalGrain;
    private FitAllB fitallb;

    protected FitallbInputWizardPage1(String pageName, ISelection sel) {
        super(pageName);
        this.setTitle("Input file settings");
        this.setDescription("This wizard creates a new input file for fitallb or fitgloball/fitglobalgrains program (*.fit extension)");
        this.selection = sel;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText("&Project:");
        this.containerText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FitallbInputWizardPage1.this.dialogChanged();
            }
        });
        Button button = new Button(container, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FitallbInputWizardPage1.this.dialogChanged();
                FitallbInputWizardPage1.this.handleBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText("&File name:");
        this.fileText = new Text(container, 2052);
        gd = new GridData(256);
        this.fileText.setLayoutData((Object)gd);
        gd.horizontalSpan = 2;
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FitallbInputWizardPage1.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        label.setText("Title:");
        this.title = new Text(container, 2052);
        gd = new GridData(768);
        this.title.setLayoutData((Object)gd);
        gd.horizontalSpan = 2;
        this.title.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FitallbInputWizardPage1.this.dialogChanged();
            }
        });
        Group grp = new Group(container, 16);
        GridLayout gdLayout = new GridLayout(3, true);
        grp.setLayout((Layout)gdLayout);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        grp.setLayoutData((Object)gd);
        grp.setText("Mode");
        this.modeFitallb = new Button((Composite)grp, 16);
        this.modeFitallb.setText("FitAllB");
        this.modeFitallb.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FitallbInputWizardPage1.this.handleProgramSelectionEvent();
            }
        });
        this.modeFitGlobalGrain = new Button((Composite)grp, 16);
        this.modeFitGlobalGrain.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FitallbInputWizardPage1.this.handleProgramSelectionEvent();
            }
        });
        this.modeFitGlobalGrain.setText("FitGlobalGrain/FitGloball");
        label = new Label(container, 0);
        label.setText("Number Of Detectors:");
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new GridLayout(2, true));
        GridData gridData = new GridData(2);
        composite.setLayoutData((Object)gridData);
        this.farfield = new Button(composite, 16);
        this.farfield.setText("1 (Farfield)");
        this.farfield.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FitallbInputWizardPage1.this.fitallb.setNumberOfDetectors(1);
            }
        });
        this.nearfield = new Button(composite, 16);
        this.nearfield.setText("2 (Far-Field and Near-Field)");
        this.nearfield.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FitallbInputWizardPage1.this.fitallb.setNumberOfDetectors(2);
            }
        });
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                this.containerText.setText(container.getFullPath().toString());
            }
        }
        this.fitallb = ((InputWizard)this.getWizard()).getFitAllB();
        this.setCurrentDirectory();
        this.fileText.setText("MyInput.fit");
        this.modeFitallb.setSelection(true);
        this.handleProgramSelectionEvent();
        this.farfield.setSelection(true);
        this.fitallb.setNumberOfDetectors(1);
        this.setToolTipText();
    }

    private void setToolTipText() {
        this.containerText.setToolTipText("Name of the project to create the input file");
        this.title.setToolTipText("Anything to specify refinement, \n'my very special fitallb farfield refinement title'");
        this.farfield.setToolTipText("Number of detecor used during the experiment");
        this.nearfield.setToolTipText("Number of detecor used during the experiment");
        this.fileText.setToolTipText("Name of the input file to create");
        this.modeFitallb.setToolTipText("");
        this.modeFitGlobalGrain.setToolTipText("");
    }

    private void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "Select new file container");
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.containerText.setText(((Path)result[0]).toOSString());
            this.setCurrentDirectory();
        }
    }

    private void setCurrentDirectory() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(this.containerText.getText()));
        if (resource != null && resource.exists() && resource instanceof IContainer) {
            IContainer container = (IContainer)resource;
            if (this.fitallb != null) {
                this.fitallb.setCurrentDirectory(container.getLocation().toOSString());
            }
        }
    }

    private void handleProgramSelectionEvent() {
        if (this.modeFitGlobalGrain.getSelection()) {
            ((InputWizard)this.getWizard()).getFitAllB().setProgram(IVarKeys.MODE_FITGLOBALGRAIN);
        } else {
            ((InputWizard)this.getWizard()).getFitAllB().setProgram(IVarKeys.MODE_FITALLB);
        }
    }

    private void dialogChanged() {
        String ext;
        String container = this.getContainerName();
        String fileName = this.getFileName();
        if (container.length() == 0) {
            this.updateStatus("File container must be specified.");
            return;
        }
        if (fileName.length() == 0) {
            this.updateStatus("File name must be specified.");
            return;
        }
        int dotLoc = fileName.lastIndexOf(46);
        if (dotLoc != -1 && !(ext = fileName.substring(dotLoc + 1)).equalsIgnoreCase("fit")) {
            this.updateStatus("File extension must be \"fit\".");
            return;
        }
        if (this.checkInputFile()) {
            this.updateStatus(null);
            this.setMessage("File Name: This input file" + this.getFileName() + " already exists in project " + this.getContainerName() + ".\n If you don't change the file name, it will be overriden.", 2);
            this.setPageComplete(true);
            return;
        }
        this.setMessage(null);
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public String getFileName() {
        return this.fileText.getText();
    }

    public String getInputFileTitle() {
        return "'" + this.title.getText() + "'";
    }

    public int getNumberOfDetectors() {
        return this.farfield.getSelection() ? 1 : 2;
    }

    public IWizardPage getNextPage() {
        CommonRequiredKeysPage2 page3 = ((InputWizard)this.getWizard()).getPage2();
        page3.setNumberOfDetectors(this.getNumberOfDetectors());
        return super.getNextPage();
    }

    @Override
    public void writePage(BufferedWriter writer) throws IOException {
        writer.write("title " + this.getInputFileTitle());
        writer.newLine();
    }

    private boolean checkInputFile() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(this.getContainerName()));
        boolean confirm = false;
        if (resource != null && resource.exists() && resource instanceof IContainer) {
            IContainer container = (IContainer)resource;
            IFile iFile = container.getFile((IPath)new Path(this.getFileName()));
            File file = iFile.getLocation().toFile();
            confirm = this.getFileName() != null && file.exists();
        }
        return confirm;
    }
}

