/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.editors;

import fable.grainspotter.internal.GrainSpotterListener;
import fable.grainspotter.internal.GrainSpotterUtils;
import fable.grainspotter.modelviewer.GrainInfoModel;
import fable.grainspotter.modelviewer.GrainSyntaxModel;
import fable.grainspotter.rcp.Activator;
import fable.grainspotter.run.LogFile;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class GrainSpotterLogFileSummary
extends Composite {
    private static final boolean DEBUG_FLOW = false;
    private Text infoText;
    private Font infoFont;
    private Action refreshAction;
    private LogFile logFile;
    private GrainSpotterListener listener;

    public GrainSpotterLogFileSummary(Composite parent, int style) {
        super(parent, style);
        this.createContents();
    }

    private void createContents() {
        GridDataFactory.fillDefaults().grab(true, true).align(0x1000000, 0x1000000).applyTo((Control)this);
        GridLayout layout = new GridLayout(1, false);
        this.setLayout((Layout)layout);
        this.setBackground(Display.getDefault().getSystemColor(1));
        this.infoText = new Text((Composite)this, 770);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.infoText);
        this.infoText.setEditable(false);
        this.infoText.setBackground(Display.getDefault().getSystemColor(1));
        this.infoFont = new Font((Device)this.getDisplay(), "Courier", 10, 0);
        this.infoText.setFont(this.infoFont);
        this.fillInfoText();
        this.makeActions();
        this.hookContextMenu((Control)this.infoText);
    }

    public void fillInfoText() {
        float meanIA;
        List<GrainInfoModel> infos;
        List<GrainSyntaxModel> grains;
        if (this.infoText == null || this.logFile == null) {
            return;
        }
        String info = "";
        info = String.valueOf(info) + this.logFile.getFileName() + "\n\n";
        if (!this.logFile.getLogFileRead()) {
            info = String.valueOf(info) + "Waiting until the grains are completely parsed...";
            this.infoText.setText(info);
            return;
        }
        if (Activator.database != null) {
            info = String.valueOf(info) + "Derby database entries correspond to FID=" + this.logFile.getDatabaseID() + "\n\n";
        }
        if ((grains = this.logFile.getGrains().getGrains()) == null) {
            if (this.infoText != null) {
                info = String.valueOf(info) + "No grains";
                this.infoText.setText(info);
            }
            return;
        }
        int nGrains = grains.size();
        int nMeas = this.logFile.getGrains().getGvecsMeasured();
        int nExpected = this.logFile.getGrains().getGvecsExpected();
        info = String.valueOf(info) + "nGrains: " + nGrains + "\n";
        int i = 1;
        int maxIndex = 0;
        float sum = 0.0f;
        float max = 0.0f;
        for (GrainSyntaxModel grain : grains) {
            infos = grain.getInfo();
            meanIA = GrainSpotterUtils.getValueAsFloat(infos.get(4).getValue());
            sum += meanIA;
            if (meanIA > max) {
                max = meanIA;
                maxIndex = i;
            }
            ++i;
        }
        float avg = nGrains == 0 ? 0.0f : sum / (float)nGrains;
        float percent = nExpected == 0 ? 0.0f : 100.0f * (float)nMeas / (float)nExpected;
        info = String.valueOf(info) + "Average meanIA: " + String.format("%.2f\n", Float.valueOf(avg));
        info = String.valueOf(info) + "Max meanIA: " + String.format("%.2f", Float.valueOf(max)) + " for Grain " + maxIndex + "\n";
        info = String.valueOf(info) + String.format("Found %d g-vectors of %d expected (%.1f%%)\n\n", nMeas, nExpected, Float.valueOf(percent));
        info = String.valueOf(info) + "   n   nExpect     nMeas nMeasOnce nMeasMore    meanIA\n";
        i = 1;
        for (GrainSyntaxModel grain : grains) {
            infos = grain.getInfo();
            float meas = GrainSpotterUtils.getValueAsFloat(infos.get(0).getValue());
            float expected = GrainSpotterUtils.getValueAsFloat(infos.get(1).getValue());
            float measOnce = GrainSpotterUtils.getValueAsFloat(infos.get(2).getValue());
            float measMore = GrainSpotterUtils.getValueAsFloat(infos.get(3).getValue());
            meanIA = GrainSpotterUtils.getValueAsFloat(infos.get(4).getValue());
            info = String.valueOf(info) + String.format("%4d %9.0f %9.0f %9.0f %9.0f %9.2f\n", i++, Float.valueOf(meas), Float.valueOf(expected), Float.valueOf(measOnce), Float.valueOf(measMore), Float.valueOf(meanIA));
        }
        this.infoText.setText(info);
    }

    public void setInfoText(String msg) {
        if (this.infoText == null) {
            return;
        }
        this.infoText.setText(msg);
    }

    private void hookContextMenu(Control control) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                GrainSpotterLogFileSummary.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(control);
        control.setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.refreshAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void makeActions() {
        this.refreshAction = new Action("Refresh"){

            public void run() {
                GrainSpotterLogFileSummary.this.fillInfoText();
            }
        };
        this.refreshAction.setToolTipText("Refresh the information");
        this.refreshAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_REDO"));
    }

    public void dispose() {
        if (this.infoFont != null & !this.infoFont.isDisposed()) {
            this.infoFont.dispose();
            this.infoFont = null;
        }
    }

    public LogFile getLogFile() {
        return this.logFile;
    }

    public void setLogFile(LogFile logFile) {
        if (logFile == this.logFile || logFile == null) {
            return;
        }
        this.logFile = logFile;
        this.fillInfoText();
        if (this.logFile != null && this.listener != null) {
            this.logFile.removeGrainSpotterListener(this.listener);
            this.listener = null;
        }
        logFile.addGrainSpotterListener(new GrainSpotterListener(){

            public void propertyChange(PropertyChangeEvent event) {
                GrainSpotterLogFileSummary.this.fillInfoText();
            }
        });
    }
}

