/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.actions;

import fable.framework.toolbox.FableUtils;
import fable.framework.toolbox.SWTUtils;
import fable.framework.toolbox.ToolBox;
import fable.framework.views.FableMessageConsole;
import fable.grainspotter.editors.GrainSpotterInput;
import fable.grainspotter.editors.GrainSpotterLogFileEditor;
import fable.grainspotter.internal.IVarKeys;
import java.io.File;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class OpenLogFileAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow _window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    private String ID = "fable.grainspotter.actions.RunAction";

    public void init(IWorkbenchWindow arg0) {
        this._window = arg0;
    }

    public OpenLogFileAction() {
        this.setToolTipText("Open log file (.log)");
        this.setText("Open log file (.log)");
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER"));
        this.setId(this.ID);
    }

    public void run(IAction arg0) {
        if (this._window != null) {
            this.openLogFileEditor();
        }
    }

    public void run() {
        if (this._window != null) {
            this.openLogFileEditor();
        }
    }

    private void openLogFileEditor() {
        try {
            block7: {
                try {
                    if (this._window != null) {
                        this._window.getWorkbench().showPerspective("fable.grainspotter.perspective.grainspotterperspective", this._window);
                    }
                }
                catch (PartInitException partInitException) {
                    if (FableMessageConsole.console == null) break block7;
                    FableMessageConsole.console.displayError("Grainspotter perspective can not be displayed.");
                }
            }
            FileDialog fileDlg = new FileDialog(new Shell(), 4096);
            fileDlg.setFilterExtensions(IVarKeys.FILTER_EXTS_LOG);
            fileDlg.setFilterNames(IVarKeys.FILTER_NAMES_LOG);
            fileDlg.setFilterPath(GrainSpotterInput.getInitialDirLog());
            fileDlg.setText("Select an existing log file or enter a new file name");
            String file = fileDlg.open();
            if (file != null) {
                if (!file.endsWith(".log")) {
                    file = String.valueOf(file) + ".log";
                }
                this.openEditor(file, GrainSpotterLogFileEditor.getID());
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this._window.getShell(), (String)"Error", (String)("Error opening log file:" + e.getMessage()));
        }
    }

    public void selectionChanged(IAction arg0, ISelection arg1) {
    }

    public void dispose() {
    }

    private IEditorPart openEditor(String fileName, String editorID) {
        IEditorPart part = null;
        if (ToolBox.checkIfFileExists((String)fileName)) {
            try {
                File file = new File(fileName);
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IEditorInput editorInput = SWTUtils.createEditorInput((File)file);
                IWorkbenchPage page = window.getActivePage();
                part = page.openEditor(editorInput, editorID);
            }
            catch (Exception ex) {
                FableUtils.excNoTraceMsg((Object)((Object)this), (String)("Error opening: " + fileName), (Throwable)ex);
            }
        } else {
            String msg = "Not found: " + fileName;
            FableUtils.errMsg((Object)((Object)this), (String)msg);
            if (FableMessageConsole.console != null) {
                FableMessageConsole.console.displayError(msg);
            }
        }
        return part;
    }
}

