/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.actions;

import fable.framework.toolbox.FableUtils;
import fable.framework.toolbox.SWTUtils;
import fable.framework.toolbox.ToolBox;
import fable.framework.views.FableMessageConsole;
import fable.grainspotter.editors.GrainSpotterInputEditor;
import fable.grainspotter.internal.IVarKeys;
import fable.grainspotter.run.GrainSpotterException;
import fable.grainspotter.run.InputFile;
import java.io.File;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class CreateNewIniFileAction
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;
    private IEditorInput input;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void run(IAction action) {
        if (this.window != null) {
            try {
                IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (activeWindow != null) {
                    activeWindow.getWorkbench().showPerspective("fable.grainspotter.perspective.grainspotterperspective", activeWindow);
                }
            }
            catch (PartInitException partInitException) {
                if (FableMessageConsole.console != null) {
                    FableMessageConsole.console.displayError("Grainspotter perspective can not be displayed.");
                }
            }
            catch (WorkbenchException e) {
                MessageDialog.openError((Shell)this.window.getShell(), (String)"Error", (String)("Error opening perspective Grainspotter: " + e.getMessage()));
            }
            FileDialog fileDlg = this.getSaveAsFileDialog();
            String fileName = fileDlg.open();
            boolean confirm = false;
            confirm = ToolBox.checkIfFileExists((String)fileName) ? FableUtils.confirmMsg((Object)this, (String)(String.valueOf(fileName) + " already exists. \nDo you want to overwrite it and start with a new .ini file containing default values ?")) : true;
            if (confirm) {
                try {
                    this.openNewIniFile(fileName);
                }
                catch (PartInitException e) {
                    FableUtils.excMsg((Object)this, (String)("Error opening ini file " + fileName), (Throwable)e);
                }
            }
        }
    }

    public FileDialog getSaveAsFileDialog() {
        this.window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        FileDialog fileDlg = new FileDialog(this.window.getShell(), 8192);
        fileDlg.setText("Create a new ini file.");
        fileDlg.setFilterExtensions(IVarKeys.FILTER_EXTS_INI);
        fileDlg.setFilterNames(IVarKeys.FILTER_NAMES_INI);
        return fileDlg;
    }

    public void openNewIniFile(String fileName) throws PartInitException {
        if (fileName != null && !fileName.equals("")) {
            String editorId;
            block5: {
                this.input = SWTUtils.createEditorInput((File)new File(fileName));
                editorId = GrainSpotterInputEditor.getID();
                try {
                    InputFile inputFile = new InputFile(fileName);
                    inputFile.initWithDefaultValues();
                    inputFile.save();
                }
                catch (GrainSpotterException ex) {
                    String msg = "Problem creating new .ini file: " + fileName;
                    FableUtils.excNoTraceMsg((Object)this, (String)msg, (Throwable)ex);
                    if (FableMessageConsole.console != null) {
                        FableMessageConsole.console.displayError(msg);
                        FableMessageConsole.console.displayError(ex.get_message());
                        SWTUtils.errMsgAsync((String)ex.get_message());
                    }
                }
                catch (Exception ex) {
                    String msg = "Problem creating new .ini file: " + fileName;
                    FableUtils.excNoTraceMsg((Object)this, (String)msg, (Throwable)ex);
                    if (FableMessageConsole.console == null) break block5;
                    FableMessageConsole.console.displayError(msg);
                    FableMessageConsole.console.displayError(ex.getMessage());
                    SWTUtils.errMsgAsync((String)ex.getMessage());
                }
            }
            this.window.getActivePage().openEditor(this.input, editorId);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

