/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.buildpath;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.provisional.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.provisional.simpleconfigurator.manipulator.SimpleConfiguratorManipulator;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

class P2Utils {
    private static final String CONFIG_FOLDER = "configuration";
    private static final String SRC_INFO_FOLDER = "org.eclipse.equinox.source";
    private static final String SRC_INFO_PATH = "org.eclipse.equinox.source" + File.separator + "source.info";
    private static final String BUNDLE_INFO_FOLDER = "org.eclipse.equinox.simpleconfigurator";
    private static final String BUNDLE_INFO_PATH = "org.eclipse.equinox.simpleconfigurator" + File.separator + "bundles.info";
    static /* synthetic */ Class class$0;

    P2Utils() {
    }

    private static BundleInfo[] readBundles(boolean isSourceBundle, boolean useConfigArea) {
        BundleInfo[] bundles;
        block8: {
            String bundleInfoPath;
            Location bundlesLocation;
            if (useConfigArea) {
                bundlesLocation = Platform.getConfigurationLocation();
                bundleInfoPath = isSourceBundle ? SRC_INFO_PATH : BUNDLE_INFO_PATH;
            } else {
                bundlesLocation = Platform.getInstallLocation();
                bundleInfoPath = isSourceBundle ? CONFIG_FOLDER + File.separator + SRC_INFO_PATH : CONFIG_FOLDER + File.separator + BUNDLE_INFO_PATH;
            }
            if (bundlesLocation == null) {
                return null;
            }
            URL bundlesLocationURL = bundlesLocation.getURL();
            if (bundleInfoPath == null) {
                return null;
            }
            URL bundlesTxt = new URL(bundlesLocationURL.getProtocol(), bundlesLocationURL.getHost(), new File(bundlesLocationURL.getFile(), bundleInfoPath).getAbsolutePath());
            bundles = P2Utils.getBundlesFromFile(bundlesLocationURL, bundlesTxt);
            if (bundles != null && bundles.length != 0) break block8;
            return null;
        }
        try {
            return bundles;
        }
        catch (MalformedURLException e) {
            JUnitPlugin.log(e);
            return null;
        }
        catch (IOException e) {
            JUnitPlugin.log(e);
            return null;
        }
    }

    private static BundleInfo[] getBundlesFromFile(URL bundlesLocation, URL fileURL) throws IOException {
        SimpleConfiguratorManipulator manipulator;
        JUnitPlugin jUnitPlugin = JUnitPlugin.getDefault();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.simpleconfigurator.manipulator.SimpleConfiguratorManipulator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manipulator = (SimpleConfiguratorManipulator)jUnitPlugin.getService(clazz.getName())) == null) {
            return null;
        }
        File home = new File(bundlesLocation.getFile());
        return manipulator.loadConfiguration(fileURL, home);
    }

    public static BundleInfo findBundle(String symbolicName, Version version, boolean isSourceBundle) {
        Assert.isLegal((symbolicName != null ? 1 : 0) != 0);
        Assert.isLegal((version != null ? 1 : 0) != 0);
        return P2Utils.findBundle(symbolicName, new VersionRange(version, true, version, true), isSourceBundle);
    }

    public static BundleInfo findBundle(String symbolicName, VersionRange versionRange, boolean isSourceBundle) {
        Assert.isLegal((symbolicName != null ? 1 : 0) != 0);
        Assert.isLegal((versionRange != null ? 1 : 0) != 0);
        BundleInfo bundleInfo = P2Utils.findBundle(symbolicName, versionRange, isSourceBundle, true);
        if (bundleInfo != null) {
            return bundleInfo;
        }
        return P2Utils.findBundle(symbolicName, versionRange, isSourceBundle, false);
    }

    private static BundleInfo findBundle(String symbolicName, VersionRange versionRange, boolean isSourceBundle, boolean useConfigArea) {
        BundleInfo[] bundles = P2Utils.readBundles(isSourceBundle, useConfigArea);
        if (bundles == null) {
            return null;
        }
        int i = 0;
        while (i < bundles.length) {
            IPath path;
            if (symbolicName.equals(bundles[i].getSymbolicName()) && versionRange.isIncluded(new Version(bundles[i].getVersion())) && (path = P2Utils.getBundleLocationPath(bundles[i])).toFile().exists()) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    public static IPath getBundleLocationPath(BundleInfo bundleInfo) {
        if (bundleInfo == null) {
            return null;
        }
        URI bundleLocation = bundleInfo.getLocation();
        if (bundleLocation == null) {
            return null;
        }
        try {
            String fileStr = FileLocator.toFileURL((URL)URIUtil.toURL((URI)bundleLocation)).getFile();
            fileStr = URLDecoder.decode(fileStr, "UTF-8");
            return new Path(fileStr);
        }
        catch (IOException e) {
            JUnitPlugin.log(e);
            return null;
        }
    }
}

