/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.tasks;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.tools.ant.BuildException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.provisional.search.ApiSearchEngine;
import org.eclipse.pde.api.tools.internal.provisional.search.IApiSearchReporter;
import org.eclipse.pde.api.tools.internal.provisional.search.IApiSearchRequestor;
import org.eclipse.pde.api.tools.internal.search.ApiUseSearchRequestor;
import org.eclipse.pde.api.tools.internal.search.SkippedComponent;
import org.eclipse.pde.api.tools.internal.tasks.CommonUtilsTask;
import org.eclipse.pde.api.tools.internal.tasks.Messages;
import org.eclipse.pde.api.tools.internal.util.Util;

public class UseTask
extends CommonUtilsTask {
    protected static final String SCOPE_BASELINE_NAME = "scope_baseline";
    protected Set excludeset = null;
    protected boolean considerapi = false;
    protected boolean considerinternal = false;
    protected String scopeLocation = null;
    protected boolean includenonapi = false;
    protected boolean includesystemlibraries = false;
    protected boolean proceedonerror = false;
    protected TreeSet notsearched = null;
    protected String reporterclazz = null;
    protected IApiSearchReporter reporter = null;
    private HashMap baselineinstalldirs = new HashMap(4);

    protected IApiElement[] getScope(IApiBaseline baseline) throws CoreException {
        TreeSet<IApiComponent> scope = new TreeSet<IApiComponent>(Util.componentsorter);
        if (baseline != null) {
            IApiComponent[] components = baseline.getApiComponents();
            boolean isapibundle = false;
            boolean excluded = false;
            boolean resolveerrors = false;
            int i = 0;
            while (i < components.length) {
                isapibundle = Util.isApiToolsComponent((IApiComponent)components[i]);
                excluded = this.excludeset.contains(components[i].getId());
                boolean bl = resolveerrors = components[i].getErrors() != null;
                if (!(!isapibundle && !this.includenonapi || excluded || components[i].isSystemComponent() || resolveerrors && !this.proceedonerror)) {
                    scope.add(components[i]);
                } else {
                    this.notsearched.add(new SkippedComponent(components[i].getId(), !isapibundle, excluded, resolveerrors));
                }
                ++i;
            }
        }
        return scope.toArray(new IApiElement[scope.size()]);
    }

    protected Set getBaselineIds(IApiBaseline baseline) throws CoreException {
        IApiComponent[] components = baseline.getApiComponents();
        TreeSet<String> comps = new TreeSet<String>(Util.componentsorter);
        int i = 0;
        while (i < components.length) {
            if (!components[i].isSystemComponent() && (Util.isApiToolsComponent((IApiComponent)components[i]) || this.includenonapi)) {
                comps.add(components[i].getId());
            }
            if (components[i].isSystemComponent() && this.includesystemlibraries) {
                comps.add(components[i].getId());
            }
            ++i;
        }
        return comps;
    }

    protected int getSearchFlags() {
        int flags = this.considerapi ? 1 : 0;
        flags |= this.considerinternal ? 2 : 0;
        return flags |= this.includenonapi ? 4 : 0;
    }

    protected void assertParameters() throws BuildException {
        if (this.currentBaselineLocation == null) {
            StringWriter out = new StringWriter();
            PrintWriter writer = new PrintWriter(out);
            writer.println(Messages.bind((String)Messages.ApiUseTask_missing_baseline_argument, (Object[])new String[]{this.currentBaselineLocation}));
            writer.flush();
            writer.close();
            throw new BuildException(String.valueOf(out.getBuffer()));
        }
        if (!this.considerapi && !this.considerinternal) {
            throw new BuildException(Messages.UseTask_no_scan_both_types_not_searched_for);
        }
    }

    protected File getBaselineInstallDir(String name) {
        return (File)this.baselineinstalldirs.get(name);
    }

    protected IApiBaseline getBaseline(String name, String location) {
        if (location == null) {
            return null;
        }
        long time = 0L;
        if (this.debug) {
            time = System.currentTimeMillis();
            System.out.println("Preparing '" + name + "' baseline installation...");
        }
        File installdir = this.extractSDK(name, location);
        if (this.debug) {
            System.out.println("done in: " + (System.currentTimeMillis() - time) + " ms");
            time = System.currentTimeMillis();
        }
        if (this.debug) {
            time = System.currentTimeMillis();
            System.out.println("Creating '" + name + "' baseline...");
        }
        IApiBaseline baseline = this.createBaseline(name, this.getInstallDir(installdir), this.eeFileLocation);
        if (this.debug) {
            System.out.println("done in: " + (System.currentTimeMillis() - time) + " ms");
        }
        this.baselineinstalldirs.put(name, installdir);
        return baseline;
    }

    protected void doSearch(IApiBaseline baseline, IApiBaseline scope, IApiSearchReporter reporter) throws CoreException {
        ApiSearchEngine engine = new ApiSearchEngine();
        ApiUseSearchRequestor requestor = new ApiUseSearchRequestor(this.getBaselineIds(baseline), this.getScope(scope), this.getSearchFlags(), this.excludeset);
        ApiSearchEngine.setDebug((boolean)this.debug);
        engine.search(baseline, (IApiSearchRequestor)requestor, reporter, null);
    }

    protected void initializeExcludeSet(IApiBaseline baseline) {
        long start = 0L;
        if (this.debug) {
            start = System.currentTimeMillis();
            System.out.println("Preparing exclude set...");
        }
        this.excludeset = Util.initializeRegexExcludeList((String)this.excludeListLocation, (IApiBaseline)baseline);
        this.notsearched = new TreeSet(Util.componentsorter);
        if (this.excludeset != null) {
            Iterator iter = this.excludeset.iterator();
            while (iter.hasNext()) {
                this.notsearched.add(new SkippedComponent((String)iter.next(), false, true, false));
            }
        }
        if (this.debug) {
            System.out.println("done in: " + (System.currentTimeMillis() - start) + " ms");
        }
    }

    protected void cleanReportLocation() {
        File file;
        if (this.reportLocation == null) {
            return;
        }
        long time = 0L;
        if (this.debug) {
            time = System.currentTimeMillis();
            System.out.println("Cleaning report location...");
        }
        if ((file = new File(this.reportLocation)).exists()) {
            this.scrubReportLocation(file);
        }
        if (this.debug) {
            System.out.println("done in: " + (System.currentTimeMillis() - time) + " ms");
        }
    }

    protected void writeDebugHeader() {
        if (this.debug) {
            System.out.println("Baseline to collect references to : " + this.currentBaselineLocation);
            System.out.println("Report location : " + this.reportLocation);
            System.out.println("Searching for API references : " + this.considerapi);
            System.out.println("Searching for internal references : " + this.considerinternal);
            if (this.scopeLocation == null) {
                System.out.println("No scope specified : baseline will act as scope");
            } else {
                System.out.println("Scope to search against : " + this.scopeLocation);
            }
            if (this.excludeListLocation != null) {
                System.out.println("Exclude list location : " + this.excludeListLocation);
            } else {
                System.out.println("No exclude list location");
            }
            if (this.eeFileLocation != null) {
                System.out.println("EE file location : " + this.eeFileLocation);
            } else {
                System.out.println("No EE file location given: using default");
            }
            System.out.println("-----------------------------------------------------------------------------------------------------");
        }
    }
}

