/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.tasks;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.tools.ant.BuildException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.search.XMLApiSearchReporter;
import org.eclipse.pde.api.tools.internal.tasks.Messages;
import org.eclipse.pde.api.tools.internal.tasks.UseTask;

public class ApiUseTask
extends UseTask {
    public void setProceedOnError(String proceed) {
        this.proceedonerror = Boolean.valueOf(proceed);
    }

    public void setIncludeSystemLibraries(String include) {
        this.includesystemlibraries = Boolean.valueOf(include);
    }

    public void setBaseline(String baselineLocation) {
        this.currentBaselineLocation = baselineLocation;
    }

    public void setScope(String scopeLocation) {
        this.scopeLocation = scopeLocation;
    }

    public void setIncludeNonApiProjects(String includenonapi) {
        this.includenonapi = Boolean.valueOf(includenonapi);
    }

    public void setExcludeList(String excludeListLocation) {
        this.excludeListLocation = excludeListLocation;
    }

    public void setReport(String reportLocation) {
        this.reportLocation = reportLocation;
    }

    public void setEEFile(String eeFileLocation) {
        this.eeFileLocation = eeFileLocation;
    }

    public void setDebug(String debugValue) {
        this.debug = Boolean.toString(true).equals(debugValue);
    }

    public void setConsiderAPI(String considerapi) {
        this.considerapi = Boolean.toString(true).equals(considerapi);
    }

    public void setConsiderInternal(String considerinternal) {
        this.considerinternal = Boolean.toString(true).equals(considerinternal);
    }

    protected void assertParameters() throws BuildException {
        super.assertParameters();
        if (this.reportLocation == null) {
            StringWriter out = new StringWriter();
            PrintWriter writer = new PrintWriter(out);
            writer.println(Messages.bind((String)Messages.ApiUseTask_missing_report_location, (Object[])new String[]{this.reportLocation}));
            writer.flush();
            writer.close();
            throw new BuildException(String.valueOf(out.getBuffer()));
        }
    }

    public void execute() throws BuildException {
        this.assertParameters();
        this.writeDebugHeader();
        this.cleanReportLocation();
        IApiBaseline baseline = this.getBaseline("current_baseline", this.currentBaselineLocation);
        IApiBaseline scope = this.getBaseline("scope_baseline", this.scopeLocation);
        if (scope == null) {
            scope = baseline;
        }
        this.initializeExcludeSet(scope);
        this.reporter = new XMLApiSearchReporter(this.reportLocation, this.debug);
        try {
            try {
                this.doSearch(baseline, scope, this.reporter);
            }
            catch (CoreException ce) {
                throw new BuildException(Messages.ApiUseTask_search_engine_problem, (Throwable)ce);
            }
        }
        finally {
            if (baseline != null) {
                baseline.dispose();
                this.deleteBaseline(this.currentBaselineLocation, this.getBaselineInstallDir("current_baseline"));
            }
            if (scope != null && this.scopeLocation != null) {
                scope.dispose();
                this.deleteBaseline(this.scopeLocation, this.getBaselineInstallDir("scope_baseline"));
            }
            this.reporter.reportNotSearched(this.notsearched.toArray(new IApiElement[this.notsearched.size()]));
        }
    }
}

