/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.tasks;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.api.tools.internal.builder.BaseApiAnalyzer;
import org.eclipse.pde.api.tools.internal.builder.BuildContext;
import org.eclipse.pde.api.tools.internal.model.StubApiComponent;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFilter;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.builder.IBuildContext;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblemFilter;
import org.eclipse.pde.api.tools.internal.tasks.CommonUtilsTask;
import org.eclipse.pde.api.tools.internal.tasks.Messages;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class APIToolsAnalysisTask
extends CommonUtilsTask {
    public static final String BUNDLE_VERSION = "bundleVersion";
    public static final String COMPATIBILITY = "compatibility";
    private static final Summary[] NO_SUMMARIES = new Summary[0];
    public static final String USAGE = "usage";
    private Set excludedElement;
    private String filters;
    private Properties properties;

    private Summary[] createAllSummaries(Map allProblems) {
        Set entrySet = allProblems.entrySet();
        int size = entrySet.size();
        if (size == 0) {
            return NO_SUMMARIES;
        }
        ArrayList allEntries = new ArrayList();
        allEntries.addAll(entrySet);
        Collections.sort(allEntries, new Comparator(){

            public int compare(Object o1, Object o2) {
                Map.Entry entry1 = (Map.Entry)o1;
                Map.Entry entry2 = (Map.Entry)o2;
                return ((String)entry1.getKey()).compareTo((String)entry2.getKey());
            }
        });
        Summary[] summaries = new Summary[size];
        int i = 0;
        Iterator iterator = allEntries.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            summaries[i++] = this.createProblemSummary((String)entry.getKey(), (IApiProblem[])entry.getValue());
        }
        if (this.debug) {
            this.dumpSummaries(summaries);
        }
        return summaries;
    }

    private Summary createProblemSummary(String componentID, IApiProblem[] apiProblems) {
        return new Summary(componentID, apiProblems);
    }

    private void dumpReport(Summary[] summaries, List bundlesNames) {
        int i = 0;
        int max = summaries.length;
        while (i < max) {
            Summary summary = summaries[i];
            String contents = null;
            String componentID = summary.componentID;
            if (this.excludedElement == null || !this.excludedElement.contains(componentID)) {
                try {
                    Document document = Util.newDocument();
                    Element report = document.createElement("report");
                    report.setAttribute("version", "1");
                    report.setAttribute("componentID", componentID);
                    document.appendChild(report);
                    Element category = document.createElement("category");
                    category.setAttribute("key", Integer.toString(0x10000000));
                    category.setAttribute("value", COMPATIBILITY);
                    this.insertAPIProblems(category, document, summary.apiCompatibilityProblems);
                    report.appendChild(category);
                    category = document.createElement("category");
                    category.setAttribute("key", Integer.toString(0x20000000));
                    category.setAttribute("value", USAGE);
                    this.insertAPIProblems(category, document, summary.apiUsageProblems);
                    report.appendChild(category);
                    category = document.createElement("category");
                    category.setAttribute("key", Integer.toString(0x30000000));
                    category.setAttribute("value", BUNDLE_VERSION);
                    this.insertAPIProblems(category, document, summary.apiBundleVersionProblems);
                    report.appendChild(category);
                    contents = Util.serializeDocument((Document)document);
                }
                catch (DOMException e) {
                    throw new BuildException((Throwable)e);
                }
                catch (CoreException e) {
                    throw new BuildException((Throwable)e);
                }
                if (contents != null) {
                    this.saveReport(componentID, contents, "report.xml");
                }
            }
            ++i;
        }
        if (bundlesNames != null && bundlesNames.size() != 0) {
            String contents = null;
            try {
                Document document = Util.newDocument();
                Element report = document.createElement("report");
                report.setAttribute("version", "1");
                document.appendChild(report);
                Iterator iterator = bundlesNames.iterator();
                while (iterator.hasNext()) {
                    String bundleName = (String)iterator.next();
                    if (this.excludedElement != null && this.excludedElement.contains(bundleName)) continue;
                    Element bundle = document.createElement("bundle");
                    bundle.setAttribute("name", bundleName);
                    report.appendChild(bundle);
                }
                contents = Util.serializeDocument((Document)document);
            }
            catch (DOMException e) {
                throw new BuildException((Throwable)e);
            }
            catch (CoreException e) {
                throw new BuildException((Throwable)e);
            }
            if (contents != null) {
                this.saveReport("allNonApiBundles", contents, "report.xml");
            }
        }
    }

    private void dumpSummaries(Summary[] summaries) {
        int i = 0;
        int max = summaries.length;
        while (i < max) {
            System.out.println(summaries[i].getTitle());
            ++i;
        }
        i = 0;
        max = summaries.length;
        while (i < max) {
            System.out.println(summaries[i].getDetails());
            ++i;
        }
    }

    public void execute() throws BuildException {
        ArrayList<String> allNonApiBundles;
        HashMap<String, IApiProblem[]> allProblems;
        block40: {
            if (this.referenceBaselineLocation == null || this.currentBaselineLocation == null || this.reportLocation == null) {
                StringWriter out = new StringWriter();
                PrintWriter writer = new PrintWriter(out);
                writer.println(Messages.bind((String)Messages.printArguments, (Object[])new String[]{this.referenceBaselineLocation, this.currentBaselineLocation, this.reportLocation}));
                writer.flush();
                writer.close();
                throw new BuildException(String.valueOf(out.getBuffer()));
            }
            if (this.debug) {
                System.out.println("reference : " + this.referenceBaselineLocation);
                System.out.println("baseline to compare : " + this.currentBaselineLocation);
                System.out.println("report location : " + this.reportLocation);
                if (this.filters != null) {
                    System.out.println("filter store : " + this.filters);
                } else {
                    System.out.println("No filter store");
                }
                if (this.excludeListLocation != null) {
                    System.out.println("exclude list location : " + this.excludeListLocation);
                } else {
                    System.out.println("No exclude list location");
                }
            }
            if (this.excludeListLocation != null) {
                this.excludedElement = CommonUtilsTask.initializeExcludedElement(this.excludeListLocation);
            }
            long time = 0L;
            if (this.debug) {
                time = System.currentTimeMillis();
            }
            File referenceInstallDir = this.extractSDK("referenceBaseline", this.referenceBaselineLocation);
            File baselineInstallDir = this.extractSDK("currentBaseline", this.currentBaselineLocation);
            if (this.debug) {
                System.out.println("Preparation of baseline installation : " + (System.currentTimeMillis() - time) + "ms");
                time = System.currentTimeMillis();
            }
            IApiBaseline referenceBaseline = this.createBaseline("reference_baseline", this.getInstallDir(referenceInstallDir), this.eeFileLocation);
            IApiBaseline currentBaseline = this.createBaseline("current_baseline", this.getInstallDir(baselineInstallDir), this.eeFileLocation);
            if (this.debug) {
                System.out.println("Creation of both baselines : " + (System.currentTimeMillis() - time) + "ms");
                time = System.currentTimeMillis();
            }
            allProblems = new HashMap<String, IApiProblem[]>();
            allNonApiBundles = new ArrayList<String>();
            ArrayList<String> allApiBundles = new ArrayList<String>();
            try {
                try {
                    IApiComponent[] apiComponents = currentBaseline.getApiComponents();
                    int length = apiComponents.length;
                    int apiToolsComponents = 0;
                    HashSet<String> visitedApiComponentNames = new HashSet<String>();
                    int i = 0;
                    while (i < length) {
                        IApiComponent apiComponent = apiComponents[i];
                        String name = apiComponent.getId();
                        visitedApiComponentNames.add(name);
                        if (!apiComponent.isSystemComponent()) {
                            if (!Util.isApiToolsComponent((IApiComponent)apiComponent)) {
                                allNonApiBundles.add(name);
                            } else {
                                ++apiToolsComponents;
                                allApiBundles.add(name);
                                BaseApiAnalyzer analyzer = new BaseApiAnalyzer();
                                try {
                                    try {
                                        analyzer.analyzeComponent(null, this.getFilterStore(name), this.properties, referenceBaseline, apiComponent, (IBuildContext)new BuildContext(), (IProgressMonitor)new NullProgressMonitor());
                                        IApiProblem[] problems = analyzer.getProblems();
                                        problems = this.removeDuplicates(problems);
                                        if (problems.length != 0) {
                                            allProblems.put(name, problems);
                                        }
                                    }
                                    catch (RuntimeException e) {
                                        ApiPlugin.log((Throwable)e);
                                        throw e;
                                    }
                                }
                                finally {
                                    analyzer.dispose();
                                }
                            }
                        }
                        ++i;
                    }
                    if (this.debug) {
                        System.out.println("Total number of components in current baseline :" + length);
                        System.out.println("Total number of api tools components in current baseline :" + allApiBundles.size());
                        System.out.println("Details:");
                        Collections.sort(allApiBundles);
                        Iterator iterator = allApiBundles.iterator();
                        while (iterator.hasNext()) {
                            System.out.println(iterator.next());
                        }
                        System.out.println("==============================================================================");
                        System.out.println("Total number of non-api tools components in current baseline :" + allNonApiBundles.size());
                        System.out.println("Details:");
                        Collections.sort(allNonApiBundles);
                        iterator = allNonApiBundles.iterator();
                        while (iterator.hasNext()) {
                            System.out.println(iterator.next());
                        }
                    }
                    IApiComponent[] baselineApiComponents = referenceBaseline.getApiComponents();
                    int i2 = 0;
                    int max = baselineApiComponents.length;
                    while (i2 < max) {
                        IApiComponent apiComponent = baselineApiComponents[i2];
                        String id = apiComponent.getId();
                        if (!visitedApiComponentNames.remove(id)) {
                            IApiProblem problem = ApiProblemFactory.newApiProblem((String)id, null, (String[])new String[]{id}, (String[])new String[]{"org.eclipse.jdt.internal.core.JavaModelManager.handleId", "apiMarkerID"}, (Object[])new Object[]{id, new Integer(2)}, (int)0, (int)-1, (int)-1, (int)0x10000000, (int)3, (int)3, (int)3);
                            allProblems.put(id, new IApiProblem[]{problem});
                        }
                        ++i2;
                    }
                }
                catch (CoreException e) {
                    IStatus status = e.getStatus();
                    if (status == null || status.getCode() != 123) {
                        throw new BuildException((Throwable)e);
                    }
                    ApiPlugin.log((Throwable)e);
                    if (this.debug) {
                        System.out.println("API tools verification check : " + (System.currentTimeMillis() - time) + "ms");
                        time = System.currentTimeMillis();
                    }
                    referenceBaseline.dispose();
                    currentBaseline.dispose();
                    StubApiComponent.disposeAllCaches();
                    this.deleteBaseline(this.referenceBaselineLocation, referenceInstallDir);
                    this.deleteBaseline(this.currentBaselineLocation, baselineInstallDir);
                    if (this.debug) {
                        System.out.println("Cleanup : " + (System.currentTimeMillis() - time) + "ms");
                    }
                    break block40;
                }
            }
            catch (Throwable throwable) {
                if (this.debug) {
                    System.out.println("API tools verification check : " + (System.currentTimeMillis() - time) + "ms");
                    time = System.currentTimeMillis();
                }
                referenceBaseline.dispose();
                currentBaseline.dispose();
                StubApiComponent.disposeAllCaches();
                this.deleteBaseline(this.referenceBaselineLocation, referenceInstallDir);
                this.deleteBaseline(this.currentBaselineLocation, baselineInstallDir);
                if (this.debug) {
                    System.out.println("Cleanup : " + (System.currentTimeMillis() - time) + "ms");
                }
                throw throwable;
            }
            if (this.debug) {
                System.out.println("API tools verification check : " + (System.currentTimeMillis() - time) + "ms");
                time = System.currentTimeMillis();
            }
            referenceBaseline.dispose();
            currentBaseline.dispose();
            StubApiComponent.disposeAllCaches();
            this.deleteBaseline(this.referenceBaselineLocation, referenceInstallDir);
            this.deleteBaseline(this.currentBaselineLocation, baselineInstallDir);
            if (this.debug) {
                System.out.println("Cleanup : " + (System.currentTimeMillis() - time) + "ms");
            }
        }
        Summary[] summaries = this.createAllSummaries(allProblems);
        try {
            this.dumpReport(summaries, allNonApiBundles);
        }
        catch (RuntimeException e) {
            ApiPlugin.log((Throwable)e);
            throw e;
        }
    }

    private IApiProblem[] removeDuplicates(IApiProblem[] problems) {
        int length = problems.length;
        if (length <= 1) {
            return problems;
        }
        HashSet<String> uniqueProblems = new HashSet<String>(length);
        ArrayList<IApiProblem> allProblems = null;
        int i = 0;
        while (i < length) {
            IApiProblem apiProblem = problems[i];
            String message = apiProblem.getMessage();
            if (!uniqueProblems.contains(message)) {
                if (allProblems == null) {
                    allProblems = new ArrayList<IApiProblem>(length);
                }
                uniqueProblems.add(message);
                allProblems.add(apiProblem);
            }
            ++i;
        }
        return allProblems.toArray(new IApiProblem[allProblems.size()]);
    }

    private IApiFilterStore getFilterStore(String name) {
        if (this.filters == null) {
            return null;
        }
        return new AntFilterStore(this.debug, this.filters, name);
    }

    private void insertAPIProblems(Element root, Document document, List problems) throws CoreException {
        Element apiProblems = document.createElement("api_problems");
        root.appendChild(apiProblems);
        Element element = null;
        Collections.sort(problems, new Comparator(){

            public int compare(Object o1, Object o2) {
                IApiProblem p1 = (IApiProblem)o1;
                IApiProblem p2 = (IApiProblem)o2;
                return p1.getTypeName().compareTo(p2.getTypeName());
            }
        });
        Iterator iterator = problems.iterator();
        while (iterator.hasNext()) {
            String[] messageArguments;
            int j;
            IApiProblem problem = (IApiProblem)iterator.next();
            element = document.createElement("api_problem");
            element.setAttribute("typeName", String.valueOf(problem.getTypeName()));
            element.setAttribute("id", Integer.toString(problem.getId()));
            element.setAttribute("linenumber", Integer.toString(problem.getLineNumber()));
            element.setAttribute("charstart", Integer.toString(problem.getCharStart()));
            element.setAttribute("charend", Integer.toString(problem.getCharEnd()));
            element.setAttribute("elementkind", Integer.toString(problem.getElementKind()));
            element.setAttribute("severity", Integer.toString(this.getSeverity(problem)));
            element.setAttribute("kind", Integer.toString(problem.getKind()));
            element.setAttribute("flags", Integer.toString(problem.getFlags()));
            element.setAttribute("message", problem.getMessage());
            String[] extraMarkerAttributeIds = problem.getExtraMarkerAttributeIds();
            if (extraMarkerAttributeIds != null && extraMarkerAttributeIds.length != 0) {
                int length = extraMarkerAttributeIds.length;
                Object[] extraMarkerAttributeValues = problem.getExtraMarkerAttributeValues();
                Element extraArgumentsElement = document.createElement("extra_arguments");
                j = 0;
                while (j < length) {
                    Element extraArgumentElement = document.createElement("extra_argument");
                    extraArgumentElement.setAttribute("id", extraMarkerAttributeIds[j]);
                    extraArgumentElement.setAttribute("value", String.valueOf(extraMarkerAttributeValues[j]));
                    extraArgumentsElement.appendChild(extraArgumentElement);
                    ++j;
                }
                element.appendChild(extraArgumentsElement);
            }
            if ((messageArguments = problem.getMessageArguments()) != null && messageArguments.length != 0) {
                int length = messageArguments.length;
                Element messageArgumentsElement = document.createElement("message_arguments");
                j = 0;
                while (j < length) {
                    Element messageArgumentElement = document.createElement("message_argument");
                    messageArgumentElement.setAttribute("value", String.valueOf(messageArguments[j]));
                    messageArgumentsElement.appendChild(messageArgumentElement);
                    ++j;
                }
                element.appendChild(messageArgumentsElement);
            }
            apiProblems.appendChild(element);
        }
    }

    private int getSeverity(IApiProblem problem) {
        String value;
        String key;
        if (this.properties != null && (key = ApiProblemFactory.getProblemSeverityId((IApiProblem)problem)) != null && (value = this.properties.getProperty(key, null)) != null && "Error".equals(value)) {
            return 2;
        }
        return 1;
    }

    public void setDebug(String debugValue) {
        this.debug = Boolean.toString(true).equals(debugValue);
    }

    public void setEEFile(String eeFileLocation) {
        this.eeFileLocation = eeFileLocation;
    }

    public void setExcludeList(String excludeListLocation) {
        this.excludeListLocation = excludeListLocation;
    }

    public void setFilters(String filters) {
        this.filters = filters;
    }

    public void setPreferences(String preferencesLocation) {
        block15: {
            File preferencesFile = new File(preferencesLocation);
            if (!preferencesFile.exists()) {
                return;
            }
            BufferedInputStream inputStream = null;
            try {
                try {
                    inputStream = new BufferedInputStream(new FileInputStream(preferencesFile));
                    Properties temp = new Properties();
                    temp.load(inputStream);
                    this.properties = temp;
                }
                catch (IOException iOException) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void setProfile(String baselineLocation) {
        this.currentBaselineLocation = baselineLocation;
    }

    public void setBaseline(String baselineLocation) {
        this.referenceBaselineLocation = baselineLocation;
    }

    public void setReport(String reportLocation) {
        this.reportLocation = reportLocation;
    }

    private static class AntFilterStore
    implements IApiFilterStore {
        private static final String GLOBAL = "!global!";
        private boolean debug;
        private Map fFilterMap;

        private static int loadIntegerAttribute(Element element, String name) {
            String value = element.getAttribute(name);
            if (value.length() == 0) {
                return -1;
            }
            try {
                int number = Integer.parseInt(value);
                return number;
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }

        public AntFilterStore(boolean debug, String filtersRoot, String componentID) {
            this.initialize(filtersRoot, componentID);
        }

        public void addFiltersFor(IApiProblem[] problems) {
        }

        public void addFilters(IApiProblemFilter[] filters) {
        }

        private boolean argumentsEquals(String[] problemMessageArguments, String[] filterProblemMessageArguments) {
            int length = problemMessageArguments.length;
            if (length == filterProblemMessageArguments.length) {
                int i = 0;
                while (i < length) {
                    String problemMessageArgument = problemMessageArguments[i];
                    String filterProblemMessageArgument = filterProblemMessageArguments[i];
                    if (!problemMessageArgument.equals(filterProblemMessageArgument)) {
                        int index = problemMessageArgument.lastIndexOf(46);
                        int filterProblemIndex = filterProblemMessageArgument.lastIndexOf(46);
                        if (index == -1) {
                            if (filterProblemIndex == -1) {
                                return false;
                            }
                            if (!filterProblemMessageArgument.substring(filterProblemIndex + 1).equals(problemMessageArgument)) {
                                return false;
                            }
                        } else {
                            if (filterProblemIndex != -1) {
                                return false;
                            }
                            if (!problemMessageArgument.substring(index + 1).equals(filterProblemMessageArgument)) {
                                return false;
                            }
                        }
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }

        public void dispose() {
        }

        public IApiProblemFilter[] getFilters(IResource resource) {
            return null;
        }

        public IResource[] getResources() {
            return null;
        }

        /*
         * Unable to fully structure code
         */
        private void initialize(String filtersRoot, String componentID) {
            block33: {
                block34: {
                    if (this.fFilterMap != null) {
                        return;
                    }
                    if (this.debug) {
                        System.out.println("null filter map, creating a new one");
                    }
                    this.fFilterMap = new HashMap<K, V>(5);
                    xml = null;
                    contents = null;
                    filterFileParent = new File(filtersRoot, componentID);
                    if (filterFileParent.exists()) break block33;
                    if (contents == null) break block34;
                    try {
                        contents.close();
                    }
                    catch (IOException v0) {}
                }
                return;
            }
            try {
                try {
                    contents = new BufferedInputStream(new FileInputStream(new File(filterFileParent, ".api_filters")));
                    xml = new String(Util.getInputStreamAsCharArray((InputStream)contents, (int)-1, (String)"UTF-8"));
                }
                catch (IOException v1) {
                    if (contents == null) ** GOTO lbl44
                    try {
                        contents.close();
                    }
                    catch (IOException v2) {}
                }
            }
            catch (Throwable var6_6) {
                if (contents != null) {
                    try {
                        contents.close();
                    }
                    catch (IOException v3) {}
                }
                throw var6_6;
            }
            if (contents != null) {
                try {
                    contents.close();
                }
                catch (IOException v4) {}
            }
lbl44:
            // 7 sources

            if (xml == null) {
                return;
            }
            root = null;
            try {
                root = Util.parseDocument(xml);
            }
            catch (CoreException ce) {
                ApiPlugin.log((Throwable)ce);
            }
            if (root == null) {
                return;
            }
            if (!root.getNodeName().equals("component")) {
                return;
            }
            component = root.getAttribute("id");
            if (component.length() == 0) {
                return;
            }
            versionValue = root.getAttribute("version");
            version = 0;
            if (versionValue.length() != 0) {
                try {
                    version = Integer.parseInt(versionValue);
                }
                catch (NumberFormatException v5) {}
            }
            if (version < 2) {
                return;
            }
            resources = root.getElementsByTagName("resource");
            newfilters = new ArrayList<IApiProblem>();
            i = 0;
            while (i < resources.getLength()) {
                element = (Element)resources.item(i);
                typeName = element.getAttribute("type");
                if (typeName != null && typeName.length() != 0) {
                    filters = element.getElementsByTagName("filter");
                    j = 0;
                    while (j < filters.getLength()) {
                        element = (Element)filters.item(j);
                        id = AntFilterStore.loadIntegerAttribute(element, "id");
                        if (id > 0) {
                            messageargs = null;
                            elements = element.getElementsByTagName("message_arguments");
                            if (elements.getLength() == 1) {
                                messageArguments = (Element)elements.item(0);
                                arguments = messageArguments.getElementsByTagName("message_argument");
                                length = arguments.getLength();
                                messageargs = new String[length];
                                k = 0;
                                while (k < length) {
                                    messageArgument = (Element)arguments.item(k);
                                    messageargs[k] = messageArgument.getAttribute("value");
                                    ++k;
                                }
                                newfilters.add(ApiProblemFactory.newApiProblem(null, (String)typeName, (String[])messageargs, null, null, (int)-1, (int)-1, (int)-1, (int)id));
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            this.internalAddFilters(componentID, newfilters.toArray(new IApiProblem[newfilters.size()]));
            newfilters.clear();
        }

        private void internalAddFilters(String componentID, IApiProblem[] problems) {
            if (problems == null) {
                if (this.debug) {
                    System.out.println("null problems array not addding filters");
                }
                return;
            }
            int i = 0;
            while (i < problems.length) {
                HashSet<ApiProblemFilter> filters;
                IApiProblem problem = problems[i];
                ApiProblemFilter filter = new ApiProblemFilter(componentID, problem);
                String typeName = problem.getTypeName();
                if (typeName == null) {
                    typeName = GLOBAL;
                }
                if ((filters = (HashSet<ApiProblemFilter>)this.fFilterMap.get(typeName)) == null) {
                    filters = new HashSet<ApiProblemFilter>();
                    this.fFilterMap.put(typeName, filters);
                }
                filters.add(filter);
                ++i;
            }
        }

        public boolean isFiltered(IApiProblem problem) {
            if (this.fFilterMap == null || this.fFilterMap.isEmpty()) {
                return false;
            }
            String typeName = problem.getTypeName();
            Set filters = (Set)this.fFilterMap.get(typeName);
            if (filters == null) {
                return false;
            }
            Iterator iterator = filters.iterator();
            while (iterator.hasNext()) {
                IApiProblemFilter filter = (IApiProblemFilter)iterator.next();
                if (problem.getCategory() == 0x20000000) {
                    return this.matchUsageProblem(filter.getUnderlyingProblem(), problem);
                }
                if (!filter.getUnderlyingProblem().equals(problem)) continue;
                return true;
            }
            return false;
        }

        private boolean matchUsageProblem(IApiProblem filterProblem, IApiProblem problem) {
            if (problem.getId() == filterProblem.getId()) {
                String problemPath = problem.getResourcePath();
                String filterProblemPath = filterProblem.getResourcePath();
                if (problemPath == null) {
                    if (filterProblemPath != null) {
                        return false;
                    }
                } else {
                    if (filterProblemPath == null) {
                        return false;
                    }
                    if (!new Path(problemPath).equals((Object)new Path(filterProblemPath))) {
                        return false;
                    }
                }
                String problemTypeName = problem.getTypeName();
                String filterProblemTypeName = filterProblem.getTypeName();
                if (problemTypeName == null) {
                    if (filterProblemTypeName != null) {
                        return false;
                    }
                } else {
                    if (filterProblemTypeName == null) {
                        return false;
                    }
                    if (!problemTypeName.equals(filterProblemTypeName)) {
                        return false;
                    }
                }
                return this.argumentsEquals(problem.getMessageArguments(), filterProblem.getMessageArguments());
            }
            return false;
        }

        public boolean removeFilters(IApiProblemFilter[] filters) {
            return false;
        }
    }

    private static class Summary {
        List apiBundleVersionProblems = new ArrayList();
        List apiCompatibilityProblems = new ArrayList();
        List apiUsageProblems = new ArrayList();
        String componentID;

        public Summary(String componentID, IApiProblem[] apiProblems) {
            this.componentID = componentID;
            int i = 0;
            int max = apiProblems.length;
            while (i < max) {
                IApiProblem problem = apiProblems[i];
                switch (problem.getCategory()) {
                    case 0x10000000: {
                        this.apiCompatibilityProblems.add(problem);
                        break;
                    }
                    case 0x20000000: {
                        this.apiUsageProblems.add(problem);
                        break;
                    }
                    case 0x30000000: {
                        this.apiBundleVersionProblems.add(problem);
                    }
                }
                ++i;
            }
        }

        private void dumpProblems(String title, List problemsList, PrintWriter printWriter) {
            printWriter.println(title);
            if (problemsList.size() != 0) {
                Iterator iterator = problemsList.iterator();
                while (iterator.hasNext()) {
                    IApiProblem problem = (IApiProblem)iterator.next();
                    printWriter.println(problem.getMessage());
                }
            } else {
                printWriter.println("None");
            }
        }

        public String getDetails() {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            printWriter.println("==================================================================================");
            printWriter.println("Details for " + this.componentID + ":");
            printWriter.println("==================================================================================");
            this.dumpProblems("Usage", this.apiUsageProblems, printWriter);
            this.dumpProblems("Compatibility", this.apiCompatibilityProblems, printWriter);
            this.dumpProblems("Bundle versions", this.apiBundleVersionProblems, printWriter);
            printWriter.println("==================================================================================");
            printWriter.flush();
            printWriter.close();
            return String.valueOf(writer.getBuffer());
        }

        public String getTitle() {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            this.printTitle(printWriter);
            printWriter.flush();
            printWriter.close();
            return String.valueOf(writer.getBuffer());
        }

        private void printTitle(PrintWriter printWriter) {
            printWriter.print("Results for " + this.componentID + " : ");
            printWriter.print('(');
            printWriter.print("total: ");
            printWriter.print(this.apiUsageProblems.size() + this.apiBundleVersionProblems.size() + this.apiCompatibilityProblems.size());
            printWriter.print(',');
            printWriter.print("usage: ");
            printWriter.print(this.apiUsageProblems.size());
            printWriter.print(',');
            printWriter.print("compatibility: ");
            printWriter.print(this.apiCompatibilityProblems.size());
            printWriter.print(',');
            printWriter.print("bundle version: ");
            printWriter.print(this.apiBundleVersionProblems.size());
            printWriter.println(')');
        }

        public String toString() {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            this.printTitle(printWriter);
            this.dumpProblems("Usage", this.apiUsageProblems, printWriter);
            this.dumpProblems("Compatibility", this.apiCompatibilityProblems, printWriter);
            this.dumpProblems("Bundle versions", this.apiBundleVersionProblems, printWriter);
            printWriter.flush();
            printWriter.close();
            return String.valueOf(writer.getBuffer());
        }
    }
}

