/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.natives.actions;

import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Util;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRequest;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IFileArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningAction;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;

public class CollectAction
extends ProvisioningAction {
    public static final String ACTION_COLLECT = "collect";

    public IStatus execute(Map parameters) {
        IProfile profile = (IProfile)parameters.get("profile");
        InstallableUnitOperand operand = (InstallableUnitOperand)parameters.get("operand");
        try {
            IArtifactRequest[] requests = this.collect(operand.second(), profile);
            Collection artifactRequests = (Collection)parameters.get("artifactRequests");
            artifactRequests.add(requests);
        }
        catch (ProvisionException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    public IStatus undo(Map parameters) {
        return Status.OK_STATUS;
    }

    IArtifactRequest[] collect(IInstallableUnit installableUnit, IProfile profile) throws ProvisionException {
        IArtifactKey[] toDownload = installableUnit.getArtifacts();
        if (toDownload == null) {
            return new IArtifactRequest[0];
        }
        IFileArtifactRepository destination = Util.getDownloadCacheRepo();
        IArtifactRequest[] requests = new IArtifactRequest[toDownload.length];
        int count = 0;
        int i = 0;
        while (i < toDownload.length) {
            requests[count++] = Util.getArtifactRepositoryManager().createMirrorRequest(toDownload[i], (IArtifactRepository)destination, null, null);
            ++i;
        }
        if (requests.length == count) {
            return requests;
        }
        IArtifactRequest[] result = new IArtifactRequest[count];
        System.arraycopy(requests, 0, result, 0, count);
        return result;
    }
}

