/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions;

import java.io.File;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Util;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions.Messages;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningAction;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.osgi.util.NLS;

public class AddProgramArgumentAction
extends ProvisioningAction {
    public static final String ID = "addProgramArg";

    public IStatus execute(Map parameters) {
        Manipulator manipulator = (Manipulator)parameters.get("manipulator");
        String programArg = (String)parameters.get("programArg");
        if (programArg == null) {
            return Util.createError(NLS.bind((String)Messages.parameter_not_set, (Object)"programArg", (Object)ID));
        }
        String programArgValue = (String)parameters.get("programArgValue");
        if ("@ignore".equals(programArgValue)) {
            return Status.OK_STATUS;
        }
        if (programArg.equals("@artifact")) {
            try {
                programArg = AddProgramArgumentAction.resolveArtifactParam(parameters);
            }
            catch (CoreException e) {
                return e.getStatus();
            }
        }
        manipulator.getLauncherData().addProgramArg(programArg);
        if (programArgValue != null) {
            if (programArgValue.equals("@artifact")) {
                try {
                    programArgValue = AddProgramArgumentAction.resolveArtifactParam(parameters);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
            }
            manipulator.getLauncherData().addProgramArg(programArgValue);
        }
        return Status.OK_STATUS;
    }

    public IStatus undo(Map parameters) {
        Manipulator manipulator = (Manipulator)parameters.get("manipulator");
        String programArg = (String)parameters.get("programArg");
        if (programArg == null) {
            return Util.createError(NLS.bind((String)Messages.parameter_not_set, (Object)"programArg", (Object)ID));
        }
        String programArgValue = (String)parameters.get("programArgValue");
        if ("@ignore".equals(programArgValue)) {
            return Status.OK_STATUS;
        }
        if (programArg.startsWith("-")) {
            manipulator.getLauncherData().removeProgramArg(programArg);
        }
        return Status.OK_STATUS;
    }

    private static String resolveArtifactParam(Map parameters) throws CoreException {
        IProfile profile = (IProfile)parameters.get("profile");
        IInstallableUnit iu = (IInstallableUnit)parameters.get("iu");
        IArtifactKey[] artifacts = iu.getArtifacts();
        if (artifacts == null || artifacts.length == 0) {
            throw new CoreException(Util.createError(NLS.bind((String)Messages.iu_contains_no_arifacts, (Object)iu)));
        }
        IArtifactKey artifactKey = artifacts[0];
        File fileLocation = Util.getArtifactFile(artifactKey, profile);
        if (fileLocation == null || !fileLocation.exists()) {
            throw new CoreException(Util.createError(NLS.bind((String)Messages.artifact_file_not_found, (Object)artifactKey)));
        }
        return fileLocation.getAbsolutePath();
    }
}

