/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.artifact.repository.ant;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.artifact.mirror.IArtifactMirrorLog;
import org.eclipse.equinox.internal.p2.artifact.repository.Messages;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;

public class AntMirrorLog
implements IArtifactMirrorLog {
    private boolean consoleMessage = false;
    private Method log;
    private Object task;
    static /* synthetic */ Class class$0;

    public AntMirrorLog(Object task) throws NoSuchMethodException {
        this.task = task;
        try {
            Class<?> clazz = task.getClass();
            Class[] classArray = new Class[2];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            classArray[1] = Integer.TYPE;
            this.log = clazz.getMethod("log", classArray);
        }
        catch (SecurityException e) {
            this.exceptionOccurred(null, e);
        }
    }

    public void log(IArtifactDescriptor descriptor, IStatus status) {
        this.log(descriptor.toString(), status.getSeverity());
        this.log(status);
    }

    public void log(IStatus status) {
        IStatus[] nestedStatus;
        int severity = status.getSeverity();
        this.log(status.getMessage(), severity);
        if (status.getException() != null) {
            this.log(status.getException().getMessage(), severity);
        }
        if ((nestedStatus = status.getChildren()) != null) {
            int i = 0;
            while (i < nestedStatus.length) {
                this.log(nestedStatus[i]);
                ++i;
            }
        }
    }

    public void close() {
    }

    private void log(String message, int statusSeverity) {
        try {
            this.log.invoke(this.task, message, new Integer(this.mapLogLevels(statusSeverity)));
        }
        catch (IllegalArgumentException e) {
            this.exceptionOccurred(message, e);
        }
        catch (IllegalAccessException e) {
            this.exceptionOccurred(message, e);
        }
        catch (InvocationTargetException e) {
            this.exceptionOccurred(message, e);
        }
    }

    private void exceptionOccurred(String message, Exception e) {
        if (!this.consoleMessage) {
            System.err.println(Messages.MirrorLog_Exception_Occurred);
            e.printStackTrace(System.err);
            System.err.println(Messages.MirrorLog_Console_Log);
            this.consoleMessage = true;
        }
        if (message != null) {
            System.out.println(message);
        }
    }

    private int mapLogLevels(int iStatusLevel) {
        switch (iStatusLevel) {
            case 4: {
                return 0;
            }
            case 0: {
                return 2;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
        }
        return 1;
    }
}

