/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;

public class FileTransfer
extends ByteArrayTransfer {
    static FileTransfer _instance = new FileTransfer();
    static final String URI_LIST = "text/uri-list";
    static final int URI_LIST_ID = FileTransfer.registerType("text/uri-list");
    static final String URI_LIST_PREFIX = "file:";
    static final String URI_LIST_SEPARATOR = "\r";

    FileTransfer() {
    }

    public static FileTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        transferData.result = 0;
        if (!this.checkFile(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        String[] files = (String[])object;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int length = files.length;
        while (i < length) {
            sb.append(URI_LIST_PREFIX);
            sb.append(files[i]);
            sb.append(URI_LIST_SEPARATOR);
            ++i;
        }
        byte[] buffer = Converter.wcsToMbcs(null, sb.toString(), true);
        int pValue = OS.XtMalloc(buffer.length);
        if (pValue == 0) {
            return;
        }
        OS.memmove(pValue, buffer, buffer.length);
        transferData.length = buffer.length;
        transferData.format = 8;
        transferData.pValue = pValue;
        transferData.result = 1;
    }

    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pValue == 0) {
            return null;
        }
        int size = transferData.format * transferData.length / 8;
        if (size == 0) {
            return null;
        }
        byte[] buffer = new byte[size];
        OS.memmove(buffer, transferData.pValue, size);
        char[] chars = Converter.mbcsToWcs(null, buffer);
        String string = new String(chars);
        int start = string.indexOf(URI_LIST_PREFIX);
        if (start == -1) {
            return null;
        }
        start += URI_LIST_PREFIX.length();
        String[] fileNames = new String[]{};
        while (start < string.length()) {
            int end = string.indexOf(URI_LIST_SEPARATOR, start);
            if (end == -1) {
                end = string.length() - 1;
            }
            String fileName = string.substring(start, end);
            String[] newFileNames = new String[fileNames.length + 1];
            System.arraycopy(fileNames, 0, newFileNames, 0, fileNames.length);
            newFileNames[fileNames.length] = fileName;
            fileNames = newFileNames;
            start = string.indexOf(URI_LIST_PREFIX, end);
            if (start == -1) break;
            start += URI_LIST_PREFIX.length();
        }
        return fileNames;
    }

    protected int[] getTypeIds() {
        return new int[]{URI_LIST_ID};
    }

    protected String[] getTypeNames() {
        return new String[]{URI_LIST};
    }

    boolean checkFile(Object object) {
        if (object == null || !(object instanceof String[]) || ((String[])object).length == 0) {
            return false;
        }
        String[] strings = (String[])object;
        int i = 0;
        while (i < strings.length) {
            if (strings[i] == null || strings[i].length() == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean validate(Object object) {
        return this.checkFile(object);
    }
}

