/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.StubTypeContext;
import org.eclipse.jdt.internal.corext.refactoring.TypeContextChecker;
import org.eclipse.jdt.internal.corext.refactoring.structure.ChangeSignatureProcessor;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.JavaTypeCompletionProcessor;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ParameterEditDialog
extends StatusDialog {
    private final ParameterInfo fParameter;
    private final boolean fEditType;
    private final boolean fEditDefault;
    private final StubTypeContext fContext;
    private Text fType;
    private Text fName;
    private Text fDefaultValue;

    public ParameterEditDialog(Shell parentShell, ParameterInfo parameter, boolean canEditType, boolean canEditDefault, StubTypeContext context) {
        super(parentShell);
        this.fParameter = parameter;
        this.fEditType = canEditType;
        this.fEditDefault = canEditDefault;
        this.fContext = context;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(RefactoringMessages.ParameterEditDialog_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)result.getLayout();
        layout.numColumns = 2;
        Label label = new Label(result, 0);
        String newName = this.fParameter.getNewName();
        if (newName.length() == 0) {
            label.setText(RefactoringMessages.ParameterEditDialog_message_new);
        } else {
            label.setText(Messages.format(RefactoringMessages.ParameterEditDialog_message, BasicElementLabels.getJavaElementName(newName)));
        }
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        if (this.fEditType) {
            label = new Label(result, 0);
            label.setText(RefactoringMessages.ParameterEditDialog_type);
            this.fType = new Text(result, 2048);
            gd = new GridData(768);
            this.fType.setLayoutData((Object)gd);
            this.fType.setText(this.fParameter.getNewTypeName());
            this.fType.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ParameterEditDialog.this.validate((Text)e.widget);
                }
            });
            TextFieldNavigationHandler.install(this.fType);
            JavaTypeCompletionProcessor processor = new JavaTypeCompletionProcessor(true, false);
            processor.setCompletionContext(this.fContext.getCuHandle(), this.fContext.getBeforeString(), this.fContext.getAfterString());
            ControlContentAssistHelper.createTextContentAssistant(this.fType, processor);
        }
        label = new Label(result, 0);
        this.fName = new Text(result, 2048);
        this.initializeDialogUnits((Control)this.fName);
        label.setText(RefactoringMessages.ParameterEditDialog_name);
        gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(45);
        this.fName.setLayoutData((Object)gd);
        this.fName.setText(newName);
        this.fName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ParameterEditDialog.this.validate((Text)e.widget);
            }
        });
        TextFieldNavigationHandler.install(this.fName);
        if (this.fEditDefault && this.fParameter.isAdded()) {
            label = new Label(result, 0);
            label.setText(RefactoringMessages.ParameterEditDialog_defaultValue);
            this.fDefaultValue = new Text(result, 2048);
            gd = new GridData(768);
            this.fDefaultValue.setLayoutData((Object)gd);
            this.fDefaultValue.setText(this.fParameter.getDefaultValue());
            this.fDefaultValue.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ParameterEditDialog.this.validate((Text)e.widget);
                }
            });
            TextFieldNavigationHandler.install(this.fDefaultValue);
        }
        ParameterEditDialog.applyDialogFont((Control)result);
        return result;
    }

    protected void okPressed() {
        if (this.fType != null) {
            this.fParameter.setNewTypeName(this.fType.getText());
        }
        this.fParameter.setNewName(this.fName.getText());
        if (this.fDefaultValue != null) {
            this.fParameter.setDefaultValue(this.fDefaultValue.getText());
        }
        super.okPressed();
    }

    private void validate(Text first) {
        IStatus[] result = new IStatus[3];
        if (first == this.fType) {
            result[0] = this.validateType();
            result[1] = this.validateName();
            result[2] = this.validateDefaultValue();
        } else if (first == this.fName) {
            result[0] = this.validateName();
            result[1] = this.validateType();
            result[2] = this.validateDefaultValue();
        } else {
            result[0] = this.validateDefaultValue();
            result[1] = this.validateName();
            result[2] = this.validateType();
        }
        int i = 0;
        while (i < result.length) {
            IStatus status = result[i];
            if (status != null && !status.isOK()) {
                this.updateStatus(status);
                return;
            }
            ++i;
        }
        this.updateStatus((IStatus)this.createOkStatus());
    }

    private IStatus validateType() {
        if (this.fType == null) {
            return null;
        }
        String type = this.fType.getText();
        RefactoringStatus status = TypeContextChecker.checkParameterTypeSyntax(type, this.fContext.getCuHandle().getJavaProject());
        if (status == null || status.isOK()) {
            return this.createOkStatus();
        }
        if (status.hasError()) {
            return this.createErrorStatus(status.getEntryWithHighestSeverity().getMessage());
        }
        return this.createWarningStatus(status.getEntryWithHighestSeverity().getMessage());
    }

    private IStatus validateName() {
        IStatus status;
        if (this.fName == null) {
            return null;
        }
        String text = this.fName.getText();
        if (text.length() == 0) {
            return this.createErrorStatus(RefactoringMessages.ParameterEditDialog_name_error);
        }
        IStatus iStatus = status = this.fContext != null ? JavaConventionsUtil.validateFieldName(text, (IJavaElement)this.fContext.getCuHandle().getJavaProject()) : JavaConventions.validateFieldName((String)text, (String)"1.3", (String)"1.3");
        if (status.matches(4)) {
            return status;
        }
        if (!Checks.startsWithLowerCase(text)) {
            return this.createWarningStatus(RefactoringCoreMessages.ExtractTempRefactoring_convention);
        }
        return this.createOkStatus();
    }

    private IStatus validateDefaultValue() {
        if (this.fDefaultValue == null) {
            return null;
        }
        String defaultValue = this.fDefaultValue.getText();
        if (defaultValue.length() == 0) {
            return this.createErrorStatus(RefactoringMessages.ParameterEditDialog_defaultValue_error);
        }
        if (ChangeSignatureProcessor.isValidExpression(defaultValue)) {
            return this.createOkStatus();
        }
        String msg = Messages.format(RefactoringMessages.ParameterEditDialog_defaultValue_invalid, new String[]{defaultValue});
        return this.createErrorStatus(msg);
    }

    private Status createOkStatus() {
        return new Status(0, JavaPlugin.getPluginId(), 0, "", null);
    }

    private Status createWarningStatus(String message) {
        return new Status(2, JavaPlugin.getPluginId(), 2, message, null);
    }

    private Status createErrorStatus(String message) {
        return new Status(4, JavaPlugin.getPluginId(), 4, message, null);
    }
}

