/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.generator.ant;

import java.net.URISyntaxException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.metadata.generator.EclipseGeneratorApplication;
import org.eclipse.equinox.internal.p2.metadata.generator.ant.TaskMessages;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.EclipseInstallGeneratorInfoProvider;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.IncrementalGenerator;

public class GeneratorTask
extends Task {
    protected EclipseInstallGeneratorInfoProvider provider = null;
    protected EclipseGeneratorApplication generator = null;
    private String mode;

    public void execute() throws BuildException {
        try {
            IncrementalGenerator incremental = new IncrementalGenerator();
            incremental.setMode(this.mode);
            incremental.run(this.generator, this.provider);
            if (!"incremental".equals(this.mode)) {
                this.provider = null;
                this.generator = null;
            }
        }
        catch (Exception e) {
            throw new BuildException(TaskMessages.exception_errorOccurredCallingGenerator, (Throwable)e);
        }
    }

    public void setAppend(String value) {
        if (this.provider == null) {
            this.provider = new EclipseInstallGeneratorInfoProvider();
        }
        this.provider.setAppend(Boolean.valueOf(value).booleanValue());
    }

    public void setArtifactRepository(String location) {
        if (this.generator == null) {
            this.generator = new EclipseGeneratorApplication();
        }
        try {
            this.generator.setArtifactLocation(URIUtil.fromString((String)location));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Specified artifact repository location (" + location + ") is not a valid URI. ");
        }
    }

    public void setArtifactRepositoryName(String name) {
        if (this.generator == null) {
            this.generator = new EclipseGeneratorApplication();
        }
        this.generator.setArtifactRepositoryName(name);
    }

    public void setBase(String value) {
        if (this.generator == null) {
            this.generator = new EclipseGeneratorApplication();
        }
        this.generator.setBase(value);
    }

    public void setBundles(String value) {
        if (this.generator == null) {
            this.generator = new EclipseGeneratorApplication();
        }
        this.generator.setBundles(value);
    }

    public void setCompress(String value) {
        if (this.generator == null) {
            this.generator = new EclipseGeneratorApplication();
        }
        this.generator.setCompress(value);
    }

    public void setConfig(String value) {
        if (this.generator == null) {
            this.generator = new EclipseGeneratorApplication();
        }
        this.generator.setOperation("-config", value);
    }

    public void setInplace(String value) {
        if (this.generator == null) {
            this.generator = new EclipseGeneratorApplication();
        }
        this.generator.setOperation("-inplace", value);
    }

    public void setSource(String location) {
        if (this.generator == null) {
            this.generator = new EclipseGeneratorApplication();
        }
        this.generator.setOperation("-source", location);
    }

    public void setUpdateSite(String value) {
        if (this.generator == null) {
            this.generator = new EclipseGeneratorApplication();
        }
        this.generator.setOperation("-updateSite", value);
    }

    public void setExe(String value) {
        if (this.provider == null) {
            this.provider = new EclipseInstallGeneratorInfoProvider();
        }
        this.provider.setExecutableLocation(value);
    }

    public void setFeatures(String value) {
        if (this.generator == null) {
            this.generator = new EclipseGeneratorApplication();
        }
        this.generator.setFeatures(value);
    }

    public void setFlavor(String flavor) {
        if (this.provider == null) {
            this.provider = new EclipseInstallGeneratorInfoProvider();
        }
        this.provider.setFlavor(flavor);
    }

    public void setLauncherConfig(String launcherConfig) {
        if (this.provider == null) {
            this.provider = new EclipseInstallGeneratorInfoProvider();
        }
        this.provider.setLauncherConfig(launcherConfig);
    }

    public void setMetadataRepository(String location) {
        if (this.generator == null) {
            this.generator = new EclipseGeneratorApplication();
        }
        try {
            this.generator.setMetadataLocation(URIUtil.fromString((String)location));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Specified metadata repository location (" + location + ") is not a valid URI. ");
        }
    }

    public void setMetadataRepositoryName(String name) {
        if (this.generator == null) {
            this.generator = new EclipseGeneratorApplication();
        }
        this.generator.setMetadataRepositoryName(name);
    }

    public void setNoDefaultIUs(String value) {
        if (this.provider == null) {
            this.provider = new EclipseInstallGeneratorInfoProvider();
        }
        this.provider.setAddDefaultIUs(Boolean.valueOf(value) == false);
    }

    public void setP2OS(String value) {
        if (this.provider == null) {
            this.provider = new EclipseInstallGeneratorInfoProvider();
        }
        this.provider.setOS(value);
    }

    public void setProductFile(String file) {
        if (this.provider == null) {
            this.provider = new EclipseInstallGeneratorInfoProvider();
        }
        this.provider.setProductFile(file);
    }

    public void setPublishArtifactRepository(String value) {
        if (this.provider == null) {
            this.provider = new EclipseInstallGeneratorInfoProvider();
        }
        this.provider.setPublishArtifactRepository(Boolean.valueOf(value).booleanValue());
    }

    public void setPublishArtifacts(String value) {
        if (this.provider == null) {
            this.provider = new EclipseInstallGeneratorInfoProvider();
        }
        this.provider.setPublishArtifacts(Boolean.valueOf(value).booleanValue());
    }

    public void setRoot(String root) {
        if (root == null || root.startsWith("${")) {
            return;
        }
        if (this.provider == null) {
            this.provider = new EclipseInstallGeneratorInfoProvider();
        }
        this.provider.setRootId(root);
    }

    public void setRootVersion(String rootVersion) {
        if (rootVersion == null || rootVersion.startsWith("${")) {
            return;
        }
        if (this.provider == null) {
            this.provider = new EclipseInstallGeneratorInfoProvider();
        }
        this.provider.setRootVersion(rootVersion);
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void setVersionAdvice(String advice) {
        if (this.provider == null) {
            this.provider = new EclipseInstallGeneratorInfoProvider();
        }
        this.provider.setVersionAdvice(advice);
    }

    public void setSite(String site) {
        if (site == null || site.startsWith("${")) {
            return;
        }
        if (this.provider == null) {
            this.provider = new EclipseInstallGeneratorInfoProvider();
        }
        try {
            this.provider.setSiteLocation(URIUtil.fromString((String)site));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("The specified location (" + site + ") is not a valid URI.");
        }
    }
}

