/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata;

import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequiredCapability;

public class ProvidedCapability
implements IProvidedCapability {
    private final String name;
    private final String namespace;
    private final Version version;

    public ProvidedCapability(String namespace, String name, Version version) {
        Assert.isNotNull((Object)namespace);
        Assert.isNotNull((Object)name);
        this.namespace = namespace;
        this.name = name;
        this.version = version == null ? Version.emptyVersion : version;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof IProvidedCapability)) {
            return false;
        }
        IProvidedCapability otherCapability = (IProvidedCapability)other;
        if (!this.namespace.equals(otherCapability.getNamespace())) {
            return false;
        }
        if (!this.name.equals(otherCapability.getName())) {
            return false;
        }
        return this.version.equals((Object)otherCapability.getVersion());
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Version getVersion() {
        return this.version;
    }

    public int hashCode() {
        return this.namespace.hashCode() * this.name.hashCode() * this.version.hashCode();
    }

    public boolean satisfies(IRequiredCapability candidate) {
        if (this.getName() == null || !this.getName().equals(candidate.getName())) {
            return false;
        }
        if (this.getNamespace() == null || !this.getNamespace().equals(candidate.getNamespace())) {
            return false;
        }
        return candidate.getRange().isIncluded(this.version);
    }

    public String toString() {
        return String.valueOf(this.namespace) + '/' + this.name + '/' + this.version;
    }
}

