/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.variables.details;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.variables.details.DetailMessages;
import org.eclipse.debug.internal.ui.views.variables.details.DetailPaneManager;
import org.eclipse.debug.internal.ui.views.variables.details.IDetailPaneContainer;
import org.eclipse.debug.internal.ui.views.variables.details.IDetailPaneContainer2;
import org.eclipse.debug.ui.IDetailPane;
import org.eclipse.debug.ui.IDetailPane2;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbenchPartSite;

public class DetailPaneProxy {
    private IDetailPane fCurrentPane;
    private Control fCurrentControl;
    private IDetailPaneContainer fParentContainer;

    public DetailPaneProxy(IDetailPaneContainer parent) {
        this.fParentContainer = parent;
    }

    public void display(IStructuredSelection selection) {
        if ((selection == null || selection.isEmpty()) && this.fCurrentPane != null) {
            this.fCurrentPane.display(selection);
            return;
        }
        String preferredPaneID = DetailPaneManager.getDefault().getPreferredPaneFromSelection(selection);
        if (this.fCurrentPane != null && preferredPaneID != null && preferredPaneID.equals(this.fCurrentPane.getID())) {
            this.fCurrentPane.display(selection);
            return;
        }
        this.setupPane(preferredPaneID, selection);
        this.fParentContainer.paneChanged(preferredPaneID);
    }

    public boolean setFocus() {
        if (this.fCurrentPane != null) {
            return this.fCurrentPane.setFocus();
        }
        return false;
    }

    public void dispose() {
        if (this.fCurrentPane != null) {
            this.fCurrentPane.dispose();
        }
        if (this.fCurrentControl != null && !this.fCurrentControl.isDisposed()) {
            this.fCurrentControl.dispose();
        }
    }

    public Object getAdapter(Class required) {
        if (this.fCurrentPane != null && this.fCurrentPane instanceof IAdaptable) {
            return ((IAdaptable)this.fCurrentPane).getAdapter(required);
        }
        return null;
    }

    public Control getCurrentControl() {
        return this.fCurrentControl;
    }

    public String getCurrentPaneID() {
        if (this.fCurrentPane != null) {
            return this.fCurrentPane.getID();
        }
        return null;
    }

    private void setupPane(String paneID, IStructuredSelection selection) {
        if (this.fCurrentPane != null) {
            this.fCurrentPane.dispose();
        }
        if (this.fCurrentControl != null && !this.fCurrentControl.isDisposed()) {
            this.fCurrentControl.dispose();
        }
        this.fCurrentPane = null;
        if (paneID != null) {
            this.fCurrentPane = DetailPaneManager.getDefault().getDetailPaneFromID(paneID);
            if (this.fCurrentPane != null) {
                IWorkbenchPartSite workbenchPartSite = this.fParentContainer.getWorkbenchPartSite();
                this.fCurrentPane.init(workbenchPartSite);
                this.fCurrentControl = this.fCurrentPane.createControl(this.fParentContainer.getParentComposite());
                if (this.fCurrentControl != null) {
                    this.fParentContainer.getParentComposite().layout(true);
                    this.fCurrentPane.display(selection);
                    if (this.fParentContainer instanceof IDetailPaneContainer2) {
                        this.fCurrentControl.addFocusListener((FocusListener)new FocusAdapter(){

                            public void focusGained(FocusEvent e) {
                                DetailPaneProxy.this.updateSelectionProvider(true);
                            }

                            public void focusLost(FocusEvent e) {
                                DetailPaneProxy.this.updateSelectionProvider(false);
                            }
                        });
                    }
                } else {
                    this.createErrorLabel(DetailMessages.DetailPaneProxy_0);
                    DebugUIPlugin.log(new CoreException((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), MessageFormat.format((String)DetailMessages.DetailPaneProxy_2, (Object[])new String[]{this.fCurrentPane.getID()}))));
                }
            } else {
                this.createErrorLabel(DetailMessages.DetailPaneProxy_0);
                DebugUIPlugin.log(new CoreException((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), MessageFormat.format((String)DetailMessages.DetailPaneProxy_3, (Object[])new String[]{paneID}))));
            }
        } else {
            this.createErrorLabel(DetailMessages.DetailPaneProxy_1);
        }
    }

    protected void updateSelectionProvider(boolean hasFocus) {
        if (this.fParentContainer instanceof IDetailPaneContainer2) {
            IDetailPaneContainer2 container2 = (IDetailPaneContainer2)this.fParentContainer;
            if (this.fCurrentPane instanceof IDetailPane2) {
                ISelectionProvider provider = hasFocus ? ((IDetailPane2)this.fCurrentPane).getSelectionProvider() : null;
                container2.setSelectionProvider(provider);
            } else {
                IWorkbenchPartSite site = container2.getWorkbenchPartSite();
                if (site != null) {
                    container2.setSelectionProvider(site.getSelectionProvider());
                }
            }
        }
    }

    private void createErrorLabel(String message) {
        if (this.fCurrentPane != null) {
            this.fCurrentPane.dispose();
        }
        if (this.fCurrentControl != null && !this.fCurrentControl.isDisposed()) {
            this.fCurrentControl.dispose();
        }
        Label errorLabel = new Label(this.fParentContainer.getParentComposite(), 16384);
        errorLabel.setText(message);
        errorLabel.setLayoutData((Object)new GridData(1808));
        this.fCurrentControl = errorLabel;
        this.fParentContainer.getParentComposite().layout();
    }
}

