/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.operations;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.engine.DefaultPhaseSet;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.PhaseSet;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;

public class ProfileModificationOperation
extends ProvisioningOperation {
    ProvisioningPlan plan;
    String profileId;
    PhaseSet phaseSet;
    boolean isUser = true;
    ProvisioningContext provisioningContext;

    public ProfileModificationOperation(String label, String profileId, ProvisioningPlan plan, ProvisioningContext context) {
        this(label, profileId, plan, context, null, true);
    }

    public ProfileModificationOperation(String label, String profileId, ProvisioningPlan plan, ProvisioningContext context, PhaseSet set, boolean isUser) {
        super(label);
        this.plan = plan;
        this.profileId = profileId;
        this.provisioningContext = context;
        this.isUser = isUser;
        this.phaseSet = set == null ? new DefaultPhaseSet() : set;
    }

    public String getProfileId() {
        return this.profileId;
    }

    protected IProfile getProfile() {
        try {
            return ProvisioningUtil.getProfile(this.profileId);
        }
        catch (ProvisionException provisionException) {
            return null;
        }
    }

    protected IStatus doExecute(IProgressMonitor monitor) throws ProvisionException {
        return ProvisioningUtil.performProvisioningPlan(this.plan, this.phaseSet, this.provisioningContext, monitor);
    }

    public boolean runInBackground() {
        return true;
    }

    public boolean isUser() {
        return this.isUser;
    }
}

