/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.dialogs;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.IResolutionErrorReportingPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.ISelectableIUsPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningOperationWizard;
import org.eclipse.equinox.internal.p2.ui.dialogs.ResolutionResultsWizardPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.SelectableIUsPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.UninstallWizardPage;
import org.eclipse.equinox.internal.p2.ui.model.ElementUtils;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUIImages;
import org.eclipse.equinox.internal.provisional.p2.ui.model.IUElementListRoot;
import org.eclipse.equinox.internal.provisional.p2.ui.model.InstalledIUElement;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.PlannerResolutionOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policy;
import org.eclipse.jface.wizard.IWizardPage;

public class UninstallWizard
extends ProvisioningOperationWizard {
    SelectableIUsPage mainPage;

    static IUElementListRoot makeElementRoot(Object[] selectedElements, String profileId) {
        IUElementListRoot elementRoot = new IUElementListRoot();
        ArrayList<InstalledIUElement> list = new ArrayList<InstalledIUElement>(selectedElements.length);
        int i = 0;
        while (i < selectedElements.length) {
            IInstallableUnit iu = ElementUtils.getIU(selectedElements[i]);
            if (iu != null) {
                list.add(new InstalledIUElement(elementRoot, profileId, iu));
            }
            ++i;
        }
        elementRoot.setChildren(list.toArray());
        return elementRoot;
    }

    public UninstallWizard(Policy policy, String profileId, IInstallableUnit[] ius, PlannerResolutionOperation initialResolution) {
        super(policy, profileId, UninstallWizard.makeElementRoot(ius, profileId), ius, initialResolution);
        this.setWindowTitle(ProvUIMessages.UninstallIUOperationLabel);
        this.setDefaultPageImageDescriptor(ProvUIImages.getImageDescriptor("wizban/uninstall_wiz.gif"));
    }

    protected ISelectableIUsPage createMainPage(IUElementListRoot input, Object[] selections) {
        this.mainPage = new SelectableIUsPage(this.policy, input, selections, this.profileId);
        this.mainPage.setTitle(ProvUIMessages.UninstallIUOperationLabel);
        this.mainPage.setDescription(ProvUIMessages.UninstallDialog_UninstallMessage);
        this.mainPage.updateStatus(input, this.resolutionOperation);
        return this.mainPage;
    }

    protected ResolutionResultsWizardPage createResolutionPage() {
        return new UninstallWizardPage(this.policy, this.root, this.profileId, this.resolutionOperation);
    }

    protected IUElementListRoot makeResolutionElementRoot(Object[] selectedElements) {
        return UninstallWizard.makeElementRoot(selectedElements, this.profileId);
    }

    protected ProfileChangeRequest computeProfileChangeRequest(Object[] selectedElements, MultiStatus additionalStatus, IProgressMonitor monitor) {
        ProfileChangeRequest request = ProfileChangeRequest.createByProfileId((String)this.profileId);
        request.removeInstallableUnits(ElementUtils.elementsToIUs(selectedElements));
        return request;
    }

    protected IResolutionErrorReportingPage getErrorReportingPage() {
        return this.mainPage;
    }

    public IWizardPage getStartingPage() {
        if (this.getCurrentStatus().isOK()) {
            if (this.resolutionPage == null) {
                this.resolutionPage = this.createResolutionPage();
                this.addPage((IWizardPage)this.resolutionPage);
            }
            this.mainPage.setPageComplete(true);
            return this.resolutionPage;
        }
        return super.getStartingPage();
    }
}

