/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.photon.OS;
import org.eclipse.swt.internal.photon.PhArea_t;
import org.eclipse.swt.internal.photon.PhDim_t;
import org.eclipse.swt.internal.photon.PhEvent_t;
import org.eclipse.swt.internal.photon.PhKeyEvent_t;
import org.eclipse.swt.internal.photon.PhRect_t;
import org.eclipse.swt.internal.photon.PtCallbackInfo_t;
import org.eclipse.swt.internal.photon.PtTextCallback_t;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.WidgetTable;

public class Text
extends Scrollable {
    char echoCharacter;
    boolean ignoreChange;
    String hiddenText;
    String message;
    int tabs;
    int lastModifiedText;
    PtTextCallback_t textVerify;
    public static final int LIMIT = Integer.MAX_VALUE;
    public static final String DELIMITER = "\n";
    static final char PASSWORD = '*';

    public Text(Composite parent, int style) {
        super(parent, Text.checkStyle(style));
    }

    static int checkStyle(int style) {
        if ((style & 0x80) != 0) {
            style |= 0x804;
            style &= 0xFFBFFFFF;
        }
        if (((style &= 0xFFFFFF7F) & 4) != 0 && (style & 2) != 0) {
            style &= 0xFFFFFFFD;
        }
        if (((style = Text.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0)) & 4) != 0) {
            style &= 0xFFFFFCBF;
        }
        if ((style & 0x40) != 0) {
            style |= 2;
            style &= 0xFFFFFEFF;
        }
        if ((style & 2) != 0) {
            style &= 0xFFBFFFFF;
        }
        if ((style & 6) != 0) {
            return style;
        }
        if ((style & 0x300) != 0) {
            return style | 2;
        }
        return style | 4;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        boolean wrap;
        this.checkWidget();
        int[] nArray = new int[6];
        nArray[0] = 1023;
        nArray[3] = 1024;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        boolean bl = wrap = (this.style & 0x40) != 0;
        if (wrap) {
            if (wHint == -1) {
                OS.PtSetResource(this.handle, 5001, 4, -1);
            } else {
                OS.PtSetResource(this.handle, 1023, wHint, 0);
            }
        }
        int resizeFlags = 0x900000;
        OS.PtSetResource(this.handle, 1008, resizeFlags, 0x3F00000);
        if ((this.style & 2) != 0 || !OS.PtWidgetIsRealized(this.handle)) {
            OS.PtExtentWidgetFamily(this.handle);
        }
        PhDim_t dim = new PhDim_t();
        OS.PtWidgetPreferredSize(this.handle, dim);
        int width = dim.w;
        int height = dim.h;
        OS.PtSetResource(this.handle, 1008, 0, 0x3F00000);
        if (wrap && wHint == -1) {
            int wrapFlags = 7;
            OS.PtSetResource(this.handle, 5001, wrapFlags, -1);
        }
        OS.PtSetResources(this.handle, args.length / 3, args);
        ScrollBar scroll = this.getVerticalBar();
        int scrollWidth = scroll != null ? scroll.getSize().x : 0;
        scroll = this.getHorizontalBar();
        int scrollHeight = scroll != null ? scroll.getSize().y : 0;
        width += scrollWidth;
        if (!wrap) {
            height += scrollHeight;
        }
        if (wHint != -1 || hHint != -1) {
            PhRect_t rect = new PhRect_t();
            PhArea_t area = new PhArea_t();
            rect.lr_x = (short)(wHint - 1);
            rect.lr_y = (short)(hHint - 1);
            OS.PtSetAreaFromWidgetCanvas(this.handle, rect, area);
            if (wHint != -1) {
                width = area.size_w + scrollWidth;
            }
            if (hHint != -1) {
                height = area.size_h + scrollHeight;
            }
        }
        return new Point(width, height);
    }

    public void clearSelection() {
        this.checkWidget();
        int[] position = new int[1];
        if ((this.style & 4) != 0) {
            int[] nArray = new int[3];
            nArray[0] = 4003;
            int[] args = nArray;
            OS.PtGetResources(this.handle, args.length / 3, args);
            position[0] = args[1];
        }
        OS.PtTextSetSelection(this.handle, position, position);
    }

    void createHandle(int index) {
        int textFlags;
        this.state |= 8;
        int parentHandle = this.parent.parentingHandle();
        boolean hasBorder = (this.style & 0x800) != 0;
        int n = textFlags = (this.style & 8) != 0 ? 0 : 2;
        if ((this.style & 4) != 0) {
            int clazz = this.display.PtText;
            int[] nArray = new int[12];
            nArray[0] = 1006;
            nArray[1] = hasBorder ? 256 : 0;
            nArray[2] = 256;
            nArray[3] = 1006;
            nArray[4] = 0x4000000;
            nArray[5] = 0x4000000;
            nArray[6] = 4008;
            nArray[7] = textFlags;
            nArray[8] = 2;
            nArray[9] = 1008;
            nArray[11] = 0x3F00000;
            int[] args = nArray;
            this.handle = OS.PtCreateWidget(clazz, parentHandle, args.length / 3, args);
            if (this.handle == 0) {
                Text.error(2);
            }
            return;
        }
        int clazz = this.display.PtMultiText;
        int wrapFlags = (this.style & 0x40) != 0 ? 3 : 0;
        int[] nArray = new int[21];
        nArray[0] = 1006;
        nArray[1] = hasBorder ? 256 : 0;
        nArray[2] = 256;
        nArray[3] = 1006;
        nArray[4] = 0x4000000;
        nArray[5] = 0x4000000;
        nArray[6] = 4008;
        nArray[7] = textFlags;
        nArray[8] = 2;
        nArray[9] = 5001;
        nArray[10] = wrapFlags;
        nArray[11] = 3;
        nArray[12] = 13006;
        nArray[13] = (this.style & 0x100) != 0 ? 1 : 0;
        nArray[15] = 13008;
        nArray[16] = (this.style & 0x200) != 0 ? 1 : 0;
        nArray[18] = 1008;
        nArray[20] = 0x3F00000;
        int[] args = nArray;
        this.handle = OS.PtCreateWidget(clazz, parentHandle, args.length / 3, args);
        if (this.handle == 0) {
            Text.error(2);
        }
        this.createStandardScrollBars();
    }

    void createWidget(int index) {
        super.createWidget(index);
        this.tabs = 8;
        this.setTabStops(8);
        this.message = "";
        this.hiddenText = "";
        if ((this.style & 0x400000) != 0) {
            this.setEchoChar('*');
        }
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            Text.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            Text.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            Text.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(25, typedListener);
    }

    public void append(String string) {
        this.checkWidget();
        if (string == null) {
            Text.error(4);
        }
        byte[] buffer = Converter.wcsToMbcs(null, string, false);
        OS.PtTextModifyText(this.handle, 0, 0, -1, buffer, buffer.length);
    }

    public void copy() {
        this.checkWidget();
        int[] start = new int[1];
        int[] end = new int[1];
        int length = OS.PtTextGetSelection(this.handle, start, end);
        if (length <= 0) {
            return;
        }
        int[] nArray = new int[3];
        nArray[0] = 3011;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        byte[] buffer = new byte[length + 1];
        OS.memmove(buffer, args[1] + start[0], length);
        int ig = OS.PhInputGroup(0);
        OS.PhClipboardCopyString((short)ig, buffer);
    }

    public void cut() {
        this.checkWidget();
        int[] start = new int[1];
        int[] end = new int[1];
        int length = OS.PtTextGetSelection(this.handle, start, end);
        if (length <= 0) {
            return;
        }
        int[] nArray = new int[3];
        nArray[0] = 3011;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        byte[] buffer = new byte[length + 1];
        OS.memmove(buffer, args[1] + start[0], length);
        int ig = OS.PhInputGroup(0);
        OS.PhClipboardCopyString((short)ig, buffer);
        buffer = new byte[]{};
        OS.PtTextModifyText(this.handle, start[0], end[0], start[0], buffer, buffer.length);
    }

    void deregister() {
        super.deregister();
        if ((this.style & 2) == 0) {
            return;
        }
        int child = OS.PtWidgetChildBack(this.handle);
        WidgetTable.remove(child);
    }

    int defaultBackground() {
        return this.display.TEXT_BACKGROUND;
    }

    int defaultForeground() {
        return this.display.TEXT_FOREGROUND;
    }

    public int getCaretLineNumber() {
        this.checkWidget();
        return 0;
    }

    public Point getCaretLocation() {
        this.checkWidget();
        return null;
    }

    public int getCaretPosition() {
        this.checkWidget();
        int[] nArray = new int[3];
        nArray[0] = 4003;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        return args[1];
    }

    public int getCharCount() {
        this.checkWidget();
        int[] nArray = new int[3];
        nArray[0] = 3011;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        if (args[1] == 0) {
            return 0;
        }
        return OS.strlen(args[1]);
    }

    public boolean getDoubleClickEnabled() {
        this.checkWidget();
        return false;
    }

    public char getEchoChar() {
        this.checkWidget();
        return this.echoCharacter;
    }

    public boolean getEditable() {
        this.checkWidget();
        int[] nArray = new int[3];
        nArray[0] = 4008;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        return (args[1] & 2) != 0;
    }

    public int getLineCount() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 1;
        }
        int[] nArray = new int[3];
        nArray[0] = 5006;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        return args[1];
    }

    public String getLineDelimiter() {
        this.checkWidget();
        return "\n";
    }

    public int getLineHeight() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            PhDim_t dim = new PhDim_t();
            if (!OS.PtWidgetIsRealized(this.handle)) {
                OS.PtExtentWidget(this.handle);
            }
            OS.PtWidgetPreferredSize(this.handle, dim);
            PhRect_t extent = new PhRect_t();
            OS.PtWidgetExtent(this.handle, extent);
            PhRect_t canvas = new PhRect_t();
            OS.PtWidgetCanvas(this.handle, canvas);
            int topBorder = canvas.ul_y - extent.ul_y;
            int bottomBorder = extent.lr_y - canvas.lr_y;
            return dim.h - topBorder - bottomBorder;
        }
        int ptr = OS.malloc(20);
        int[] nArray = new int[6];
        nArray[0] = 5010;
        nArray[1] = ptr;
        nArray[2] = 1;
        nArray[3] = 5003;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        int[] line = new int[1];
        OS.memmove(line, args[1] + 8, 4);
        PhRect_t extent = new PhRect_t();
        OS.memmove(extent, line[0] + 10, 8);
        OS.free(ptr);
        return extent.lr_y - extent.ul_y + 1 + args[4];
    }

    public String getMessage() {
        this.checkWidget();
        return this.message;
    }

    String getNameText() {
        if ((this.style & 4) != 0) {
            return this.getText();
        }
        return this.getText(0, Math.min(this.getCharCount() - 1, 10));
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Point getSelection() {
        this.checkWidget();
        if (this.textVerify != null) {
            return new Point(this.textVerify.start_pos, this.textVerify.end_pos);
        }
        int[] start = new int[1];
        int[] end = new int[1];
        OS.PtTextGetSelection(this.handle, start, end);
        if (start[0] == -1) {
            int[] nArray = new int[3];
            nArray[0] = 4003;
            int[] args = nArray;
            OS.PtGetResources(this.handle, args.length / 3, args);
            start[0] = end[0] = args[1];
        }
        return new Point(start[0], end[0]);
    }

    public int getSelectionCount() {
        this.checkWidget();
        Point selection = this.getSelection();
        return selection.y - selection.x;
    }

    public String getSelectionText() {
        this.checkWidget();
        Point selection = this.getSelection();
        return this.getText().substring(selection.x, selection.y);
    }

    public int getTabs() {
        this.checkWidget();
        return this.tabs;
    }

    int getTabWidth(int tabs) {
        int[] nArray = new int[3];
        nArray[0] = 3010;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        PhRect_t rect = new PhRect_t();
        int ptr = OS.malloc(1);
        OS.memmove(ptr, new byte[]{32}, 1);
        OS.PfExtentText(rect, null, args[1], ptr, 1);
        OS.free(ptr);
        int width = rect.lr_x - rect.ul_x + 1;
        return width * tabs;
    }

    public String getText(int start, int end) {
        this.checkWidget();
        if (start > end || end < 0) {
            return "";
        }
        String text = this.getText();
        int length = text.length();
        if (start > (end = Math.min(end, length - 1))) {
            return "";
        }
        start = Math.max(0, start);
        return text.substring(start, end + 1);
    }

    public String getText() {
        this.checkWidget();
        if (this.echoCharacter != '\u0000') {
            return this.hiddenText;
        }
        int[] nArray = new int[3];
        nArray[0] = 3011;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        if (args[1] == 0) {
            return "";
        }
        int length = OS.strlen(args[1]);
        byte[] buffer = new byte[length];
        OS.memmove(buffer, args[1], length);
        char[] unicode = Converter.mbcsToWcs(null, buffer);
        return new String(unicode);
    }

    public int getTextLimit() {
        this.checkWidget();
        int[] nArray = new int[3];
        nArray[0] = 4005;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        return args[1];
    }

    public int getTopIndex() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        int[] nArray = new int[3];
        nArray[0] = 5007;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        return args[1] - 1;
    }

    public int getTopPixel() {
        this.checkWidget();
        return 0;
    }

    void hookEvents() {
        super.hookEvents();
        int windowProc = this.display.windowProc;
        OS.PtAddCallback(this.handle, 4009, windowProc, 4009);
        OS.PtAddCallback(this.handle, 4010, windowProc, 4010);
    }

    public void insert(String string) {
        this.checkWidget();
        if (string == null) {
            Text.error(4);
        }
        byte[] buffer = Converter.wcsToMbcs(null, string, false);
        int[] start = new int[1];
        int[] end = new int[1];
        OS.PtTextGetSelection(this.handle, start, end);
        if (start[0] == -1) {
            int[] nArray = new int[3];
            nArray[0] = 4003;
            int[] args = nArray;
            OS.PtGetResources(this.handle, args.length / 3, args);
            start[0] = end[0] = args[1];
        }
        OS.PtTextModifyText(this.handle, start[0], end[0], start[0], buffer, buffer.length);
    }

    public void paste() {
        this.checkWidget();
        int ig = OS.PhInputGroup(0);
        int ptr = OS.PhClipboardPasteString((short)ig);
        if (ptr == 0) {
            return;
        }
        int length = OS.strlen(ptr);
        int[] start = new int[1];
        int[] end = new int[1];
        OS.PtTextGetSelection(this.handle, start, end);
        if (start[0] == -1) {
            int[] nArray = new int[3];
            nArray[0] = 4003;
            int[] args = nArray;
            OS.PtGetResources(this.handle, args.length / 3, args);
            start[0] = end[0] = args[1];
        }
        OS.PtTextModifyText(this.handle, start[0], end[0], end[0], ptr, length);
        OS.free(ptr);
    }

    int Ph_EV_BOUNDARY(int widget, int info) {
        if ((this.style & 2) != 0) {
            if (info == 0) {
                return 2;
            }
            PtCallbackInfo_t cbinfo = new PtCallbackInfo_t();
            OS.memmove(cbinfo, info, 16);
            if (cbinfo.event == 0) {
                return 2;
            }
            PhEvent_t ev = new PhEvent_t();
            OS.memmove(ev, cbinfo.event, 40);
            switch (ev.subtype) {
                case 4: 
                case 5: {
                    return 0;
                }
            }
        }
        return super.Ph_EV_BOUNDARY(widget, info);
    }

    int Pt_CB_GOT_FOCUS(int widget, int info) {
        if ((this.style & 2) != 0 && widget != this.handle) {
            return 0;
        }
        return super.Pt_CB_GOT_FOCUS(widget, info);
    }

    int Pt_CB_MODIFY_VERIFY(int widget, int info) {
        String text;
        if (this.lastModifiedText != 0) {
            OS.free(this.lastModifiedText);
            this.lastModifiedText = 0;
        }
        if (this.echoCharacter == '\u0000' && !this.hooks(25) && !this.filters(25)) {
            return 0;
        }
        PtCallbackInfo_t cbinfo = new PtCallbackInfo_t();
        OS.memmove(cbinfo, info, 16);
        PtTextCallback_t textVerify = new PtTextCallback_t();
        OS.memmove(textVerify, cbinfo.cbdata, 32);
        byte[] buffer = new byte[textVerify.length];
        OS.memmove(buffer, textVerify.text, buffer.length);
        String newText = text = new String(Converter.mbcsToWcs(null, buffer));
        if (!this.ignoreChange) {
            int data;
            Event event = new Event();
            event.start = textVerify.start_pos;
            event.end = textVerify.end_pos;
            event.doit = textVerify.doit != 0;
            event.text = text;
            if (cbinfo.event != 0 && (data = OS.PhGetData(cbinfo.event)) != 0) {
                PhKeyEvent_t ke = new PhKeyEvent_t();
                OS.memmove(ke, data, PhKeyEvent_t.sizeof);
                if ((ke.key_flags & 3) != 0) {
                    this.setKeyState(event, 25, ke);
                }
            }
            this.sendEvent(25, event);
            newText = event.text;
            int n = textVerify.doit = event.doit && newText != null ? 1 : 0;
        }
        if (newText != null) {
            if (this.echoCharacter != '\u0000' && textVerify.doit != 0) {
                String prefix = this.hiddenText.substring(0, textVerify.start_pos);
                String suffix = this.hiddenText.substring(textVerify.end_pos, this.hiddenText.length());
                this.hiddenText = String.valueOf(prefix) + newText + suffix;
                char[] charBuffer = new char[newText.length()];
                int i = 0;
                while (i < charBuffer.length) {
                    charBuffer[i] = this.echoCharacter;
                    ++i;
                }
                newText = new String(charBuffer);
            }
            if (newText != text) {
                byte[] buffer2 = Converter.wcsToMbcs(null, newText, true);
                int length = buffer2.length - 1;
                if (length == textVerify.length) {
                    OS.memmove(textVerify.text, buffer2, length);
                } else {
                    int ptr = OS.malloc(length);
                    OS.memmove(ptr, buffer2, length);
                    textVerify.new_insert += length - textVerify.length;
                    textVerify.text = ptr;
                    textVerify.length = length;
                    this.lastModifiedText = ptr;
                }
            }
        }
        OS.memmove(cbinfo.cbdata, textVerify, 32);
        textVerify = null;
        return 0;
    }

    int Pt_CB_TEXT_CHANGED(int widget, int info) {
        if (this.lastModifiedText != 0) {
            OS.free(this.lastModifiedText);
            this.lastModifiedText = 0;
        }
        if (!this.ignoreChange) {
            this.sendEvent(24);
        }
        return 0;
    }

    void register() {
        super.register();
        if ((this.style & 2) == 0) {
            return;
        }
        int child = OS.PtWidgetChildBack(this.handle);
        WidgetTable.put(child, this);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.lastModifiedText != 0) {
            OS.free(this.lastModifiedText);
        }
        this.lastModifiedText = 0;
        this.message = null;
        this.hiddenText = null;
        this.textVerify = null;
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            Text.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            Text.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            Text.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, listener);
    }

    public void selectAll() {
        this.checkWidget();
        OS.PtTextSetSelection(this.handle, new int[1], new int[]{Integer.MAX_VALUE});
    }

    public void setEchoChar(char echo) {
        String newText;
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if (this.echoCharacter == echo) {
            return;
        }
        if (echo == '\u0000') {
            newText = this.hiddenText;
            this.hiddenText = "";
        } else {
            newText = this.hiddenText = this.getText();
        }
        this.echoCharacter = echo;
        Point selection = this.getSelection();
        boolean oldValue = this.ignoreChange;
        this.ignoreChange = true;
        this.setText(newText);
        this.setSelection(selection.x, selection.y);
        this.ignoreChange = oldValue;
    }

    public void setDoubleClickEnabled(boolean doubleClick) {
        this.checkWidget();
    }

    public void setEditable(boolean editable) {
        this.checkWidget();
        this.style &= 0xFFFFFFF7;
        if (!editable) {
            this.style |= 8;
        }
        int flags = editable ? 2 : 0;
        OS.PtSetResource(this.handle, 4008, flags, 2);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.setTabStops(this.tabs);
    }

    public void setMessage(String message) {
        this.checkWidget();
        if (message == null) {
            Text.error(4);
        }
        this.message = message;
    }

    public void setOrientation(int orientation) {
        this.checkWidget();
    }

    public void setSelection(int position) {
        this.checkWidget();
        OS.PtSetResource(this.handle, 4003, position, 0);
        if ((this.style & 4) != 0) {
            int[] selection = new int[]{position};
            OS.PtTextSetSelection(this.handle, selection, selection);
        }
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if (selection == null) {
            Text.error(4);
        }
        this.setSelection(selection.x, selection.y);
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        OS.PtTextSetSelection(this.handle, new int[]{start}, new int[]{end});
        if ((this.style & 2) != 0 && start == end) {
            OS.PtSetResource(this.handle, 4003, start, 0);
        }
    }

    public void setTabs(int tabs) {
        this.checkWidget();
        if (tabs < 0) {
            return;
        }
        this.tabs = tabs;
        this.setTabStops(this.tabs);
    }

    void setTabStops(int tabs) {
        if ((this.style & 4) != 0) {
            return;
        }
        int tabsWidth = this.getTabWidth(tabs);
        int ptr = OS.malloc(4);
        OS.memmove(ptr, new int[]{tabsWidth}, 4);
        OS.PtSetResource(this.handle, 5013, ptr, 1);
        OS.free(ptr);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            Text.error(4);
        }
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        int ptr = OS.malloc(buffer.length);
        OS.memmove(ptr, buffer, buffer.length);
        OS.PtSetResource(this.handle, 3011, ptr, 0);
        OS.free(ptr);
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            Text.error(7);
        }
        OS.PtSetResource(this.handle, 4005, limit, 0);
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        OS.PtSetResource(this.handle, 5007, index + 1, 0);
    }

    public void showSelection() {
        this.checkWidget();
    }

    int traversalCode(int key_sym, PhKeyEvent_t ke) {
        int code = super.traversalCode(key_sym, ke);
        if ((this.style & 8) != 0) {
            return code;
        }
        if ((this.style & 2) != 0) {
            code &= 0xFFFFFFFB;
            if (key_sym == 61449 && ke != null && (ke.key_mods & 2) == 0) {
                code &= 0xFFFFFFE7;
            }
        }
        return code;
    }

    boolean translateTraversal(int key_sym, PhKeyEvent_t phEvent) {
        boolean translated = super.translateTraversal(key_sym, phEvent);
        if ((this.style & 4) != 0 && !translated && key_sym == 61453) {
            this.postEvent(14);
            return false;
        }
        return translated;
    }

    int widgetClass() {
        if ((this.style & 4) != 0) {
            return OS.PtText();
        }
        return OS.PtMultiText();
    }
}

