/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.internal.photon.FontQueryInfo;

public final class FontMetrics {
    public FontQueryInfo handle;

    FontMetrics() {
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FontMetrics)) {
            return false;
        }
        FontQueryInfo info = ((FontMetrics)object).handle;
        if (info == this.handle) {
            return true;
        }
        if (info == null || this.handle == null) {
            return false;
        }
        if (this.handle.size == info.size && this.handle.style == info.style && this.handle.ascender == info.ascender && this.handle.descender == info.descender && this.handle.width == info.width && this.handle.lochar == info.lochar && this.handle.hichar == info.hichar && this.handle.desc.length == info.desc.length && this.handle.font.length == info.font.length) {
            int i = this.handle.desc.length - 1;
            while (i >= 0) {
                if (this.handle.desc[i] != info.desc[i]) {
                    return false;
                }
                --i;
            }
            i = this.handle.font.length - 1;
            while (i >= 0) {
                if (this.handle.font[i] != info.font[i]) {
                    return false;
                }
                --i;
            }
            return true;
        }
        return false;
    }

    public int getAscent() {
        return -this.handle.ascender;
    }

    public int getAverageCharWidth() {
        if ((this.handle.style & 0x10) != 0) {
            return this.handle.width;
        }
        return this.handle.width / 3;
    }

    public int getDescent() {
        return this.handle.descender;
    }

    public int getHeight() {
        return -this.handle.ascender + this.handle.descender;
    }

    public int getLeading() {
        return 0;
    }

    public int hashCode() {
        if (this.handle == null) {
            return 0;
        }
        return this.handle.size ^ this.handle.style ^ this.handle.ascender ^ this.handle.descender ^ this.handle.width ^ this.handle.lochar ^ this.handle.hichar ^ this.handle.font.hashCode() ^ this.handle.desc.hashCode();
    }

    public static FontMetrics internal_new(int ascent, int descent, int aveCharWidth, int leading, int height) {
        FontQueryInfo info = new FontQueryInfo();
        info.ascender = (short)(-ascent);
        info.descender = (short)descent;
        info.style = (short)16;
        info.width = (short)aveCharWidth;
        return FontMetrics.photon_new(info);
    }

    public static FontMetrics photon_new(FontQueryInfo handle) {
        FontMetrics fontMetrics = new FontMetrics();
        fontMetrics.handle = handle;
        return fontMetrics;
    }
}

