/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;

public final class Color
extends Resource {
    public int handle;

    Color(Device device) {
        super(device);
    }

    public Color(Device device, int red, int green, int blue) {
        super(device);
        this.init(red, green, blue);
        this.init();
    }

    public Color(Device device, RGB rgb) {
        super(device);
        if (rgb == null) {
            SWT.error(4);
        }
        this.init(rgb.red, rgb.green, rgb.blue);
        this.init();
    }

    void destroy() {
        this.handle = -1;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Color)) {
            return false;
        }
        Color color = (Color)object;
        return this.device == color.device && (this.handle & 0xFFFFFF) == (color.handle & 0xFFFFFF);
    }

    public int getBlue() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.handle & 0xFF;
    }

    public int getGreen() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return (this.handle & 0xFF00) >> 8;
    }

    public int getRed() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return (this.handle & 0xFF0000) >> 16;
    }

    public RGB getRGB() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return new RGB((this.handle & 0xFF0000) >> 16, (this.handle & 0xFF00) >> 8, this.handle & 0xFF);
    }

    public int hashCode() {
        return this.handle;
    }

    void init(int red, int green, int blue) {
        if (red > 255 || red < 0 || green > 255 || green < 0 || blue > 255 || blue < 0) {
            SWT.error(5);
        }
        this.handle = blue & 0xFF | (green & 0xFF) << 8 | (red & 0xFF) << 16;
    }

    public boolean isDisposed() {
        return this.handle == -1;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Color {*DISPOSED*}";
        }
        return "Color {" + this.getRed() + ", " + this.getGreen() + ", " + this.getBlue() + "}";
    }

    public static Color photon_new(Device device, int handle) {
        Color color = new Color(device);
        color.handle = handle;
        return color;
    }
}

