/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TypedListener;

public class TrayItem
extends Item {
    Tray parent;
    int id;
    ToolTip toolTip;
    String toolTipText;
    boolean visible = true;

    public TrayItem(Tray parent, int style) {
        super(parent, style);
        this.parent = parent;
        parent.createItem(this, parent.getItemCount());
        this.createWidget();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addMenuDetectListener(MenuDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(35, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createHandle() {
        this.handle = OS.gcnew_NotifyIcon();
        if (this.handle == 0) {
            this.error(2);
        }
        OS.NotifyIcon_Visible(this.handle, true);
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    Point getLocation() {
        return this.display.getCursorLocation();
    }

    public Tray getParent() {
        this.checkWidget();
        return this.parent;
    }

    public ToolTip getToolTip() {
        this.checkWidget();
        return this.toolTip;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public boolean getVisible() {
        this.checkWidget();
        return this.visible;
    }

    void HandleDoubleClick(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        if (this.hooks(14)) {
            this.postEvent(14);
        }
        this.display.wakeThread();
    }

    void HandleMouseDown(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        if (this.hooks(13)) {
            this.postEvent(13);
        }
        this.display.wakeThread();
    }

    void HandleMouseUp(int sender, int e) {
        int button;
        if (!this.checkEvent(e)) {
            return;
        }
        if (this.hooks(35) && (button = OS.FormsMouseEventArgs_Button(e)) == 0x200000) {
            this.sendEvent(35);
        }
        this.display.wakeThread();
    }

    void hookEvents() {
        super.hookEvents();
        int handler = OS.gcnew_FormsMouseEventHandler(this.jniRef, "HandleMouseDown");
        if (handler == 0) {
            this.error(2);
        }
        OS.NotifyIcon_MouseDown(this.handle, handler);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_FormsMouseEventHandler(this.jniRef, "HandleMouseUp");
        if (handler == 0) {
            this.error(2);
        }
        OS.NotifyIcon_MouseUp(this.handle, handler);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_EventHandler(this.jniRef, "HandleDoubleClick");
        if (handler == 0) {
            this.error(2);
        }
        OS.NotifyIcon_DoubleClick(this.handle, handler);
        OS.GCHandle_Free(handler);
    }

    void releaseHandle() {
        this.setImage(null);
        super.releaseHandle();
        if (this.handle != 0) {
            OS.GCHandle_Free(this.handle);
        }
        this.handle = 0;
        this.parent = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeMenuDetectListener(MenuDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(35, listener);
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        super.setImage(image);
        if (image != null) {
            int format = OS.PixelFormats_Bgra32();
            int newImage = OS.gcnew_FormatConvertedBitmap(image.handle, format, OS.BitmapSource_Palette(image.handle), 0.0);
            int depth = OS.PixelFormat_BitsPerPixel(format);
            OS.GCHandle_Free(format);
            int width = OS.BitmapSource_PixelWidth(newImage);
            int height = OS.BitmapSource_PixelHeight(newImage);
            int scanlinePad = 4;
            int bytesPerLine = ((width * depth + 7) / 8 + (scanlinePad - 1)) / scanlinePad * scanlinePad;
            byte[] buffer = new byte[bytesPerLine * height];
            int rect = OS.Int32Rect_Empty();
            OS.BitmapSource_CopyPixels(newImage, rect, buffer, buffer.length, bytesPerLine);
            OS.GCHandle_Free(rect);
            OS.GCHandle_Free(newImage);
            int bitmap = OS.gcnew_Bitmap(width, height, bytesPerLine, 2498570, buffer);
            int hIcon = OS.Bitmap_GetHicon(bitmap);
            OS.GCHandle_Free(bitmap);
            int icon = OS.Icon_FromHandle(hIcon);
            OS.NotifyIcon_Icon(this.handle, icon);
            OS.GCHandle_Free(icon);
        } else {
            OS.NotifyIcon_Icon(this.handle, 0);
        }
    }

    public void setToolTip(ToolTip toolTip) {
        this.checkWidget();
        this.toolTip = toolTip;
    }

    public void setToolTipText(String value) {
        this.checkWidget();
        this.toolTipText = value;
        int strPtr = this.createDotNetString(value, false);
        OS.NotifyIcon_Text(this.handle, strPtr);
        OS.GCHandle_Free(strPtr);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (this.visible == visible) {
            return;
        }
        if (visible) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
        }
        this.visible = visible;
        OS.NotifyIcon_Visible(this.handle, visible);
        if (!visible) {
            this.sendEvent(23);
        }
    }
}

