/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.PathData;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.wpf.OS;

public class Path
extends Resource {
    public int handle;
    int currentFigure;
    int currentPoint;

    public Path(Device device) {
        super(device);
        this.handle = OS.gcnew_PathGeometry();
        if (this.handle == 0) {
            SWT.error(2);
        }
        this.init();
    }

    public Path(Device device, Path path, float flatness) {
        super(device);
        if (path == null) {
            SWT.error(4);
        }
        if (path.isDisposed()) {
            SWT.error(5);
        }
        this.handle = (flatness = Math.max(0.0f, flatness)) == 0.0f ? OS.PathGeometry_Clone(path.handle) : OS.Geometry_GetFlattenedPathGeometry(path.handle, flatness, 0);
        if (this.handle == 0) {
            SWT.error(2);
        }
        this.init();
    }

    public Path(Device device, PathData data) {
        this(device);
        if (data == null) {
            SWT.error(4);
        }
        this.init(data);
    }

    public void addArc(float x, float y, float width, float height, float startAngle, float arcAngle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (width < 0.0f) {
            x += width;
            width = -width;
        }
        if (height < 0.0f) {
            y += height;
            height = -height;
        }
        if (width == 0.0f || height == 0.0f || arcAngle == 0.0f) {
            return;
        }
        boolean isNegative = arcAngle < 0.0f;
        boolean isLargeAngle = arcAngle > 180.0f || arcAngle < -180.0f;
        arcAngle += startAngle;
        if (isNegative) {
            float tmp = startAngle;
            startAngle = arcAngle;
            arcAngle = tmp;
        }
        double x1 = Math.cos((double)startAngle * Math.PI / 180.0) * (double)width / 2.0 + (double)x + (double)width / 2.0;
        double y1 = -1.0 * Math.sin((double)startAngle * Math.PI / 180.0) * (double)height / 2.0 + (double)y + (double)height / 2.0;
        double x2 = Math.cos((double)arcAngle * Math.PI / 180.0) * (double)width / 2.0 + (double)x + (double)width / 2.0;
        double y2 = -1.0 * Math.sin((double)arcAngle * Math.PI / 180.0) * (double)height / 2.0 + (double)y + (double)height / 2.0;
        if (this.currentFigure == 0) {
            this.currentFigure = OS.gcnew_PathFigure();
            int figures = OS.PathGeometry_Figures(this.handle);
            OS.PathFigureCollection_Add(figures, this.currentFigure);
            OS.GCHandle_Free(figures);
        }
        int startPoint = OS.gcnew_Point(x1, y1);
        int endPoint = OS.gcnew_Point(x2, y2);
        int segments = OS.PathFigure_Segments(this.currentFigure);
        if (OS.PathSegmentCollection_Count(segments) != 0) {
            int segment = OS.gcnew_LineSegment(startPoint, true);
            OS.PathSegmentCollection_Add(segments, segment);
            OS.GCHandle_Free(segment);
        } else {
            OS.PathFigure_StartPoint(this.currentFigure, startPoint);
        }
        if (arcAngle >= 360.0f || arcAngle <= -360.0f) {
            int rect = OS.gcnew_Rect(x, y, width, height);
            int geometry = OS.gcnew_EllipseGeometry(rect);
            OS.PathGeometry_AddGeometry(this.handle, geometry);
            OS.GCHandle_Free(geometry);
            OS.GCHandle_Free(rect);
            OS.GCHandle_Free(this.currentFigure);
            this.currentFigure = 0;
        } else {
            int size = OS.gcnew_Size((double)width / 2.0, (double)height / 2.0);
            int arc = OS.gcnew_ArcSegment(endPoint, size, 0.0, isLargeAngle, 0, true);
            OS.PathSegmentCollection_Add(segments, arc);
            OS.GCHandle_Free(size);
            OS.GCHandle_Free(arc);
        }
        OS.GCHandle_Free(segments);
        OS.GCHandle_Free(startPoint);
        if (this.currentPoint != 0) {
            OS.GCHandle_Free(this.currentPoint);
        }
        this.currentPoint = endPoint;
    }

    public void addPath(Path path) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.isDisposed()) {
            SWT.error(5);
        }
        OS.PathGeometry_AddGeometry(this.handle, path.handle);
        if (path.currentPoint != 0) {
            this.currentPoint = OS.gcnew_Point(OS.Point_X(path.currentPoint), OS.Point_Y(path.currentPoint));
        }
        int figures = OS.PathGeometry_Figures(this.handle);
        int count = OS.PathFigureCollection_Count(figures);
        OS.GCHandle_Free(figures);
        if (count != 0) {
            int figure = OS.PathGeometry_Figures(this.handle, count - 1);
            if (!OS.PathFigure_IsClosed(figure)) {
                this.currentFigure = figure;
                return;
            }
            OS.GCHandle_Free(figure);
        }
    }

    public void addRectangle(float x, float y, float width, float height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        int rect = OS.gcnew_Rect(x, y, width, height);
        int geometry = OS.gcnew_RectangleGeometry(rect);
        OS.PathGeometry_AddGeometry(this.handle, geometry);
        OS.GCHandle_Free(geometry);
        OS.GCHandle_Free(rect);
        if (this.currentFigure != 0) {
            OS.GCHandle_Free(this.currentFigure);
        }
        this.currentFigure = 0;
        int point = OS.gcnew_Point(x, y);
        if (this.currentPoint != 0) {
            OS.GCHandle_Free(this.currentPoint);
        }
        this.currentPoint = point;
    }

    public void addString(String string, float x, float y, Font font) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (font == null) {
            SWT.error(4);
        }
        if (font.isDisposed()) {
            SWT.error(5);
        }
        int length = string.length();
        char[] buffer = new char[length + 1];
        string.getChars(0, length, buffer, 0);
        int str = OS.gcnew_String(buffer);
        int culture = OS.CultureInfo_CurrentUICulture();
        int point = OS.gcnew_Point(x, y);
        int brush = OS.Brushes_White();
        int text = OS.gcnew_FormattedText(str, culture, 0, font.handle, font.size, brush);
        int geometry = OS.FormattedText_BuildGeometry(text, point);
        OS.PathGeometry_AddGeometry(this.handle, geometry);
        OS.GCHandle_Free(brush);
        OS.GCHandle_Free(geometry);
        OS.GCHandle_Free(culture);
        OS.GCHandle_Free(str);
        OS.GCHandle_Free(point);
        OS.GCHandle_Free(text);
        if (this.currentFigure != 0) {
            OS.GCHandle_Free(this.currentFigure);
        }
        this.currentFigure = 0;
        if (this.currentPoint != 0) {
            OS.GCHandle_Free(this.currentPoint);
        }
        this.currentPoint = 0;
    }

    public void close() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.currentFigure != 0) {
            OS.PathFigure_IsClosed(this.currentFigure, true);
        }
        this.currentFigure = 0;
    }

    public boolean contains(float x, float y, GC gc, boolean outline) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (gc == null) {
            SWT.error(4);
        }
        if (gc.isDisposed()) {
            SWT.error(5);
        }
        gc.checkGC(1272);
        int point = OS.gcnew_Point(x, y);
        boolean result = outline ? OS.Geometry_StrokeContains(this.handle, gc.data.pen, point) : OS.Geometry_FillContains(this.handle, point);
        OS.GCHandle_Free(point);
        return result;
    }

    public void cubicTo(float cx1, float cy1, float cx2, float cy2, float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        int controlPoint1 = OS.gcnew_Point(cx1, cy1);
        int controlPoint2 = OS.gcnew_Point(cx2, cy2);
        int point = OS.gcnew_Point(x, y);
        if (this.currentFigure == 0) {
            this.newFigure();
        }
        if (this.currentPoint != 0) {
            OS.GCHandle_Free(this.currentPoint);
        }
        this.currentPoint = point;
        int segment = OS.gcnew_BezierSegment(controlPoint1, controlPoint2, point, true);
        int segments = OS.PathFigure_Segments(this.currentFigure);
        OS.PathSegmentCollection_Add(segments, segment);
        OS.GCHandle_Free(segments);
        OS.GCHandle_Free(segment);
        OS.GCHandle_Free(controlPoint1);
        OS.GCHandle_Free(controlPoint2);
    }

    void destroy() {
        OS.GCHandle_Free(this.handle);
        this.handle = 0;
        if (this.currentFigure != 0) {
            OS.GCHandle_Free(this.currentFigure);
        }
        this.currentFigure = 0;
        if (this.currentPoint != 0) {
            OS.GCHandle_Free(this.currentPoint);
        }
        this.currentPoint = 0;
    }

    public void getBounds(float[] bounds) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (bounds == null) {
            SWT.error(4);
        }
        if (bounds.length < 4) {
            SWT.error(5);
        }
        int rect = OS.PathGeometry_Bounds(this.handle);
        bounds[0] = (float)OS.Rect_X(rect);
        bounds[1] = (float)OS.Rect_Y(rect);
        bounds[2] = (float)OS.Rect_Width(rect);
        bounds[3] = (float)OS.Rect_Height(rect);
        OS.GCHandle_Free(rect);
    }

    public void getCurrentPoint(float[] point) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (point == null) {
            SWT.error(4);
        }
        if (point.length < 2) {
            SWT.error(5);
        }
        if (this.currentPoint != 0) {
            point[0] = (float)OS.Point_X(this.currentPoint);
            point[1] = (float)OS.Point_Y(this.currentPoint);
        } else {
            point[1] = 0.0f;
            point[0] = 0.0f;
        }
    }

    public PathData getPathData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        byte[] types = new byte[128];
        float[] points = new float[256];
        int pointsIndex = 0;
        int typesIndex = 0;
        int figures = OS.PathGeometry_Figures(this.handle);
        int figureCount = OS.PathFigureCollection_Count(figures);
        OS.GCHandle_Free(figures);
        int i = 0;
        while (i < figureCount) {
            int figure = OS.PathGeometry_Figures(this.handle, i);
            int segments = OS.PathFigure_Segments(figure);
            int segmentCount = OS.PathSegmentCollection_Count(segments);
            OS.GCHandle_Free(segments);
            int j = 0;
            while (j < segmentCount) {
                int segment = OS.PathFigure_Segments(figure, j);
                int type = OS.Object_GetType(segment);
                OS.GCHandle_Free(type);
                OS.GCHandle_Free(segment);
                ++j;
            }
            OS.GCHandle_Free(figure);
            ++i;
        }
        if (typesIndex != types.length) {
            byte[] newTypes = new byte[typesIndex];
            System.arraycopy(types, 0, newTypes, 0, typesIndex);
            types = newTypes;
        }
        if (pointsIndex != points.length) {
            float[] newPoints = new float[pointsIndex];
            System.arraycopy(points, 0, newPoints, 0, pointsIndex);
            points = newPoints;
        }
        PathData result = new PathData();
        result.types = types;
        result.points = points;
        return result;
    }

    public void lineTo(float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        int point = OS.gcnew_Point(x, y);
        if (this.currentFigure == 0) {
            this.newFigure();
        }
        if (this.currentPoint != 0) {
            OS.GCHandle_Free(this.currentPoint);
        }
        this.currentPoint = point;
        int segment = OS.gcnew_LineSegment(point, true);
        int segments = OS.PathFigure_Segments(this.currentFigure);
        OS.PathSegmentCollection_Add(segments, segment);
        OS.GCHandle_Free(segments);
        OS.GCHandle_Free(segment);
    }

    void init(PathData data) {
        byte[] types = data.types;
        float[] points = data.points;
        int i = 0;
        int j = 0;
        while (i < types.length) {
            switch (types[i]) {
                case 1: {
                    this.moveTo(points[j++], points[j++]);
                    break;
                }
                case 2: {
                    this.lineTo(points[j++], points[j++]);
                    break;
                }
                case 4: {
                    this.cubicTo(points[j++], points[j++], points[j++], points[j++], points[j++], points[j++]);
                    break;
                }
                case 3: {
                    this.quadTo(points[j++], points[j++], points[j++], points[j++]);
                    break;
                }
                case 5: {
                    this.close();
                    break;
                }
                default: {
                    this.dispose();
                    SWT.error(5);
                }
            }
            ++i;
        }
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public void moveTo(float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        int point = OS.gcnew_Point(x, y);
        if (this.currentPoint != 0) {
            OS.GCHandle_Free(this.currentPoint);
        }
        this.currentPoint = point;
        if (this.currentFigure != 0) {
            int segments = OS.PathFigure_Segments(this.currentFigure);
            int count = OS.PathSegmentCollection_Count(segments);
            OS.GCHandle_Free(segments);
            if (count == 0) {
                OS.PathFigure_StartPoint(this.currentFigure, point);
                return;
            }
        }
        if (this.currentFigure != 0) {
            OS.GCHandle_Free(this.currentFigure);
        }
        this.newFigure();
    }

    void newFigure() {
        this.currentFigure = OS.gcnew_PathFigure();
        if (this.currentPoint != 0) {
            OS.PathFigure_StartPoint(this.currentFigure, this.currentPoint);
        }
        int figures = OS.PathGeometry_Figures(this.handle);
        OS.PathFigureCollection_Add(figures, this.currentFigure);
        OS.GCHandle_Free(figures);
    }

    public void quadTo(float cx, float cy, float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        int controlPoint = OS.gcnew_Point(cx, cy);
        int point = OS.gcnew_Point(x, y);
        if (this.currentFigure == 0) {
            this.newFigure();
        }
        if (this.currentPoint != 0) {
            OS.GCHandle_Free(this.currentPoint);
        }
        this.currentPoint = point;
        int segment = OS.gcnew_QuadraticBezierSegment(controlPoint, point, true);
        int segments = OS.PathFigure_Segments(this.currentFigure);
        OS.PathSegmentCollection_Add(segments, segment);
        OS.GCHandle_Free(segments);
        OS.GCHandle_Free(segment);
        OS.GCHandle_Free(controlPoint);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Path {*DISPOSED*}";
        }
        return "Path {" + this.handle + "}";
    }
}

