/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.director.app.ant;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.director.app.Application;
import org.eclipse.equinox.internal.provisional.p2.core.Version;

public class DirectorTask
extends Task {
    boolean roaming;
    boolean list;
    String profile;
    String flavor;
    String os;
    String ws;
    String nl;
    String arch;
    String installIU;
    String uninstallIU;
    File destination;
    File bundlePool;
    URI metadataRepository;
    URI artifactRepository;
    Version version;

    public void execute() throws BuildException {
        try {
            new Application().run(this.getArguments());
        }
        catch (Exception e) {
            throw new BuildException("Exception while calling the director task.", (Throwable)e);
        }
    }

    private String[] getArguments() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.roaming) {
            result.add("-roaming");
        }
        if (this.profile != null) {
            result.add("-profile");
            result.add(this.profile);
        }
        if (this.destination != null) {
            result.add("-destination");
            result.add(this.destination.getAbsolutePath());
        }
        if (this.bundlePool != null) {
            result.add("-bundlePool");
            result.add(this.bundlePool.getAbsolutePath());
        }
        if (this.metadataRepository != null) {
            result.add("-metadataRepository");
            result.add(this.metadataRepository.toString());
        }
        if (this.artifactRepository != null) {
            result.add("-artifactRepository");
            result.add(this.artifactRepository.toString());
        }
        if (this.flavor != null) {
            result.add("-flavor");
            result.add(this.flavor);
        }
        if (this.version != null) {
            result.add("-version");
            result.add(this.version.toString());
        }
        if (this.os != null) {
            result.add("-p2.os");
            result.add(this.os);
        }
        if (this.ws != null) {
            result.add("-p2.ws");
            result.add(this.ws);
        }
        if (this.arch != null) {
            result.add("-p2.arch");
            result.add(this.arch);
        }
        if (this.nl != null) {
            result.add("-p2.nl");
            result.add(this.nl);
        }
        if (this.list) {
            result.add(Application.COMMAND_NAMES[2]);
        }
        if (this.installIU != null) {
            result.add(Application.COMMAND_NAMES[0]);
            result.add(this.installIU);
        }
        if (this.uninstallIU != null) {
            result.add(Application.COMMAND_NAMES[1]);
            result.add(this.uninstallIU);
        }
        return result.toArray(new String[result.size()]);
    }

    public void setArch(String value) {
        this.arch = value;
    }

    public void setArtifactRepository(String value) {
        try {
            this.artifactRepository = URIUtil.fromString((String)value);
        }
        catch (URISyntaxException e) {
            this.log("Error setting the artifact repository.", e, 0);
        }
    }

    public void setBundlePool(String value) {
        this.bundlePool = new File(value);
    }

    public void setDestination(String value) {
        this.destination = new File(value);
    }

    public void setFlavor(String value) {
        this.flavor = value;
    }

    public void setInstallIU(String value) {
        this.installIU = value;
    }

    public void setList(String value) {
        this.list = Boolean.valueOf(value);
    }

    public void setMetadataRepository(String value) {
        try {
            this.metadataRepository = URIUtil.fromString((String)value);
        }
        catch (URISyntaxException e) {
            this.log("Error setting the metadata repository.", e, 0);
        }
    }

    public void setNl(String value) {
        this.nl = value;
    }

    public void setOs(String value) {
        this.os = value;
    }

    public void setProfile(String value) {
        this.profile = value;
    }

    public void setRoaming(String value) {
        this.roaming = Boolean.valueOf(value);
    }

    public void setUninstallIU(String value) {
        this.uninstallIU = value;
    }

    public void setVersion(String value) {
        this.version = new Version(value);
    }

    public void setWs(String value) {
        this.ws = value;
    }
}

