/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools.tasks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.types.DataType;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.IUPropertyQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.LatestIUVersionQuery;
import org.eclipse.equinox.internal.provisional.p2.query.CompositeQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Query;

public class IUDescription
extends DataType {
    private static final String QUERY_PROPERTY = "property";
    private static final String QUERY_NAME = "name";
    private static final String QUERY_VALUE = "value";
    private static final String ANT_PREFIX = "${";
    private String id;
    private String version;
    private String queryString;
    private boolean required = true;

    public void setId(String value) {
        if (value != null && !value.startsWith(ANT_PREFIX)) {
            this.id = value;
        }
    }

    public void setVersion(String value) {
        if (value != null && !value.startsWith(ANT_PREFIX)) {
            this.version = value;
        }
    }

    public void setQuery(String query) {
        if (query != null && !query.startsWith(ANT_PREFIX)) {
            this.queryString = query;
        }
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("Installable Unit [");
        if (this.id != null) {
            buffer.append(" id=");
            buffer.append(this.id);
        }
        if (this.version != null) {
            buffer.append(" version=");
            buffer.append(this.version);
        }
        if (this.queryString != null) {
            buffer.append(" query=");
            buffer.append(this.queryString);
        }
        buffer.append(" ]");
        return buffer.toString();
    }

    public Query createQuery() {
        Query iuQuery;
        ArrayList<Object> queries = new ArrayList<Object>();
        if (this.id != null) {
            if (this.version == null || this.version.length() == 0) {
                queries.add(new InstallableUnitQuery(this.id));
                queries.add(new LatestIUVersionQuery());
            } else {
                Version iuVersion = Version.parseVersion((String)this.version);
                queries.add(new InstallableUnitQuery(this.id, iuVersion));
            }
        }
        if ((iuQuery = this.processQueryString()) != null) {
            queries.add(iuQuery);
        }
        if (queries.size() == 1) {
            return (Query)queries.get(0);
        }
        return new CompositeQuery(queries.toArray(new Query[queries.size()]));
    }

    private Query processQueryString() {
        if (this.queryString == null) {
            return null;
        }
        int startIdx = this.queryString.indexOf(91);
        int endIdx = this.queryString.lastIndexOf(93);
        if (startIdx == -1 || endIdx == -1 || endIdx < startIdx) {
            return null;
        }
        String element = this.queryString.substring(0, startIdx);
        Map attributes = this.processQueryAttributes(this.queryString.substring(startIdx + 1, endIdx));
        if (element.equals(QUERY_PROPERTY)) {
            String name = (String)attributes.get(QUERY_NAME);
            String value = (String)attributes.get(QUERY_VALUE);
            if (name == null) {
                return null;
            }
            return new IUPropertyQuery(name, value);
        }
        return null;
    }

    private Map processQueryAttributes(String attributes) {
        if (attributes == null || attributes.length() == 0) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        int start = 0;
        int idx = 0;
        while ((idx = attributes.indexOf(64, start)) > -1) {
            int equals = attributes.indexOf(61, idx);
            int startQuote = attributes.indexOf(39, equals);
            int endQuote = attributes.indexOf(39, startQuote + 1);
            if (equals == -1 || startQuote <= equals || endQuote <= startQuote) break;
            String key = attributes.substring(idx + 1, equals).trim();
            String value = attributes.substring(startQuote + 1, endQuote);
            result.put(key, value);
            start = endQuote + 1;
        }
        return result;
    }
}

