/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.antsupport.logger.debug;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Task;
import org.eclipse.ant.internal.ui.antsupport.logger.RemoteAntBuildLogger;
import org.eclipse.ant.internal.ui.antsupport.logger.debug.RemoteAntBreakpoint;
import org.eclipse.ant.internal.ui.antsupport.logger.util.AntDebugState;
import org.eclipse.ant.internal.ui.antsupport.logger.util.IDebugBuildLogger;

public class RemoteAntDebugBuildLogger
extends RemoteAntBuildLogger
implements IDebugBuildLogger {
    private ServerSocket fServerSocket;
    private static final int fgServerSocketTimeout = 5000;
    private Socket fRequestSocket;
    private PrintWriter fRequestWriter;
    private BufferedReader fRequestReader;
    private boolean fBuildStartedSuspend = true;
    private Task fStepOverTaskInterrupted;
    private List fBreakpoints = null;
    private int fRequestPort = -1;
    private AntDebugState fDebugState;

    private void requestConnect() {
        if (this.fDebugMode) {
            System.out.println("RemoteAntDebugBuildLogger: trying to connect" + this.fHost + ":" + this.fRequestPort);
        }
        try {
            this.fServerSocket.setSoTimeout(5000);
            this.fRequestSocket = this.fServerSocket.accept();
            this.fRequestWriter = new PrintWriter(this.fRequestSocket.getOutputStream(), true);
            this.fRequestReader = new BufferedReader(new InputStreamReader(this.fRequestSocket.getInputStream()));
            ReaderThread readerThread = new ReaderThread();
            readerThread.setDaemon(true);
            readerThread.start();
            return;
        }
        catch (SocketTimeoutException socketTimeoutException) {
        }
        catch (IOException iOException) {}
        this.shutDown();
    }

    protected void shutDown() {
        if (this.fRequestWriter != null) {
            this.fRequestWriter.close();
            this.fRequestWriter = null;
        }
        if (this.fRequestReader != null) {
            try {
                this.fRequestReader.close();
            }
            catch (IOException iOException) {}
            this.fRequestReader = null;
        }
        if (this.fRequestSocket != null) {
            try {
                this.fRequestSocket.close();
            }
            catch (IOException iOException) {}
        }
        this.fRequestSocket = null;
        super.shutDown();
    }

    public synchronized void buildStarted(BuildEvent event) {
        this.fDebugState = new AntDebugState(this);
        super.buildStarted(event);
        this.marshalMessage(-1, "build_started");
        if (this.fRequestPort != -1) {
            try {
                this.fServerSocket = new ServerSocket(this.fRequestPort);
            }
            catch (IOException iOException) {
                this.shutDown();
            }
            this.requestConnect();
        } else {
            this.shutDown();
        }
        this.fDebugState.buildStarted();
        this.fDebugState.setShouldSuspend(true);
        this.waitIfSuspended();
    }

    public void taskStarted(BuildEvent event) {
        super.taskStarted(event);
        this.fDebugState.taskStarted(event);
    }

    public synchronized void taskFinished(BuildEvent event) {
        super.taskFinished(event);
        this.fDebugState.taskFinished();
    }

    public synchronized void waitIfSuspended() {
        String detail = null;
        boolean shouldSuspend = true;
        RemoteAntBreakpoint breakpoint = this.breakpointAtLineNumber(this.fDebugState.getBreakpointLocation());
        if (breakpoint != null) {
            detail = breakpoint.toMarshallString();
            this.fDebugState.setShouldSuspend(false);
            if (this.fDebugState.getStepOverTask() != null) {
                this.fStepOverTaskInterrupted = this.fDebugState.getStepOverTask();
                this.fDebugState.setStepOverTask(null);
            }
        } else if (this.fDebugState.getCurrentTask() != null) {
            if (this.fDebugState.isStepIntoSuspend()) {
                detail = "step";
                this.fDebugState.setStepIntoSuspend(false);
            } else if (this.fDebugState.getLastTaskFinished() != null && this.fDebugState.getLastTaskFinished() == this.fDebugState.getStepOverTask() || this.fDebugState.shouldSuspend()) {
                detail = "step";
                this.fDebugState.setStepOverTask(null);
                this.fDebugState.setShouldSuspend(false);
            } else if (this.fDebugState.getLastTaskFinished() != null && this.fDebugState.getLastTaskFinished() == this.fDebugState.getStepIntoTask()) {
                detail = "step";
                this.fDebugState.setStepIntoTask(null);
            } else if (this.fDebugState.getLastTaskFinished() != null && this.fDebugState.getLastTaskFinished() == this.fStepOverTaskInterrupted) {
                detail = "step";
                this.fStepOverTaskInterrupted = null;
            } else if (this.fDebugState.isClientSuspend()) {
                detail = "client";
                this.fDebugState.setClientSuspend(false);
            } else {
                shouldSuspend = false;
            }
        } else if (this.fDebugState.shouldSuspend() && this.fBuildStartedSuspend) {
            this.fBuildStartedSuspend = false;
            this.fDebugState.setShouldSuspend(false);
        } else {
            shouldSuspend = false;
        }
        if (shouldSuspend) {
            if (detail != null) {
                StringBuffer message = new StringBuffer("suspended");
                message.append(detail);
                this.sendRequestResponse(message.toString());
            }
            try {
                this.wait();
                shouldSuspend = false;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private RemoteAntBreakpoint breakpointAtLineNumber(Location location) {
        if (this.fBreakpoints == null || location == null || location == Location.UNKNOWN_LOCATION) {
            return null;
        }
        String fileName = this.fDebugState.getFileName(location);
        int lineNumber = this.fDebugState.getLineNumber(location);
        int i = 0;
        while (i < this.fBreakpoints.size()) {
            RemoteAntBreakpoint breakpoint = (RemoteAntBreakpoint)this.fBreakpoints.get(i);
            if (breakpoint.isAt(fileName, lineNumber)) {
                return breakpoint;
            }
            ++i;
        }
        return null;
    }

    private void sendRequestResponse(String message) {
        if (this.fRequestWriter == null) {
            return;
        }
        this.fRequestWriter.println(message);
    }

    protected void marshallStack() {
        StringBuffer stackRepresentation = new StringBuffer();
        this.fDebugState.marshalStack(stackRepresentation);
        this.sendRequestResponse(stackRepresentation.toString());
    }

    protected void marshallProperties() {
        StringBuffer propertiesRepresentation = new StringBuffer();
        this.fDebugState.marshallProperties(propertiesRepresentation, true);
        this.sendRequestResponse(propertiesRepresentation.toString());
    }

    protected void addBreakpoint(String breakpointRepresentation) {
        RemoteAntBreakpoint newBreakpoint;
        if (this.fBreakpoints == null) {
            this.fBreakpoints = new ArrayList();
        }
        if (!this.fBreakpoints.contains(newBreakpoint = new RemoteAntBreakpoint(breakpointRepresentation))) {
            this.fBreakpoints.add(newBreakpoint);
        }
    }

    protected void removeBreakpoint(String breakpointRepresentation) {
        if (this.fBreakpoints == null) {
            return;
        }
        RemoteAntBreakpoint equivalentBreakpoint = new RemoteAntBreakpoint(breakpointRepresentation);
        Iterator iter = this.fBreakpoints.iterator();
        while (iter.hasNext()) {
            RemoteAntBreakpoint breakpoint = (RemoteAntBreakpoint)iter.next();
            if (!breakpoint.equals(equivalentBreakpoint)) continue;
            iter.remove();
            return;
        }
    }

    public void targetStarted(BuildEvent event) {
        this.fDebugState.targetStarted(event);
        if (!this.fSentProcessId) {
            this.establishConnection();
        }
        this.waitIfSuspended();
        super.targetStarted(event);
    }

    public void targetFinished(BuildEvent event) {
        super.targetFinished(event);
        this.fDebugState.setTargetExecuting(null);
    }

    public void configure(Map userProperties) {
        super.configure(userProperties);
        String requestPortProperty = (String)userProperties.remove("eclipse.connect.request_port");
        if (requestPortProperty != null) {
            this.fRequestPort = Integer.parseInt(requestPortProperty);
        }
    }

    private class ReaderThread
    extends Thread {
        public ReaderThread() {
            super("ReaderThread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                String message = null;
                while (RemoteAntDebugBuildLogger.this.fRequestReader != null) {
                    RemoteAntDebugBuildLogger remoteAntDebugBuildLogger;
                    message = RemoteAntDebugBuildLogger.this.fRequestReader.readLine();
                    if (message == null) continue;
                    if (message.startsWith("step_into")) {
                        remoteAntDebugBuildLogger = RemoteAntDebugBuildLogger.this;
                        synchronized (remoteAntDebugBuildLogger) {
                            RemoteAntDebugBuildLogger.this.fDebugState.setStepIntoSuspend(true);
                            RemoteAntDebugBuildLogger.this.fDebugState.setStepIntoTask(RemoteAntDebugBuildLogger.this.fDebugState.getCurrentTask());
                            RemoteAntDebugBuildLogger.this.notifyAll();
                        }
                    }
                    if (message.startsWith("step_over")) {
                        remoteAntDebugBuildLogger = RemoteAntDebugBuildLogger.this;
                        synchronized (remoteAntDebugBuildLogger) {
                            RemoteAntDebugBuildLogger.this.fDebugState.stepOver();
                            continue;
                        }
                    }
                    if (message.startsWith("suspend")) {
                        remoteAntDebugBuildLogger = RemoteAntDebugBuildLogger.this;
                        synchronized (remoteAntDebugBuildLogger) {
                            RemoteAntDebugBuildLogger.this.fDebugState.setStepIntoTask(null);
                            RemoteAntDebugBuildLogger.this.fDebugState.setStepOverTask(null);
                            RemoteAntDebugBuildLogger.this.fStepOverTaskInterrupted = null;
                            RemoteAntDebugBuildLogger.this.fDebugState.setClientSuspend(true);
                            continue;
                        }
                    }
                    if (message.startsWith("resume")) {
                        remoteAntDebugBuildLogger = RemoteAntDebugBuildLogger.this;
                        synchronized (remoteAntDebugBuildLogger) {
                            RemoteAntDebugBuildLogger.this.fDebugState.setStepIntoTask(null);
                            RemoteAntDebugBuildLogger.this.fDebugState.setStepOverTask(null);
                            RemoteAntDebugBuildLogger.this.fStepOverTaskInterrupted = null;
                            RemoteAntDebugBuildLogger.this.notifyAll();
                            continue;
                        }
                    }
                    if (message.startsWith("terminate")) {
                        RemoteAntDebugBuildLogger.this.sendRequestResponse("terminated");
                        RemoteAntDebugBuildLogger.this.shutDown();
                        continue;
                    }
                    if (message.startsWith("stack")) {
                        RemoteAntDebugBuildLogger.this.marshallStack();
                        continue;
                    }
                    if (message.startsWith("add")) {
                        RemoteAntDebugBuildLogger.this.addBreakpoint(message);
                        continue;
                    }
                    if (message.startsWith("remove")) {
                        RemoteAntDebugBuildLogger.this.removeBreakpoint(message);
                        continue;
                    }
                    if (!message.startsWith("prop")) continue;
                    RemoteAntDebugBuildLogger.this.marshallProperties();
                }
            }
            catch (Exception exception) {
                RemoteAntDebugBuildLogger.this.shutDown();
            }
        }
    }
}

