/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.text;

import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.pde.internal.ui.editor.text.BasePDEScanner;
import org.eclipse.pde.internal.ui.editor.text.IColorManager;
import org.eclipse.pde.internal.ui.editor.text.XMLWhitespaceDetector;

public class XMLTagScanner
extends BasePDEScanner {
    private Token fStringToken;
    private Token fExternalizedStringToken;

    public XMLTagScanner(IColorManager manager) {
        super(manager);
    }

    protected void initialize() {
        this.fStringToken = new Token((Object)this.createTextAttribute("editor.color.string"));
        this.fExternalizedStringToken = new Token((Object)this.createTextAttribute("editor.color.externalized_string"));
        IRule[] rules = new IRule[]{new SingleLineRule("\"%", "\"", (IToken)this.fExternalizedStringToken), new SingleLineRule("'%", "'", (IToken)this.fExternalizedStringToken), new MultiLineRule("\"", "\"", (IToken)this.fStringToken), new SingleLineRule("'", "'", (IToken)this.fStringToken), new WhitespaceRule((IWhitespaceDetector)new XMLWhitespaceDetector())};
        this.setRules(rules);
        this.setDefaultReturnToken((IToken)new Token((Object)this.createTextAttribute("editor.color.tag")));
    }

    protected Token getTokenAffected(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.startsWith("editor.color.string")) {
            return this.fStringToken;
        }
        if (property.startsWith("editor.color.externalized_string")) {
            return this.fExternalizedStringToken;
        }
        return (Token)this.fDefaultReturnToken;
    }

    public boolean affectsTextPresentation(String property) {
        return property.startsWith("editor.color.tag") || property.startsWith("editor.color.string") || property.startsWith("editor.color.externalized_string");
    }
}

