/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.core;

import java.io.Serializable;

public class VersionVector
implements Comparable,
Serializable {
    public static final Comparable MAX_VALUE = new MaxValue();
    public static final Comparable MAXS_VALUE = new MaxStringValue();
    public static final Comparable MIN_VALUE = new MinValue();
    private static final long serialVersionUID = -8385373304298723744L;
    private Comparable padValue;
    private Comparable[] vector;

    static void rawToString(StringBuffer sb, boolean forRange, Comparable e) {
        if (e instanceof String) {
            VersionVector.writeQuotedString(sb, forRange, (String)((Object)e), '\'', 0, false);
        } else if (e instanceof VersionVector) {
            sb.append('<');
            ((VersionVector)e).toString(sb, forRange);
            sb.append('>');
        } else {
            sb.append(e);
        }
    }

    static void writeQuotedString(StringBuffer sb, boolean rangeSafe, String s, char quote, int startPos, boolean didFlip) {
        int quotePos = sb.length();
        sb.append(quote);
        boolean otherSeen = false;
        int top = s.length();
        int idx = startPos;
        while (idx < top) {
            char c = s.charAt(idx);
            if (c == '\'' || c == '\"') {
                if (c == quote) {
                    char otherQuote;
                    char c2 = otherQuote = quote == '\'' ? (char)'\"' : '\'';
                    if (didFlip || otherSeen) {
                        sb.append(quote);
                        VersionVector.writeQuotedString(sb, rangeSafe, s, otherQuote, idx, true);
                        return;
                    }
                    quote = otherQuote;
                    sb.setCharAt(quotePos, quote);
                    didFlip = true;
                } else {
                    otherSeen = true;
                }
            }
            if (rangeSafe && (c == '\\' || c == '[' || c == '(' || c == ']' || c == ')' || c == ',' || c <= ' ')) {
                sb.append('\\');
            }
            sb.append(c);
            ++idx;
        }
        sb.append(quote);
    }

    private static int compareSegments(Comparable a, Comparable b) {
        if (a == b) {
            return 0;
        }
        if (a instanceof Integer && b instanceof Integer) {
            int bi;
            int ai = (Integer)a;
            return ai > (bi = ((Integer)b).intValue()) ? 1 : (ai < bi ? -1 : 0);
        }
        if (a instanceof String && b instanceof String) {
            return a.compareTo(b);
        }
        if (a == MAX_VALUE || a == MIN_VALUE || a == MAXS_VALUE) {
            return a.compareTo(b);
        }
        if (b == MAX_VALUE || b == MIN_VALUE || b == MAXS_VALUE) {
            return -b.compareTo(a);
        }
        if (a instanceof Integer) {
            return 1;
        }
        if (b instanceof Integer) {
            return -1;
        }
        if (a instanceof VersionVector) {
            return b instanceof VersionVector ? a.compareTo(b) : 1;
        }
        if (b instanceof VersionVector) {
            return -1;
        }
        throw new IllegalArgumentException();
    }

    VersionVector() {
    }

    VersionVector(Comparable[] vector, Comparable pad) {
        this.vector = vector;
        this.padValue = pad == MIN_VALUE ? null : pad;
    }

    public int compareTo(Object o) {
        if (o == this) {
            return 0;
        }
        VersionVector ov = (VersionVector)o;
        Comparable[] t_vector = this.vector;
        int top = t_vector.length;
        Comparable[] o_vector = ov.vector;
        if (top > o_vector.length) {
            top = o_vector.length;
        }
        int idx = 0;
        while (idx < top) {
            int cmp = VersionVector.compareSegments(t_vector[idx], o_vector[idx]);
            if (cmp != 0) {
                return cmp;
            }
            ++idx;
        }
        if (top < t_vector.length) {
            return ov.padValue == null ? 1 : this.compareReminder(top, ov.padValue);
        }
        if (top < o_vector.length) {
            return this.padValue == null ? -1 : -ov.compareReminder(top, this.padValue);
        }
        return this.padValue == null ? (ov.padValue == null ? 0 : -1) : (ov.padValue == null ? 1 : VersionVector.compareSegments(this.padValue, ov.padValue));
    }

    /*
     * Unable to fully structure code
     */
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VersionVector)) {
            return false;
        }
        ov = (VersionVector)o;
        if (this.padValue == null ? ov.padValue != null : ov.padValue == null || this.padValue.equals(ov.padValue) == false) {
            return false;
        }
        t_vector = this.vector;
        idx = t_vector.length;
        o_vector = ov.vector;
        if (idx == o_vector.length) ** GOTO lbl15
        return false;
lbl-1000:
        // 1 sources

        {
            if (t_vector[idx].equals(o_vector[idx])) continue;
            return false;
lbl15:
            // 2 sources

            ** while (--idx >= 0)
        }
lbl16:
        // 1 sources

        return true;
    }

    public Comparable getPad() {
        return this.padValue;
    }

    public Comparable getSegment(int index) {
        return this.vector[index];
    }

    public int getSegmentCount() {
        return this.vector.length;
    }

    public int hashCode() {
        int hashCode = this.padValue == null ? 31 : this.padValue.hashCode();
        int idx = this.vector.length;
        while (--idx >= 0) {
            Comparable elem = this.vector[idx];
            if (elem != null) {
                hashCode += elem.hashCode();
            }
            hashCode *= 31;
        }
        return hashCode;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        this.toString(sb);
        return sb.toString();
    }

    public void toString(StringBuffer sb) {
        this.toString(sb, false);
    }

    public void toString(StringBuffer sb, boolean rangeSafe) {
        int top = this.vector.length;
        if (top == 0) {
            VersionVector.rawToString(sb, rangeSafe, this.padValue == null ? MIN_VALUE : this.padValue);
        } else {
            int idx = 0;
            while (idx < top) {
                if (idx > 0) {
                    sb.append('.');
                }
                VersionVector.rawToString(sb, rangeSafe, this.vector[idx]);
                ++idx;
            }
        }
        if (this.padValue != null) {
            sb.append('p');
            VersionVector.rawToString(sb, rangeSafe, this.padValue);
        }
    }

    Comparable[] getVector() {
        return this.vector;
    }

    void init(Comparable[] vec, Comparable pad) {
        this.vector = vec;
        this.padValue = pad == MIN_VALUE ? null : pad;
    }

    private int compareReminder(int idx, Comparable othersPad) {
        int cmp = 0;
        while (idx < this.vector.length && cmp == 0) {
            cmp = VersionVector.compareSegments(this.vector[idx], othersPad);
            ++idx;
        }
        if (cmp == 0) {
            cmp = this.padValue == null ? -1 : this.padValue.compareTo(othersPad);
        }
        return cmp;
    }

    private static final class MaxStringValue
    implements Comparable,
    Serializable {
        private static final long serialVersionUID = -4936252230441132767L;

        MaxStringValue() {
        }

        public int compareTo(Object o) {
            return o == this ? 0 : (o == MAX_VALUE || o instanceof Integer || o instanceof VersionVector ? -1 : 1);
        }

        private Object readResolve() {
            return MAXS_VALUE;
        }

        public String toString() {
            return "m";
        }
    }

    private static final class MaxValue
    implements Comparable,
    Serializable {
        private static final long serialVersionUID = -5889641741635253589L;

        MaxValue() {
        }

        public int compareTo(Object o) {
            return o == this ? 0 : 1;
        }

        public String toString() {
            return "M";
        }

        private Object readResolve() {
            return MAX_VALUE;
        }
    }

    private static class MinValue
    implements Comparable,
    Serializable {
        private static final long serialVersionUID = -1066323980049812226L;

        MinValue() {
        }

        public int compareTo(Object o) {
            return o == this ? 0 : -1;
        }

        public String toString() {
            return "-M";
        }

        private Object readResolve() {
            return MIN_VALUE;
        }
    }
}

