/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.publisher.ant;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.Task;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.artifact.repository.CompositeArtifactRepository;
import org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository;
import org.eclipse.equinox.internal.p2.publisher.Messages;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.p2.publisher.Publisher;
import org.eclipse.equinox.p2.publisher.PublisherInfo;

public abstract class AbstractPublishTask
extends Task {
    protected static final String ANT_PROPERTY_PREFIX = "${";
    protected boolean compress = false;
    protected boolean reusePackedFiles = false;
    protected boolean append = true;
    protected boolean publish = true;
    protected URI metadataLocation;
    protected String metadataRepoName;
    protected URI artifactLocation;
    protected String artifactRepoName;
    protected PublisherInfo provider = null;
    protected List contextRepositories = new ArrayList();

    protected IStatus createConfigurationEror(String message) {
        return new Status(4, "org.eclipse.equinox.p2.publisher", message);
    }

    protected void initializeRepositories(PublisherInfo info) throws ProvisionException {
        if (this.artifactLocation != null) {
            info.setArtifactRepository(Publisher.createArtifactRepository((URI)this.artifactLocation, (String)this.artifactRepoName, (boolean)this.append, (boolean)this.compress, (boolean)this.reusePackedFiles));
        } else if ((info.getArtifactOptions() & 2) > 0) {
            throw new ProvisionException(this.createConfigurationEror(Messages.exception_noArtifactRepo));
        }
        if (this.metadataLocation == null) {
            throw new ProvisionException(this.createConfigurationEror(Messages.exception_noMetadataRepo));
        }
        info.setMetadataRepository(Publisher.createMetadataRepository((URI)this.metadataLocation, (String)this.metadataRepoName, (boolean)this.append, (boolean)this.compress));
        if (this.contextRepositories.size() > 0) {
            CompositeMetadataRepository contextMetadata = CompositeMetadataRepository.createMemoryComposite();
            CompositeArtifactRepository contextArtifact = CompositeArtifactRepository.createMemoryComposite();
            Iterator iterator = this.contextRepositories.iterator();
            while (iterator.hasNext()) {
                RepoEntry entry = (RepoEntry)iterator.next();
                if (contextMetadata != null && entry.isMetadataRepository()) {
                    contextMetadata.addChild(entry.getRepositoryLocation());
                }
                if (contextArtifact == null || !entry.isArtifactRepository()) continue;
                contextArtifact.addChild(entry.getRepositoryLocation());
            }
            if (contextMetadata != null && contextMetadata.getChildren().size() > 0) {
                info.setContextMetadataRepository((IMetadataRepository)contextMetadata);
            }
            if (contextArtifact != null && contextArtifact.getChildren().size() > 0) {
                info.setContextArtifactRepository((IArtifactRepository)contextArtifact);
            }
        }
    }

    protected PublisherInfo getInfo() {
        if (this.provider == null) {
            this.provider = new PublisherInfo();
        }
        if (this.publish) {
            this.provider.setArtifactOptions(this.provider.getArtifactOptions() | 2);
        }
        return this.provider;
    }

    public void setCompress(String value) {
        this.compress = Boolean.valueOf(value);
    }

    public void setReusePackedFiles(String value) {
        this.reusePackedFiles = Boolean.valueOf(value);
    }

    public void setAppend(String value) {
        this.append = Boolean.valueOf(value);
    }

    public void setPublishArtifacts(String value) {
        this.publish = Boolean.valueOf(value);
    }

    public void setArtifactRepository(String location) {
        try {
            this.artifactLocation = URIUtil.fromString((String)location);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Artifact repository location (" + location + ") must be a URL.");
        }
    }

    public void setArtifactRepositoryName(String value) {
        this.artifactRepoName = value;
    }

    public void setMetadataRepository(String location) {
        try {
            this.metadataLocation = URIUtil.fromString((String)location);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Metadata repository location (" + location + ") must be a URL.");
        }
    }

    public void setMetadataRepositoryName(String value) {
        this.metadataRepoName = value;
    }

    public void setRepository(String location) {
        this.setArtifactRepository(location);
        this.setMetadataRepository(location);
    }

    public void setRepositoryName(String name) {
        this.setArtifactRepositoryName(name);
        this.setMetadataRepositoryName(name);
    }

    public void addConfiguredContextRepository(RepoEntry repo) {
        this.contextRepositories.add(repo);
    }

    public static class RepoEntry {
        private URI repoLocation;
        private Boolean metadata = null;
        private Boolean artifact = null;

        public boolean isMetadataRepository() {
            if (this.metadata != null) {
                return this.metadata;
            }
            return !Boolean.TRUE.equals(this.artifact);
        }

        public boolean isArtifactRepository() {
            if (this.artifact != null) {
                return this.artifact;
            }
            return !Boolean.TRUE.equals(this.metadata);
        }

        public URI getRepositoryLocation() {
            return this.repoLocation;
        }

        public void setLocation(String location) {
            try {
                this.repoLocation = URIUtil.fromString((String)location);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalArgumentException("Repository location (" + location + ") must be a URL.");
            }
        }

        public void setMetadata(boolean metadata) {
            this.metadata = metadata;
        }

        public void setArtifact(boolean artifact) {
            this.artifact = artifact;
        }
    }
}

