/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;

public class TableItem
extends Item {
    Table parent;
    String[] strings;
    Image[] images;
    boolean checked;
    boolean grayed;
    boolean cached;
    Color foreground;
    Color background;
    Color[] cellForeground;
    Color[] cellBackground;
    Font font;
    Font[] cellFont;
    int width = -1;

    public TableItem(Table parent, int style) {
        this(parent, style, TableItem.checkNull(parent).getItemCount(), true);
    }

    public TableItem(Table parent, int style, int index) {
        this(parent, style, index, true);
    }

    TableItem(Table parent, int style, int index, boolean create) {
        super(parent, style);
        this.parent = parent;
        if (create) {
            parent.createItem(this, index);
        }
    }

    static Table checkNull(Table control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    int calculateWidth(int index, GC gc) {
        Image image;
        if (index == 0 && this.width != -1) {
            return this.width;
        }
        int width = 0;
        Image image2 = index == 0 ? this.image : (image = this.images == null ? null : this.images[index]);
        String text = index == 0 ? this.text : (this.strings == null ? "" : this.strings[index]);
        Font font = null;
        if (this.cellFont != null) {
            font = this.cellFont[index];
        }
        if (font == null) {
            font = this.font;
        }
        if (font == null) {
            font = this.parent.getFont();
        }
        gc.setFont(font);
        if (image != null) {
            width += image.getBounds().width + this.parent.getGap();
        }
        if (text != null && text.length() > 0) {
            width += gc.stringExtent((String)text).x;
        }
        boolean sendMeasure = true;
        if ((this.parent.style & 0x10000000) != 0) {
            sendMeasure = this.cached;
        }
        if (sendMeasure && this.parent.hooks(41)) {
            Event event = new Event();
            event.item = this;
            event.index = index;
            event.gc = gc;
            short[] height = new short[1];
            OS.GetDataBrowserTableViewRowHeight(this.parent.handle, height);
            event.width = width;
            event.height = height[0];
            this.parent.sendEvent(41, event);
            if (height[0] < event.height) {
                OS.SetDataBrowserTableViewRowHeight(this.parent.handle, (short)event.height);
                this.redrawWidget(this.parent.handle, false);
            }
            width = event.width;
        }
        if (index == 0) {
            this.width = width;
        }
        return width;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void clear() {
        this.text = "";
        this.image = null;
        this.strings = null;
        this.images = null;
        this.cached = false;
        this.grayed = false;
        this.checked = false;
        this.background = null;
        this.foreground = null;
        this.cellBackground = null;
        this.cellForeground = null;
        this.font = null;
        this.cellFont = null;
        this.width = -1;
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Color getBackground() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.background != null ? this.background : this.parent.getBackground();
    }

    public Color getBackground(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return this.getBackground();
        }
        if (this.cellBackground == null || this.cellBackground[index] == null) {
            return this.getBackground();
        }
        return this.cellBackground[index];
    }

    public Rectangle getBounds() {
        int columnId;
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        Rect rect = new Rect();
        int itemIndex = this.parent.indexOf(this);
        if (itemIndex == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        int id = this.parent.getId(itemIndex);
        int n = columnId = this.parent.columnCount == 0 ? this.parent.column_id : this.parent.columns[0].id;
        if (OS.GetDataBrowserItemPartBounds(this.parent.handle, id, columnId, 0x2D2D2D2D, rect) != 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int x = rect.left;
        short y = rect.top;
        int width = 0;
        if (this.image != null) {
            Rectangle bounds = this.image.getBounds();
            x += bounds.width + this.parent.getGap();
        }
        GC gc = new GC(this.parent);
        Point extent = gc.stringExtent(this.text);
        gc.dispose();
        width += extent.x;
        if (this.parent.columnCount > 0) {
            width = Math.min(width, rect.right - x);
        }
        int height = rect.bottom - rect.top;
        return new Rectangle(x, y, width, height);
    }

    public Rectangle getBounds(int index) {
        int height;
        int width;
        short y;
        short x;
        int columnId;
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        this.parent.checkItems(true);
        if (index != 0 && (index < 0 || index >= this.parent.columnCount)) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rect rect = new Rect();
        int itemIndex = this.parent.indexOf(this);
        if (itemIndex == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        int id = this.parent.getId(itemIndex);
        int n = columnId = this.parent.columnCount == 0 ? this.parent.column_id : this.parent.columns[index].id;
        if (OS.GetDataBrowserItemPartBounds(this.parent.handle, id, columnId, 0, rect) != 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (OS.VERSION >= 4160) {
            if (this.parent.getLinesVisible()) {
                rect.left = (short)(rect.left + 1);
                rect.top = (short)(rect.top + 1);
            }
            x = rect.left;
            y = rect.top;
            width = rect.right - rect.left;
            height = rect.bottom - rect.top;
        } else {
            Rect rect2 = new Rect();
            if (OS.GetDataBrowserItemPartBounds(this.parent.handle, id, columnId, 0x2D2D2D2D, rect2) != 0) {
                return new Rectangle(0, 0, 0, 0);
            }
            x = rect2.left;
            y = rect2.top;
            width = rect.right - rect2.left + 1;
            height = rect2.bottom - rect2.top + 1;
        }
        return new Rectangle(x, y, width, height);
    }

    public boolean getChecked() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.checked;
    }

    public Font getFont() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.font != null ? this.font : this.parent.getFont();
    }

    public Font getFont(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return this.getFont();
        }
        if (this.cellFont == null || this.cellFont[index] == null) {
            return this.getFont();
        }
        return this.cellFont[index];
    }

    public Color getForeground() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.foreground != null ? this.foreground : this.parent.getForeground();
    }

    public Color getForeground(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return this.getForeground();
        }
        if (this.cellForeground == null || this.cellForeground[index] == null) {
            return this.getForeground();
        }
        return this.cellForeground[index];
    }

    public boolean getGrayed() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    public Image getImage() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return super.getImage();
    }

    public Image getImage(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (index == 0) {
            return this.getImage();
        }
        if (this.images != null && index >= 0 && index < this.images.length) {
            return this.images[index];
        }
        return null;
    }

    public Rectangle getImageBounds(int index) {
        Rectangle bounds;
        int columnId;
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        this.parent.checkItems(true);
        if (index != 0 && (index < 0 || index >= this.parent.columnCount)) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rect rect = new Rect();
        int itemIndex = this.parent.indexOf(this);
        if (itemIndex == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        int id = this.parent.getId(itemIndex);
        int n = columnId = this.parent.columnCount == 0 ? this.parent.column_id : this.parent.columns[index].id;
        if (OS.GetDataBrowserItemPartBounds(this.parent.handle, id, columnId, 0x2D2D2D2D, rect) != 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        short x = rect.left;
        short y = rect.top;
        int width = 0;
        if (index == 0 && this.image != null) {
            bounds = this.image.getBounds();
            width += bounds.width;
        }
        if (index != 0 && this.images != null && this.images[index] != null) {
            bounds = this.images[index].getBounds();
            width += bounds.width;
        }
        int height = rect.bottom - rect.top + 1;
        return new Rectangle(x, y, width, height);
    }

    public int getImageIndent() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return 0;
    }

    String getNameText() {
        if ((this.parent.style & 0x10000000) != 0 && !this.cached) {
            return "*virtual*";
        }
        return super.getNameText();
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getText() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return super.getText();
    }

    public String getText(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (index == 0) {
            return this.getText();
        }
        if (this.strings != null && index >= 0 && index < this.strings.length) {
            String string = this.strings[index];
            return string != null ? string : "";
        }
        return "";
    }

    public Rectangle getTextBounds(int index) {
        int height;
        int width;
        short y;
        int x;
        int columnId;
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        this.parent.checkItems(true);
        if (index != 0 && (index < 0 || index >= this.parent.columnCount)) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rect rect = new Rect();
        int itemIndex = this.parent.indexOf(this);
        if (itemIndex == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        int id = this.parent.getId(itemIndex);
        int n = columnId = this.parent.columnCount == 0 ? this.parent.column_id : this.parent.columns[index].id;
        if (OS.GetDataBrowserItemPartBounds(this.parent.handle, id, columnId, 0, rect) != 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int imageWidth = 0;
        int margin = this.parent.getInsetWidth() / 2;
        Image image = this.getImage(index);
        if (image != null) {
            Rectangle bounds = image.getBounds();
            imageWidth = bounds.width + this.parent.getGap();
        }
        if (OS.VERSION >= 4160) {
            if (this.parent.getLinesVisible()) {
                rect.left = (short)(rect.left + 1);
                rect.top = (short)(rect.top + 1);
            }
            x = rect.left + imageWidth + margin;
            y = rect.top;
            width = Math.max(0, rect.right - rect.left - imageWidth - margin * 2);
            height = rect.bottom - rect.top;
        } else {
            Rect rect2 = new Rect();
            if (OS.GetDataBrowserItemPartBounds(this.parent.handle, id, columnId, 0x2D2D2D2D, rect2) != 0) {
                return new Rectangle(0, 0, 0, 0);
            }
            x = rect2.left + imageWidth + margin;
            y = rect2.top;
            width = Math.max(0, rect.right - rect2.left + 1 - imageWidth - margin * 2);
            height = rect2.bottom - rect2.top + 1;
        }
        return new Rectangle(x, y, width, height);
    }

    void redraw(int propertyID) {
        if (this.parent.currentItem == this) {
            return;
        }
        if (!this.getDrawing() && propertyID != 1024) {
            return;
        }
        int itemIndex = this.parent.indexOf(this);
        if (itemIndex == -1) {
            return;
        }
        int[] id = new int[]{this.parent.getId(itemIndex)};
        OS.UpdateDataBrowserItems(this.parent.handle, 0, id.length, id, 0, propertyID);
        if (propertyID == 1024) {
            Rect rect = new Rect();
            if (OS.GetDataBrowserItemPartBounds(this.parent.handle, this.parent.getId(itemIndex), propertyID, 0, rect) == 0) {
                short x = rect.left;
                int y = rect.top - 1;
                int width = rect.right - rect.left;
                int height = 1;
                this.redrawWidget(this.parent.handle, x, y, width, height, false);
            }
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    void releaseParent() {
        super.releaseParent();
        this.parent.checkItems(true);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.strings = null;
        this.images = null;
        this.foreground = null;
        this.background = null;
        this.font = null;
        this.cellForeground = null;
        this.cellBackground = null;
        this.cellFont = null;
    }

    public void setBackground(Color color) {
        Color oldColor;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if ((oldColor = this.background) == color) {
            return;
        }
        this.background = color;
        if (oldColor != null && oldColor.equals(color)) {
            return;
        }
        this.cached = true;
        this.redraw(0);
    }

    public void setBackground(int index, Color color) {
        Color oldColor;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return;
        }
        if (this.cellBackground == null) {
            if (color == null) {
                return;
            }
            this.cellBackground = new Color[count];
        }
        if ((oldColor = this.cellBackground[index]) == color) {
            return;
        }
        this.cellBackground[index] = color;
        if (oldColor != null && oldColor.equals(color)) {
            return;
        }
        this.cached = true;
        this.redraw(0);
    }

    public void setChecked(boolean checked) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.checked == checked) {
            return;
        }
        this.setChecked(checked, false);
    }

    void setChecked(boolean checked, boolean notify) {
        this.checked = checked;
        this.cached = true;
        this.redraw(1024);
        if (notify) {
            Event event = new Event();
            event.item = this;
            event.detail = 32;
            this.parent.postEvent(13, event);
        }
    }

    public void setFont(Font font) {
        Font oldFont;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if ((oldFont = this.font) == font) {
            return;
        }
        this.font = font;
        if (oldFont != null && oldFont.equals(font)) {
            return;
        }
        this.cached = true;
        this.redraw(0);
    }

    public void setFont(int index, Font font) {
        Font oldFont;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return;
        }
        if (this.cellFont == null) {
            if (font == null) {
                return;
            }
            this.cellFont = new Font[count];
        }
        if ((oldFont = this.cellFont[index]) == font) {
            return;
        }
        this.cellFont[index] = font;
        if (oldFont != null && oldFont.equals(font)) {
            return;
        }
        this.cached = true;
        this.redraw(0);
    }

    public void setForeground(Color color) {
        Color oldColor;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if ((oldColor = this.foreground) == color) {
            return;
        }
        this.foreground = color;
        if (oldColor != null && oldColor.equals(color)) {
            return;
        }
        this.cached = true;
        this.redraw(0);
    }

    public void setForeground(int index, Color color) {
        Color oldColor;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return;
        }
        if (this.cellForeground == null) {
            if (color == null) {
                return;
            }
            this.cellForeground = new Color[count];
        }
        if ((oldColor = this.cellForeground[index]) == color) {
            return;
        }
        this.cellForeground[index] = color;
        if (oldColor != null && oldColor.equals(color)) {
            return;
        }
        this.cached = true;
        this.redraw(0);
    }

    public void setGrayed(boolean grayed) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.grayed == grayed) {
            return;
        }
        this.grayed = grayed;
        this.cached = true;
        this.redraw(1024);
    }

    public void setImage(Image[] images) {
        this.checkWidget();
        if (images == null) {
            this.error(4);
        }
        int i = 0;
        while (i < images.length) {
            this.setImage(i, images[i]);
            ++i;
        }
    }

    public void setImage(int index, Image image) {
        int itemIndex;
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((itemIndex = this.parent.indexOf(this)) == -1) {
            return;
        }
        if (this.parent.imageBounds == null && image != null) {
            this.parent.setItemHeight(image);
        }
        if (index == 0) {
            if (image != null && image.type == 1 && image.equals(this.image)) {
                return;
            }
            this.width = -1;
            super.setImage(image);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index >= 0 && index < count) {
            if (this.images == null) {
                this.images = new Image[count];
            }
            if (image != null && image.type == 1 && image.equals(this.images[index])) {
                return;
            }
            this.images[index] = image;
        }
        this.cached = true;
        if (index == 0) {
            this.parent.setScrollWidth(this);
        }
        this.redraw(0);
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public void setImageIndent(int indent) {
        this.checkWidget();
        if (indent < 0) {
            return;
        }
        this.cached = true;
    }

    public void setText(String[] strings) {
        this.checkWidget();
        if (strings == null) {
            this.error(4);
        }
        int i = 0;
        while (i < strings.length) {
            String string = strings[i];
            if (string != null) {
                this.setText(i, string);
            }
            ++i;
        }
    }

    public void setText(int index, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (index == 0) {
            if (string.equals(this.text)) {
                return;
            }
            this.width = -1;
            super.setText(string);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index >= 0 && index < count) {
            if (this.strings == null) {
                this.strings = new String[count];
            }
            if (string.equals(this.strings[index])) {
                return;
            }
            this.strings[index] = string;
        }
        this.cached = true;
        if (index == 0) {
            this.parent.setScrollWidth(this);
        }
        this.redraw(0);
    }

    public void setText(String string) {
        this.checkWidget();
        this.setText(0, string);
    }
}

