/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.TypedListener;

public class Shell
extends Decorations {
    int shellHandle;
    int windowGroup;
    boolean resized;
    boolean moved;
    boolean drawing;
    boolean reshape;
    boolean update;
    boolean deferDispose;
    boolean active;
    boolean disposed;
    boolean opened;
    boolean fullScreen;
    boolean center;
    boolean showWithParent;
    boolean ignoreBounds;
    int invalRgn;
    Control lastActive;
    Rect rgnRect;
    Rectangle normalBounds;
    int imHandle;
    ToolTip[] toolTips;
    static int DEFAULT_CLIENT_WIDTH = -1;
    static int DEFAULT_CLIENT_HEIGHT = -1;

    public Shell() {
        this((Display)null);
    }

    public Shell(int style) {
        this((Display)null, style);
    }

    public Shell(Display display) {
        this(display, 1264);
    }

    public Shell(Display display, int style) {
        this(display, null, style, 0, false);
    }

    Shell(Display display, Shell parent, int style, int handle, boolean embedded) {
        this.checkSubclass();
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        if (parent != null && parent.isDisposed()) {
            this.error(5);
        }
        this.center = parent != null && (style & 0x10000000) != 0;
        this.style = Shell.checkStyle(parent, style);
        this.parent = parent;
        this.display = display;
        if (handle != 0) {
            if (embedded) {
                this.handle = handle;
            } else {
                this.shellHandle = handle;
                this.state |= 0x20000;
            }
        }
        this.createWidget();
    }

    public Shell(Shell parent) {
        this(parent, 2144);
    }

    public Shell(Shell parent, int style) {
        this(parent != null ? parent.display : null, parent, style, 0, false);
    }

    public static Shell internal_new(Display display, int handle) {
        return new Shell(display, null, 8, handle, false);
    }

    static int checkStyle(Shell parent, int style) {
        style = Decorations.checkStyle(style);
        int mask = 229376;
        if (((style &= 0xBFFFFFFF) & 0x10000000) != 0) {
            style &= 0xEFFFFFFF;
            if (((style |= parent == null ? 1264 : 2144) & mask) == 0) {
                style |= parent == null ? 65536 : 32768;
            }
        }
        int bits = style & ~mask;
        if ((style & 0x20000) != 0) {
            return bits | 0x20000;
        }
        if ((style & 0x10000) != 0) {
            return bits | 0x10000;
        }
        if ((style & 0x8000) != 0) {
            return bits | 0x8000;
        }
        return bits;
    }

    public void addShellListener(ShellListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(26, typedListener);
        this.addListener(21, typedListener);
        this.addListener(27, typedListener);
        this.addListener(19, typedListener);
        this.addListener(20, typedListener);
    }

    void addToolTip(ToolTip toolTip) {
        if (this.toolTips == null) {
            this.toolTips = new ToolTip[4];
        }
        int i = 0;
        while (i < this.toolTips.length) {
            if (this.toolTips[i] == null) {
                this.toolTips[i] = toolTip;
                return;
            }
            ++i;
        }
        ToolTip[] newToolTips = new ToolTip[this.toolTips.length + 4];
        newToolTips[this.toolTips.length] = toolTip;
        System.arraycopy(this.toolTips, 0, newToolTips, 0, this.toolTips.length);
        this.toolTips = newToolTips;
    }

    void bringToTop(boolean force) {
        if (this.getMinimized()) {
            return;
        }
        if (force) {
            this.forceActive();
        } else {
            this.setActive();
        }
    }

    void center() {
        if (this.parent == null) {
            return;
        }
        Rectangle rect = this.getBounds();
        Rectangle parentRect = this.display.map((Control)this.parent, null, this.parent.getClientArea());
        int x = Math.max(parentRect.x, parentRect.x + (parentRect.width - rect.width) / 2);
        int y = Math.max(parentRect.y, parentRect.y + (parentRect.height - rect.height) / 2);
        Rectangle monitorRect = this.parent.getMonitor().getClientArea();
        x = x + rect.width > monitorRect.x + monitorRect.width ? Math.max(monitorRect.x, monitorRect.x + monitorRect.width - rect.width) : Math.max(x, monitorRect.x);
        y = y + rect.height > monitorRect.y + monitorRect.height ? Math.max(monitorRect.y, monitorRect.y + monitorRect.height - rect.height) : Math.max(y, monitorRect.y);
        this.setLocation(x, y);
    }

    void checkOpen() {
        if (!this.opened) {
            this.resized = false;
        }
    }

    public void close() {
        this.checkWidget();
        this.closeWidget();
    }

    void closeWidget() {
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit && !this.isDisposed()) {
            this.dispose();
        }
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        Rectangle trim = super.computeTrim(x, y, width, height);
        Rect rect = new Rect();
        OS.GetWindowStructureWidths(this.shellHandle, rect);
        trim.x -= rect.left;
        trim.y -= rect.top;
        trim.width += rect.left + rect.right;
        trim.height += rect.top + rect.bottom;
        return trim;
    }

    void createHandle() {
        this.state |= 0x32;
        int attributes = 0x2000000;
        attributes |= 0x80000;
        if ((this.style & 8) == 0) {
            if ((this.style & 0x40) != 0) {
                attributes |= 1;
            }
            if ((this.style & 0x80) != 0) {
                attributes |= 8;
            }
            if ((this.style & 0x400) != 0) {
                attributes |= 6;
            }
            if ((this.style & 0x10) != 0) {
                attributes |= 0x10;
                if ((this.style & 0x20) == 0) {
                    attributes |= 0x10000000;
                }
                if (!OS.__BIG_ENDIAN__()) {
                    attributes |= 0x10000000;
                }
            }
        } else if ((this.style & 4) == 0) {
            attributes |= 0x200000;
        }
        int windowClass = 6;
        if ((this.style & 0x60) == 0) {
            windowClass = 11;
        }
        if ((this.style & 0x38000) != 0 && (this.style & 0x4C0) == 0) {
            int n = windowClass = (this.style & 0x20) != 0 ? 4 : 3;
        }
        if (this.shellHandle == 0) {
            Monitor monitor = this.getMonitor();
            Rectangle rect = monitor.getClientArea();
            int width = rect.width * 5 / 8;
            int height = rect.height * 5 / 8;
            Rect bounds = new Rect();
            OS.SetRect(bounds, (short)0, (short)0, (short)width, (short)height);
            int[] outWindow = new int[1];
            OS.CreateNewWindow(windowClass, attributes &= OS.GetAvailableWindowAttributes(windowClass), bounds, outWindow);
            if (outWindow[0] == 0) {
                this.error(2);
            }
            this.shellHandle = outWindow[0];
            OS.RepositionWindow(this.shellHandle, 0, 4);
            int[] theRoot = new int[1];
            OS.HIViewFindByID(OS.HIViewGetRoot(this.shellHandle), OS.kHIViewWindowContentID(), theRoot);
            if (theRoot[0] == 0) {
                OS.GetRootControl(this.shellHandle, theRoot);
            }
            if (theRoot[0] == 0) {
                this.error(2);
            }
            if ((this.style & 0x300) != 0) {
                this.createScrolledHandle(theRoot[0]);
            } else {
                this.createHandle(theRoot[0]);
            }
            OS.SetControlVisibility(this.topHandle(), false, false);
        } else {
            int[] theRoot = new int[1];
            OS.HIViewFindByID(this.shellHandle, OS.kHIViewWindowContentID(), theRoot);
            if (theRoot[0] == 0) {
                OS.GetRootControl(this.shellHandle, theRoot);
            }
            this.handle = OS.HIViewGetFirstSubview(theRoot[0]);
            if (this.handle == 0) {
                this.error(2);
            }
            if (OS.IsWindowVisible(this.shellHandle)) {
                this.state &= 0xFFFFFFEF;
            }
        }
        int[] outGroup = new int[1];
        OS.CreateWindowGroup(16, outGroup);
        if (outGroup[0] == 0) {
            this.error(2);
        }
        this.windowGroup = outGroup[0];
        int parentGroup = (this.style & 0x4000) != 0 ? OS.GetWindowGroupOfClass(5) : (this.parent != null ? this.parent.getShell().windowGroup : OS.GetWindowGroupOfClass(6));
        OS.SetWindowGroup(this.shellHandle, parentGroup);
        OS.SetWindowGroupParent(this.windowGroup, parentGroup);
        OS.SetWindowGroupOwner(this.windowGroup, this.shellHandle);
        CGPoint inMinLimits = new CGPoint();
        CGPoint inMaxLimits = new CGPoint();
        OS.GetWindowResizeLimits(this.shellHandle, inMinLimits, inMaxLimits);
        if (DEFAULT_CLIENT_WIDTH == -1) {
            DEFAULT_CLIENT_WIDTH = (int)inMinLimits.x;
        }
        if (DEFAULT_CLIENT_HEIGHT == -1) {
            DEFAULT_CLIENT_HEIGHT = 0;
        }
        inMinLimits.y = 0.0f;
        int trim = 1248;
        if ((this.style & 8) != 0 || (this.style & trim) == 0) {
            inMinLimits.x = 0.0f;
        }
        OS.SetWindowResizeLimits(this.shellHandle, inMinLimits, inMaxLimits);
        int[] docID = new int[1];
        OS.NewTSMDocument((short)1, new int[]{1969516387}, docID, 0L);
        if (docID[0] == 0) {
            this.error(2);
        }
        this.imHandle = docID[0];
    }

    void createWidget() {
        super.createWidget();
        this.resizeBounds();
    }

    void deregister() {
        super.deregister();
        int[] theRoot = new int[1];
        OS.GetRootControl(this.shellHandle, theRoot);
        this.display.removeWidget(theRoot[0]);
    }

    void destroyWidget() {
        int theWindow = this.shellHandle;
        Display display = this.display;
        Composite parent = this.parent;
        while (!this.deferDispose && parent != null) {
            Shell shell = parent.getShell();
            this.deferDispose = shell.deferDispose;
            parent = shell.parent;
        }
        if (this.deferDispose) {
            OS.HideWindow(this.shellHandle);
        }
        this.releaseHandle();
        if (theWindow != 0) {
            if (this.deferDispose) {
                display.addDisposeWindow(theWindow);
            } else {
                OS.DisposeWindow(theWindow);
            }
        }
    }

    void drawWidget(int control, int context, int damageRgn, int visibleRgn, int theEvent) {
        super.drawWidget(control, context, damageRgn, visibleRgn, theEvent);
        if (this.region == null || this.region.isDisposed()) {
            return;
        }
        boolean origin = this.region.contains(0, 0);
        boolean limit = this.region.contains(this.rgnRect.right - 1, this.rgnRect.bottom - 1);
        if (origin && limit) {
            return;
        }
        CGRect cgRect = new CGRect();
        cgRect.width = 1.0f;
        cgRect.height = 1.0f;
        if (!origin) {
            OS.CGContextClearRect(context, cgRect);
        }
        if (!limit) {
            cgRect.x = this.rgnRect.right - 1;
            cgRect.y = this.rgnRect.bottom - 1;
            OS.CGContextClearRect(context, cgRect);
        }
        OS.CGContextSynchronize(context);
    }

    Control findBackgroundControl() {
        return this.background != null || this.backgroundImage != null ? this : null;
    }

    Composite findDeferredControl() {
        return this.layoutCount > 0 ? this : null;
    }

    Cursor findCursor() {
        return this.cursor;
    }

    void fixShell(Shell newShell, Control control) {
        if (this == newShell) {
            return;
        }
        if (control == this.lastActive) {
            this.setActiveControl(null);
        }
    }

    public void forceActive() {
        this.checkWidget();
        if (!this.isVisible()) {
            return;
        }
        OS.SelectWindow(this.shellHandle);
        OS.SetUserFocusWindow(this.shellHandle);
        int[] nArray = new int[2];
        nArray[1] = 2;
        OS.SetFrontProcessWithOptions(nArray, 1);
    }

    public int getAlpha() {
        this.checkWidget();
        float[] alpha = new float[1];
        if (OS.GetWindowAlpha(this.shellHandle, alpha) == 0) {
            return (int)(alpha[0] * 255.0f);
        }
        return 255;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        Rect rect = new Rect();
        OS.GetWindowBounds(this.shellHandle, (short)32, rect);
        return new Rectangle(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
    }

    public boolean getFullScreen() {
        this.checkWidget();
        return this.fullScreen;
    }

    public int getImeInputMode() {
        this.checkWidget();
        return 0;
    }

    public org.eclipse.swt.graphics.Point getLocation() {
        this.checkWidget();
        Rect rect = new Rect();
        OS.GetWindowBounds(this.shellHandle, (short)32, rect);
        return new org.eclipse.swt.graphics.Point(rect.left, rect.top);
    }

    public boolean getMaximized() {
        this.checkWidget();
        return !this.fullScreen && super.getMaximized();
    }

    public boolean getMinimized() {
        this.checkWidget();
        if (!this.getVisible()) {
            return super.getMinimized();
        }
        return OS.IsWindowCollapsed(this.shellHandle);
    }

    public org.eclipse.swt.graphics.Point getMinimumSize() {
        this.checkWidget();
        Rect rect = new Rect();
        OS.GetWindowStructureWidths(this.shellHandle, rect);
        CGPoint inMinLimits = new CGPoint();
        CGPoint inMaxLimits = new CGPoint();
        OS.GetWindowResizeLimits(this.shellHandle, inMinLimits, inMaxLimits);
        int width = Math.max(1, (int)inMinLimits.x + (rect.left + rect.right));
        int height = Math.max(1, (int)inMinLimits.y + (rect.top + rect.bottom));
        return new org.eclipse.swt.graphics.Point(width, height);
    }

    Shell getModalShell() {
        Shell shell = null;
        Shell[] modalShells = this.display.modalShells;
        if (modalShells != null) {
            int bits = 196608;
            int index = modalShells.length;
            while (--index >= 0) {
                Shell modal = modalShells[index];
                if (modal == null) continue;
                if ((modal.style & bits) != 0) {
                    Composite control = this;
                    while (control != null) {
                        if (control == modal) break;
                        control = control.parent;
                    }
                    if (control == modal) break;
                    return modal;
                }
                if ((modal.style & 0x8000) == 0) continue;
                if (shell == null) {
                    shell = this.getShell();
                }
                if (modal.parent != shell) continue;
                return modal;
            }
        }
        return null;
    }

    public boolean getModified() {
        this.checkWidget();
        return OS.IsWindowModified(this.shellHandle);
    }

    float[] getParentBackground() {
        return null;
    }

    public Region getRegion() {
        this.checkWidget();
        return this.region;
    }

    public Shell getShell() {
        this.checkWidget();
        return this;
    }

    public Shell[] getShells() {
        this.checkWidget();
        int count = 0;
        Shell[] shells = this.display.getShells();
        int i = 0;
        while (i < shells.length) {
            Composite shell = shells[i];
            while ((shell = shell.parent) != null && shell != this) {
            }
            if (shell == this) {
                ++count;
            }
            ++i;
        }
        int index = 0;
        Shell[] result = new Shell[count];
        int i2 = 0;
        while (i2 < shells.length) {
            Composite shell = shells[i2];
            while ((shell = shell.parent) != null && shell != this) {
            }
            if (shell == this) {
                result[index++] = shells[i2];
            }
            ++i2;
        }
        return result;
    }

    public org.eclipse.swt.graphics.Point getSize() {
        this.checkWidget();
        Rect rect = new Rect();
        OS.GetWindowBounds(this.shellHandle, (short)32, rect);
        return new org.eclipse.swt.graphics.Point(rect.right - rect.left, rect.bottom - rect.top);
    }

    float getThemeAlpha() {
        return 1.0f;
    }

    boolean hasBorder() {
        return false;
    }

    void hookEvents() {
        super.hookEvents();
        int mouseProc = this.display.mouseProc;
        int windowProc = this.display.windowProc;
        int[] mask1 = new int[]{2003398244, 5, 2003398244, 27, 2003398244, 72, 2003398244, 86, 2003398244, 67, 2003398244, 6, 2003398244, 2, 2003398244, 70, 2003398244, 1002, 2003398244, 25, 2003398244, 1003, 2003398244, 24, 2003398244, 1, 2003398244, 8};
        int windowTarget = OS.GetWindowEventTarget(this.shellHandle);
        OS.InstallEventHandler(windowTarget, windowProc, mask1.length / 2, mask1, this.shellHandle, null);
        int[] mask2 = new int[]{1836021107, 1, 1836021107, 6, 1836021107, 5, 1836021107, 2, 1836021107, 10};
        OS.InstallEventHandler(windowTarget, mouseProc, mask2.length / 2, mask2, this.shellHandle, null);
    }

    void invalidateVisibleRegion(int control) {
        this.resetVisibleRegion(control);
        this.invalidateChildrenVisibleRegion(control);
    }

    void invalWindowRgn(int window, int rgn) {
        this.display.needsPaint = true;
        if (this.invalRgn == 0) {
            this.invalRgn = OS.NewRgn();
        }
        OS.UnionRgn(rgn, this.invalRgn, this.invalRgn);
    }

    boolean isDrawing() {
        return this.getDrawing();
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled();
    }

    boolean isEnabledCursor() {
        return true;
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    int kEventWindowActivated(int nextHandler, int theEvent, int userData) {
        int result = super.kEventWindowActivated(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        int[] outScope = new int[1];
        OS.GetWindowActivationScope(this.shellHandle, outScope);
        if (outScope[0] == 0) {
            return result;
        }
        if (!this.active) {
            this.active = true;
            this.deferDispose = true;
            Display display = this.display;
            display.activeShell = this;
            display.setMenuBar(this.menuBar);
            if (this.menuBar != null) {
                OS.DrawMenuBar();
            }
            this.sendEvent(26);
            if (this.isDisposed()) {
                return result;
            }
            if (!this.restoreFocus() && !this.traverseGroup(true)) {
                this.setFocus();
            }
            if (this.isDisposed()) {
                return result;
            }
            display.activeShell = null;
            Shell parentShell = this;
            while (parentShell.parent != null) {
                parentShell = (Shell)parentShell.parent;
                if (parentShell.fullScreen) break;
            }
            if (!parentShell.fullScreen || this.menuBar != null) {
                this.updateSystemUIMode();
            } else {
                parentShell.updateSystemUIMode();
            }
            this.deferDispose = false;
        }
        return result;
    }

    int kEventWindowBoundsChanged(int nextHandler, int theEvent, int userData) {
        int result = super.kEventWindowBoundsChanged(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        int[] attributes = new int[1];
        OS.GetEventParameter(theEvent, 1635021938, 1835100014, null, attributes.length * 4, null, attributes);
        if ((attributes[0] & 8) != 0 && !this.ignoreBounds) {
            this.moved = true;
            this.sendEvent(10);
            if (this.isDisposed()) {
                return 0;
            }
        }
        if ((attributes[0] & 4) != 0) {
            this.resizeBounds();
            if (!this.ignoreBounds) {
                this.resized = true;
                this.sendEvent(11);
                if (this.isDisposed()) {
                    return 0;
                }
                if (this.layout != null) {
                    this.markLayout(false, false);
                    this.updateLayout(false);
                }
            }
            if (this.region != null && !this.region.isDisposed()) {
                OS.GetEventParameter(theEvent, 1668440948, 1902408308, null, 8, null, this.rgnRect);
                OS.SetRect(this.rgnRect, (short)0, (short)0, (short)(this.rgnRect.right - this.rgnRect.left), (short)(this.rgnRect.bottom - this.rgnRect.top));
                OS.ReshapeCustomWindow(this.shellHandle);
            }
        }
        return result;
    }

    int kEventWindowClose(int nextHandler, int theEvent, int userData) {
        int result = super.kEventWindowClose(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        if (this.isEnabled()) {
            this.closeWidget();
        }
        return 0;
    }

    int kEventWindowCollapsed(int nextHandler, int theEvent, int userData) {
        int result = super.kEventWindowCollapsed(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        this.minimized = true;
        this.sendEvent(19);
        return result;
    }

    int kEventWindowCollapsing(int nextHandler, int theEvent, int userData) {
        int result = super.kEventWindowCollapsing(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        this.updateMinimized(true);
        return result;
    }

    int kEventWindowDeactivated(int nextHandler, int theEvent, int userData) {
        int result = super.kEventWindowDeactivated(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        if (this.active) {
            this.active = false;
            this.deferDispose = true;
            Display display = this.display;
            display.activeShell = this;
            this.sendEvent(27);
            if (this.isDisposed()) {
                return result;
            }
            this.setActiveControl(null);
            if (this.isDisposed()) {
                return result;
            }
            display.activeShell = null;
            this.saveFocus();
            if (this.savedFocus != null) {
                display.ignoreFocus = true;
                OS.ClearKeyboardFocus(this.shellHandle);
                display.ignoreFocus = false;
                if (!this.savedFocus.isDisposed()) {
                    this.savedFocus.sendFocusEvent(16, false);
                }
            }
            display.setMenuBar(null);
            this.deferDispose = false;
        }
        return result;
    }

    int kEventWindowDrawContent(int nextHandler, int theEvent, int userData) {
        this.drawing = true;
        int result = OS.CallNextEventHandler(nextHandler, theEvent);
        this.drawing = false;
        if (this.reshape) {
            this.reshape = false;
            OS.ReshapeCustomWindow(this.shellHandle);
        }
        return result;
    }

    int kEventWindowExpanded(int nextHandler, int theEvent, int userData) {
        int result = super.kEventWindowExpanded(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        this.minimized = false;
        this.updateMinimized(false);
        this.sendEvent(20);
        return result;
    }

    int kEventWindowGetClickModality(int nextHandler, int theEvent, int userData) {
        Shell modalShell;
        int result = OS.CallNextEventHandler(nextHandler, theEvent);
        int[] modal = new int[1];
        OS.GetEventParameter(theEvent, 1836542318, 2003398244, null, 4, null, modal);
        if (modal[0] != 0) {
            OS.SelectWindow(modal[0]);
        }
        if ((modalShell = this.getModalShell()) != null) {
            int[] modality = new int[1];
            OS.GetWindowModality(modalShell.shellHandle, modality, null);
            if ((this.style & 0x4000) != 0 || modality[0] == 3) {
                int clickResult = 5;
                OS.SetEventParameter(theEvent, 2003660644, 2003660644, 4, modality);
                OS.SetEventParameter(theEvent, 2003657586, 2003657586, 4, new int[]{clickResult});
                OS.SetEventParameter(theEvent, 1836542318, 2003398244, 4, new int[]{modalShell.shellHandle});
            }
        }
        return result;
    }

    int kEventWindowGetRegion(int nextHandler, int theEvent, int userData) {
        int result = super.kEventWindowGetRegion(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        if (this.region == null || this.region.isDisposed()) {
            return -9874;
        }
        short[] regionCode = new short[1];
        OS.GetEventParameter(theEvent, 2004052080, 2004052080, null, 2, null, regionCode);
        int[] temp = new int[1];
        OS.GetEventParameter(theEvent, 1919381096, 1919381096, null, 4, null, temp);
        int hRegion = temp[0];
        switch (regionCode[0]) {
            case 32: 
            case 33: {
                int rectRgn;
                Rect r;
                OS.RectRgn(hRegion, this.rgnRect);
                OS.SectRgn(hRegion, this.region.handle, hRegion);
                if (!this.region.contains(0, 0)) {
                    r = new Rect();
                    OS.SetRect(r, (short)0, (short)0, (short)1, (short)1);
                    rectRgn = OS.NewRgn();
                    OS.RectRgn(rectRgn, r);
                    OS.UnionRgn(rectRgn, hRegion, hRegion);
                    OS.DisposeRgn(rectRgn);
                }
                if (!this.region.contains(this.rgnRect.right - 1, this.rgnRect.bottom - 1)) {
                    r = new Rect();
                    OS.SetRect(r, (short)(this.rgnRect.right - 1), (short)(this.rgnRect.bottom - 1), this.rgnRect.right, this.rgnRect.bottom);
                    rectRgn = OS.NewRgn();
                    OS.RectRgn(rectRgn, r);
                    OS.UnionRgn(rectRgn, hRegion, hRegion);
                    OS.DisposeRgn(rectRgn);
                }
                return 0;
            }
        }
        OS.DiffRgn(hRegion, hRegion, hRegion);
        return 0;
    }

    int kEventWindowHidden(int nextHandler, int theEvent, int userData) {
        int result = super.kEventWindowHidden(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (!shell.isDisposed()) {
                shell.setWindowVisible(false);
            }
            ++i;
        }
        return -9874;
    }

    int kEventWindowHitTest(int nextHandler, int theEvent, int userData) {
        int result = super.kEventWindowHitTest(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        if (this.region == null || this.region.isDisposed()) {
            return -9874;
        }
        Point pt = new Point();
        int sizeof = 4;
        OS.GetEventParameter(theEvent, 1835822947, 1363439732, null, sizeof, null, pt);
        Rect rect = new Rect();
        OS.GetWindowBounds(this.shellHandle, (short)33, rect);
        OS.SetPt(pt, (short)(pt.h - rect.left), (short)(pt.v - rect.top));
        int rgn = OS.NewRgn();
        OS.RectRgn(rgn, this.rgnRect);
        OS.SectRgn(rgn, this.region.handle, rgn);
        short inData = OS.PtInRgn(pt, rgn) ? (short)1 : 0;
        OS.DisposeRgn(rgn);
        OS.SetEventParameter(theEvent, 2003071075, 2003071092, 2, new short[]{inData});
        return 0;
    }

    int kEventWindowShown(int nextHandler, int theEvent, int userData) {
        int result = super.kEventWindowShown(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        this.invalidateVisibleRegion(this.topHandle());
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (!shell.isDisposed() && shell.getVisible()) {
                shell.setWindowVisible(true);
            }
            ++i;
        }
        return -9874;
    }

    int kEventWindowUpdate(int nextHandler, int theEvent, int userData) {
        this.update = true;
        int result = OS.CallNextEventHandler(nextHandler, theEvent);
        this.update = false;
        if (this.invalRgn != 0) {
            OS.InvalWindowRgn(this.shellHandle, this.invalRgn);
            OS.DisposeRgn(this.invalRgn);
            this.invalRgn = 0;
        }
        return result;
    }

    void resizeBounds() {
        Rect rect = new Rect();
        OS.GetWindowBounds(this.shellHandle, (short)33, rect);
        int control = this.scrolledHandle != 0 ? this.scrolledHandle : this.handle;
        this.setBounds(control, 0, 0, rect.right - rect.left, rect.bottom - rect.top, false, true, false);
        this.resizeClientArea();
    }

    public void open() {
        this.checkWidget();
        this.bringToTop(false);
        this.setVisible(true);
        if (this.isDisposed()) {
            return;
        }
        if (this.active && !this.restoreFocus() && !this.traverseGroup(true)) {
            this.setFocus();
        }
    }

    public boolean print(GC gc) {
        this.checkWidget();
        if (gc == null) {
            this.error(4);
        }
        if (gc.isDisposed()) {
            this.error(5);
        }
        return false;
    }

    void register() {
        super.register();
        int[] theRoot = new int[1];
        OS.GetRootControl(this.shellHandle, theRoot);
        this.display.addWidget(theRoot[0], this);
    }

    void releaseChildren(boolean destroy) {
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (shell != null && !shell.isDisposed()) {
                shell.dispose();
            }
            ++i;
        }
        if (this.toolTips != null) {
            i = 0;
            while (i < this.toolTips.length) {
                ToolTip toolTip = this.toolTips[i];
                if (toolTip != null && !toolTip.isDisposed()) {
                    toolTip.dispose();
                }
                ++i;
            }
            this.toolTips = null;
        }
        super.releaseChildren(destroy);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.shellHandle = 0;
    }

    void releaseParent() {
    }

    void releaseWidget() {
        super.releaseWidget();
        this.display.clearModal(this);
        this.disposed = true;
        if (this.windowGroup != 0) {
            OS.ReleaseWindowGroup(this.windowGroup);
        }
        this.display.updateQuitMenu();
        if (this.invalRgn != 0) {
            OS.DisposeRgn(this.invalRgn);
        }
        if (this.imHandle != 0) {
            OS.DeleteTSMDocument(this.imHandle);
        }
        this.windowGroup = 0;
        this.invalRgn = 0;
        this.imHandle = 0;
        this.lastActive = null;
    }

    public void removeShellListener(ShellListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(26, listener);
        this.eventTable.unhook(21, listener);
        this.eventTable.unhook(27, listener);
        this.eventTable.unhook(19, listener);
        this.eventTable.unhook(20, listener);
    }

    void removeTooTip(ToolTip toolTip) {
        if (this.toolTips == null) {
            return;
        }
        int i = 0;
        while (i < this.toolTips.length) {
            if (this.toolTips[i] == toolTip) {
                this.toolTips[i] = null;
                return;
            }
            ++i;
        }
    }

    public void setActive() {
        this.checkWidget();
        if (!this.isVisible()) {
            return;
        }
        OS.SelectWindow(this.shellHandle);
        OS.SetUserFocusWindow(this.shellHandle);
    }

    void setActiveControl(Control control) {
        if (control != null && control.isDisposed()) {
            control = null;
        }
        if (this.lastActive != null && this.lastActive.isDisposed()) {
            this.lastActive = null;
        }
        if (this.lastActive == control) {
            return;
        }
        Control[] activate = control == null ? new Control[]{} : control.getPath();
        Control[] deactivate = this.lastActive == null ? new Control[]{} : this.lastActive.getPath();
        this.lastActive = control;
        int index = 0;
        int length = Math.min(activate.length, deactivate.length);
        while (index < length) {
            if (activate[index] != deactivate[index]) break;
            ++index;
        }
        int i = deactivate.length - 1;
        while (i >= index) {
            if (!deactivate[i].isDisposed()) {
                deactivate[i].sendEvent(27);
            }
            --i;
        }
        i = activate.length - 1;
        while (i >= index) {
            if (!activate[i].isDisposed()) {
                activate[i].sendEvent(26);
            }
            --i;
        }
    }

    public void setAlpha(int alpha) {
        this.checkWidget();
        OS.SetWindowAlpha(this.shellHandle, (float)(alpha &= 0xFF) / 255.0f);
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize, boolean events) {
        if (this.fullScreen) {
            this.setFullScreen(false);
        }
        Rect rect = new Rect();
        if (!move) {
            OS.GetWindowBounds(this.shellHandle, (short)32, rect);
            x = rect.left;
            y = rect.top;
        }
        if (!resize) {
            OS.GetWindowBounds(this.shellHandle, (short)32, rect);
            width = rect.right - rect.left;
            height = rect.bottom - rect.top;
        } else {
            OS.GetWindowStructureWidths(this.shellHandle, rect);
            CGPoint inMinLimits = new CGPoint();
            CGPoint inMaxLimits = new CGPoint();
            OS.GetWindowResizeLimits(this.shellHandle, inMinLimits, inMaxLimits);
            width = Math.max(1, Math.max(width, (int)inMinLimits.x + (rect.left + rect.right)));
            height = Math.max(1, Math.max(height, (int)inMinLimits.y + (rect.top + rect.bottom)));
        }
        if (this.rgnRect != null) {
            OS.SetRect(this.rgnRect, (short)0, (short)0, (short)width, (short)height);
        }
        OS.SetRect(rect, (short)x, (short)y, (short)(x + width), (short)(y + height));
        OS.SetWindowBounds(this.shellHandle, 32, rect);
        return 0;
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if ((this.state & 8) == 0 == enabled) {
            return;
        }
        super.setEnabled(enabled);
        if (enabled && OS.IsWindowActive(this.shellHandle) && !this.restoreFocus()) {
            this.traverseGroup(false);
        }
    }

    public void setFullScreen(boolean fullScreen) {
        this.checkWidget();
        this.fullScreen = fullScreen;
        if (fullScreen) {
            Rect rect;
            this.normalBounds = this.getBounds();
            OS.ChangeWindowAttributes(this.shellHandle, 512, 0x10000010);
            this.updateSystemUIMode();
            Rectangle screen = this.getMonitor().getBounds();
            if (this.menuBar != null && this.getMonitor().equals(this.display.getPrimaryMonitor())) {
                rect = new Rect();
                int gdevice = OS.GetMainDevice();
                OS.GetAvailableWindowPositioningBounds(gdevice, rect);
                screen.height -= rect.top;
                screen.y += rect.top;
            }
            rect = new Rect();
            OS.SetRect(rect, (short)screen.x, (short)screen.y, (short)(screen.x + screen.width), (short)(screen.y + screen.height));
            OS.SetWindowBounds(this.shellHandle, 32, rect);
        } else {
            int attributes = 0;
            if ((this.style & 0x10) != 0) {
                attributes |= 0x10;
                if ((this.style & 0x20) == 0) {
                    attributes |= 0x10000000;
                }
                if (!OS.__BIG_ENDIAN__()) {
                    attributes |= 0x10000000;
                }
            }
            OS.ChangeWindowAttributes(this.shellHandle, attributes, 512);
            OS.SetSystemUIMode(0, 0);
            if (this.maximized) {
                this.setMaximized(true);
            } else {
                Rect rect = new Rect();
                if (this.normalBounds != null) {
                    OS.SetRect(rect, (short)this.normalBounds.x, (short)this.normalBounds.y, (short)(this.normalBounds.x + this.normalBounds.width), (short)(this.normalBounds.y + this.normalBounds.height));
                }
                OS.SetWindowBounds(this.shellHandle, 32, rect);
            }
            this.normalBounds = null;
        }
    }

    public void setMenuBar(Menu menu) {
        this.checkWidget();
        super.setMenuBar(menu);
        if (this.display.getActiveShell() == this) {
            this.display.setMenuBar(this.menuBar);
        }
    }

    public void setImeInputMode(int mode) {
        this.checkWidget();
    }

    public void setMaximized(boolean maximized) {
        this.checkWidget();
        super.setMaximized(maximized);
        Point pt = new Point();
        if (maximized) {
            Rect rect = new Rect();
            int gdevice = OS.GetMainDevice();
            OS.GetAvailableWindowPositioningBounds(gdevice, rect);
            pt.h = (short)(rect.right - rect.left);
            pt.v = (short)(rect.bottom - rect.top);
        }
        short inPartCode = (short)(maximized ? 8 : 7);
        if (!this.opened) {
            this.ignoreBounds = true;
        }
        OS.ZoomWindowIdeal(this.shellHandle, inPartCode, pt);
        if (!this.opened) {
            this.ignoreBounds = false;
        }
    }

    public void setMinimized(boolean minimized) {
        this.checkWidget();
        if (this.minimized == minimized) {
            return;
        }
        super.setMinimized(minimized);
        if (!minimized && OS.IsWindowCollapsed(this.shellHandle)) {
            OS.SelectWindow(this.shellHandle);
        }
        OS.CollapseWindow(this.shellHandle, minimized);
    }

    public void setMinimumSize(int width, int height) {
        this.checkWidget();
        int clientWidth = 0;
        int clientHeight = 0;
        int trim = 1248;
        if ((this.style & 8) == 0 && (this.style & trim) != 0) {
            clientWidth = DEFAULT_CLIENT_WIDTH;
            clientHeight = DEFAULT_CLIENT_HEIGHT;
        }
        Rect rect = new Rect();
        OS.GetWindowStructureWidths(this.shellHandle, rect);
        CGPoint inMinLimits = new CGPoint();
        CGPoint inMaxLimits = new CGPoint();
        OS.GetWindowResizeLimits(this.shellHandle, inMinLimits, inMaxLimits);
        width = Math.max(width, clientWidth + rect.left + rect.right);
        height = Math.max(height, clientHeight + rect.top + rect.bottom);
        inMinLimits.x = width - (rect.left + rect.right);
        inMinLimits.y = height - (rect.top + rect.bottom);
        OS.SetWindowResizeLimits(this.shellHandle, inMinLimits, inMaxLimits);
        org.eclipse.swt.graphics.Point size = this.getSize();
        int newWidth = Math.max(size.x, width);
        int newHeight = Math.max(size.y, height);
        if (newWidth != size.x || newHeight != size.y) {
            this.setSize(newWidth, newHeight);
        }
    }

    public void setMinimumSize(org.eclipse.swt.graphics.Point size) {
        this.checkWidget();
        if (size == null) {
            this.error(4);
        }
        this.setMinimumSize(size.x, size.y);
    }

    public void setModified(boolean modified) {
        this.checkWidget();
        OS.SetWindowModified(this.shellHandle, modified);
    }

    public void setRegion(Region region) {
        this.checkWidget();
        if ((this.style & 8) == 0) {
            return;
        }
        if (region != null && region.isDisposed()) {
            this.error(5);
        }
        if (region == null) {
            this.rgnRect = null;
        } else if (this.rgnRect == null) {
            this.rgnRect = new Rect();
            OS.GetWindowBounds(this.shellHandle, (short)32, this.rgnRect);
            OS.SetRect(this.rgnRect, (short)0, (short)0, (short)(this.rgnRect.right - this.rgnRect.left), (short)(this.rgnRect.bottom - this.rgnRect.top));
        }
        this.region = region;
        if (this.drawing) {
            this.reshape = true;
        } else {
            OS.ReshapeCustomWindow(this.shellHandle);
            this.redrawWidget(this.handle, true);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        super.setText(string);
        char[] buffer = new char[string.length()];
        string.getChars(0, buffer.length, buffer, 0);
        int ptr = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
        if (ptr == 0) {
            this.error(13);
        }
        OS.SetWindowTitleWithCFString(this.shellHandle, ptr);
        OS.CFRelease(ptr);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        int mask = 229376;
        if ((this.style & mask) != 0) {
            if (visible) {
                this.display.setModalShell(this);
            } else {
                this.display.clearModal(this);
            }
        } else {
            this.updateModal();
        }
        if (visible) {
            if ((this.state & 0x10) == 0) {
                return;
            }
            this.state &= 0xFFFFFFEF;
        } else {
            if ((this.state & 0x10) != 0) {
                return;
            }
            this.state |= 0x10;
        }
        this.showWithParent = visible;
        this.setWindowVisible(visible);
    }

    void setWindowVisible(boolean visible) {
        if (OS.IsWindowVisible(this.shellHandle) == visible) {
            return;
        }
        if (visible) {
            if (this.center && !this.moved) {
                if (this.isDisposed()) {
                    return;
                }
                this.center();
            }
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
            int inModalKind = 0;
            if ((this.style & 0x8000) != 0) {
                inModalKind = 3;
            }
            if ((this.style & 0x10000) != 0) {
                inModalKind = 2;
            }
            if ((this.style & 0x20000) != 0) {
                inModalKind = 1;
            }
            if (inModalKind != 0) {
                int inUnavailableWindow = 0;
                if (this.parent != null) {
                    inUnavailableWindow = OS.GetControlOwner(this.parent.handle);
                }
                OS.SetWindowModality(this.shellHandle, inModalKind, inUnavailableWindow);
                if (inUnavailableWindow != 0) {
                    OS.CollapseWindow(inUnavailableWindow, false);
                }
            }
            int topHandle = this.topHandle();
            OS.SetControlVisibility(topHandle, true, false);
            int[] scope = new int[1];
            if ((this.style & 0x4000) != 0) {
                OS.GetWindowActivationScope(this.shellHandle, scope);
                OS.SetWindowActivationScope(this.shellHandle, 0);
            }
            int shellHandle = this.shellHandle;
            OS.RetainWindow(shellHandle);
            OS.ShowWindow(shellHandle);
            OS.ReleaseWindow(shellHandle);
            if (this.isDisposed()) {
                return;
            }
            if (this.minimized != OS.IsWindowCollapsed(shellHandle)) {
                OS.CollapseWindow(shellHandle, this.minimized);
            }
            if ((this.style & 0x4000) != 0) {
                OS.SetWindowActivationScope(shellHandle, scope[0]);
                OS.BringToFront(shellHandle);
            } else if (this.display.getActiveShell() != this) {
                Shell[] shells = this.display.getShells();
                int i = 0;
                while (i < shells.length) {
                    Shell shell = shells[i];
                    if ((shell.style & 0x4000) != 0 && shell.isVisible()) {
                        this.bringToTop(false);
                        break;
                    }
                    ++i;
                }
            }
            this.opened = true;
            if (!this.moved) {
                this.moved = true;
                this.sendEvent(10);
                if (this.isDisposed()) {
                    return;
                }
            }
            if (!this.resized) {
                this.resized = true;
                this.sendEvent(11);
                if (this.isDisposed()) {
                    return;
                }
                if (this.layout != null) {
                    this.markLayout(false, false);
                    this.updateLayout(false);
                }
            }
        } else {
            if (!this.disposed) {
                OS.HideWindow(this.shellHandle);
            }
            if (this.isDisposed()) {
                return;
            }
            int topHandle = this.topHandle();
            OS.SetControlVisibility(topHandle, false, false);
            this.invalidateVisibleRegion(topHandle);
            this.sendEvent(23);
        }
        this.display.updateQuitMenu();
    }

    void setZOrder() {
        if (this.scrolledHandle != 0) {
            OS.HIViewAddSubview(this.scrolledHandle, this.handle);
        }
    }

    void setZOrder(Control control, boolean above) {
        if (above) {
            OS.BringToFront(this.shellHandle);
        } else {
            int window = control == null ? 0 : OS.GetControlOwner(control.handle);
            OS.SendBehind(this.shellHandle, window);
        }
    }

    boolean traverseEscape() {
        if (this.parent == null) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        this.close();
        return true;
    }

    void updateMinimized(boolean minimized) {
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (this == shell.parent && (shell.style & 0x4000) != 0) {
                if (minimized) {
                    if (shells[i].isVisible()) {
                        shells[i].showWithParent = true;
                        OS.HideWindow(shell.shellHandle);
                    }
                } else if (shells[i].showWithParent) {
                    shells[i].showWithParent = false;
                    OS.ShowWindow(shell.shellHandle);
                }
            }
            ++i;
        }
    }

    void updateModal() {
    }

    void updateSystemUIMode() {
        if (!this.getMonitor().equals(this.display.getPrimaryMonitor())) {
            return;
        }
        boolean isActive = false;
        Shell activeShell = this.display.getActiveShell();
        Shell current = this;
        while (current != null) {
            if (current.equals(activeShell)) {
                isActive = true;
                break;
            }
            current = (Shell)current.parent;
        }
        if (!isActive) {
            return;
        }
        if (this.fullScreen) {
            int mode = 3;
            if (this.menuBar != null) {
                mode = 2;
            }
            OS.SetSystemUIMode(mode, 0);
        } else {
            OS.SetSystemUIMode(0, 0);
        }
    }
}

