/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.cairo.cairo_font_extents_t;
import org.eclipse.swt.internal.cairo.cairo_text_extents_t;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.Visual;
import org.eclipse.swt.internal.motif.XCharStruct;
import org.eclipse.swt.internal.motif.XColor;
import org.eclipse.swt.internal.motif.XFontStruct;
import org.eclipse.swt.internal.motif.XGCValues;
import org.eclipse.swt.internal.motif.XImage;
import org.eclipse.swt.internal.motif.XRectangle;
import org.eclipse.swt.internal.motif.XRenderPictureAttributes;

public final class GC
extends Resource {
    public int handle;
    Drawable drawable;
    GCData data;
    static final int FOREGROUND = 1;
    static final int BACKGROUND = 2;
    static final int FONT = 4;
    static final int LINE_STYLE = 8;
    static final int LINE_CAP = 16;
    static final int LINE_JOIN = 32;
    static final int LINE_WIDTH = 64;
    static final int LINE_MITERLIMIT = 128;
    static final int BACKGROUND_BG = 256;
    static final int FOREGROUND_RGB = 512;
    static final int BACKGROUND_RGB = 1024;
    static final int DRAW_OFFSET = 2048;
    static final int DRAW = 2297;
    static final int FILL = 2;
    static final float[] LINE_DOT = new float[]{1.0f, 1.0f};
    static final float[] LINE_DASH = new float[]{3.0f, 1.0f};
    static final float[] LINE_DASHDOT = new float[]{3.0f, 1.0f, 1.0f, 1.0f};
    static final float[] LINE_DASHDOTDOT = new float[]{3.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    static final float[] LINE_DOT_ZERO = new float[]{3.0f, 3.0f};
    static final float[] LINE_DASH_ZERO = new float[]{18.0f, 6.0f};
    static final float[] LINE_DASHDOT_ZERO = new float[]{9.0f, 6.0f, 3.0f, 6.0f};
    static final float[] LINE_DASHDOTDOT_ZERO = new float[]{9.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f};

    GC() {
    }

    public GC(Drawable drawable) {
        this(drawable, 0);
    }

    public GC(Drawable drawable, int style) {
        if (drawable == null) {
            SWT.error(4);
        }
        GCData data = new GCData();
        data.style = GC.checkStyle(style);
        int xGC = drawable.internal_new_GC(data);
        Device device = data.device;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = data.device = device;
        this.init(drawable, data, xGC);
        this.init();
    }

    static void addCairoString(int cairo, String string, float x, float y, Font font) {
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        GC.setCairoFont(cairo, font);
        cairo_font_extents_t extents = new cairo_font_extents_t();
        Cairo.cairo_font_extents(cairo, extents);
        double baseline = (double)y + extents.ascent;
        Cairo.cairo_move_to(cairo, x, baseline);
        Cairo.cairo_text_path(cairo, buffer);
    }

    static int checkStyle(int style) {
        if ((style & 0x2000000) != 0) {
            style &= 0xFBFFFFFF;
        }
        return style & 0x6000000;
    }

    void checkGC(int mask) {
        int state = this.data.state;
        if ((state & mask) == mask) {
            return;
        }
        state = (state ^ mask) & mask;
        this.data.state |= mask;
        int cairo = this.data.cairo;
        if (cairo != 0) {
            if ((state & 3) != 0) {
                Pattern pattern;
                XColor color;
                if ((state & 1) != 0) {
                    color = this.data.foreground;
                    if ((this.data.state & 0x200) == 0) {
                        OS.XQueryColor(this.data.display, this.data.colormap, color);
                        this.data.state |= 0x200;
                    }
                    pattern = this.data.foregroundPattern;
                    this.data.state &= 0xFFFFFFFD;
                } else {
                    color = this.data.background;
                    if ((this.data.state & 0x400) == 0) {
                        OS.XQueryColor(this.data.display, this.data.colormap, color);
                        this.data.state |= 0x400;
                    }
                    pattern = this.data.backgroundPattern;
                    this.data.state &= 0xFFFFFFFE;
                }
                if (pattern != null) {
                    Cairo.cairo_set_source(cairo, pattern.handle);
                } else {
                    Cairo.cairo_set_source_rgba(cairo, (float)(color.red & 0xFFFF) / 65535.0f, (float)(color.green & 0xFFFF) / 65535.0f, (float)(color.blue & 0xFFFF) / 65535.0f, (float)this.data.alpha / 255.0f);
                }
            }
            if ((state & 4) != 0) {
                GC.setCairoFont(cairo, this.data.font);
            }
            if ((state & 0x10) != 0) {
                int cap_style = 0;
                switch (this.data.lineCap) {
                    case 2: {
                        cap_style = 1;
                        break;
                    }
                    case 1: {
                        cap_style = 0;
                        break;
                    }
                    case 3: {
                        cap_style = 2;
                    }
                }
                Cairo.cairo_set_line_cap(cairo, cap_style);
            }
            if ((state & 0x20) != 0) {
                int join_style = 0;
                switch (this.data.lineJoin) {
                    case 1: {
                        join_style = 0;
                        break;
                    }
                    case 2: {
                        join_style = 1;
                        break;
                    }
                    case 3: {
                        join_style = 2;
                    }
                }
                Cairo.cairo_set_line_join(cairo, join_style);
            }
            if ((state & 0x40) != 0) {
                Cairo.cairo_set_line_width(cairo, this.data.lineWidth == 0.0f ? 1.0f : this.data.lineWidth);
                switch (this.data.lineStyle) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        state |= 8;
                    }
                }
            }
            if ((state & 8) != 0) {
                float dashesOffset = 0.0f;
                float[] dashes = null;
                float width = this.data.lineWidth;
                switch (this.data.lineStyle) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        dashes = width != 0.0f ? LINE_DASH : LINE_DASH_ZERO;
                        break;
                    }
                    case 3: {
                        dashes = width != 0.0f ? LINE_DOT : LINE_DOT_ZERO;
                        break;
                    }
                    case 4: {
                        dashes = width != 0.0f ? LINE_DASHDOT : LINE_DASHDOT_ZERO;
                        break;
                    }
                    case 5: {
                        dashes = width != 0.0f ? LINE_DASHDOTDOT : LINE_DASHDOTDOT_ZERO;
                        break;
                    }
                    case 6: {
                        dashes = this.data.lineDashes;
                    }
                }
                if (dashes != null) {
                    dashesOffset = this.data.lineDashesOffset;
                    double[] cairoDashes = new double[dashes.length];
                    int i = 0;
                    while (i < cairoDashes.length) {
                        cairoDashes[i] = width == 0.0f || this.data.lineStyle == 6 ? dashes[i] : dashes[i] * width;
                        ++i;
                    }
                    Cairo.cairo_set_dash(cairo, cairoDashes, cairoDashes.length, dashesOffset);
                } else {
                    Cairo.cairo_set_dash(cairo, null, 0, 0.0);
                }
            }
            if ((state & 0x80) != 0) {
                Cairo.cairo_set_miter_limit(cairo, this.data.lineMiterLimit);
            }
            if ((state & 0x800) != 0) {
                double strokeWidth;
                this.data.cairoYoffset = 0.0;
                this.data.cairoXoffset = 0.0;
                double[] matrix = new double[6];
                Cairo.cairo_get_matrix(cairo, matrix);
                double[] dx = new double[]{1.0};
                double[] dy = new double[]{1.0};
                Cairo.cairo_user_to_device_distance(cairo, dx, dy);
                double scaling = dx[0];
                if (scaling < 0.0) {
                    scaling = -scaling;
                }
                if ((strokeWidth = (double)this.data.lineWidth * scaling) == 0.0 || (int)strokeWidth % 2 == 1) {
                    this.data.cairoXoffset = 0.5 / scaling;
                }
                if ((scaling = dy[0]) < 0.0) {
                    scaling = -scaling;
                }
                if ((strokeWidth = (double)this.data.lineWidth * scaling) == 0.0 || (int)strokeWidth % 2 == 1) {
                    this.data.cairoYoffset = 0.5 / scaling;
                }
            }
            return;
        }
        int xDisplay = this.data.display;
        if ((state & 3) != 0) {
            XColor foreground;
            if ((state & 1) != 0) {
                foreground = this.data.foreground;
                this.data.state &= 0xFFFFFFFD;
            } else {
                foreground = this.data.background;
                this.data.state &= 0xFFFFFFFE;
            }
            OS.XSetForeground(xDisplay, this.handle, foreground.pixel);
        }
        if ((state & 0x100) != 0) {
            XColor background = this.data.background;
            OS.XSetBackground(xDisplay, this.handle, background.pixel);
        }
        if ((state & 0x78) != 0) {
            int cap_style = 0;
            int join_style = 0;
            int width = (int)this.data.lineWidth;
            int line_style = 0;
            float[] dashes = null;
            switch (this.data.lineCap) {
                case 2: {
                    cap_style = 2;
                    break;
                }
                case 1: {
                    cap_style = 1;
                    break;
                }
                case 3: {
                    cap_style = 3;
                }
            }
            switch (this.data.lineJoin) {
                case 2: {
                    join_style = 1;
                    break;
                }
                case 1: {
                    join_style = 0;
                    break;
                }
                case 3: {
                    join_style = 2;
                }
            }
            switch (this.data.lineStyle) {
                case 1: {
                    break;
                }
                case 2: {
                    dashes = width != 0 ? LINE_DASH : LINE_DASH_ZERO;
                    break;
                }
                case 3: {
                    dashes = width != 0 ? LINE_DOT : LINE_DOT_ZERO;
                    break;
                }
                case 4: {
                    dashes = width != 0 ? LINE_DASHDOT : LINE_DASHDOT_ZERO;
                    break;
                }
                case 5: {
                    dashes = width != 0 ? LINE_DASHDOTDOT : LINE_DASHDOTDOT_ZERO;
                    break;
                }
                case 6: {
                    dashes = this.data.lineDashes;
                }
            }
            if (dashes != null) {
                if ((state & 8) != 0) {
                    byte[] dash_list = new byte[dashes.length];
                    int i = 0;
                    while (i < dash_list.length) {
                        dash_list[i] = (byte)(width == 0 || this.data.lineStyle == 6 ? dashes[i] : dashes[i] * (float)width);
                        ++i;
                    }
                    OS.XSetDashes(xDisplay, this.handle, 0, dash_list, dash_list.length);
                }
                line_style = 1;
            } else {
                line_style = 0;
            }
            OS.XSetLineAttributes(xDisplay, this.handle, width, line_style, cap_style, join_style);
        }
    }

    int convertRgn(int rgn, double[] matrix) {
        int newRgn = OS.XCreateRegion();
        XRectangle rect = new XRectangle();
        OS.XClipBox(rgn, rect);
        short[] pointArray = new short[8];
        double[] x = new double[1];
        double[] y = new double[1];
        x[0] = rect.x;
        y[0] = rect.y;
        Cairo.cairo_matrix_transform_point(matrix, x, y);
        pointArray[0] = (short)x[0];
        pointArray[1] = (short)y[0];
        x[0] = rect.x + rect.width;
        y[0] = rect.y;
        Cairo.cairo_matrix_transform_point(matrix, x, y);
        pointArray[2] = (short)Math.round(x[0]);
        pointArray[3] = (short)y[0];
        x[0] = rect.x + rect.width;
        y[0] = rect.y + rect.height;
        Cairo.cairo_matrix_transform_point(matrix, x, y);
        pointArray[4] = (short)Math.round(x[0]);
        pointArray[5] = (short)Math.round(y[0]);
        x[0] = rect.x;
        y[0] = rect.y + rect.height;
        Cairo.cairo_matrix_transform_point(matrix, x, y);
        pointArray[6] = (short)x[0];
        pointArray[7] = (short)Math.round(y[0]);
        int polyRgn = OS.XPolygonRegion(pointArray, pointArray.length / 2, 0);
        OS.XUnionRegion(newRgn, polyRgn, newRgn);
        OS.XDestroyRegion(polyRgn);
        return newRgn;
    }

    public void copyArea(int x, int y, int width, int height, int destX, int destY) {
        this.copyArea(x, y, width, height, destX, destY, true);
    }

    public void copyArea(int x, int y, int width, int height, int destX, int destY, boolean paint) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        int deltaX = destX - x;
        int deltaY = destY - y;
        if (deltaX == 0 && deltaY == 0) {
            return;
        }
        int xDisplay = this.data.display;
        int xDrawable = this.data.drawable;
        if (this.data.backgroundImage != null && paint) {
            OS.XClearArea(xDisplay, xDrawable, x, y, width, height, true);
            OS.XClearArea(xDisplay, xDrawable, destX, destY, width, height, true);
            return;
        }
        if (this.data.image == null && paint) {
            OS.XSetGraphicsExposures(xDisplay, this.handle, true);
        }
        OS.XCopyArea(xDisplay, xDrawable, xDrawable, this.handle, x, y, width, height, destX, destY);
        if (this.data.image == null && paint) {
            boolean disjoint;
            OS.XSetGraphicsExposures(xDisplay, this.handle, false);
            boolean bl = disjoint = destX + width < x || x + width < destX || destY + height < y || y + height < destY;
            if (disjoint) {
                OS.XClearArea(xDisplay, xDrawable, x, y, width, height, true);
            } else {
                if (deltaX != 0) {
                    int newX = destX - deltaX;
                    if (deltaX < 0) {
                        newX = destX + width;
                    }
                    OS.XClearArea(xDisplay, xDrawable, newX, y, Math.abs(deltaX), height, true);
                }
                if (deltaY != 0) {
                    int newY = destY - deltaY;
                    if (deltaY < 0) {
                        newY = destY + height;
                    }
                    OS.XClearArea(xDisplay, xDrawable, x, newY, width, Math.abs(deltaY), true);
                }
            }
        }
    }

    public void copyArea(Image image, int x, int y) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.type != 0 || image.isDisposed()) {
            SWT.error(5);
        }
        Rectangle rect = image.getBounds();
        int xDisplay = this.data.display;
        int xGC = OS.XCreateGC(xDisplay, image.pixmap, 0, null);
        if (xGC == 0) {
            SWT.error(2);
        }
        OS.XSetSubwindowMode(xDisplay, xGC, 1);
        OS.XCopyArea(xDisplay, this.data.drawable, image.pixmap, xGC, x, y, rect.width, rect.height, 0, 0);
        OS.XFreeGC(xDisplay, xGC);
    }

    void destroy() {
        int xmMnemonic;
        int xmText;
        int xmString;
        int renderTable;
        Image image;
        int cairo = this.data.cairo;
        if (cairo != 0) {
            Cairo.cairo_destroy(cairo);
        }
        this.data.cairo = 0;
        int clipRgn = this.data.clipRgn;
        if (clipRgn != 0) {
            OS.XDestroyRegion(clipRgn);
        }
        if ((image = this.data.image) != null) {
            image.memGC = null;
            if (image.transparentPixel != -1) {
                image.createMask();
            }
        }
        if ((renderTable = this.data.renderTable) != 0) {
            OS.XmRenderTableFree(renderTable);
        }
        if ((xmString = this.data.xmString) != 0) {
            OS.XmStringFree(xmString);
        }
        if ((xmText = this.data.xmText) != 0) {
            OS.XmStringFree(xmText);
        }
        if ((xmMnemonic = this.data.xmMnemonic) != 0) {
            OS.XmStringFree(xmMnemonic);
        }
        if (this.drawable != null) {
            this.drawable.internal_dispose_GC(this.handle, this.data);
        }
        this.data.xmMnemonic = 0;
        this.data.xmText = 0;
        this.data.xmString = 0;
        this.data.renderTable = 0;
        this.data.clipRgn = 0;
        this.data.colormap = 0;
        this.data.drawable = 0;
        this.data.display = 0;
        this.data.font = null;
        this.drawable = null;
        this.handle = 0;
        this.data.image = null;
        this.data = null;
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(2297);
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (width == 0 || height == 0 || arcAngle == 0) {
            return;
        }
        int cairo = this.data.cairo;
        if (cairo != 0) {
            double xOffset = this.data.cairoXoffset;
            double yOffset = this.data.cairoYoffset;
            if (width == height) {
                if (arcAngle >= 0) {
                    Cairo.cairo_arc_negative(cairo, (double)x + xOffset + (double)((float)width / 2.0f), (double)y + yOffset + (double)((float)height / 2.0f), (float)width / 2.0f, (float)(-startAngle) * (float)Compatibility.PI / 180.0f, (float)(-(startAngle + arcAngle)) * (float)Compatibility.PI / 180.0f);
                } else {
                    Cairo.cairo_arc(cairo, (double)x + xOffset + (double)((float)width / 2.0f), (double)y + yOffset + (double)((float)height / 2.0f), (float)width / 2.0f, (float)(-startAngle) * (float)Compatibility.PI / 180.0f, (float)(-(startAngle + arcAngle)) * (float)Compatibility.PI / 180.0f);
                }
            } else {
                Cairo.cairo_save(cairo);
                Cairo.cairo_translate(cairo, (double)x + xOffset + (double)((float)width / 2.0f), (double)y + yOffset + (double)((float)height / 2.0f));
                Cairo.cairo_scale(cairo, (float)width / 2.0f, (float)height / 2.0f);
                if (arcAngle >= 0) {
                    Cairo.cairo_arc_negative(cairo, 0.0, 0.0, 1.0, (float)(-startAngle) * (float)Compatibility.PI / 180.0f, (float)(-(startAngle + arcAngle)) * (float)Compatibility.PI / 180.0f);
                } else {
                    Cairo.cairo_arc(cairo, 0.0, 0.0, 1.0, (float)(-startAngle) * (float)Compatibility.PI / 180.0f, (float)(-(startAngle + arcAngle)) * (float)Compatibility.PI / 180.0f);
                }
                Cairo.cairo_restore(cairo);
            }
            Cairo.cairo_stroke(cairo);
            return;
        }
        OS.XDrawArc(this.data.display, this.data.drawable, this.handle, x, y, width, height, startAngle * 64, arcAngle * 64);
    }

    public void drawFocus(int x, int y, int width, int height) {
        int cairo;
        if (this.handle == 0) {
            SWT.error(44);
        }
        int xDisplay = this.data.display;
        int xDrawable = this.data.drawable;
        int highlightColor = 0;
        int widget = OS.XtWindowToWidget(xDisplay, xDrawable);
        if (widget != 0) {
            int[] nArray = new int[2];
            nArray[0] = OS.XmNhighlightColor;
            int[] argList = nArray;
            OS.XtGetValues(widget, argList, argList.length / 2);
            highlightColor = argList[1];
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if ((cairo = this.data.cairo) != 0) {
            boolean lineWidth = true;
            Cairo.cairo_save(cairo);
            Cairo.cairo_set_line_width(cairo, (double)lineWidth);
            XColor color = new XColor();
            color.pixel = highlightColor;
            OS.XQueryColor(this.data.display, this.data.colormap, color);
            Cairo.cairo_set_source_rgba(cairo, (float)(color.red & 0xFFFF) / 65535.0f, (float)(color.green & 0xFFFF) / 65535.0f, (float)(color.blue & 0xFFFF) / 65535.0f, 1.0);
            Cairo.cairo_rectangle(cairo, (float)x + (float)lineWidth / 2.0f, (float)y + (float)lineWidth / 2.0f, width, height);
            Cairo.cairo_stroke(cairo);
            Cairo.cairo_restore(cairo);
            return;
        }
        OS.XSetForeground(xDisplay, this.handle, highlightColor);
        OS.XDrawRectangle(xDisplay, xDrawable, this.handle, x, y, width - 1, height - 1);
        this.data.state &= 0xFFFFFFFC;
    }

    public void drawImage(Image image, int x, int y) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, 0, 0, -1, -1, x, y, -1, -1, true);
    }

    public void drawImage(Image image, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (srcWidth == 0 || srcHeight == 0 || destWidth == 0 || destHeight == 0) {
            return;
        }
        if (srcX < 0 || srcY < 0 || srcWidth < 0 || srcHeight < 0 || destWidth < 0 || destHeight < 0) {
            SWT.error(5);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, false);
    }

    void drawImage(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple) {
        int[] width = new int[1];
        int[] height = new int[1];
        int[] depth = new int[1];
        int[] unused = new int[1];
        OS.XGetGeometry(this.data.display, srcImage.pixmap, unused, unused, unused, width, height, unused, depth);
        int imgWidth = width[0];
        int imgHeight = height[0];
        if (simple) {
            srcWidth = destWidth = imgWidth;
            srcHeight = destHeight = imgHeight;
        } else {
            boolean bl = simple = srcX == 0 && srcY == 0 && srcWidth == destWidth && destWidth == imgWidth && srcHeight == destHeight && destHeight == imgHeight;
            if (srcX + srcWidth > imgWidth || srcY + srcHeight > imgHeight) {
                SWT.error(5);
            }
        }
        int cairo = this.data.cairo;
        if (cairo != 0) {
            if (this.data.alpha != 0) {
                srcImage.createSurface();
                Cairo.cairo_save(cairo);
                Cairo.cairo_rectangle(cairo, destX, destY, destWidth, destHeight);
                Cairo.cairo_clip(cairo);
                Cairo.cairo_translate(cairo, destX - srcX, destY - srcY);
                if (srcWidth != destWidth || srcHeight != destHeight) {
                    Cairo.cairo_scale(cairo, (float)destWidth / (float)srcWidth, (float)destHeight / (float)srcHeight);
                }
                int filter = 1;
                switch (this.data.interpolation) {
                    case -1: {
                        filter = 1;
                        break;
                    }
                    case 0: {
                        filter = 3;
                        break;
                    }
                    case 1: {
                        filter = 0;
                        break;
                    }
                    case 2: {
                        filter = 2;
                    }
                }
                int pattern = Cairo.cairo_pattern_create_for_surface(srcImage.surface);
                if (pattern == 0) {
                    SWT.error(2);
                }
                if ((srcWidth != destWidth || srcHeight != destHeight) && Cairo.cairo_version() >= Cairo.CAIRO_VERSION_ENCODE(1, 4, 2)) {
                    int surface = Cairo.cairo_image_surface_create(0, imgWidth * 3, imgHeight * 3);
                    int cr = Cairo.cairo_create(surface);
                    Cairo.cairo_set_source_surface(cr, srcImage.surface, imgWidth, imgHeight);
                    Cairo.cairo_paint(cr);
                    Cairo.cairo_scale(cr, -1.0, -1.0);
                    Cairo.cairo_set_source_surface(cr, srcImage.surface, -imgWidth, -imgHeight);
                    Cairo.cairo_paint(cr);
                    Cairo.cairo_set_source_surface(cr, srcImage.surface, -imgWidth * 3, -imgHeight);
                    Cairo.cairo_paint(cr);
                    Cairo.cairo_set_source_surface(cr, srcImage.surface, -imgWidth, -imgHeight * 3);
                    Cairo.cairo_paint(cr);
                    Cairo.cairo_set_source_surface(cr, srcImage.surface, -imgWidth * 3, -imgHeight * 3);
                    Cairo.cairo_paint(cr);
                    Cairo.cairo_scale(cr, 1.0, -1.0);
                    Cairo.cairo_set_source_surface(cr, srcImage.surface, -imgWidth, imgHeight);
                    Cairo.cairo_paint(cr);
                    Cairo.cairo_set_source_surface(cr, srcImage.surface, -imgWidth * 3, imgHeight);
                    Cairo.cairo_paint(cr);
                    Cairo.cairo_scale(cr, -1.0, -1.0);
                    Cairo.cairo_set_source_surface(cr, srcImage.surface, imgWidth, -imgHeight);
                    Cairo.cairo_paint(cr);
                    Cairo.cairo_set_source_surface(cr, srcImage.surface, imgWidth, -imgHeight * 3);
                    Cairo.cairo_paint(cr);
                    Cairo.cairo_destroy(cr);
                    int newPattern = Cairo.cairo_pattern_create_for_surface(surface);
                    Cairo.cairo_surface_destroy(surface);
                    if (newPattern == 0) {
                        SWT.error(2);
                    }
                    Cairo.cairo_pattern_destroy(pattern);
                    pattern = newPattern;
                    Cairo.cairo_pattern_set_extend(pattern, 3);
                    double[] matrix = new double[6];
                    Cairo.cairo_matrix_init_translate(matrix, imgWidth, imgHeight);
                    Cairo.cairo_pattern_set_matrix(pattern, matrix);
                }
                Cairo.cairo_pattern_set_filter(pattern, filter);
                Cairo.cairo_set_source(cairo, pattern);
                if (this.data.alpha != 255) {
                    Cairo.cairo_paint_with_alpha(cairo, (float)this.data.alpha / 255.0f);
                } else {
                    Cairo.cairo_paint(cairo);
                }
                Cairo.cairo_restore(cairo);
                Cairo.cairo_pattern_destroy(pattern);
            }
            return;
        }
        if (srcImage.alpha != -1 || srcImage.alphaData != null) {
            this.drawImageAlpha(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, imgWidth, imgHeight, depth[0]);
        } else if (srcImage.transparentPixel != -1 || srcImage.mask != 0) {
            this.drawImageMask(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, imgWidth, imgHeight, depth[0]);
        } else {
            this.drawImage(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, imgWidth, imgHeight, depth[0]);
        }
    }

    void drawImageAlpha(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, int imgWidth, int imgHeight, int depth) {
        if (srcImage.alpha == 0) {
            return;
        }
        if (srcImage.alpha == 255) {
            this.drawImage(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, imgWidth, imgHeight, depth);
            return;
        }
        if (this.device.useXRender) {
            this.drawImageXRender(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, imgWidth, imgHeight, srcImage.mask, 2);
            return;
        }
        Rectangle rect = this.getClipping();
        if ((rect = rect.intersection(new Rectangle(destX, destY, destWidth, destHeight))).isEmpty()) {
            return;
        }
        int sx1 = srcX + (rect.x - destX) * srcWidth / destWidth;
        int sx2 = srcX + (rect.x + rect.width - destX) * srcWidth / destWidth;
        int sy1 = srcY + (rect.y - destY) * srcHeight / destHeight;
        int sy2 = srcY + (rect.y + rect.height - destY) * srcHeight / destHeight;
        destX = rect.x;
        destY = rect.y;
        destWidth = rect.width;
        destHeight = rect.height;
        srcX = sx1;
        srcY = sy1;
        srcWidth = Math.max(1, sx2 - sx1);
        srcHeight = Math.max(1, sy2 - sy1);
        int xDisplay = this.data.display;
        int xDrawable = this.data.drawable;
        int xDestImagePtr = 0;
        int xSrcImagePtr = 0;
        try {
            xDestImagePtr = OS.XGetImage(xDisplay, xDrawable, destX, destY, destWidth, destHeight, -1, 2);
            if (xDestImagePtr == 0) {
                return;
            }
            XImage xDestImage = new XImage();
            OS.memmove(xDestImage, xDestImagePtr, 88);
            byte[] destData = new byte[xDestImage.bytes_per_line * xDestImage.height];
            OS.memmove(destData, xDestImage.data, destData.length);
            xSrcImagePtr = OS.XGetImage(xDisplay, srcImage.pixmap, srcX, srcY, srcWidth, srcHeight, -1, 2);
            if (xSrcImagePtr == 0) {
                return;
            }
            XImage xSrcImage = new XImage();
            OS.memmove(xSrcImage, xSrcImagePtr, 88);
            byte[] srcData = new byte[xSrcImage.bytes_per_line * xSrcImage.height];
            OS.memmove(srcData, xSrcImage.data, srcData.length);
            if (xSrcImage.depth <= 8) {
                XColor[] xcolors = this.data.device.xcolors;
                if (xcolors == null) {
                    SWT.error(38);
                }
                byte[] reds = new byte[xcolors.length];
                byte[] greens = new byte[xcolors.length];
                byte[] blues = new byte[xcolors.length];
                int i = 0;
                while (i < xcolors.length) {
                    XColor color = xcolors[i];
                    if (color != null) {
                        reds[i] = (byte)(color.red >> 8 & 0xFF);
                        greens[i] = (byte)(color.green >> 8 & 0xFF);
                        blues[i] = (byte)(color.blue >> 8 & 0xFF);
                    }
                    ++i;
                }
                ImageData.blit(2, srcData, xSrcImage.bits_per_pixel, xSrcImage.bytes_per_line, xSrcImage.byte_order, 0, 0, srcWidth, srcHeight, reds, greens, blues, srcImage.alpha, srcImage.alphaData, imgWidth, srcX, srcY, destData, xDestImage.bits_per_pixel, xDestImage.bytes_per_line, xDestImage.byte_order, 0, 0, destWidth, destHeight, reds, greens, blues, false, false);
            } else {
                int srcRedMask = xSrcImage.red_mask;
                int srcGreenMask = xSrcImage.green_mask;
                int srcBlueMask = xSrcImage.blue_mask;
                int destRedMask = xDestImage.red_mask;
                int destGreenMask = xDestImage.green_mask;
                int destBlueMask = xDestImage.blue_mask;
                int visual = OS.XDefaultVisual(xDisplay, OS.XDefaultScreen(xDisplay));
                Visual xVisual = new Visual();
                OS.memmove(xVisual, visual, 32);
                if (srcRedMask == 0 && srcGreenMask == 0 && srcBlueMask == 0) {
                    srcRedMask = xVisual.red_mask;
                    srcGreenMask = xVisual.green_mask;
                    srcBlueMask = xVisual.blue_mask;
                }
                if (destRedMask == 0 && destGreenMask == 0 && destBlueMask == 0) {
                    destRedMask = xVisual.red_mask;
                    destGreenMask = xVisual.green_mask;
                    destBlueMask = xVisual.blue_mask;
                }
                ImageData.blit(2, srcData, xSrcImage.bits_per_pixel, xSrcImage.bytes_per_line, xSrcImage.byte_order, 0, 0, srcWidth, srcHeight, srcRedMask, srcGreenMask, srcBlueMask, srcImage.alpha, srcImage.alphaData, imgWidth, srcX, srcY, destData, xDestImage.bits_per_pixel, xDestImage.bytes_per_line, xDestImage.byte_order, 0, 0, destWidth, destHeight, destRedMask, destGreenMask, destBlueMask, false, false);
            }
            OS.memmove(xDestImage.data, destData, destData.length);
            OS.XPutImage(xDisplay, xDrawable, this.handle, xDestImagePtr, 0, 0, destX, destY, destWidth, destHeight);
        }
        finally {
            if (xSrcImagePtr != 0) {
                OS.XDestroyImage(xSrcImagePtr);
            }
            if (xDestImagePtr != 0) {
                OS.XDestroyImage(xDestImagePtr);
            }
        }
    }

    void drawImageMask(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, int imgWidth, int imgHeight, int depth) {
        int xDisplay = this.data.display;
        int xDrawable = this.data.drawable;
        if (srcImage.transparentPixel != -1) {
            srcImage.createMask();
        }
        if (this.device.useXRender) {
            this.drawImageXRender(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, imgWidth, imgHeight, srcImage.mask, 4);
        } else {
            int colorPixmap = 0;
            int maskPixmap = 0;
            int foreground = 0;
            if (simple || srcWidth == destWidth && srcHeight == destHeight) {
                colorPixmap = srcImage.pixmap;
                maskPixmap = srcImage.mask;
            } else {
                int xImagePtr = GC.scalePixmap(xDisplay, srcImage.pixmap, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, false, false);
                if (xImagePtr != 0) {
                    int xMaskPtr = GC.scalePixmap(xDisplay, srcImage.mask, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, false, false);
                    if (xMaskPtr != 0) {
                        colorPixmap = OS.XCreatePixmap(xDisplay, xDrawable, destWidth, destHeight, depth);
                        int tempGC = OS.XCreateGC(xDisplay, colorPixmap, 0, null);
                        OS.XPutImage(xDisplay, colorPixmap, tempGC, xImagePtr, 0, 0, 0, 0, destWidth, destHeight);
                        OS.XFreeGC(xDisplay, tempGC);
                        maskPixmap = OS.XCreatePixmap(xDisplay, xDrawable, destWidth, destHeight, 1);
                        tempGC = OS.XCreateGC(xDisplay, maskPixmap, 0, null);
                        OS.XPutImage(xDisplay, maskPixmap, tempGC, xMaskPtr, 0, 0, 0, 0, destWidth, destHeight);
                        OS.XFreeGC(xDisplay, tempGC);
                        OS.XDestroyImage(xMaskPtr);
                    }
                    OS.XDestroyImage(xImagePtr);
                }
                srcY = 0;
                srcX = 0;
                srcWidth = destWidth;
                srcHeight = destHeight;
                foreground ^= 0xFFFFFFFF;
            }
            if (colorPixmap != 0 && maskPixmap != 0) {
                XGCValues values = new XGCValues();
                OS.XGetGCValues(xDisplay, this.handle, 13, values);
                OS.XSetFunction(xDisplay, this.handle, 6);
                OS.XCopyArea(xDisplay, colorPixmap, xDrawable, this.handle, srcX, srcY, srcWidth, srcHeight, destX, destY);
                OS.XSetForeground(xDisplay, this.handle, foreground);
                OS.XSetBackground(xDisplay, this.handle, ~foreground);
                OS.XSetFunction(xDisplay, this.handle, 1);
                OS.XCopyPlane(xDisplay, maskPixmap, xDrawable, this.handle, srcX, srcY, srcWidth, srcHeight, destX, destY, 1);
                OS.XSetFunction(xDisplay, this.handle, 6);
                OS.XCopyArea(xDisplay, colorPixmap, xDrawable, this.handle, srcX, srcY, srcWidth, srcHeight, destX, destY);
                OS.XSetForeground(xDisplay, this.handle, values.foreground);
                OS.XSetBackground(xDisplay, this.handle, values.background);
                OS.XSetFunction(xDisplay, this.handle, values.function);
            }
            if (colorPixmap != 0 && srcImage.pixmap != colorPixmap) {
                OS.XFreePixmap(xDisplay, colorPixmap);
            }
            if (maskPixmap != 0 && srcImage.mask != maskPixmap) {
                OS.XFreePixmap(xDisplay, maskPixmap);
            }
        }
        if (srcImage.transparentPixel != -1 && srcImage.memGC != null) {
            srcImage.destroyMask();
        }
    }

    void drawImageXRender(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, int imgWidth, int imgHeight, int maskPixmap, int maskType) {
        int srcPict;
        int format;
        int destPict;
        int drawable = this.data.drawable;
        int xDisplay = this.data.display;
        int maskPict = 0;
        if (maskPixmap != 0) {
            int attribCount = 0;
            XRenderPictureAttributes attrib = null;
            if (srcImage.alpha != -1) {
                attribCount = 1;
                attrib = new XRenderPictureAttributes();
                attrib.repeat = true;
            }
            if ((maskPict = OS.XRenderCreatePicture(xDisplay, maskPixmap, OS.XRenderFindStandardFormat(xDisplay, maskType), attribCount, attrib)) == 0) {
                SWT.error(2);
            }
        }
        if ((destPict = OS.XRenderCreatePicture(xDisplay, drawable, format = OS.XRenderFindVisualFormat(xDisplay, OS.XDefaultVisual(xDisplay, OS.XDefaultScreen(xDisplay))), 0, null)) == 0) {
            SWT.error(2);
        }
        if ((srcPict = OS.XRenderCreatePicture(xDisplay, srcImage.pixmap, format, 0, null)) == 0) {
            SWT.error(2);
        }
        if (srcWidth != destWidth || srcHeight != destHeight) {
            int[] nArray = new int[9];
            nArray[0] = (int)((float)srcWidth / (float)destWidth * 65536.0f);
            nArray[4] = (int)((float)srcHeight / (float)destHeight * 65536.0f);
            nArray[8] = 65536;
            int[] transform = nArray;
            OS.XRenderSetPictureTransform(xDisplay, srcPict, transform);
            if (maskPict != 0) {
                OS.XRenderSetPictureTransform(xDisplay, maskPict, transform);
            }
            srcX = (int)((float)srcX * ((float)destWidth / (float)srcWidth));
            srcY = (int)((float)srcY * ((float)destHeight / (float)srcHeight));
        }
        int clipping = this.data.clipRgn;
        if (this.data.damageRgn != 0) {
            if (clipping == 0) {
                clipping = this.data.damageRgn;
            } else {
                clipping = OS.XCreateRegion();
                OS.XUnionRegion(clipping, this.data.clipRgn, clipping);
                OS.XIntersectRegion(clipping, this.data.damageRgn, clipping);
            }
        }
        if (clipping != 0) {
            OS.XRenderSetPictureClipRegion(xDisplay, destPict, clipping);
            if (clipping != this.data.clipRgn && clipping != this.data.damageRgn) {
                OS.XDestroyRegion(clipping);
            }
        }
        OS.XRenderComposite(xDisplay, maskPict != 0 ? 3 : 1, srcPict, maskPict, destPict, srcX, srcY, srcX, srcY, destX, destY, destWidth, destHeight);
        OS.XRenderFreePicture(xDisplay, destPict);
        OS.XRenderFreePicture(xDisplay, srcPict);
        if (maskPict != 0) {
            OS.XRenderFreePicture(xDisplay, maskPict);
        }
    }

    void drawImage(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, int imgWidth, int imgHeight, int depth) {
        int xDisplay = this.data.display;
        int xDrawable = this.data.drawable;
        if (srcWidth == destWidth && srcHeight == destHeight) {
            OS.XCopyArea(xDisplay, srcImage.pixmap, xDrawable, this.handle, srcX, srcY, srcWidth, srcHeight, destX, destY);
            return;
        }
        if (this.device.useXRender) {
            this.drawImageXRender(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, imgWidth, imgHeight, 0, -1);
            return;
        }
        int xImagePtr = GC.scalePixmap(xDisplay, srcImage.pixmap, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, false, false);
        if (xImagePtr != 0) {
            OS.XPutImage(xDisplay, xDrawable, this.handle, xImagePtr, 0, 0, destX, destY, destWidth, destHeight);
            OS.XDestroyImage(xImagePtr);
        }
    }

    static int scalePixmap(int display, int pixmap, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean flipX, boolean flipY) {
        int xSrcImagePtr = OS.XGetImage(display, pixmap, srcX, srcY, srcWidth, srcHeight, -1, 2);
        if (xSrcImagePtr == 0) {
            return 0;
        }
        XImage xSrcImage = new XImage();
        OS.memmove(xSrcImage, xSrcImagePtr, 88);
        byte[] srcData = new byte[xSrcImage.bytes_per_line * xSrcImage.height];
        OS.memmove(srcData, xSrcImage.data, srcData.length);
        OS.XDestroyImage(xSrcImagePtr);
        int xImagePtr = 0;
        int visual = OS.XDefaultVisual(display, OS.XDefaultScreen(display));
        switch (xSrcImage.bits_per_pixel) {
            case 1: 
            case 4: 
            case 8: {
                int bufPtr;
                int format = xSrcImage.bits_per_pixel == 1 ? 0 : 2;
                xImagePtr = OS.XCreateImage(display, visual, xSrcImage.depth, format, 0, 0, destWidth, destHeight, xSrcImage.bitmap_pad, 0);
                if (xImagePtr == 0) {
                    return 0;
                }
                XImage xImage = new XImage();
                OS.memmove(xImage, xImagePtr, 88);
                int bufSize = xImage.bytes_per_line * xImage.height;
                if (bufSize < 0) {
                    OS.XDestroyImage(xImagePtr);
                    return 0;
                }
                xImage.data = bufPtr = OS.XtMalloc(bufSize);
                OS.memmove(xImagePtr, xImage, 88);
                byte[] buf = new byte[bufSize];
                int srcOrder = xSrcImage.bits_per_pixel == 1 ? xSrcImage.bitmap_bit_order : xSrcImage.byte_order;
                int destOrder = xImage.bits_per_pixel == 1 ? xImage.bitmap_bit_order : xImage.byte_order;
                ImageData.blit(1, srcData, xSrcImage.bits_per_pixel, xSrcImage.bytes_per_line, srcOrder, 0, 0, srcWidth, srcHeight, null, null, null, 255, null, 0, 0, 0, buf, xImage.bits_per_pixel, xImage.bytes_per_line, destOrder, 0, 0, destWidth, destHeight, null, null, null, flipX, flipY);
                OS.memmove(bufPtr, buf, bufSize);
                break;
            }
            case 16: 
            case 24: 
            case 32: {
                int bufPtr;
                xImagePtr = OS.XCreateImage(display, visual, xSrcImage.depth, 2, 0, 0, destWidth, destHeight, xSrcImage.bitmap_pad, 0);
                if (xImagePtr == 0) {
                    return 0;
                }
                XImage xImage = new XImage();
                OS.memmove(xImage, xImagePtr, 88);
                int bufSize = xImage.bytes_per_line * xImage.height;
                if (bufSize < 0) {
                    OS.XDestroyImage(xImagePtr);
                    return 0;
                }
                xImage.data = bufPtr = OS.XtMalloc(bufSize);
                OS.memmove(xImagePtr, xImage, 88);
                byte[] buf = new byte[bufSize];
                ImageData.blit(1, srcData, xSrcImage.bits_per_pixel, xSrcImage.bytes_per_line, xSrcImage.byte_order, 0, 0, srcWidth, srcHeight, 0, 0, 0, 255, null, 0, 0, 0, buf, xImage.bits_per_pixel, xImage.bytes_per_line, xImage.byte_order, 0, 0, destWidth, destHeight, 0, 0, 0, flipX, flipY);
                OS.memmove(bufPtr, buf, bufSize);
            }
        }
        return xImagePtr;
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(2297);
        int cairo = this.data.cairo;
        if (cairo != 0) {
            double xOffset = this.data.cairoXoffset;
            double yOffset = this.data.cairoYoffset;
            Cairo.cairo_move_to(cairo, (double)x1 + xOffset, (double)y1 + yOffset);
            Cairo.cairo_line_to(cairo, (double)x2 + xOffset, (double)y2 + yOffset);
            Cairo.cairo_stroke(cairo);
            return;
        }
        OS.XDrawLine(this.data.display, this.data.drawable, this.handle, x1, y1, x2, y2);
    }

    public void drawOval(int x, int y, int width, int height) {
        int cairo;
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(2297);
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if ((cairo = this.data.cairo) != 0) {
            double xOffset = this.data.cairoXoffset;
            double yOffset = this.data.cairoYoffset;
            if (width == height) {
                Cairo.cairo_arc_negative(cairo, (double)x + xOffset + (double)((float)width / 2.0f), (double)y + yOffset + (double)((float)height / 2.0f), (float)width / 2.0f, 0.0, -2.0f * (float)Compatibility.PI);
            } else {
                Cairo.cairo_save(cairo);
                Cairo.cairo_translate(cairo, (double)x + xOffset + (double)((float)width / 2.0f), (double)y + yOffset + (double)((float)height / 2.0f));
                Cairo.cairo_scale(cairo, (float)width / 2.0f, (float)height / 2.0f);
                Cairo.cairo_arc_negative(cairo, 0.0, 0.0, 1.0, 0.0, -2.0f * (float)Compatibility.PI);
                Cairo.cairo_restore(cairo);
            }
            Cairo.cairo_stroke(cairo);
            return;
        }
        OS.XDrawArc(this.data.display, this.data.drawable, this.handle, x, y, width, height, 0, 23040);
    }

    public void drawPath(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.handle == 0) {
            SWT.error(5);
        }
        this.initCairo();
        this.checkGC(2297);
        int cairo = this.data.cairo;
        Cairo.cairo_save(cairo);
        double xOffset = this.data.cairoXoffset;
        double yOffset = this.data.cairoYoffset;
        Cairo.cairo_translate(cairo, xOffset, yOffset);
        int copy = Cairo.cairo_copy_path(path.handle);
        if (copy == 0) {
            SWT.error(2);
        }
        Cairo.cairo_append_path(cairo, copy);
        Cairo.cairo_path_destroy(copy);
        Cairo.cairo_stroke(cairo);
        Cairo.cairo_restore(cairo);
    }

    public void drawPoint(int x, int y) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(2297);
        int cairo = this.data.cairo;
        if (cairo != 0) {
            Cairo.cairo_rectangle(cairo, x, y, 1.0, 1.0);
            Cairo.cairo_fill(cairo);
            return;
        }
        OS.XDrawPoint(this.data.display, this.data.drawable, this.handle, x, y);
    }

    public void drawPolygon(int[] pointArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        this.checkGC(2297);
        int cairo = this.data.cairo;
        if (cairo != 0) {
            this.drawPolyline(cairo, pointArray, true);
            Cairo.cairo_stroke(cairo);
            return;
        }
        int length = pointArray.length;
        if (length < 4) {
            this.drawPolyline(pointArray);
            return;
        }
        if (pointArray[0] == pointArray[length - 2] && pointArray[1] == pointArray[length - 1]) {
            this.drawPolyline(pointArray);
            return;
        }
        int[] newPoints = new int[length + 2];
        int i = 0;
        while (i < length) {
            newPoints[i] = pointArray[i];
            ++i;
        }
        newPoints[length] = pointArray[0];
        newPoints[length + 1] = pointArray[1];
        this.drawPolyline(newPoints);
    }

    public void drawPolyline(int[] pointArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        this.checkGC(2297);
        int cairo = this.data.cairo;
        if (cairo != 0) {
            this.drawPolyline(cairo, pointArray, false);
            Cairo.cairo_stroke(cairo);
            return;
        }
        short[] xPoints = new short[pointArray.length];
        int i = 0;
        while (i < pointArray.length) {
            xPoints[i] = (short)pointArray[i];
            ++i;
        }
        OS.XDrawLines(this.data.display, this.data.drawable, this.handle, xPoints, xPoints.length / 2, 0);
    }

    void drawPolyline(int cairo, int[] pointArray, boolean close) {
        int count = pointArray.length / 2;
        if (count == 0) {
            return;
        }
        double xOffset = this.data.cairoXoffset;
        double yOffset = this.data.cairoYoffset;
        Cairo.cairo_move_to(cairo, (double)pointArray[0] + xOffset, (double)pointArray[1] + yOffset);
        int i = 1;
        int j = 2;
        while (i < count) {
            Cairo.cairo_line_to(cairo, (double)pointArray[j] + xOffset, (double)pointArray[j + 1] + yOffset);
            ++i;
            j += 2;
        }
        if (close) {
            Cairo.cairo_close_path(cairo);
        }
    }

    public void drawRectangle(int x, int y, int width, int height) {
        int cairo;
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(2297);
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if ((cairo = this.data.cairo) != 0) {
            double xOffset = this.data.cairoXoffset;
            double yOffset = this.data.cairoYoffset;
            Cairo.cairo_rectangle(cairo, (double)x + xOffset, (double)y + yOffset, width, height);
            Cairo.cairo_stroke(cairo);
            return;
        }
        OS.XDrawRectangle(this.data.display, this.data.drawable, this.handle, x, y, width, height);
    }

    public void drawRectangle(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        this.drawRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void drawRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        int cairo;
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(2297);
        int nx = x;
        int ny = y;
        int nw = width;
        int nh = height;
        int naw = arcWidth;
        int nah = arcHeight;
        if (nw < 0) {
            nw = 0 - nw;
            nx -= nw;
        }
        if (nh < 0) {
            nh = 0 - nh;
            ny -= nh;
        }
        if (naw < 0) {
            naw = 0 - naw;
        }
        if (nah < 0) {
            nah = 0 - nah;
        }
        if ((cairo = this.data.cairo) != 0) {
            double xOffset = this.data.cairoXoffset;
            double yOffset = this.data.cairoYoffset;
            if (naw == 0 || nah == 0) {
                Cairo.cairo_rectangle(cairo, (double)x + xOffset, (double)y + yOffset, width, height);
            } else {
                float naw2 = (float)naw / 2.0f;
                float nah2 = (float)nah / 2.0f;
                float fw = (float)nw / naw2;
                float fh = (float)nh / nah2;
                Cairo.cairo_save(cairo);
                Cairo.cairo_translate(cairo, (double)nx + xOffset, (double)ny + yOffset);
                Cairo.cairo_scale(cairo, naw2, nah2);
                Cairo.cairo_move_to(cairo, fw - 1.0f, 0.0);
                Cairo.cairo_arc(cairo, fw - 1.0f, 1.0, 1.0, Compatibility.PI + Compatibility.PI / 2.0, Compatibility.PI * 2.0);
                Cairo.cairo_arc(cairo, fw - 1.0f, fh - 1.0f, 1.0, 0.0, Compatibility.PI / 2.0);
                Cairo.cairo_arc(cairo, 1.0, fh - 1.0f, 1.0, Compatibility.PI / 2.0, Compatibility.PI);
                Cairo.cairo_arc(cairo, 1.0, 1.0, 1.0, Compatibility.PI, 270.0 * Compatibility.PI / 180.0);
                Cairo.cairo_close_path(cairo);
                Cairo.cairo_restore(cairo);
            }
            Cairo.cairo_stroke(cairo);
            return;
        }
        int naw2 = naw / 2;
        int nah2 = nah / 2;
        int xDisplay = this.data.display;
        int xDrawable = this.data.drawable;
        if (nw > naw) {
            if (nh > nah) {
                OS.XDrawArc(xDisplay, xDrawable, this.handle, nx, ny, naw, nah, 5760, 5760);
                OS.XDrawLine(xDisplay, xDrawable, this.handle, nx + naw2, ny, nx + nw - naw2, ny);
                OS.XDrawArc(xDisplay, xDrawable, this.handle, nx + nw - naw, ny, naw, nah, 0, 5760);
                OS.XDrawLine(xDisplay, xDrawable, this.handle, nx + nw, ny + nah2, nx + nw, ny + nh - nah2);
                OS.XDrawArc(xDisplay, xDrawable, this.handle, nx + nw - naw, ny + nh - nah, naw, nah, 17280, 5760);
                OS.XDrawLine(xDisplay, xDrawable, this.handle, nx + naw2, ny + nh, nx + nw - naw2, ny + nh);
                OS.XDrawArc(xDisplay, xDrawable, this.handle, nx, ny + nh - nah, naw, nah, 11520, 5760);
                OS.XDrawLine(xDisplay, xDrawable, this.handle, nx, ny + nah2, nx, ny + nh - nah2);
            } else {
                OS.XDrawArc(xDisplay, xDrawable, this.handle, nx, ny, naw, nh, 5760, 11520);
                OS.XDrawLine(xDisplay, xDrawable, this.handle, nx + naw2, ny, nx + nw - naw2, ny);
                OS.XDrawArc(xDisplay, xDrawable, this.handle, nx + nw - naw, ny, naw, nh, 17280, 11520);
                OS.XDrawLine(xDisplay, xDrawable, this.handle, nx + naw2, ny + nh, nx + nw - naw2, ny + nh);
            }
        } else if (nh > nah) {
            OS.XDrawArc(xDisplay, xDrawable, this.handle, nx, ny, nw, nah, 0, 11520);
            OS.XDrawLine(xDisplay, xDrawable, this.handle, nx + nw, ny + nah2, nx + nw, ny + nh - nah2);
            OS.XDrawArc(xDisplay, xDrawable, this.handle, nx, ny + nh - nah, nw, nah, 11520, 11520);
            OS.XDrawLine(xDisplay, xDrawable, this.handle, nx, ny + nah2, nx, ny + nh - nah2);
        } else {
            OS.XDrawArc(xDisplay, xDrawable, this.handle, nx, ny, nw, nh, 0, 23040);
        }
    }

    public void drawString(String string, int x, int y) {
        this.drawString(string, x, y, false);
    }

    public void drawString(String string, int x, int y, boolean isTransparent) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() == 0) {
            return;
        }
        int cairo = this.data.cairo;
        if (cairo != 0) {
            this.checkGC(5);
            cairo_font_extents_t extents = new cairo_font_extents_t();
            Cairo.cairo_font_extents(cairo, extents);
            double baseline = (double)y + extents.ascent;
            Cairo.cairo_move_to(cairo, x, baseline);
            byte[] buffer = Converter.wcsToMbcs(null, string, true);
            Cairo.cairo_show_text(cairo, buffer);
            Cairo.cairo_new_path(cairo);
            return;
        }
        this.setString(string);
        this.checkGC(261);
        if (isTransparent) {
            OS.XmStringDraw(this.data.display, this.data.drawable, this.data.font.handle, this.data.xmString, this.handle, x, y, Integer.MAX_VALUE, 0, 0, null);
        } else {
            OS.XmStringDrawImage(this.data.display, this.data.drawable, this.data.font.handle, this.data.xmString, this.handle, x, y, Integer.MAX_VALUE, 0, 0, null);
        }
    }

    void createRenderTable() {
        int fontList = this.data.font.handle;
        byte[] byArray = new byte[2];
        byArray[0] = 32;
        byte[] buffer = byArray;
        int xmString = OS.XmStringCreate(buffer, OS.XmFONTLIST_DEFAULT_TAG);
        int tabWidth = OS.XmStringWidth(fontList, xmString) * 8;
        OS.XmStringFree(xmString);
        int[] tabs = new int[16];
        int tab = OS.XmTabCreate(tabWidth, (byte)0, (byte)1, (byte)0, null);
        int i = 0;
        while (i < tabs.length) {
            tabs[i] = tab;
            ++i;
        }
        int tabList = OS.XmTabListInsertTabs(0, tabs, tabs.length, 0);
        int[] fontBuffer = new int[1];
        if (!OS.XmFontListInitFontContext(fontBuffer, fontList)) {
            SWT.error(2);
        }
        int context = fontBuffer[0];
        int fontListEntry = 0;
        int[] renditions = new int[4];
        int renditionCount = 0;
        while ((fontListEntry = OS.XmFontListNextEntry(context)) != 0) {
            int fontType;
            int fontPtr = OS.XmFontListEntryGetFont(fontListEntry, fontBuffer);
            int n = fontType = fontBuffer[0] == 0 ? 0 : 1;
            if (fontPtr == 0) {
                SWT.error(2);
            }
            int[] argList = new int[]{OS.XmNtabList, tabList, OS.XmNfont, fontPtr, OS.XmNfontType, fontType};
            int rendition = OS.XmRenditionCreate(this.data.device.shellHandle, OS.XmFONTLIST_DEFAULT_TAG, argList, argList.length / 2);
            renditions[renditionCount++] = rendition;
            if (renditionCount != renditions.length) continue;
            int[] newArray = new int[renditions.length + 4];
            System.arraycopy(newArray, 0, renditions, 0, renditionCount);
            renditions = newArray;
        }
        OS.XmFontListFreeFontContext(context);
        OS.XmTabFree(tab);
        OS.XmTabListFree(tabList);
        this.data.renderTable = OS.XmRenderTableAddRenditions(0, renditions, renditionCount, 1);
        int i2 = 0;
        while (i2 < renditionCount) {
            OS.XmRenditionFree(renditions[i2]);
            ++i2;
        }
    }

    public void drawText(String string, int x, int y) {
        this.drawText(string, x, y, 6);
    }

    public void drawText(String string, int x, int y, boolean isTransparent) {
        int flags = 6;
        if (isTransparent) {
            flags |= 1;
        }
        this.drawText(string, x, y, flags);
    }

    public void drawText(String string, int x, int y, int flags) {
        int xmMnemonic;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() == 0) {
            return;
        }
        int cairo = this.data.cairo;
        if (cairo != 0) {
            this.checkGC(5);
            cairo_font_extents_t extents = new cairo_font_extents_t();
            Cairo.cairo_font_extents(cairo, extents);
            double baseline = (double)y + extents.ascent;
            Cairo.cairo_move_to(cairo, x, baseline);
            byte[] buffer = Converter.wcsToMbcs(null, string, true);
            Cairo.cairo_show_text(cairo, buffer);
            Cairo.cairo_new_path(cairo);
            return;
        }
        this.setText(string, flags);
        this.checkGC(261);
        int xDisplay = this.data.display;
        int xDrawable = this.data.drawable;
        if (this.data.image != null) {
            OS.XtRegisterDrawable(xDisplay, xDrawable, this.data.device.shellHandle);
        }
        if ((xmMnemonic = this.data.xmMnemonic) != 0) {
            OS.XmStringDrawUnderline(xDisplay, xDrawable, this.data.renderTable, this.data.xmText, this.handle, x, y, Integer.MAX_VALUE, 0, 0, null, xmMnemonic);
        } else if ((flags & 1) != 0) {
            OS.XmStringDraw(xDisplay, xDrawable, this.data.renderTable, this.data.xmText, this.handle, x, y, Integer.MAX_VALUE, 0, 0, null);
        } else {
            OS.XmStringDrawImage(xDisplay, xDrawable, this.data.renderTable, this.data.xmText, this.handle, x, y, Integer.MAX_VALUE, 0, 0, null);
        }
        if (this.data.image != null) {
            OS.XtUnregisterDrawable(xDisplay, xDrawable);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GC)) {
            return false;
        }
        return this.handle == ((GC)object).handle;
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(2);
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (width == 0 || height == 0 || arcAngle == 0) {
            return;
        }
        int cairo = this.data.cairo;
        if (cairo != 0) {
            if (width == height) {
                if (arcAngle >= 0) {
                    Cairo.cairo_arc_negative(cairo, (float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f, (float)width / 2.0f, (float)(-startAngle) * (float)Compatibility.PI / 180.0f, (float)(-(startAngle + arcAngle)) * (float)Compatibility.PI / 180.0f);
                } else {
                    Cairo.cairo_arc(cairo, (float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f, (float)width / 2.0f, (float)(-startAngle) * (float)Compatibility.PI / 180.0f, (float)(-(startAngle + arcAngle)) * (float)Compatibility.PI / 180.0f);
                }
                Cairo.cairo_line_to(cairo, (float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f);
            } else {
                Cairo.cairo_save(cairo);
                Cairo.cairo_translate(cairo, (float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f);
                Cairo.cairo_scale(cairo, (float)width / 2.0f, (float)height / 2.0f);
                if (arcAngle >= 0) {
                    Cairo.cairo_arc_negative(cairo, 0.0, 0.0, 1.0, (float)(-startAngle) * (float)Compatibility.PI / 180.0f, (float)(-(startAngle + arcAngle)) * (float)Compatibility.PI / 180.0f);
                } else {
                    Cairo.cairo_arc(cairo, 0.0, 0.0, 1.0, (float)(-startAngle) * (float)Compatibility.PI / 180.0f, (float)(-(startAngle + arcAngle)) * (float)Compatibility.PI / 180.0f);
                }
                Cairo.cairo_line_to(cairo, 0.0, 0.0);
                Cairo.cairo_restore(cairo);
            }
            Cairo.cairo_fill(cairo);
            return;
        }
        OS.XFillArc(this.data.display, this.data.drawable, this.handle, x, y, width, height, startAngle * 64, arcAngle * 64);
    }

    public void fillGradientRectangle(int x, int y, int width, int height, boolean vertical) {
        int blueBits;
        int greenBits;
        int redBits;
        RGB foregroundRGB;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width == 0 || height == 0) {
            return;
        }
        RGB backgroundRGB = this.getBackground().getRGB();
        RGB fromRGB = foregroundRGB = this.getForeground().getRGB();
        RGB toRGB = backgroundRGB;
        boolean swapColors = false;
        if (width < 0) {
            x += width;
            width = -width;
            if (!vertical) {
                swapColors = true;
            }
        }
        if (height < 0) {
            y += height;
            height = -height;
            if (vertical) {
                swapColors = true;
            }
        }
        if (swapColors) {
            fromRGB = backgroundRGB;
            toRGB = foregroundRGB;
        }
        if (fromRGB.equals(toRGB)) {
            this.fillRectangle(x, y, width, height);
            return;
        }
        int xDisplay = this.data.display;
        int xScreenNum = OS.XDefaultScreen(xDisplay);
        int xScreen = OS.XDefaultScreenOfDisplay(xDisplay);
        int xVisual = OS.XDefaultVisual(xDisplay, xScreenNum);
        Visual visual = new Visual();
        OS.memmove(visual, xVisual, 32);
        int depth = OS.XDefaultDepthOfScreen(xScreen);
        boolean directColor = depth > 8;
        int cairo = this.data.cairo;
        if (cairo != 0) {
            int pattern = vertical ? Cairo.cairo_pattern_create_linear(0.0, 0.0, 0.0, 1.0) : Cairo.cairo_pattern_create_linear(0.0, 0.0, 1.0, 0.0);
            Cairo.cairo_pattern_add_color_stop_rgba(pattern, 0.0, (float)fromRGB.red / 255.0f, (float)fromRGB.green / 255.0f, (float)fromRGB.blue / 255.0f, (float)this.data.alpha / 255.0f);
            Cairo.cairo_pattern_add_color_stop_rgba(pattern, 1.0, (float)toRGB.red / 255.0f, (float)toRGB.green / 255.0f, (float)toRGB.blue / 255.0f, (float)this.data.alpha / 255.0f);
            Cairo.cairo_save(cairo);
            Cairo.cairo_translate(cairo, x, y);
            Cairo.cairo_scale(cairo, width, height);
            Cairo.cairo_rectangle(cairo, 0.0, 0.0, 1.0, 1.0);
            Cairo.cairo_set_source(cairo, pattern);
            Cairo.cairo_fill(cairo);
            Cairo.cairo_restore(cairo);
            Cairo.cairo_pattern_destroy(pattern);
            return;
        }
        if (directColor) {
            redBits = GC.getChannelWidth(visual.red_mask);
            greenBits = GC.getChannelWidth(visual.green_mask);
            blueBits = GC.getChannelWidth(visual.blue_mask);
        } else {
            blueBits = 0;
            greenBits = 0;
            redBits = 0;
        }
        ImageData.fillGradientRectangle(this, this.data.device, x, y, width, height, vertical, fromRGB, toRGB, redBits, greenBits, blueBits);
    }

    static int getChannelWidth(int mask) {
        int width = 0;
        while (mask != 0) {
            width += mask & 1;
            mask >>>= 1;
        }
        return width;
    }

    public void fillOval(int x, int y, int width, int height) {
        int cairo;
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(2);
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if ((cairo = this.data.cairo) != 0) {
            if (width == height) {
                Cairo.cairo_arc_negative(cairo, (float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f, (float)width / 2.0f, 0.0, 2.0f * (float)Compatibility.PI);
            } else {
                Cairo.cairo_save(cairo);
                Cairo.cairo_translate(cairo, (float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f);
                Cairo.cairo_scale(cairo, (float)width / 2.0f, (float)height / 2.0f);
                Cairo.cairo_arc_negative(cairo, 0.0, 0.0, 1.0, 0.0, 2.0f * (float)Compatibility.PI);
                Cairo.cairo_restore(cairo);
            }
            Cairo.cairo_fill(cairo);
            return;
        }
        OS.XFillArc(this.data.display, this.data.drawable, this.handle, x, y, width, height, 0, 23040);
    }

    public void fillPath(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.handle == 0) {
            SWT.error(5);
        }
        this.initCairo();
        this.checkGC(2);
        int cairo = this.data.cairo;
        int copy = Cairo.cairo_copy_path(path.handle);
        if (copy == 0) {
            SWT.error(2);
        }
        Cairo.cairo_append_path(cairo, copy);
        Cairo.cairo_path_destroy(copy);
        Cairo.cairo_fill(cairo);
    }

    public void fillPolygon(int[] pointArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        this.checkGC(2);
        int cairo = this.data.cairo;
        if (cairo != 0) {
            this.drawPolyline(cairo, pointArray, true);
            Cairo.cairo_fill(cairo);
            return;
        }
        short[] xPoints = new short[pointArray.length];
        int i = 0;
        while (i < pointArray.length) {
            xPoints[i] = (short)pointArray[i];
            ++i;
        }
        OS.XFillPolygon(this.data.display, this.data.drawable, this.handle, xPoints, xPoints.length / 2, 0, 0);
    }

    public void fillRectangle(int x, int y, int width, int height) {
        int cairo;
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(2);
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if ((cairo = this.data.cairo) != 0) {
            Cairo.cairo_rectangle(cairo, x, y, width, height);
            Cairo.cairo_fill(cairo);
            return;
        }
        OS.XFillRectangle(this.data.display, this.data.drawable, this.handle, x, y, width, height);
    }

    public void fillRectangle(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        this.fillRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void fillRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        int cairo;
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(2);
        int nx = x;
        int ny = y;
        int nw = width;
        int nh = height;
        int naw = arcWidth;
        int nah = arcHeight;
        if (nw < 0) {
            nw = 0 - nw;
            nx -= nw;
        }
        if (nh < 0) {
            nh = 0 - nh;
            ny -= nh;
        }
        if (naw < 0) {
            naw = 0 - naw;
        }
        if (nah < 0) {
            nah = 0 - nah;
        }
        if ((cairo = this.data.cairo) != 0) {
            if (naw == 0 || nah == 0) {
                Cairo.cairo_rectangle(cairo, x, y, width, height);
            } else {
                float naw2 = (float)naw / 2.0f;
                float nah2 = (float)nah / 2.0f;
                float fw = (float)nw / naw2;
                float fh = (float)nh / nah2;
                Cairo.cairo_save(cairo);
                Cairo.cairo_translate(cairo, nx, ny);
                Cairo.cairo_scale(cairo, naw2, nah2);
                Cairo.cairo_move_to(cairo, fw - 1.0f, 0.0);
                Cairo.cairo_arc(cairo, fw - 1.0f, 1.0, 1.0, Compatibility.PI + Compatibility.PI / 2.0, Compatibility.PI * 2.0);
                Cairo.cairo_arc(cairo, fw - 1.0f, fh - 1.0f, 1.0, 0.0, Compatibility.PI / 2.0);
                Cairo.cairo_arc(cairo, 1.0, fh - 1.0f, 1.0, Compatibility.PI / 2.0, Compatibility.PI);
                Cairo.cairo_arc(cairo, 1.0, 1.0, 1.0, Compatibility.PI, 270.0 * Compatibility.PI / 180.0);
                Cairo.cairo_close_path(cairo);
                Cairo.cairo_restore(cairo);
            }
            Cairo.cairo_fill(cairo);
            return;
        }
        int naw2 = naw / 2;
        int nah2 = nah / 2;
        int xDisplay = this.data.display;
        int xDrawable = this.data.drawable;
        if (nw > naw) {
            if (nh > nah) {
                OS.XFillArc(xDisplay, xDrawable, this.handle, nx, ny, naw, nah, 5760, 5760);
                OS.XFillRectangle(xDisplay, xDrawable, this.handle, nx + naw2, ny, nw - naw2 * 2, nah2);
                OS.XFillArc(xDisplay, xDrawable, this.handle, nx + nw - naw, ny, naw, nah, 0, 5760);
                OS.XFillRectangle(xDisplay, xDrawable, this.handle, nx, ny + nah2, nw, nh - nah2 * 2);
                OS.XFillArc(xDisplay, xDrawable, this.handle, nx + nw - naw, ny + nh - nah, naw, nah, 17280, 5760);
                OS.XFillRectangle(xDisplay, xDrawable, this.handle, nx + naw2, ny + nh - nah2, nw - naw2 * 2, nah2);
                OS.XFillArc(xDisplay, xDrawable, this.handle, nx, ny + nh - nah, naw, nah, 11520, 5760);
            } else {
                OS.XFillArc(xDisplay, xDrawable, this.handle, nx, ny, naw, nh, 5760, 11520);
                OS.XFillRectangle(xDisplay, xDrawable, this.handle, nx + naw2, ny, nw - naw2 * 2, nh);
                OS.XFillArc(xDisplay, xDrawable, this.handle, nx + nw - naw, ny, naw, nh, 17280, 11520);
            }
        } else if (nh > nah) {
            OS.XFillArc(xDisplay, xDrawable, this.handle, nx, ny, nw, nah, 0, 11520);
            OS.XFillRectangle(xDisplay, xDrawable, this.handle, nx, ny + nah2, nw, nh - nah2 * 2);
            OS.XFillArc(xDisplay, xDrawable, this.handle, nx, ny + nh - nah, nw, nah, 11520, 11520);
        } else {
            OS.XFillArc(xDisplay, xDrawable, this.handle, nx, ny, nw, nh, 0, 23040);
        }
    }

    char fixMnemonic(char[] text) {
        char mnemonic = '\u0000';
        int i = 0;
        int j = 0;
        while (i < text.length) {
            if ((text[j++] = text[i++]) != '&' || i == text.length) continue;
            if (text[i] == '&') {
                ++i;
                continue;
            }
            if (mnemonic == '\u0000') {
                mnemonic = text[i];
            }
            --j;
        }
        while (j < text.length) {
            text[j++] = '\u0000';
        }
        return mnemonic;
    }

    public int getAdvanceWidth(char ch) {
        int fontListEntry;
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(4);
        int fontList = this.data.font.handle;
        byte[] charBuffer = Converter.wcsToMbcs(this.getCodePage(), new char[]{ch}, false);
        int val = charBuffer[0] & 0xFF;
        int[] buffer = new int[1];
        if (!OS.XmFontListInitFontContext(buffer, fontList)) {
            SWT.error(2);
        }
        int context = buffer[0];
        XFontStruct fontStruct = new XFontStruct();
        XCharStruct charStruct = new XCharStruct();
        int[] fontStructPtr = new int[1];
        int[] fontNamePtr = new int[1];
        while ((fontListEntry = OS.XmFontListNextEntry(context)) != 0) {
            int perCharPtr;
            short charWidth;
            int fontPtr = OS.XmFontListEntryGetFont(fontListEntry, buffer);
            if (buffer[0] == 0) {
                OS.memmove(fontStruct, fontPtr, 80);
                if (fontStruct.min_byte1 == 0 && fontStruct.max_byte1 == 0) {
                    if (fontStruct.min_char_or_byte2 > val || val > fontStruct.max_char_or_byte2) continue;
                    short charWidth2 = 0;
                    int perCharPtr2 = fontStruct.per_char;
                    if (perCharPtr2 == 0) {
                        charWidth2 = fontStruct.max_bounds_width;
                    } else {
                        OS.memmove(charStruct, perCharPtr2 + (val - fontStruct.min_char_or_byte2) * 12, 12);
                        charWidth2 = charStruct.width;
                    }
                    if (charWidth2 == 0) continue;
                    OS.XmFontListFreeFontContext(context);
                    return charWidth2;
                }
                int charsPerRow = fontStruct.max_char_or_byte2 - fontStruct.min_char_or_byte2 + 1;
                int row = 0;
                if (charBuffer.length > 1) {
                    row = charBuffer[1] - fontStruct.min_byte1;
                }
                int col = charBuffer[0] - fontStruct.min_char_or_byte2;
                if (row > fontStruct.max_byte1 || col > fontStruct.max_char_or_byte2) continue;
                charWidth = 0;
                perCharPtr = fontStruct.per_char;
                if (perCharPtr == 0) {
                    charWidth = fontStruct.max_bounds_width;
                } else {
                    int offset = row * charsPerRow + col;
                    OS.memmove(charStruct, perCharPtr + offset * 12, 12);
                    charWidth = charStruct.width;
                }
                if (charWidth == 0) continue;
                OS.XmFontListFreeFontContext(context);
                return charWidth;
            }
            int nFonts = OS.XFontsOfFontSet(fontPtr, fontStructPtr, fontNamePtr);
            int[] fontStructs = new int[nFonts];
            OS.memmove(fontStructs, fontStructPtr[0], nFonts * 4);
            int i = 0;
            while (i < nFonts) {
                OS.memmove(fontStruct, fontStructs[i], 80);
                if (fontStruct.min_byte1 == 0 && fontStruct.max_byte1 == 0) {
                    if (fontStruct.min_char_or_byte2 <= val && val <= fontStruct.max_char_or_byte2) {
                        charWidth = 0;
                        perCharPtr = fontStruct.per_char;
                        if (perCharPtr == 0) {
                            charWidth = fontStruct.max_bounds_width;
                        } else {
                            OS.memmove(charStruct, perCharPtr + (val - fontStruct.min_char_or_byte2) * 12, 12);
                            charWidth = charStruct.width;
                        }
                        if (charWidth != 0) {
                            OS.XmFontListFreeFontContext(context);
                            return charWidth;
                        }
                    }
                } else {
                    int charsPerRow = fontStruct.max_char_or_byte2 - fontStruct.min_char_or_byte2 + 1;
                    int row = 0;
                    if (charBuffer.length > 1) {
                        row = charBuffer[1] - fontStruct.min_byte1;
                    }
                    int col = charBuffer[0] - fontStruct.min_char_or_byte2;
                    if (row <= fontStruct.max_byte1 && col <= fontStruct.max_char_or_byte2) {
                        short charWidth3 = 0;
                        int perCharPtr3 = fontStruct.per_char;
                        if (perCharPtr3 == 0) {
                            charWidth3 = fontStruct.max_bounds_width;
                        } else {
                            int offset = row * charsPerRow + col;
                            OS.memmove(charStruct, perCharPtr3 + offset * 12, 12);
                            charWidth3 = charStruct.width;
                        }
                        if (charWidth3 != 0) {
                            OS.XmFontListFreeFontContext(context);
                            return charWidth3;
                        }
                    }
                }
                ++i;
            }
        }
        OS.XmFontListFreeFontContext(context);
        return this.stringExtent((String)new String((char[])new char[]{ch})).x;
    }

    public boolean getAdvanced() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.cairo != 0;
    }

    public int getAlpha() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.alpha;
    }

    public int getAntialias() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.cairo == 0) {
            return -1;
        }
        int antialias = Cairo.cairo_get_antialias(this.data.cairo);
        switch (antialias) {
            case 0: {
                return -1;
            }
            case 1: {
                return 0;
            }
            case 2: 
            case 3: {
                return 1;
            }
        }
        return -1;
    }

    public Color getBackground() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        XColor color = this.data.background;
        if ((this.data.state & 0x400) == 0) {
            OS.XQueryColor(this.data.display, this.data.colormap, color);
            this.data.state |= 0x400;
        }
        return Color.motif_new(this.data.device, color);
    }

    public Pattern getBackgroundPattern() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.backgroundPattern;
    }

    public int getCharWidth(char ch) {
        int fontListEntry;
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(4);
        int fontList = this.data.font.handle;
        byte[] charBuffer = Converter.wcsToMbcs(this.getCodePage(), new char[]{ch}, false);
        int val = charBuffer[0] & 0xFF;
        int[] buffer = new int[1];
        if (!OS.XmFontListInitFontContext(buffer, fontList)) {
            SWT.error(2);
        }
        int context = buffer[0];
        XFontStruct fontStruct = new XFontStruct();
        XCharStruct charStruct = new XCharStruct();
        int[] fontStructPtr = new int[1];
        int[] fontNamePtr = new int[1];
        while ((fontListEntry = OS.XmFontListNextEntry(context)) != 0) {
            int perCharPtr;
            short rBearing;
            short lBearing;
            short charWidth;
            int fontPtr = OS.XmFontListEntryGetFont(fontListEntry, buffer);
            if (buffer[0] == 0) {
                OS.memmove(fontStruct, fontPtr, 80);
                if (fontStruct.min_byte1 == 0 && fontStruct.max_byte1 == 0) {
                    if (fontStruct.min_char_or_byte2 > val || val > fontStruct.max_char_or_byte2) continue;
                    short charWidth2 = 0;
                    short lBearing2 = 0;
                    short rBearing2 = 0;
                    int perCharPtr2 = fontStruct.per_char;
                    if (perCharPtr2 == 0) {
                        charWidth2 = fontStruct.max_bounds_width;
                        lBearing2 = fontStruct.min_bounds_lbearing;
                        rBearing2 = fontStruct.max_bounds_rbearing;
                    } else {
                        OS.memmove(charStruct, perCharPtr2 + (val - fontStruct.min_char_or_byte2) * 12, 12);
                        charWidth2 = charStruct.width;
                        lBearing2 = charStruct.lbearing;
                        rBearing2 = charStruct.rbearing;
                    }
                    if (charWidth2 == 0) continue;
                    OS.XmFontListFreeFontContext(context);
                    return rBearing2 - lBearing2;
                }
                int charsPerRow = fontStruct.max_char_or_byte2 - fontStruct.min_char_or_byte2 + 1;
                int row = 0;
                if (charBuffer.length > 1) {
                    row = charBuffer[1] - fontStruct.min_byte1;
                }
                int col = charBuffer[0] - fontStruct.min_char_or_byte2;
                if (row > fontStruct.max_byte1 || col > fontStruct.max_char_or_byte2) continue;
                charWidth = 0;
                lBearing = 0;
                rBearing = 0;
                perCharPtr = fontStruct.per_char;
                if (perCharPtr == 0) {
                    charWidth = fontStruct.max_bounds_width;
                    lBearing = fontStruct.min_bounds_lbearing;
                    rBearing = fontStruct.max_bounds_rbearing;
                } else {
                    int offset = row * charsPerRow + col;
                    OS.memmove(charStruct, perCharPtr + offset * 12, 12);
                    charWidth = charStruct.width;
                    lBearing = charStruct.lbearing;
                    rBearing = charStruct.rbearing;
                }
                if (charWidth == 0) continue;
                OS.XmFontListFreeFontContext(context);
                return rBearing - lBearing;
            }
            int nFonts = OS.XFontsOfFontSet(fontPtr, fontStructPtr, fontNamePtr);
            int[] fontStructs = new int[nFonts];
            OS.memmove(fontStructs, fontStructPtr[0], nFonts * 4);
            int i = 0;
            while (i < nFonts) {
                OS.memmove(fontStruct, fontStructs[i], 80);
                if (fontStruct.min_byte1 == 0 && fontStruct.max_byte1 == 0) {
                    if (fontStruct.min_char_or_byte2 <= val && val <= fontStruct.max_char_or_byte2) {
                        charWidth = 0;
                        lBearing = 0;
                        rBearing = 0;
                        perCharPtr = fontStruct.per_char;
                        if (perCharPtr == 0) {
                            charWidth = fontStruct.max_bounds_width;
                            lBearing = fontStruct.min_bounds_lbearing;
                            rBearing = fontStruct.max_bounds_rbearing;
                        } else {
                            OS.memmove(charStruct, perCharPtr + (val - fontStruct.min_char_or_byte2) * 12, 12);
                            charWidth = charStruct.width;
                            lBearing = charStruct.lbearing;
                            rBearing = charStruct.rbearing;
                        }
                        if (charWidth != 0) {
                            OS.XmFontListFreeFontContext(context);
                            return rBearing - lBearing;
                        }
                    }
                } else {
                    int charsPerRow = fontStruct.max_char_or_byte2 - fontStruct.min_char_or_byte2 + 1;
                    int row = 0;
                    if (charBuffer.length > 1) {
                        row = charBuffer[1] - fontStruct.min_byte1;
                    }
                    int col = charBuffer[0] - fontStruct.min_char_or_byte2;
                    if (row <= fontStruct.max_byte1 && col <= fontStruct.max_char_or_byte2) {
                        short charWidth3 = 0;
                        short lBearing3 = 0;
                        short rBearing3 = 0;
                        int perCharPtr3 = fontStruct.per_char;
                        if (perCharPtr3 == 0) {
                            charWidth3 = fontStruct.max_bounds_width;
                            lBearing3 = fontStruct.min_bounds_lbearing;
                            rBearing3 = fontStruct.max_bounds_rbearing;
                        } else {
                            int offset = row * charsPerRow + col;
                            OS.memmove(charStruct, perCharPtr3 + offset * 12, 12);
                            charWidth3 = charStruct.width;
                            lBearing3 = charStruct.lbearing;
                            rBearing3 = charStruct.rbearing;
                        }
                        if (charWidth3 != 0) {
                            OS.XmFontListFreeFontContext(context);
                            return rBearing3 - lBearing3;
                        }
                    }
                }
                ++i;
            }
        }
        OS.XmFontListFreeFontContext(context);
        return this.stringExtent((String)new String((char[])new char[]{ch})).x;
    }

    public Rectangle getClipping() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        int[] w = new int[1];
        int[] h = new int[1];
        int[] unused = new int[1];
        OS.XGetGeometry(this.data.display, this.data.drawable, unused, unused, unused, w, h, unused, unused);
        width = w[0];
        height = h[0];
        int cairo = this.data.cairo;
        int clipRgn = this.data.clipRgn;
        int damageRgn = this.data.damageRgn;
        if (clipRgn != 0 || damageRgn != 0 || cairo != 0) {
            int rgn = OS.XCreateRegion();
            XRectangle rect = new XRectangle();
            rect.width = (short)width;
            rect.height = (short)height;
            OS.XUnionRectWithRegion(rect, rgn, rgn);
            if (damageRgn != 0) {
                OS.XIntersectRegion(damageRgn, rgn, rgn);
            }
            if (clipRgn != 0) {
                if (this.data.clippingTransform != null) {
                    clipRgn = this.convertRgn(clipRgn, this.data.clippingTransform);
                    OS.XIntersectRegion(rgn, clipRgn, rgn);
                    OS.XDestroyRegion(clipRgn);
                } else {
                    OS.XIntersectRegion(rgn, clipRgn, rgn);
                }
            }
            if (cairo != 0) {
                double[] matrix = new double[6];
                Cairo.cairo_get_matrix(cairo, matrix);
                Cairo.cairo_matrix_invert(matrix);
                clipRgn = this.convertRgn(rgn, matrix);
                OS.XDestroyRegion(rgn);
                rgn = clipRgn;
            }
            OS.XClipBox(rgn, rect);
            OS.XDestroyRegion(rgn);
            x = rect.x;
            y = rect.y;
            width = rect.width;
            height = rect.height;
        }
        return new Rectangle(x, y, width, height);
    }

    public void getClipping(Region region) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        int clipping = region.handle;
        OS.XSubtractRegion(clipping, clipping, clipping);
        int cairo = this.data.cairo;
        int clipRgn = this.data.clipRgn;
        if (clipRgn == 0) {
            int[] width = new int[1];
            int[] height = new int[1];
            int[] unused = new int[1];
            OS.XGetGeometry(this.data.display, this.data.drawable, unused, unused, unused, width, height, unused, unused);
            XRectangle rect = new XRectangle();
            rect.x = 0;
            rect.y = 0;
            rect.width = (short)width[0];
            rect.height = (short)height[0];
            OS.XUnionRectWithRegion(rect, clipping, clipping);
        } else if (this.data.clippingTransform != null) {
            int rgn = this.convertRgn(clipRgn, this.data.clippingTransform);
            OS.XUnionRegion(clipping, rgn, clipping);
            OS.XDestroyRegion(rgn);
        } else {
            OS.XUnionRegion(clipping, clipRgn, clipping);
        }
        if (this.data.damageRgn != 0) {
            OS.XIntersectRegion(clipping, this.data.damageRgn, clipping);
        }
        if (cairo != 0) {
            double[] matrix = new double[6];
            Cairo.cairo_get_matrix(cairo, matrix);
            Cairo.cairo_matrix_invert(matrix);
            int rgn = this.convertRgn(clipping, matrix);
            OS.XSubtractRegion(clipping, clipping, clipping);
            OS.XUnionRegion(clipping, rgn, clipping);
            OS.XDestroyRegion(rgn);
        }
    }

    String getCodePage() {
        return this.data.font.codePage;
    }

    public int getFillRule() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        XGCValues values = new XGCValues();
        OS.XGetGCValues(this.data.display, this.handle, 512, values);
        return values.fill_rule == 1 ? 2 : 1;
    }

    public Font getFont() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return Font.motif_new(this.data.device, this.data.font.handle);
    }

    int getFontHeight() {
        int fontListEntry;
        int[] buffer = new int[1];
        int fontList = this.data.font.handle;
        if (!OS.XmFontListInitFontContext(buffer, fontList)) {
            SWT.error(2);
        }
        int context = buffer[0];
        int height = 0;
        XFontStruct fontStruct = new XFontStruct();
        int[] fontStructPtr = new int[1];
        int[] fontNamePtr = new int[1];
        while ((fontListEntry = OS.XmFontListNextEntry(context)) != 0) {
            int fontPtr = OS.XmFontListEntryGetFont(fontListEntry, buffer);
            if (buffer[0] == 0) {
                OS.memmove(fontStruct, fontPtr, 80);
                int fontHeight = fontStruct.ascent + fontStruct.descent;
                height = Math.max(height, fontHeight);
                continue;
            }
            int nFonts = OS.XFontsOfFontSet(fontPtr, fontStructPtr, fontNamePtr);
            int[] fontStructs = new int[nFonts];
            OS.memmove(fontStructs, fontStructPtr[0], nFonts * 4);
            int i = 0;
            while (i < nFonts) {
                OS.memmove(fontStruct, fontStructs[i], 80);
                int fontHeight = fontStruct.ascent + fontStruct.descent;
                height = Math.max(height, fontHeight);
                ++i;
            }
        }
        OS.XmFontListFreeFontContext(context);
        return height;
    }

    public FontMetrics getFontMetrics() {
        int fontListEntry;
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(4);
        int xDisplay = this.data.display;
        Font font = this.data.font;
        int fontList = font.handle;
        int[] buffer = new int[1];
        if (!OS.XmFontListInitFontContext(buffer, fontList)) {
            SWT.error(2);
        }
        int context = buffer[0];
        int ascent = 0;
        int descent = 0;
        int averageCharWidth = 0;
        int numAverageCharWidth = 0;
        int leading = 0;
        int height = 0;
        XFontStruct fontStruct = new XFontStruct();
        int[] fontStructPtr = new int[1];
        int[] fontNamePtr = new int[1];
        block6: while ((fontListEntry = OS.XmFontListNextEntry(context)) != 0) {
            int i;
            int fontPtr = OS.XmFontListEntryGetFont(fontListEntry, buffer);
            if (buffer[0] == 0) {
                OS.memmove(fontStruct, fontPtr, 80);
                ascent = Math.max(ascent, fontStruct.ascent);
                descent = Math.max(descent, fontStruct.descent);
                int fontHeight = fontStruct.ascent + fontStruct.descent;
                height = Math.max(height, fontHeight);
                int propPtr = fontStruct.properties;
                i = 0;
                while (i < fontStruct.n_properties) {
                    int[] prop = new int[2];
                    OS.memmove(prop, propPtr, 8);
                    if (prop[0] == 18) {
                        int ptr = OS.XmGetAtomName(xDisplay, prop[1]);
                        int length = OS.strlen(ptr);
                        byte[] nameBuf = new byte[length];
                        OS.memmove(nameBuf, ptr, length);
                        OS.XFree(ptr);
                        String xlfd = new String(Converter.mbcsToWcs(null, nameBuf)).toLowerCase();
                        int avg = 0;
                        try {
                            avg = FontData.motif_new((String)xlfd).averageWidth / 10;
                        }
                        catch (Exception exception) {}
                        if (avg == 0) {
                            int perCharPtr = fontStruct.per_char;
                            if (perCharPtr == 0) {
                                averageCharWidth = fontStruct.max_bounds_width;
                            } else {
                                int sum = 0;
                                int count = 0;
                                int cols = fontStruct.max_char_or_byte2 - fontStruct.min_char_or_byte2 + 1;
                                XCharStruct struct = new XCharStruct();
                                int index = 0;
                                while (index < cols) {
                                    OS.memmove(struct, perCharPtr + index * 12, 12);
                                    short w = struct.width;
                                    if (w != 0) {
                                        sum += w;
                                        ++count;
                                    }
                                    ++index;
                                }
                                averageCharWidth += sum / count;
                            }
                        } else {
                            averageCharWidth += avg;
                        }
                        ++numAverageCharWidth;
                        continue block6;
                    }
                    propPtr += 8;
                    ++i;
                }
                continue;
            }
            int nFonts = OS.XFontsOfFontSet(fontPtr, fontStructPtr, fontNamePtr);
            int[] fontStructs = new int[nFonts];
            OS.memmove(fontStructs, fontStructPtr[0], nFonts * 4);
            i = 0;
            while (i < nFonts) {
                OS.memmove(fontStruct, fontStructs[i], 80);
                ascent = Math.max(ascent, fontStruct.ascent);
                descent = Math.max(descent, fontStruct.descent);
                int fontHeight = fontStruct.ascent + fontStruct.descent;
                height = Math.max(height, fontHeight);
                int propPtr = fontStruct.properties;
                int j = 0;
                while (j < fontStruct.n_properties) {
                    int[] prop = new int[2];
                    OS.memmove(prop, propPtr, 8);
                    if (prop[0] == 18) {
                        int avg;
                        block27: {
                            int ptr = OS.XmGetAtomName(xDisplay, prop[1]);
                            int length = OS.strlen(ptr);
                            byte[] nameBuf = new byte[length];
                            OS.memmove(nameBuf, ptr, length);
                            OS.XFree(ptr);
                            String xlfd = new String(Converter.mbcsToWcs(null, nameBuf)).toLowerCase();
                            avg = 0;
                            try {
                                avg = FontData.motif_new((String)xlfd).averageWidth / 10;
                            }
                            catch (Exception exception) {
                                int[] fontName = new int[1];
                                OS.memmove(fontName, fontNamePtr[0] + i * 4, 4);
                                ptr = fontName[0];
                                if (ptr == 0) break block27;
                                length = OS.strlen(ptr);
                                nameBuf = new byte[length];
                                OS.memmove(nameBuf, ptr, length);
                                xlfd = new String(Converter.mbcsToWcs(null, nameBuf)).toLowerCase();
                                try {
                                    avg = FontData.motif_new((String)xlfd).averageWidth / 10;
                                }
                                catch (Exception exception2) {}
                            }
                        }
                        if (avg == 0) {
                            int perCharPtr = fontStruct.per_char;
                            if (perCharPtr == 0) {
                                averageCharWidth = fontStruct.max_bounds_width;
                            } else {
                                int sum = 0;
                                int count = 0;
                                int cols = fontStruct.max_char_or_byte2 - fontStruct.min_char_or_byte2 + 1;
                                XCharStruct struct = new XCharStruct();
                                int index = 0;
                                while (index < cols) {
                                    OS.memmove(struct, perCharPtr + index * 12, 12);
                                    short w = struct.width;
                                    if (w != 0) {
                                        sum += w;
                                        ++count;
                                    }
                                    ++index;
                                }
                                averageCharWidth += sum / count;
                            }
                        } else {
                            averageCharWidth += avg;
                        }
                        ++numAverageCharWidth;
                        break;
                    }
                    propPtr += 8;
                    ++j;
                }
                ++i;
            }
        }
        OS.XmFontListFreeFontContext(context);
        return FontMetrics.motif_new(ascent, descent, averageCharWidth / numAverageCharWidth, leading, height);
    }

    public Color getForeground() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        XColor color = this.data.foreground;
        if ((this.data.state & 0x200) == 0) {
            OS.XQueryColor(this.data.display, this.data.colormap, color);
            this.data.state |= 0x200;
        }
        return Color.motif_new(this.data.device, color);
    }

    public Pattern getForegroundPattern() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.foregroundPattern;
    }

    public GCData getGCData() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data;
    }

    public int getInterpolation() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.interpolation;
    }

    public LineAttributes getLineAttributes() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        float[] dashes = null;
        if (this.data.lineDashes != null) {
            dashes = new float[this.data.lineDashes.length];
            System.arraycopy(this.data.lineDashes, 0, dashes, 0, dashes.length);
        }
        return new LineAttributes(this.data.lineWidth, this.data.lineCap, this.data.lineJoin, this.data.lineStyle, dashes, this.data.lineDashesOffset, this.data.lineMiterLimit);
    }

    public int getLineCap() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineCap;
    }

    public int[] getLineDash() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineDashes == null) {
            return null;
        }
        int[] lineDashes = new int[this.data.lineDashes.length];
        int i = 0;
        while (i < lineDashes.length) {
            lineDashes[i] = (int)this.data.lineDashes[i];
            ++i;
        }
        return lineDashes;
    }

    public int getLineJoin() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineJoin;
    }

    public int getLineStyle() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineStyle;
    }

    public int getLineWidth() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return (int)this.data.lineWidth;
    }

    public int getStyle() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.style;
    }

    public int getTextAntialias() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.cairo == 0) {
            return -1;
        }
        int options = Cairo.cairo_font_options_create();
        Cairo.cairo_get_font_options(this.data.cairo, options);
        int antialias = Cairo.cairo_font_options_get_antialias(options);
        Cairo.cairo_font_options_destroy(options);
        switch (antialias) {
            case 0: {
                return -1;
            }
            case 1: {
                return 0;
            }
            case 2: 
            case 3: {
                return 1;
            }
        }
        return -1;
    }

    public void getTransform(Transform transform) {
        int cairo;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (transform == null) {
            SWT.error(4);
        }
        if (transform.isDisposed()) {
            SWT.error(5);
        }
        if ((cairo = this.data.cairo) != 0) {
            Cairo.cairo_get_matrix(cairo, transform.handle);
        } else {
            transform.setElements(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        }
    }

    public boolean getXORMode() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        XGCValues values = new XGCValues();
        OS.XGetGCValues(this.data.display, this.handle, 1, values);
        return values.function == 6;
    }

    public int hashCode() {
        return this.handle;
    }

    void init(Drawable drawable, GCData data, int xGC) {
        Image image;
        if (data.foreground != null) {
            data.state &= 0xFFFFFDFE;
        }
        if (data.background != null) {
            data.state &= 0xFFFFFAFD;
        }
        if (data.font != null) {
            data.state &= 0xFFFFFFFB;
        }
        if ((image = data.image) != null) {
            image.memGC = this;
            if (image.transparentPixel != -1) {
                image.destroyMask();
            }
        }
        this.drawable = drawable;
        this.data = data;
        this.handle = xGC;
    }

    void initCairo() {
        this.data.device.checkCairo();
        int cairo = this.data.cairo;
        if (cairo != 0) {
            return;
        }
        int xDisplay = this.data.display;
        int xDrawable = this.data.drawable;
        int xVisual = OS.XDefaultVisual(xDisplay, OS.XDefaultScreen(xDisplay));
        int[] width = new int[1];
        int[] height = new int[1];
        int[] unused = new int[1];
        OS.XGetGeometry(xDisplay, xDrawable, unused, unused, unused, width, height, unused, unused);
        int surface = Cairo.cairo_xlib_surface_create(xDisplay, xDrawable, xVisual, width[0], height[0]);
        if (surface == 0) {
            SWT.error(2);
        }
        this.data.cairo = cairo = Cairo.cairo_create(surface);
        Cairo.cairo_surface_destroy(surface);
        if (cairo == 0) {
            SWT.error(2);
        }
        Cairo.cairo_set_fill_rule(cairo, 1);
        this.data.state &= 0xFFFFF780;
        this.setCairoClip(this.data.damageRgn, this.data.clipRgn);
    }

    public boolean isClipped() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.clipRgn != 0;
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    boolean isIdentity(double[] matrix) {
        if (matrix == null) {
            return true;
        }
        return matrix[0] == 1.0 && matrix[1] == 0.0 && matrix[2] == 0.0 && matrix[3] == 1.0 && matrix[4] == 0.0 && matrix[5] == 0.0;
    }

    public void setAdvanced(boolean advanced) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (advanced && this.data.cairo != 0) {
            return;
        }
        if (advanced) {
            try {
                this.initCairo();
            }
            catch (SWTException sWTException) {}
        } else {
            int cairo = this.data.cairo;
            if (cairo != 0) {
                Cairo.cairo_destroy(cairo);
            }
            this.data.cairo = 0;
            this.data.interpolation = -1;
            this.data.foregroundPattern = null;
            this.data.backgroundPattern = null;
            this.data.state = 0;
            this.setClipping(0);
        }
    }

    public void setAlpha(int alpha) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.cairo == 0 && (alpha & 0xFF) == 255) {
            return;
        }
        this.initCairo();
        this.data.alpha = alpha & 0xFF;
        this.data.state &= 0xFFFFFEFC;
    }

    public void setAntialias(int antialias) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.cairo == 0 && antialias == -1) {
            return;
        }
        int mode = 0;
        switch (antialias) {
            case -1: {
                mode = 0;
                break;
            }
            case 0: {
                mode = 1;
                break;
            }
            case 1: {
                mode = 2;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initCairo();
        int cairo = this.data.cairo;
        Cairo.cairo_set_antialias(cairo, mode);
    }

    public static GC motif_new(Drawable drawable, GCData data) {
        GC gc = new GC();
        int xGC = drawable.internal_new_GC(data);
        gc.device = data.device;
        gc.init(drawable, data, xGC);
        return gc;
    }

    public static GC motif_new(int xGC, GCData data) {
        GC gc = new GC();
        gc.device = data.device;
        gc.init(null, data, xGC);
        return gc;
    }

    public void setBackground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.data.background = color.handle;
        this.data.backgroundPattern = null;
        this.data.state &= 0xFFFFFEFD;
        this.data.state |= 0x400;
    }

    public void setBackgroundPattern(Pattern pattern) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pattern != null && pattern.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.cairo == 0 && pattern == null) {
            return;
        }
        this.initCairo();
        if (this.data.backgroundPattern == pattern) {
            return;
        }
        this.data.backgroundPattern = pattern;
        this.data.state &= 0xFFFFFFFD;
    }

    static void setCairoFont(int cairo, Font font) {
        String name;
        int index;
        FontData[] fds = font.getFontData();
        FontData fd = fds[0];
        int style = fd.getStyle();
        int slant = 0;
        if ((style & 2) != 0) {
            slant = 1;
        }
        int weight = 0;
        if ((style & 1) != 0) {
            weight = 1;
        }
        if ((index = (name = fd.getName()).indexOf(45)) != -1) {
            name = name.substring(index + 1);
        }
        byte[] buffer = Converter.wcsToMbcs(null, name, true);
        Cairo.cairo_select_font_face(cairo, buffer, slant, weight);
        Cairo.cairo_set_font_size(cairo, fd.getHeight());
    }

    static void setCairoRegion(int cairo, int rgn) {
        XRectangle rect = new XRectangle();
        OS.XClipBox(rgn, rect);
        Cairo.cairo_rectangle(cairo, rect.x, rect.y, rect.width, rect.height);
    }

    static void setCairoPatternColor(int pattern, int offset, Color c, int alpha) {
        XColor color = c.handle;
        double aa = (double)(alpha & 0xFF) / 255.0;
        double red = (double)(color.red & 0xFFFF) / 65535.0;
        double green = (double)(color.green & 0xFFFF) / 65535.0;
        double blue = (double)(color.blue & 0xFFFF) / 65535.0;
        Cairo.cairo_pattern_add_color_stop_rgba(pattern, offset, red, green, blue, aa);
    }

    void setCairoClip(int damageRgn, int clipRgn) {
        int cairo = this.data.cairo;
        Cairo.cairo_reset_clip(cairo);
        if (damageRgn != 0) {
            double[] matrix = new double[6];
            Cairo.cairo_get_matrix(cairo, matrix);
            Cairo.cairo_identity_matrix(cairo);
            GC.setCairoRegion(cairo, damageRgn);
            Cairo.cairo_clip(cairo);
            Cairo.cairo_set_matrix(cairo, matrix);
        }
        if (clipRgn != 0) {
            GC.setCairoRegion(cairo, clipRgn);
            Cairo.cairo_clip(cairo);
        }
    }

    void setClipping(int clipRgn) {
        int cairo = this.data.cairo;
        if (clipRgn == 0) {
            if (this.data.clipRgn != 0) {
                OS.XDestroyRegion(this.data.clipRgn);
                this.data.clipRgn = 0;
            }
            if (cairo != 0) {
                this.data.clippingTransform = null;
                this.setCairoClip(this.data.damageRgn, 0);
            } else if (this.data.damageRgn == 0) {
                OS.XSetClipMask(this.data.display, this.handle, 0);
            } else {
                OS.XSetRegion(this.data.display, this.handle, this.data.damageRgn);
            }
        } else {
            if (this.data.clipRgn == 0) {
                this.data.clipRgn = OS.XCreateRegion();
            }
            OS.XSubtractRegion(this.data.clipRgn, this.data.clipRgn, this.data.clipRgn);
            OS.XUnionRegion(clipRgn, this.data.clipRgn, this.data.clipRgn);
            if (cairo != 0) {
                if (this.data.clippingTransform == null) {
                    this.data.clippingTransform = new double[6];
                }
                Cairo.cairo_get_matrix(cairo, this.data.clippingTransform);
                this.setCairoClip(this.data.damageRgn, clipRgn);
            } else {
                int clipping = clipRgn;
                if (this.data.damageRgn != 0) {
                    clipping = OS.XCreateRegion();
                    OS.XUnionRegion(clipping, clipRgn, clipping);
                    OS.XIntersectRegion(clipping, this.data.damageRgn, clipping);
                }
                OS.XSetRegion(this.data.display, this.handle, clipping);
                if (clipping != clipRgn) {
                    OS.XDestroyRegion(clipping);
                }
            }
        }
    }

    public void setClipping(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        XRectangle rect = new XRectangle();
        rect.x = (short)x;
        rect.y = (short)y;
        rect.width = (short)Math.max(0, width);
        rect.height = (short)Math.max(0, height);
        int clipRgn = OS.XCreateRegion();
        OS.XUnionRectWithRegion(rect, clipRgn, clipRgn);
        this.setClipping(clipRgn);
        OS.XDestroyRegion(clipRgn);
    }

    public void setClipping(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path != null && path.isDisposed()) {
            SWT.error(44);
        }
        this.setClipping(0);
        if (path != null) {
            this.initCairo();
            int cairo = this.data.cairo;
            int copy = Cairo.cairo_copy_path(path.handle);
            if (copy == 0) {
                SWT.error(2);
            }
            Cairo.cairo_append_path(cairo, copy);
            Cairo.cairo_path_destroy(copy);
            Cairo.cairo_clip(cairo);
            Cairo.cairo_new_path(cairo);
        }
    }

    public void setClipping(Rectangle rect) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (rect == null) {
            this.setClipping(0);
        } else {
            this.setClipping(rect.x, rect.y, rect.width, rect.height);
        }
    }

    public void setClipping(Region region) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (region != null && region.isDisposed()) {
            SWT.error(5);
        }
        this.setClipping(region != null ? region.handle : 0);
    }

    public void setFillRule(int rule) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int mode = 0;
        int cairo_mode = 1;
        switch (rule) {
            case 2: {
                mode = 1;
                cairo_mode = 0;
                break;
            }
            case 1: {
                mode = 0;
                cairo_mode = 1;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        OS.XSetFillRule(this.data.display, this.handle, mode);
        int cairo = this.data.cairo;
        if (cairo != 0) {
            Cairo.cairo_set_fill_rule(cairo, cairo_mode);
        }
    }

    public void setFont(Font font) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        this.data.font = font != null ? font : this.data.device.systemFont;
        this.data.state &= 0xFFFFFFFB;
        if (this.data.renderTable != 0) {
            OS.XmRenderTableFree(this.data.renderTable);
        }
        this.data.renderTable = 0;
        this.data.textHeight = -1;
        this.data.textWidth = -1;
        this.data.stringHeight = -1;
        this.data.stringWidth = -1;
    }

    public void setForeground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.data.foreground = color.handle;
        this.data.foregroundPattern = null;
        this.data.state &= 0xFFFFFFFE;
        this.data.state |= 0x200;
    }

    public void setForegroundPattern(Pattern pattern) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pattern != null && pattern.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.cairo == 0 && pattern == null) {
            return;
        }
        this.initCairo();
        if (this.data.foregroundPattern == pattern) {
            return;
        }
        this.data.foregroundPattern = pattern;
        this.data.state &= 0xFFFFFFFE;
    }

    public void setInterpolation(int interpolation) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.cairo == 0 && interpolation == -1) {
            return;
        }
        switch (interpolation) {
            case -1: 
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initCairo();
        this.data.interpolation = interpolation;
    }

    public void setLineAttributes(LineAttributes attributes) {
        float miterLimit;
        int cap;
        int join;
        int lineStyle;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (attributes == null) {
            SWT.error(4);
        }
        int mask = 0;
        float lineWidth = attributes.width;
        if (lineWidth != this.data.lineWidth) {
            mask |= 0x840;
        }
        if ((lineStyle = attributes.style) != this.data.lineStyle) {
            mask |= 8;
            switch (lineStyle) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    if (attributes.dash != null) break;
                    lineStyle = 1;
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        if ((join = attributes.join) != this.data.lineJoin) {
            mask |= 0x20;
            switch (join) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        if ((cap = attributes.cap) != this.data.lineCap) {
            mask |= 0x10;
            switch (cap) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        float[] dashes = attributes.dash;
        float[] lineDashes = this.data.lineDashes;
        if (dashes != null && dashes.length > 0) {
            boolean changed = lineDashes == null || lineDashes.length != dashes.length;
            int i = 0;
            while (i < dashes.length) {
                float dash = dashes[i];
                if (dash <= 0.0f) {
                    SWT.error(5);
                }
                if (!changed && lineDashes[i] != dash) {
                    changed = true;
                }
                ++i;
            }
            if (changed) {
                float[] newDashes = new float[dashes.length];
                System.arraycopy(dashes, 0, newDashes, 0, dashes.length);
                dashes = newDashes;
                mask |= 8;
            } else {
                dashes = lineDashes;
            }
        } else if (lineDashes != null && lineDashes.length > 0) {
            mask |= 8;
        } else {
            dashes = lineDashes;
        }
        float dashOffset = attributes.dashOffset;
        if (dashOffset != this.data.lineDashesOffset) {
            mask |= 8;
        }
        if ((miterLimit = attributes.miterLimit) != this.data.lineMiterLimit) {
            mask |= 0x80;
        }
        this.initCairo();
        if (mask == 0) {
            return;
        }
        this.data.lineWidth = lineWidth;
        this.data.lineStyle = lineStyle;
        this.data.lineCap = cap;
        this.data.lineJoin = join;
        this.data.lineDashes = dashes;
        this.data.lineDashesOffset = dashOffset;
        this.data.lineMiterLimit = miterLimit;
        this.data.state &= ~mask;
    }

    public void setLineCap(int cap) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineCap == cap) {
            return;
        }
        switch (cap) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineCap = cap;
        this.data.state &= 0xFFFFFFEF;
    }

    public void setLineDash(int[] dashes) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        float[] lineDashes = this.data.lineDashes;
        if (dashes != null && dashes.length > 0) {
            boolean changed = this.data.lineStyle != 6 || lineDashes == null || lineDashes.length != dashes.length;
            int i = 0;
            while (i < dashes.length) {
                int dash = dashes[i];
                if (dash <= 0) {
                    SWT.error(5);
                }
                if (!changed && lineDashes[i] != (float)dash) {
                    changed = true;
                }
                ++i;
            }
            if (!changed) {
                return;
            }
            this.data.lineDashes = new float[dashes.length];
            i = 0;
            while (i < dashes.length) {
                this.data.lineDashes[i] = dashes[i];
                ++i;
            }
            this.data.lineStyle = 6;
        } else {
            if (this.data.lineStyle == 1 && (lineDashes == null || lineDashes.length == 0)) {
                return;
            }
            this.data.lineDashes = null;
            this.data.lineStyle = 1;
        }
        this.data.state &= 0xFFFFFFF7;
    }

    public void setLineJoin(int join) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineJoin == join) {
            return;
        }
        switch (join) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineJoin = join;
        this.data.state &= 0xFFFFFFDF;
    }

    public void setLineStyle(int lineStyle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineStyle == lineStyle) {
            return;
        }
        switch (lineStyle) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                if (this.data.lineDashes != null) break;
                lineStyle = 1;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineStyle = lineStyle;
        this.data.state &= 0xFFFFFFF7;
    }

    public void setLineWidth(int lineWidth) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineWidth == (float)lineWidth) {
            return;
        }
        this.data.lineWidth = lineWidth;
        this.data.state &= 0xFFFFF7BF;
    }

    void setString(String string) {
        if (string == this.data.string) {
            return;
        }
        if (this.data.xmString != 0) {
            OS.XmStringFree(this.data.xmString);
        }
        byte[] buffer = Converter.wcsToMbcs(this.getCodePage(), string, true);
        this.data.xmString = OS.XmStringCreate(buffer, OS.XmFONTLIST_DEFAULT_TAG);
        this.data.string = string;
        this.data.stringHeight = -1;
        this.data.stringWidth = -1;
    }

    void setText(String string, int flags) {
        if (this.data.renderTable == 0) {
            this.createRenderTable();
        }
        if (string == this.data.text && (flags & 0xFFFFFFFE) == (this.data.drawFlags & 0xFFFFFFFE)) {
            return;
        }
        if (this.data.xmText != 0) {
            OS.XmStringFree(this.data.xmText);
        }
        if (this.data.xmMnemonic != 0) {
            OS.XmStringFree(this.data.xmMnemonic);
        }
        char mnemonic = '\u0000';
        int tableLength = 0;
        Device device = this.data.device;
        int[] parseTable = new int[2];
        char[] text = new char[string.length()];
        string.getChars(0, text.length, text, 0);
        if ((flags & 2) != 0) {
            parseTable[tableLength++] = device.crMapping;
        }
        if ((flags & 4) != 0) {
            parseTable[tableLength++] = device.tabMapping;
        }
        if ((flags & 8) != 0) {
            mnemonic = this.fixMnemonic(text);
        }
        String codePage = this.getCodePage();
        byte[] buffer = Converter.wcsToMbcs(codePage, text, true);
        this.data.xmText = OS.XmStringParseText(buffer, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, parseTable, tableLength, 0);
        if (mnemonic != '\u0000') {
            byte[] buffer1 = Converter.wcsToMbcs(codePage, new char[]{mnemonic}, true);
            this.data.xmMnemonic = OS.XmStringCreate(buffer1, OS.XmFONTLIST_DEFAULT_TAG);
        } else {
            this.data.xmMnemonic = 0;
        }
        this.data.text = string;
        this.data.textHeight = -1;
        this.data.textWidth = -1;
        this.data.drawFlags = flags;
    }

    public void setTextAntialias(int antialias) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.cairo == 0 && antialias == -1) {
            return;
        }
        int mode = 0;
        switch (antialias) {
            case -1: {
                mode = 0;
                break;
            }
            case 0: {
                mode = 1;
                break;
            }
            case 1: {
                mode = 2;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initCairo();
        int options = Cairo.cairo_font_options_create();
        Cairo.cairo_font_options_set_antialias(options, mode);
        Cairo.cairo_set_font_options(this.data.cairo, options);
        Cairo.cairo_font_options_destroy(options);
    }

    public void setTransform(Transform transform) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (transform != null && transform.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.cairo == 0 && transform == null) {
            return;
        }
        this.initCairo();
        int cairo = this.data.cairo;
        if (transform != null) {
            Cairo.cairo_set_matrix(cairo, transform.handle);
        } else {
            Cairo.cairo_identity_matrix(cairo);
        }
        this.data.state &= 0xFFFFF7FF;
    }

    public void setXORMode(boolean xor) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        OS.XSetFunction(this.data.display, this.handle, xor ? 6 : 3);
    }

    public Point stringExtent(String string) {
        int height;
        int width;
        int cairo;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if ((cairo = this.data.cairo) != 0) {
            this.checkGC(4);
            byte[] buffer = Converter.wcsToMbcs(null, string, true);
            cairo_font_extents_t font_extents = new cairo_font_extents_t();
            Cairo.cairo_font_extents(cairo, font_extents);
            cairo_text_extents_t extents = new cairo_text_extents_t();
            Cairo.cairo_text_extents(cairo, buffer, extents);
            return new Point((int)extents.width, (int)font_extents.height);
        }
        this.setString(string);
        this.checkGC(4);
        if (this.data.stringWidth != -1) {
            return new Point(this.data.stringWidth, this.data.stringHeight);
        }
        if (string.length() == 0) {
            width = 0;
            height = this.getFontHeight();
        } else {
            int fontList = this.data.font.handle;
            int xmString = this.data.xmString;
            width = OS.XmStringWidth(fontList, xmString);
            height = OS.XmStringHeight(fontList, xmString);
        }
        this.data.stringWidth = width;
        this.data.stringHeight = height;
        return new Point(this.data.stringWidth, this.data.stringHeight);
    }

    public Point textExtent(String string) {
        return this.textExtent(string, 6);
    }

    public Point textExtent(String string, int flags) {
        int height;
        int width;
        int cairo;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if ((cairo = this.data.cairo) != 0) {
            this.checkGC(4);
            byte[] buffer = Converter.wcsToMbcs(null, string, true);
            cairo_font_extents_t font_extents = new cairo_font_extents_t();
            Cairo.cairo_font_extents(cairo, font_extents);
            cairo_text_extents_t extents = new cairo_text_extents_t();
            Cairo.cairo_text_extents(cairo, buffer, extents);
            return new Point((int)extents.width, (int)font_extents.height);
        }
        this.setText(string, flags);
        this.checkGC(4);
        if (this.data.textWidth != -1) {
            return new Point(this.data.textWidth, this.data.textHeight);
        }
        if (string.length() == 0) {
            width = 0;
            height = this.getFontHeight();
        } else {
            int fontList = this.data.font.handle;
            int xmText = this.data.xmText;
            width = OS.XmStringWidth(fontList, xmText);
            height = OS.XmStringHeight(fontList, xmText);
        }
        this.data.textWidth = width;
        this.data.textHeight = height;
        return new Point(this.data.textWidth, this.data.textHeight);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "GC {*DISPOSED*}";
        }
        return "GC {" + this.handle + "}";
    }
}

