/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XClientMessageEvent;
import org.eclipse.swt.internal.motif.XConfigureEvent;
import org.eclipse.swt.internal.motif.XFocusChangeEvent;
import org.eclipse.swt.internal.motif.XSizeHints;
import org.eclipse.swt.internal.motif.XWindowAttributes;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.TypedListener;

public class Shell
extends Decorations {
    int shellHandle;
    int focusProxy;
    boolean reparented;
    boolean realized;
    boolean moved;
    boolean resized;
    boolean opened;
    boolean modified;
    boolean center;
    int oldX;
    int oldY;
    int oldWidth;
    int oldHeight;
    Control lastActive;
    static final int MAXIMUM_TRIM = 128;
    static final byte[] WM_DELETE_WINDOW = Converter.wcsToMbcs(null, "WM_DELETE_WINDOW\u0000");
    static final byte[] _NET_WM_STATE = Converter.wcsToMbcs(null, "_NET_WM_STATE\u0000");
    static final byte[] _NET_WM_STATE_MAXIMIZED_VERT = Converter.wcsToMbcs(null, "_NET_WM_STATE_MAXIMIZED_VERT\u0000");
    static final byte[] _NET_WM_STATE_MAXIMIZED_HORZ = Converter.wcsToMbcs(null, "_NET_WM_STATE_MAXIMIZED_HORZ\u0000");
    static final byte[] _NET_WM_STATE_FULLSCREEN = Converter.wcsToMbcs(null, "_NET_WM_STATE_FULLSCREEN\u0000");

    public Shell() {
        this((Display)null);
    }

    public Shell(int style) {
        this((Display)null, style);
    }

    public Shell(Display display) {
        this(display, 1264);
    }

    public Shell(Display display, int style) {
        this(display, null, style, 0, false);
    }

    Shell(Display display, Shell parent, int style, int handle, boolean embedded) {
        this.checkSubclass();
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        if (parent != null && parent.isDisposed()) {
            this.error(5);
        }
        this.center = parent != null && (style & 0x10000000) != 0;
        this.style = Shell.checkStyle(parent, style);
        this.parent = parent;
        this.display = display;
        if (handle != 0) {
            if (embedded) {
                this.handle = handle;
            } else {
                this.shellHandle = handle;
                this.state |= 0x2000;
            }
        }
        this.createWidget(0);
    }

    public Shell(Shell parent) {
        this(parent, 2144);
    }

    public Shell(Shell parent, int style) {
        this(parent != null ? parent.display : null, parent, style, 0, false);
    }

    static int checkStyle(Shell parent, int style) {
        style = Decorations.checkStyle(style);
        if (((style &= 0xBFFFFFFF) & 0x4000) != 0) {
            style &= 0xFFFFFB0F;
        }
        int mask = 229376;
        if ((style & 0x10000000) != 0) {
            style &= 0xEFFFFFFF;
            if (((style |= parent == null ? 1264 : 2144) & mask) == 0) {
                style |= parent == null ? 65536 : 32768;
            }
        }
        int bits = style & ~mask;
        if ((style & 0x20000) != 0) {
            return bits | 0x20000;
        }
        if ((style & 0x10000) != 0) {
            return bits | 0x10000;
        }
        if ((style & 0x8000) != 0) {
            return bits | 0x8000;
        }
        return bits;
    }

    public static Shell motif_new(Display display, int handle) {
        return new Shell(display, null, 8, handle, true);
    }

    public static Shell internal_new(Display display, int handle) {
        return new Shell(display, null, 8, handle, false);
    }

    public void addShellListener(ShellListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(26, typedListener);
        this.addListener(21, typedListener);
        this.addListener(27, typedListener);
        this.addListener(19, typedListener);
        this.addListener(20, typedListener);
    }

    /*
     * Unable to fully structure code
     */
    void adjustTrim() {
        if (this.display.ignoreTrim) {
            return;
        }
        if (OS.XtIsSubclass(this.shellHandle, OS.overrideShellWidgetClass())) {
            return;
        }
        v0 = new int[2];
        v0[0] = OS.XmNoverrideRedirect;
        argList = v0;
        OS.XtGetValues(this.shellHandle, argList, argList.length / 2);
        if (argList[1] != 0) {
            return;
        }
        shellWindow = OS.XtWindow(this.shellHandle);
        if (shellWindow == 0) {
            return;
        }
        xDisplay = OS.XtDisplay(this.shellHandle);
        if (xDisplay == 0) {
            return;
        }
        unused = new int[1];
        rootWindow = new int[1];
        parent = new int[1];
        ptr = new int[1];
        trimWindow = shellWindow;
        OS.XQueryTree(xDisplay, trimWindow, rootWindow, parent, ptr, unused);
        if (ptr[0] != 0) {
            OS.XFree(ptr[0]);
        }
        if (parent[0] != 0) ** GOTO lbl37
        return;
lbl-1000:
        // 1 sources

        {
            trimWindow = parent[0];
            OS.XQueryTree(xDisplay, trimWindow, unused, parent, ptr, unused);
            if (ptr[0] != 0) {
                OS.XFree(ptr[0]);
            }
            if (parent[0] != 0) continue;
            return;
lbl37:
            // 2 sources

            ** while (parent[0] != rootWindow[0])
        }
lbl38:
        // 1 sources

        if (shellWindow == trimWindow) {
            return;
        }
        trimBorder = new int[1];
        trimWidth = new int[1];
        trimHeight = new int[1];
        trimX = new int[1];
        trimY = new int[1];
        OS.XGetGeometry(xDisplay, trimWindow, unused, trimX, trimY, trimWidth, trimHeight, trimBorder, unused);
        shellBorder = new int[1];
        shellWidth = new int[1];
        shellHeight = new int[1];
        OS.XGetGeometry(xDisplay, shellWindow, unused, unused, unused, shellWidth, shellHeight, shellBorder, unused);
        inner_x = new short[1];
        inner_y = new short[1];
        OS.XtTranslateCoords(this.shellHandle, (short)0, (short)0, inner_x, inner_y);
        width = trimWidth[0] + trimBorder[0] * 2 - (shellWidth[0] + shellBorder[0] * 2);
        height = trimHeight[0] + trimBorder[0] * 2 - (shellHeight[0] + shellBorder[0] * 2);
        leftInset = inner_x[0] - trimX[0];
        topInset = inner_y[0] - trimY[0];
        if (width > 128 || height > 128) {
            this.display.ignoreTrim = true;
            return;
        }
        hasTitle = false;
        hasResize = false;
        hasBorder = false;
        if ((this.style & 8) == 0) {
            hasTitle = (this.style & 1248) != 0;
            hasResize = (this.style & 16) != 0;
            v1 = hasBorder = (this.style & 2048) != 0;
        }
        if (hasTitle) {
            if (hasResize) {
                this.display.leftTitleResizeWidth = leftInset;
                this.display.rightTitleResizeWidth = width - leftInset;
                this.display.topTitleResizeHeight = topInset;
                this.display.bottomTitleResizeHeight = height - topInset;
                return;
            }
            if (hasBorder) {
                this.display.leftTitleBorderWidth = leftInset;
                this.display.rightTitleBorderWidth = width - leftInset;
                this.display.topTitleBorderHeight = topInset;
                this.display.bottomTitleBorderHeight = height - topInset;
                return;
            }
            this.display.leftTitleWidth = leftInset;
            this.display.rightTitleWidth = width - leftInset;
            this.display.topTitleHeight = topInset;
            this.display.bottomTitleHeight = height - topInset;
            return;
        }
        if (hasResize) {
            this.display.leftResizeWidth = leftInset;
            this.display.rightResizeWidth = width - leftInset;
            this.display.topResizeHeight = topInset;
            this.display.bottomResizeHeight = height - topInset;
            return;
        }
        if (hasBorder) {
            this.display.leftBorderWidth = leftInset;
            this.display.rightBorderWidth = width - leftInset;
            this.display.topBorderHeight = topInset;
            this.display.bottomBorderHeight = height - topInset;
            return;
        }
    }

    int borderHandle() {
        return this.handle;
    }

    void bringToTop(boolean force) {
        int shellWindow;
        if (this.minimized) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        int xDisplay = OS.XtDisplay(this.shellHandle);
        if (xDisplay == 0) {
            return;
        }
        int xWindow = OS.XtWindow(this.focusProxy != 0 ? this.focusProxy : this.shellHandle);
        if (xWindow == 0) {
            return;
        }
        if (!force) {
            int[] buffer1 = new int[1];
            int[] buffer2 = new int[1];
            OS.XGetInputFocus(xDisplay, buffer1, buffer2);
            if (buffer1[0] == 0) {
                return;
            }
            int handle = OS.XtWindowToWidget(xDisplay, buffer1[0]);
            if (handle == 0) {
                return;
            }
        }
        if ((shellWindow = OS.XtWindow(this.shellHandle)) != 0) {
            OS.XRaiseWindow(xDisplay, shellWindow);
        }
        OS.XSetInputFocus(xDisplay, xWindow, 2, 0);
    }

    void center() {
        if (this.parent == null) {
            return;
        }
        Rectangle rect = this.getBounds();
        Rectangle parentRect = this.display.map((Control)this.parent, null, this.parent.getClientArea());
        int x = Math.max(parentRect.x, parentRect.x + (parentRect.width - rect.width) / 2);
        int y = Math.max(parentRect.y, parentRect.y + (parentRect.height - rect.height) / 2);
        Rectangle monitorRect = this.parent.getMonitor().getClientArea();
        x = x + rect.width > monitorRect.x + monitorRect.width ? Math.max(monitorRect.x, monitorRect.x + monitorRect.width - rect.width) : Math.max(x, monitorRect.x);
        y = y + rect.height > monitorRect.y + monitorRect.height ? Math.max(monitorRect.y, monitorRect.y + monitorRect.height - rect.height) : Math.max(y, monitorRect.y);
        this.setLocation(x, y);
    }

    void checkOpen() {
        if (!this.opened) {
            this.resized = false;
        }
    }

    public void close() {
        this.checkWidget();
        this.closeWidget();
    }

    void closeWidget() {
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit && !this.isDisposed()) {
            this.dispose();
        }
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        Rectangle trim = super.computeTrim(x, y, width, height);
        int border = 0;
        if ((this.style & 0xCF8) == 0) {
            int[] nArray = new int[2];
            nArray[0] = OS.XmNborderWidth;
            int[] argList = nArray;
            OS.XtGetValues(this.handle, argList, argList.length / 2);
            border = argList[1];
        }
        trim.x -= this.trimLeft() + border;
        trim.y -= this.trimTop() + border;
        trim.width += this.trimWidth() + border * 2;
        trim.height += this.trimHeight() + this.imeHeight() + border * 2;
        return trim;
    }

    void createFocusProxy() {
        if (this.focusProxy != 0) {
            return;
        }
        int[] argList = new int[]{OS.XmNx, -1, OS.XmNy, -1, OS.XmNwidth, 1, OS.XmNheight, 1};
        this.focusProxy = OS.XmCreateDrawingArea(this.scrolledHandle, null, argList, argList.length / 2);
        if (this.focusProxy == 0) {
            this.error(2);
        }
        OS.XtSetMappedWhenManaged(this.focusProxy, false);
        OS.XtManageChild(this.focusProxy);
        OS.XtSetMappedWhenManaged(this.focusProxy, true);
    }

    void createHandle(int index) {
        this.state |= 2;
        if (this.shellHandle == 0) {
            int xDisplay;
            int decorations = 0;
            if ((this.style & 8) == 0) {
                if ((this.style & 0x80) != 0) {
                    decorations |= 0x20;
                }
                if ((this.style & 0x400) != 0) {
                    decorations |= 0x40;
                }
                if ((this.style & 0x10) != 0) {
                    decorations |= 4;
                }
                if ((this.style & 0x800) != 0) {
                    decorations |= 2;
                }
                if ((this.style & 0x40) != 0) {
                    decorations |= 0x10;
                }
                if ((this.style & 0x20) != 0) {
                    decorations |= 8;
                }
                if ((this.style & 0x10) != 0) {
                    decorations |= 2;
                }
            }
            int inputMode = 0;
            if ((this.style & 0x8000) != 0) {
                inputMode = 1;
            }
            if ((this.style & 0x10000) != 0) {
                inputMode = 3;
            }
            if ((this.style & 0x20000) != 0) {
                inputMode = 2;
            }
            byte[] byArray = new byte[4];
            byArray[0] = 32;
            byte[] buffer = byArray;
            int ptr = OS.XtMalloc(buffer.length);
            OS.memmove(ptr, buffer, buffer.length);
            int[] argList1 = new int[]{OS.XmNmwmInputMode, inputMode, OS.XmNmwmDecorations, decorations, OS.XmNoverrideRedirect, (this.style & 0x4000) != 0 ? 1 : 0, OS.XmNtitle, ptr};
            if (this.isUndecorated()) {
                this.reparented = true;
            }
            byte[] appClass = this.display.appClass;
            if (this.parent == null && (this.style & 0x4000) == 0 && inputMode != 3) {
                xDisplay = this.display.xDisplay;
                int widgetClass = OS.applicationShellWidgetClass();
                this.shellHandle = OS.XtAppCreateShell(this.display.appName, appClass, widgetClass, xDisplay, argList1, argList1.length / 2);
            } else {
                int widgetClass = OS.transientShellWidgetClass();
                int parentHandle = this.display.shellHandle;
                if (this.parent != null) {
                    parentHandle = this.parent.handle;
                }
                this.shellHandle = OS.XtCreatePopupShell(appClass, widgetClass, parentHandle, argList1, argList1.length / 2);
            }
            OS.XtFree(ptr);
            if (this.shellHandle == 0) {
                this.error(2);
            }
            if (this.handle != 0) {
                OS.XtSetMappedWhenManaged(this.shellHandle, false);
                OS.XtRealizeWidget(this.shellHandle);
                OS.XtSetMappedWhenManaged(this.shellHandle, true);
                xDisplay = this.display.xDisplay;
                int xWindow = OS.XtWindow(this.shellHandle);
                if (xWindow == 0) {
                    this.error(2);
                }
                OS.XReparentWindow(xDisplay, xWindow, this.handle, 0, 0);
                this.handle = 0;
            }
            this.createHandle(index, this.shellHandle, true);
        } else {
            int[] buffer = new int[1];
            int[] nArray = new int[4];
            nArray[0] = OS.XmNchildren;
            nArray[2] = OS.XmNnumChildren;
            int[] argList = nArray;
            OS.XtGetValues(this.shellHandle, argList, argList.length / 2);
            if (argList[3] < 1) {
                this.error(2);
            }
            OS.memmove(buffer, argList[1], 4);
            this.scrolledHandle = buffer[0];
            if (this.scrolledHandle == 0) {
                this.error(2);
            }
            argList[3] = 0;
            argList[1] = 0;
            OS.XtGetValues(this.scrolledHandle, argList, argList.length / 2);
            if (argList[3] < 4) {
                this.error(2);
            }
            OS.memmove(buffer, argList[1] + (argList[3] - 1) * 4, 4);
            this.handle = buffer[0];
            if (this.handle == 0) {
                this.error(2);
            }
        }
        if ((this.style & 0xCF8) == 0) {
            int[] argList2 = new int[]{OS.XmNborderWidth, 1};
            OS.XtSetValues(this.handle, argList2, argList2.length / 2);
        }
        if ((this.style & 0x4000) == 0) {
            int[] nArray = new int[2];
            nArray[0] = OS.XmNtraversalOn;
            int[] argList3 = nArray;
            int textHandle = OS.XmCreateTextField(this.handle, null, argList3, argList3.length / 2);
            if (textHandle == 0) {
                this.error(2);
            }
        }
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.shellHandle);
    }

    void destroyWidget() {
        if (OS.XtIsRealized(this.shellHandle)) {
            if (OS.XtIsTopLevelShell(this.shellHandle)) {
                OS.XtUnmapWidget(this.shellHandle);
            } else {
                OS.XtPopdown(this.shellHandle);
            }
        }
        super.destroyWidget();
    }

    public void dispose() {
        Shell activeShell;
        if (this.isDisposed()) {
            return;
        }
        if (this.parent != null && (activeShell = this.display.getActiveShell()) == this) {
            Shell shell = this.parent.getShell();
            shell.bringToTop(false);
        }
        super.dispose();
    }

    void enableWidget(boolean enabled) {
        super.enableWidget(enabled);
        this.enableHandle(enabled, this.shellHandle);
    }

    Control findBackgroundControl() {
        return (this.state & 0x10) != 0 || this.backgroundImage != null ? this : null;
    }

    Composite findDeferredControl() {
        return this.layoutCount > 0 ? this : null;
    }

    public void forceActive() {
        this.checkWidget();
        this.bringToTop(true);
    }

    public int getAlpha() {
        this.checkWidget();
        return 255;
    }

    public int getBorderWidth() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNborderWidth;
        int[] argList = nArray;
        OS.XtGetValues(this.scrolledHandle, argList, argList.length / 2);
        return argList[1];
    }

    public Rectangle getBounds() {
        this.checkWidget();
        Rectangle bounds = new Rectangle(0, 0, 0, 0);
        this.getBounds(null, null, bounds);
        return bounds;
    }

    void getBounds(Point location, Point size, Rectangle bounds) {
        int x = 0;
        int y = 0;
        if (location != null || bounds != null) {
            if (OS.XtIsRealized(this.shellHandle)) {
                int xDisplay = OS.XtDisplay(this.shellHandle);
                int xWindow = OS.XtWindow(this.shellHandle);
                int[] root_x = new int[1];
                int[] root_y = new int[1];
                int[] child = new int[1];
                OS.XSync(xDisplay, false);
                OS.XTranslateCoordinates(xDisplay, xWindow, OS.XDefaultRootWindow(xDisplay), 0, 0, root_x, root_y, child);
                x = root_x[0];
                y = root_y[0];
            } else {
                short[] root_x = new short[1];
                short[] root_y = new short[1];
                OS.XtTranslateCoords(this.shellHandle, (short)0, (short)0, root_x, root_y);
                x = root_x[0];
                y = root_y[0];
            }
            if (this.reparented) {
                x -= this.trimLeft();
                y -= this.trimTop();
            }
        }
        int width = 0;
        int height = 0;
        if (size != null || bounds != null) {
            int[] nArray = new int[6];
            nArray[0] = OS.XmNwidth;
            nArray[2] = OS.XmNheight;
            nArray[4] = OS.XmNborderWidth;
            int[] argList = nArray;
            OS.XtGetValues(this.shellHandle, argList, argList.length / 2);
            int border = argList[5];
            int trimWidth = this.trimWidth();
            int trimHeight = this.trimHeight();
            width = argList[1] + trimWidth + border * 2;
            height = argList[3] + trimHeight + border * 2;
        }
        if (location != null) {
            location.x = x;
            location.y = y;
        }
        if (size != null) {
            size.x = width;
            size.y = height;
        }
        if (bounds != null) {
            bounds.x = x;
            bounds.y = y;
            bounds.width = width;
            bounds.height = height;
        }
    }

    public boolean getFullScreen() {
        int property;
        this.checkWidget();
        int xDisplay = OS.XtDisplay(this.shellHandle);
        int xWindow = OS.XtWindow(this.shellHandle);
        if (xWindow != 0 && (property = OS.XInternAtom(xDisplay, _NET_WM_STATE, true)) != 0) {
            int fullScreen;
            int[] type = new int[1];
            int[] format = new int[1];
            int[] nitems = new int[1];
            int[] bytes_after = new int[1];
            int[] atoms = new int[1];
            OS.XGetWindowProperty(xDisplay, xWindow, property, 0, Integer.MAX_VALUE, false, 4, type, format, nitems, bytes_after, atoms);
            boolean result = false;
            if (type[0] != 0 && (fullScreen = OS.XInternAtom(xDisplay, _NET_WM_STATE_FULLSCREEN, true)) != 0) {
                int[] atom = new int[1];
                int i = 0;
                while (i < nitems[0]) {
                    OS.memmove(atom, atoms[0] + i * 4, 4);
                    if (atom[0] == fullScreen) {
                        result = true;
                        break;
                    }
                    ++i;
                }
            }
            if (atoms[0] != 0) {
                OS.XFree(atoms[0]);
            }
            return result;
        }
        return false;
    }

    public int getImeInputMode() {
        this.checkWidget();
        return 0;
    }

    public Point getLocation() {
        this.checkWidget();
        Point location = new Point(0, 0);
        this.getBounds(location, null, null);
        return location;
    }

    public boolean getMaximized() {
        int property;
        this.checkWidget();
        int xDisplay = OS.XtDisplay(this.shellHandle);
        int xWindow = OS.XtWindow(this.shellHandle);
        if (xWindow != 0 && (property = OS.XInternAtom(xDisplay, _NET_WM_STATE, true)) != 0) {
            int[] type = new int[1];
            int[] format = new int[1];
            int[] nitems = new int[1];
            int[] bytes_after = new int[1];
            int[] atoms = new int[1];
            OS.XGetWindowProperty(xDisplay, xWindow, property, 0, Integer.MAX_VALUE, false, 4, type, format, nitems, bytes_after, atoms);
            boolean result = false;
            if (type[0] != 0) {
                int maximizedHorz = OS.XInternAtom(xDisplay, _NET_WM_STATE_MAXIMIZED_HORZ, true);
                int maximizedVert = OS.XInternAtom(xDisplay, _NET_WM_STATE_MAXIMIZED_VERT, true);
                if (maximizedHorz != 0 && maximizedVert != 0) {
                    int[] atom = new int[1];
                    int i = 0;
                    while (i < nitems[0]) {
                        OS.memmove(atom, atoms[0] + i * 4, 4);
                        if (atom[0] == maximizedHorz || atom[0] == maximizedVert) {
                            result = true;
                            break;
                        }
                        ++i;
                    }
                }
            }
            if (atoms[0] != 0) {
                OS.XFree(atoms[0]);
            }
            return result;
        }
        return super.getMaximized();
    }

    public Point getMinimumSize() {
        this.checkWidget();
        int[] nArray = new int[4];
        nArray[0] = OS.XmNminWidth;
        nArray[2] = OS.XmNminHeight;
        int[] argList = nArray;
        OS.XtGetValues(this.shellHandle, argList, argList.length / 2);
        int width = Math.max(1, Math.max(0, argList[1]) + this.trimWidth());
        int height = Math.max(1, Math.max(0, argList[3]) + this.trimHeight());
        return new Point(width, height);
    }

    public boolean getModified() {
        this.checkWidget();
        return this.modified;
    }

    public Region getRegion() {
        this.checkWidget();
        return this.region;
    }

    public Shell getShell() {
        this.checkWidget();
        return this;
    }

    public Shell[] getShells() {
        this.checkWidget();
        int count = 0;
        Shell[] shells = this.display.getShells();
        int i = 0;
        while (i < shells.length) {
            Composite shell = shells[i];
            while ((shell = shell.parent) != null && shell != this) {
            }
            if (shell == this) {
                ++count;
            }
            ++i;
        }
        int index = 0;
        Shell[] result = new Shell[count];
        int i2 = 0;
        while (i2 < shells.length) {
            Composite shell = shells[i2];
            while ((shell = shell.parent) != null && shell != this) {
            }
            if (shell == this) {
                result[index++] = shells[i2];
            }
            ++i2;
        }
        return result;
    }

    public Point getSize() {
        this.checkWidget();
        Point size = new Point(0, 0);
        this.getBounds(null, size, null);
        return size;
    }

    public boolean getVisible() {
        this.checkWidget();
        if (!OS.XtIsRealized(this.handle)) {
            return false;
        }
        int xDisplay = OS.XtDisplay(this.handle);
        if (xDisplay == 0) {
            return false;
        }
        int xWindow = OS.XtWindow(this.handle);
        if (xWindow == 0) {
            return false;
        }
        XWindowAttributes attributes = new XWindowAttributes();
        OS.XGetWindowAttributes(xDisplay, xWindow, attributes);
        if (attributes.map_state == 2 && this.reparented) {
            return true;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNmappedWhenManaged;
        int[] argList = nArray;
        OS.XtGetValues(this.shellHandle, argList, argList.length / 2);
        return this.minimized && attributes.map_state == 1 && argList[1] != 0;
    }

    boolean hasBorder() {
        return false;
    }

    void hookEvents() {
        super.hookEvents();
        int windowProc = this.display.windowProc;
        OS.XtInsertEventHandler(this.shellHandle, 131072, false, windowProc, 27, 1);
        if (OS.XtIsSubclass(this.shellHandle, OS.overrideShellWidgetClass())) {
            return;
        }
        OS.XtInsertEventHandler(this.shellHandle, 0x200000, false, windowProc, 5, 1);
        int[] argList = new int[]{OS.XmNdeleteResponse, 2};
        OS.XtSetValues(this.shellHandle, argList, argList.length / 2);
        int xDisplay = OS.XtDisplay(this.shellHandle);
        if (xDisplay != 0) {
            int atom = OS.XmInternAtom(xDisplay, WM_DELETE_WINDOW, false);
            OS.XmAddWMProtocolCallback(this.shellHandle, atom, windowProc, 30);
        }
    }

    int imeHeight() {
        if (!OS.IsDBLocale) {
            return 0;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNheight;
        int[] argList1 = nArray;
        OS.XtGetValues(this.shellHandle, argList1, argList1.length / 2);
        int[] nArray2 = new int[2];
        nArray2[0] = OS.XmNheight;
        int[] argList2 = nArray2;
        OS.XtGetValues(this.scrolledHandle, argList2, argList2.length / 2);
        return argList1[1] - argList2[1];
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled();
    }

    boolean isModal() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNmwmInputMode;
        int[] argList = nArray;
        OS.XtGetValues(this.shellHandle, argList, argList.length / 2);
        return argList[1] != -1 && argList[1] != 0;
    }

    boolean isUndecorated() {
        return (this.style & 0xCF0) == 0 || (this.style & 0x4008) != 0;
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    void manageChildren() {
        if ((this.state & 0x2000) != 0) {
            return;
        }
        OS.XtSetMappedWhenManaged(this.shellHandle, false);
        super.manageChildren();
        int width = 0;
        int height = 0;
        if (OS.IsLinux) {
            Monitor monitor = this.getMonitor();
            Rectangle rect = monitor.getClientArea();
            width = rect.width * 5 / 8;
            height = rect.height * 5 / 8;
        } else {
            int xDisplay = OS.XtDisplay(this.shellHandle);
            if (xDisplay == 0) {
                return;
            }
            width = OS.XDisplayWidth(xDisplay, OS.XDefaultScreen(xDisplay)) * 5 / 8;
            height = OS.XDisplayHeight(xDisplay, OS.XDefaultScreen(xDisplay)) * 5 / 8;
        }
        OS.XtResizeWidget(this.shellHandle, width, height, 0);
    }

    public void open() {
        this.checkWidget();
        this.bringToTop(false);
        this.setVisible(true);
        if (this.isDisposed()) {
            return;
        }
        if (!this.restoreFocus() && !this.traverseGroup(true)) {
            this.setFocus();
        }
    }

    public boolean print(GC gc) {
        this.checkWidget();
        if (gc == null) {
            this.error(4);
        }
        if (gc.isDisposed()) {
            this.error(5);
        }
        return false;
    }

    void propagateWidget(boolean enabled) {
        super.propagateWidget(enabled);
        int xCursor = this.cursor != null && !enabled ? this.cursor.handle : 0;
        this.propagateHandle(enabled, this.shellHandle, xCursor);
    }

    void realizeWidget() {
        if (this.realized) {
            return;
        }
        OS.XtRealizeWidget(this.shellHandle);
        this.realizeChildren();
        this.realized = true;
    }

    void register() {
        super.register();
        this.display.addWidget(this.shellHandle, this);
    }

    void releaseChildren(boolean destroy) {
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (shell != null && !shell.isDisposed()) {
                shell.release(false);
            }
            ++i;
        }
        super.releaseChildren(destroy);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.shellHandle = 0;
    }

    void releaseParent() {
    }

    void releaseWidget() {
        super.releaseWidget();
        this.lastActive = null;
    }

    public void removeShellListener(ShellListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(26, listener);
        this.eventTable.unhook(21, listener);
        this.eventTable.unhook(27, listener);
        this.eventTable.unhook(19, listener);
        this.eventTable.unhook(20, listener);
    }

    public void setActive() {
        this.checkWidget();
        this.bringToTop(false);
    }

    void setActiveControl(Control control) {
        if (control != null && control.isDisposed()) {
            control = null;
        }
        if (this.lastActive != null && this.lastActive.isDisposed()) {
            this.lastActive = null;
        }
        if (this.lastActive == control) {
            return;
        }
        Control[] activate = control == null ? new Control[]{} : control.getPath();
        Control[] deactivate = this.lastActive == null ? new Control[]{} : this.lastActive.getPath();
        this.lastActive = control;
        int index = 0;
        int length = Math.min(activate.length, deactivate.length);
        while (index < length) {
            if (activate[index] != deactivate[index]) break;
            ++index;
        }
        int i = deactivate.length - 1;
        while (i >= index) {
            if (!deactivate[i].isDisposed()) {
                if (this.display.postFocusOut) {
                    deactivate[i].postEvent(27);
                } else {
                    deactivate[i].sendEvent(27);
                }
            }
            --i;
        }
        i = activate.length - 1;
        while (i >= index) {
            if (!activate[i].isDisposed()) {
                activate[i].sendEvent(26);
            }
            --i;
        }
    }

    public void setAlpha(int alpha) {
        this.checkWidget();
    }

    public void setImeInputMode(int mode) {
        this.checkWidget();
    }

    boolean setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        if (this.getMaximized()) {
            boolean sameExtent;
            Rectangle rect = this.getBounds();
            boolean sameOrigin = !move || rect.x == x && rect.y == y;
            boolean bl = sameExtent = !resize || rect.width == width && rect.height == height;
            if (sameOrigin && sameExtent) {
                return false;
            }
        }
        if (resize) {
            int[] nArray = new int[4];
            nArray[0] = OS.XmNminWidth;
            nArray[2] = OS.XmNminHeight;
            int[] argList = nArray;
            OS.XtGetValues(this.shellHandle, argList, argList.length / 2);
            width = Math.max(1, Math.max(argList[1], width - this.trimWidth()));
            height = Math.max(1, Math.max(argList[3], height - this.trimHeight()));
            this.updateResizable(width, height);
        }
        if (move && resize) {
            OS.XtConfigureWidget(this.shellHandle, x, y, width, height, 0);
        } else {
            if (move) {
                OS.XtMoveWidget(this.shellHandle, x, y);
            }
            if (resize) {
                OS.XtResizeWidget(this.shellHandle, width, height, 0);
            }
        }
        if (this.redrawWindow != 0) {
            int xDisplay = OS.XtDisplay(this.handle);
            OS.XResizeWindow(xDisplay, this.redrawWindow, width, height);
        }
        if (move && (this.oldX != x || this.oldY != y)) {
            this.moved = true;
            this.oldX = x + this.trimLeft();
            this.oldY = y + this.trimTop();
            this.sendEvent(10);
            if (this.isDisposed()) {
                return false;
            }
        }
        if (resize && (width != this.oldWidth || height != this.oldHeight)) {
            this.resized = true;
            this.oldWidth = width;
            this.oldHeight = height;
            this.sendEvent(11);
            if (this.isDisposed()) {
                return false;
            }
            if (this.layout != null) {
                this.markLayout(false, false);
                this.updateLayout(false);
            }
        }
        return move || resize;
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if (enabled == this.getEnabled()) {
            return;
        }
        super.setEnabled(enabled);
        if (enabled && this == this.display.getActiveShell() && !this.restoreFocus()) {
            this.traverseGroup(false);
        }
    }

    public void setFullScreen(boolean fullScreen) {
        this.checkWidget();
        if (!OS.XtIsRealized(this.handle)) {
            this.realizeWidget();
        }
        int xDisplay = OS.XtDisplay(this.shellHandle);
        int xWindow = OS.XtWindow(this.shellHandle);
        if (xWindow == 0) {
            return;
        }
        int property = OS.XInternAtom(xDisplay, _NET_WM_STATE, true);
        if (property == 0) {
            return;
        }
        int atom = OS.XInternAtom(xDisplay, _NET_WM_STATE_FULLSCREEN, true);
        if (atom == 0) {
            return;
        }
        XClientMessageEvent xEvent = new XClientMessageEvent();
        xEvent.type = 33;
        xEvent.send_event = 1;
        xEvent.display = xDisplay;
        xEvent.window = xWindow;
        xEvent.message_type = property;
        xEvent.format = 32;
        xEvent.data[0] = fullScreen ? 1 : 0;
        xEvent.data[1] = atom;
        XWindowAttributes attributes = new XWindowAttributes();
        OS.XGetWindowAttributes(xDisplay, xWindow, attributes);
        int rootWindow = OS.XRootWindowOfScreen(attributes.screen);
        int event = OS.XtMalloc(96);
        OS.memmove(event, xEvent, 48);
        OS.XSendEvent(xDisplay, rootWindow, false, 0x180000, event);
        OS.XSync(xDisplay, false);
        OS.XtFree(event);
    }

    public void setMaximized(boolean maximized) {
        this.checkWidget();
        super.setMaximized(maximized);
        if (!OS.XtIsRealized(this.handle)) {
            this.realizeWidget();
        }
        int xDisplay = OS.XtDisplay(this.shellHandle);
        int xWindow = OS.XtWindow(this.shellHandle);
        if (xWindow == 0) {
            return;
        }
        int property = OS.XInternAtom(xDisplay, _NET_WM_STATE, true);
        if (property == 0) {
            return;
        }
        int hMaxAtom = OS.XInternAtom(xDisplay, _NET_WM_STATE_MAXIMIZED_HORZ, true);
        int vMaxAtom = OS.XInternAtom(xDisplay, _NET_WM_STATE_MAXIMIZED_VERT, true);
        if (hMaxAtom == 0 || vMaxAtom == 0) {
            return;
        }
        XClientMessageEvent xEvent = new XClientMessageEvent();
        xEvent.type = 33;
        xEvent.send_event = 1;
        xEvent.display = xDisplay;
        xEvent.window = xWindow;
        xEvent.message_type = property;
        xEvent.format = 32;
        xEvent.data[0] = maximized ? 1 : 0;
        xEvent.data[1] = hMaxAtom;
        xEvent.data[2] = vMaxAtom;
        XWindowAttributes attributes = new XWindowAttributes();
        OS.XGetWindowAttributes(xDisplay, xWindow, attributes);
        int rootWindow = OS.XRootWindowOfScreen(attributes.screen);
        int event = OS.XtMalloc(96);
        OS.memmove(event, xEvent, 48);
        OS.XSendEvent(xDisplay, rootWindow, false, 0x180000, event);
        OS.XSync(xDisplay, false);
        OS.XtFree(event);
    }

    public void setMinimized(boolean minimized) {
        this.checkWidget();
        if (minimized == this.minimized) {
            return;
        }
        int[] nArray = new int[4];
        nArray[0] = OS.XmNiconic;
        nArray[2] = OS.XmNinitialState;
        int[] argList = nArray;
        OS.XtGetValues(this.shellHandle, argList, argList.length / 2);
        if (argList[1] != 0 != this.minimized) {
            argList[1] = this.minimized ? 1 : 0;
            OS.XtSetValues(this.shellHandle, argList, argList.length / 2);
        }
        super.setMinimized(minimized);
        argList[1] = minimized ? 1 : 0;
        argList[3] = minimized ? 3 : 1;
        OS.XtSetValues(this.shellHandle, argList, argList.length / 2);
        int xDisplay = OS.XtDisplay(this.handle);
        if (xDisplay != 0) {
            OS.XSync(xDisplay, false);
        }
        if (!minimized) {
            int[] nArray2 = new int[2];
            nArray2[0] = OS.XmNmappedWhenManaged;
            int[] argList2 = nArray2;
            OS.XtGetValues(this.shellHandle, argList2, argList2.length / 2);
            if (argList2[1] != 0) {
                do {
                    this.display.update();
                } while (!this.isVisible());
                this.setActive();
            }
        }
    }

    public void setMinimumSize(int width, int height) {
        this.checkWidget();
        int[] argList = new int[]{OS.XmNminWidth, Math.max(width, this.trimWidth()) - this.trimWidth(), OS.XmNminHeight, Math.max(height, this.trimHeight()) - this.trimHeight()};
        OS.XtSetValues(this.shellHandle, argList, argList.length / 2);
    }

    public void setMinimumSize(Point size) {
        this.checkWidget();
        if (size == null) {
            this.error(4);
        }
        this.setMinimumSize(size.x, size.y);
    }

    public void setModified(boolean modified) {
        this.checkWidget();
        this.modified = modified;
    }

    void setParentTraversal() {
    }

    public void setRegion(Region region) {
        this.checkWidget();
        if ((this.style & 8) == 0) {
            return;
        }
        if (region != null && region.isDisposed()) {
            this.error(5);
        }
        super.setRegion(region);
    }

    public void setText(String string) {
        byte[] buffer1;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        super.setText(string);
        if (string.length() == 0) {
            string = " ";
        }
        byte[] buffer2 = buffer1 = Converter.wcsToMbcs(null, string, true);
        int length = buffer1.length - 1;
        if (length % 4 != 0) {
            buffer2 = new byte[(length + 3) / 4 * 4];
            System.arraycopy(buffer1, 0, buffer2, 0, length);
        }
        int ptr = OS.XtMalloc(buffer2.length + 1);
        OS.memmove(ptr, buffer2, buffer2.length);
        int[] argList = new int[]{OS.XmNtitle, ptr, OS.XmNiconName, ptr};
        OS.XtSetValues(this.shellHandle, argList, argList.length / 2);
        OS.XtFree(ptr);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        this.realizeWidget();
        if (visible) {
            int mask;
            if (this.center && !this.moved) {
                this.center();
                if (this.isDisposed()) {
                    return;
                }
            }
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
            OS.XtSetMappedWhenManaged(this.shellHandle, true);
            if (OS.XtIsTopLevelShell(this.shellHandle)) {
                OS.XtMapWidget(this.shellHandle);
            } else {
                OS.XtPopup(this.shellHandle, 0);
            }
            boolean iconic = false;
            Shell shell = this.parent != null ? this.parent.getShell() : null;
            do {
                this.display.update();
                if (this.isDisposed()) {
                    return;
                }
                boolean bl = iconic = this.minimized || shell != null && shell.minimized;
            } while (!this.isVisible() && !iconic);
            if (!iconic) {
                this.adjustTrim();
            }
            if ((this.style & (mask = 98304)) != 0) {
                OS.XUngrabPointer(this.display.xDisplay, 0);
            }
            this.opened = true;
            if (!this.moved) {
                this.moved = true;
                Point location = this.getLocation();
                this.oldX = location.x + this.trimLeft();
                this.oldY = location.x + this.trimTop();
                this.sendEvent(10);
                if (this.isDisposed()) {
                    return;
                }
            }
            if (!this.resized) {
                this.resized = true;
                Point size = this.getSize();
                this.oldWidth = size.x - this.trimWidth();
                this.oldHeight = size.y - this.trimHeight();
                this.sendEvent(11);
                if (this.isDisposed()) {
                    return;
                }
                if (this.layout != null) {
                    this.markLayout(false, false);
                    this.updateLayout(false);
                }
            }
        } else {
            Shell activeShell;
            if (this.parent != null && (activeShell = this.display.getActiveShell()) == this) {
                Shell shell = this.parent.getShell();
                shell.bringToTop(false);
            }
            OS.XtSetMappedWhenManaged(this.shellHandle, false);
            if (OS.XtIsTopLevelShell(this.shellHandle)) {
                OS.XtUnmapWidget(this.shellHandle);
            } else {
                OS.XtPopdown(this.shellHandle);
            }
            int xDisplay = OS.XtDisplay(this.shellHandle);
            if (xDisplay == 0) {
                return;
            }
            int xWindow = OS.XtWindow(this.shellHandle);
            if (xWindow == 0) {
                return;
            }
            OS.XWithdrawWindow(xDisplay, xWindow, OS.XDefaultScreen(xDisplay));
            this.sendEvent(23);
        }
    }

    void setZOrder(Control control, boolean above) {
        this.setZOrder(control, above, false);
    }

    int topHandle() {
        return this.shellHandle;
    }

    boolean traverseEscape() {
        if (this.parent == null) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        this.close();
        return true;
    }

    int trimHeight() {
        if ((this.style & 8) != 0) {
            return 0;
        }
        boolean hasTitle = false;
        boolean hasResize = false;
        boolean hasBorder = false;
        hasTitle = (this.style & 0x4E0) != 0;
        hasResize = (this.style & 0x10) != 0;
        boolean bl = hasBorder = (this.style & 0x800) != 0;
        if (hasTitle) {
            if (hasResize) {
                return this.display.topTitleResizeHeight + this.display.bottomTitleResizeHeight;
            }
            if (hasBorder) {
                return this.display.topTitleBorderHeight + this.display.bottomTitleBorderHeight;
            }
            return this.display.topTitleHeight + this.display.bottomTitleHeight;
        }
        if (hasResize) {
            return this.display.topResizeHeight + this.display.bottomResizeHeight;
        }
        if (hasBorder) {
            return this.display.topBorderHeight + this.display.bottomBorderHeight;
        }
        return 0;
    }

    int trimLeft() {
        if ((this.style & 8) != 0) {
            return 0;
        }
        boolean hasTitle = false;
        boolean hasResize = false;
        boolean hasBorder = false;
        hasTitle = (this.style & 0x4E0) != 0;
        hasResize = (this.style & 0x10) != 0;
        boolean bl = hasBorder = (this.style & 0x800) != 0;
        if (hasTitle) {
            if (hasResize) {
                return this.display.leftTitleResizeWidth;
            }
            if (hasBorder) {
                return this.display.leftTitleBorderWidth;
            }
            return this.display.leftTitleWidth;
        }
        if (hasResize) {
            return this.display.leftResizeWidth;
        }
        if (hasBorder) {
            return this.display.leftBorderWidth;
        }
        return 0;
    }

    int trimTop() {
        if ((this.style & 8) != 0) {
            return 0;
        }
        boolean hasTitle = false;
        boolean hasResize = false;
        boolean hasBorder = false;
        hasTitle = (this.style & 0x4E0) != 0;
        hasResize = (this.style & 0x10) != 0;
        boolean bl = hasBorder = (this.style & 0x800) != 0;
        if (hasTitle) {
            if (hasResize) {
                return this.display.topTitleResizeHeight;
            }
            if (hasBorder) {
                return this.display.topTitleBorderHeight;
            }
            return this.display.topTitleHeight;
        }
        if (hasResize) {
            return this.display.topResizeHeight;
        }
        if (hasBorder) {
            return this.display.topBorderHeight;
        }
        return 0;
    }

    int trimWidth() {
        if ((this.style & 8) != 0) {
            return 0;
        }
        boolean hasTitle = false;
        boolean hasResize = false;
        boolean hasBorder = false;
        hasTitle = (this.style & 0x4E0) != 0;
        hasResize = (this.style & 0x10) != 0;
        boolean bl = hasBorder = (this.style & 0x800) != 0;
        if (hasTitle) {
            if (hasResize) {
                return this.display.leftTitleResizeWidth + this.display.rightTitleResizeWidth;
            }
            if (hasBorder) {
                return this.display.leftTitleBorderWidth + this.display.rightTitleBorderWidth;
            }
            return this.display.leftTitleWidth + this.display.rightTitleWidth;
        }
        if (hasResize) {
            return this.display.leftResizeWidth + this.display.rightResizeWidth;
        }
        if (hasBorder) {
            return this.display.leftBorderWidth + this.display.rightBorderWidth;
        }
        return 0;
    }

    void updateResizable(int width, int height) {
        if ((this.style & 0x10) != 0) {
            return;
        }
        if (!OS.XtIsRealized(this.shellHandle)) {
            return;
        }
        XSizeHints hints = new XSizeHints();
        hints.flags = 52;
        hints.min_width = hints.max_width = width;
        hints.min_height = hints.max_height = height;
        OS.XSetWMNormalHints(OS.XtDisplay(this.shellHandle), OS.XtWindow(this.shellHandle), hints);
    }

    int WM_DELETE_WINDOW(int w, int client_data, int call_data) {
        if (!this.isEnabled()) {
            return 0;
        }
        Composite widget = this.parent;
        while (widget != null && !widget.getShell().isModal()) {
            widget = widget.parent;
        }
        if (widget == null) {
            Shell[] shells = this.getShells();
            int i = 0;
            while (i < shells.length) {
                Shell shell = shells[i];
                if (shell != this && shell.isModal() && shell.isVisible()) {
                    shell.bringToTop(false);
                    return 0;
                }
                ++i;
            }
        }
        this.closeWidget();
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    int XFocusChange(int w, int client_data, int call_data, int continue_to_dispatch) {
        XFocusChangeEvent xEvent = new XFocusChangeEvent();
        OS.memmove(xEvent, call_data, 28);
        int handle = OS.XtWindowToWidget(xEvent.display, xEvent.window);
        if (handle != this.shellHandle) {
            return super.XFocusChange(w, client_data, call_data, continue_to_dispatch);
        }
        if (xEvent.mode != 0) {
            return 0;
        }
        if (xEvent.type == 9 && xEvent.detail == 2 && this.focusProxy != 0) {
            int xWindow = OS.XtWindow(this.focusProxy);
            int xDisplay = OS.XtDisplay(this.focusProxy);
            OS.XSetInputFocus(xDisplay, xWindow, 2, 0);
        }
        switch (xEvent.detail) {
            case 3: 
            case 4: {
                switch (xEvent.type) {
                    case 9: {
                        if (this.display.postFocusOut) {
                            this.postEvent(26);
                            return 0;
                        }
                        this.sendEvent(26);
                        return 0;
                    }
                    case 10: {
                        Display display = this.display;
                        if (display.postFocusOut) {
                            this.postEvent(27);
                        } else {
                            this.sendEvent(27);
                        }
                        Combo focusedCombo = display.focusedCombo;
                        display.focusedCombo = null;
                        if (focusedCombo == null || focusedCombo == this || focusedCombo.isDisposed()) return 0;
                        display.sendFocusEvent(focusedCombo, 16);
                    }
                }
                return 0;
            }
        }
        return 0;
    }

    int XStructureNotify(int w, int client_data, int call_data, int continue_to_dispatch) {
        XConfigureEvent xEvent = new XConfigureEvent();
        OS.memmove(xEvent, call_data, 52);
        int handle = OS.XtWindowToWidget(xEvent.display, xEvent.window);
        if (handle != this.shellHandle) {
            return super.XStructureNotify(w, client_data, call_data, continue_to_dispatch);
        }
        switch (xEvent.type) {
            case 21: {
                this.reparented = true;
                this.adjustTrim();
                break;
            }
            case 22: {
                int[] root_x = new int[1];
                int[] root_y = new int[1];
                int[] child = new int[1];
                OS.XTranslateCoordinates(xEvent.display, xEvent.window, OS.XDefaultRootWindow(xEvent.display), 0, 0, root_x, root_y, child);
                if (!this.moved || this.oldX != root_x[0] || this.oldY != root_y[0]) {
                    this.moved = true;
                    this.oldX = root_x[0];
                    this.oldY = root_y[0];
                    this.sendEvent(10);
                    if (this.isDisposed()) {
                        return 0;
                    }
                }
                this.updateResizable(xEvent.width, xEvent.height);
                if (!this.resized || this.oldWidth != xEvent.width || this.oldHeight != xEvent.height) {
                    int xEvent1 = OS.XtMalloc(96);
                    this.display.resizeWindow = xEvent.window;
                    this.display.resizeWidth = xEvent.width;
                    this.display.resizeHeight = xEvent.height;
                    this.display.resizeCount = 0;
                    int checkResizeProc = this.display.checkResizeProc;
                    OS.XCheckIfEvent(xEvent.display, xEvent1, checkResizeProc, 0);
                    OS.XtFree(xEvent1);
                    if (this.display.resizeCount == 0) {
                        this.resized = true;
                        this.oldWidth = xEvent.width;
                        this.oldHeight = xEvent.height;
                        this.sendEvent(11);
                        if (this.isDisposed()) {
                            return 0;
                        }
                        if (this.layout != null) {
                            this.markLayout(false, false);
                            this.updateLayout(false);
                        }
                    }
                }
                return 0;
            }
            case 18: {
                int[] nArray = new int[2];
                nArray[0] = OS.XmNmappedWhenManaged;
                int[] argList = nArray;
                OS.XtGetValues(this.shellHandle, argList, argList.length / 2);
                if (argList[1] != 0) {
                    this.minimized = true;
                    this.sendEvent(19);
                }
                return 0;
            }
            case 19: {
                if (this.minimized) {
                    this.minimized = false;
                    this.sendEvent(20);
                }
                return 0;
            }
        }
        return 0;
    }
}

