/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.adaptors;

import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.equinox.service.weaving.CacheEntry;
import org.eclipse.equinox.service.weaving.ICachingService;
import org.eclipse.equinox.service.weaving.IWeavingService;
import org.eclipse.equinox.weaving.adaptors.AspectJAdaptorFactory;
import org.eclipse.equinox.weaving.adaptors.Debug;
import org.eclipse.equinox.weaving.adaptors.IAspectJAdaptor;
import org.eclipse.equinox.weaving.hooks.AspectJBundleFile;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.framework.internal.core.BundleFragment;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.osgi.framework.Bundle;

public class AspectJAdaptor
implements IAspectJAdaptor {
    private static ThreadLocalSet identifyRecursionSet = new ThreadLocalSet();
    private BaseClassLoader baseLoader;
    private Bundle bundle;
    private ICachingService cachingService;
    private final BaseData data;
    private final AspectJAdaptorFactory factory;
    private boolean initialized = false;
    private String symbolicName;
    private IWeavingService weavingService;

    public AspectJAdaptor(BaseData baseData, AspectJAdaptorFactory aspectJAdaptorFactory, BaseClassLoader baseClassLoader, IWeavingService iWeavingService, ICachingService iCachingService) {
        this.data = baseData;
        this.factory = aspectJAdaptorFactory;
        this.symbolicName = baseData.getLocation();
        if (Debug.DEBUG_GENERAL) {
            Debug.println("- AspectJAdaptor.AspectJAdaptor() bundle=" + this.symbolicName);
        }
    }

    public CacheEntry findClass(String string, URL uRL) {
        if (Debug.DEBUG_CACHE) {
            Debug.println("> AspectJAdaptor.findClass() bundle=" + this.symbolicName + ", url=" + uRL + ", name=" + string);
        }
        CacheEntry cacheEntry = null;
        this.initialize();
        if (this.cachingService != null) {
            cacheEntry = this.cachingService.findStoredClass("", uRL, string);
        }
        if (Debug.DEBUG_CACHE) {
            Debug.println("< AspectJAdaptor.findClass() cacheEntry=" + cacheEntry);
        }
        return cacheEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        AspectJAdaptor aspectJAdaptor = this;
        synchronized (aspectJAdaptor) {
            if (this.initialized) {
                return;
            }
            this.bundle = this.data.getBundle();
            this.symbolicName = this.data.getSymbolicName();
            if (!identifyRecursionSet.contains(this)) {
                identifyRecursionSet.put(this);
                if (Debug.DEBUG_GENERAL) {
                    Debug.println("> AspectJAdaptor.initialize() bundle=" + this.symbolicName + ", baseLoader=" + this.baseLoader);
                }
                if (this.symbolicName.startsWith("org.aspectj")) {
                    if (Debug.DEBUG_GENERAL) {
                        Debug.println("- AspectJAdaptor.initialize() symbolicName=" + this.symbolicName + ", baseLoader=" + this.baseLoader);
                    }
                } else if (this.baseLoader != null) {
                    this.weavingService = this.factory.getWeavingService(this.baseLoader);
                    this.cachingService = this.factory.getCachingService(this.baseLoader, this.bundle, this.weavingService);
                } else if (this.bundle instanceof BundleFragment) {
                    BaseData baseData;
                    BundleFile bundleFile;
                    BundleFragment bundleFragment = (BundleFragment)this.bundle;
                    BundleHost bundleHost = (BundleHost)this.factory.getHost((Bundle)bundleFragment);
                    if (Debug.DEBUG_GENERAL) {
                        Debug.println("- AspectJAdaptor.initialize() symbolicName=" + this.symbolicName + ", host=" + bundleHost);
                    }
                    if ((bundleFile = (baseData = (BaseData)bundleHost.getBundleData()).getBundleFile()) instanceof AspectJBundleFile) {
                        AspectJBundleFile aspectJBundleFile = (AspectJBundleFile)bundleFile;
                        AspectJAdaptor aspectJAdaptor2 = (AspectJAdaptor)aspectJBundleFile.getAdaptor();
                        this.weavingService = aspectJAdaptor2.weavingService;
                        this.cachingService = this.factory.getCachingService(aspectJAdaptor2.baseLoader, this.bundle, this.weavingService);
                    }
                } else if (Debug.DEBUG_GENERAL) {
                    Debug.println("W AspectJAdaptor.initialize() symbolicName=" + this.symbolicName + ", baseLoader=" + this.baseLoader);
                }
                this.initialized = true;
                identifyRecursionSet.remove(this);
            }
            if (Debug.DEBUG_GENERAL) {
                Debug.println("< AspectJAdaptor.initialize() weavingService=" + (this.weavingService != null) + ", cachingService=" + (this.cachingService != null));
            }
        }
    }

    public void setBaseClassLoader(BaseClassLoader baseClassLoader) {
        this.baseLoader = baseClassLoader;
        if (Debug.DEBUG_GENERAL) {
            Debug.println("- AspectJAdaptor.setBaseClassLoader() bundle=" + this.symbolicName + ", baseLoader=" + this.baseLoader);
        }
    }

    public boolean storeClass(String string, URL uRL, Class clazz, byte[] byArray) {
        if (Debug.DEBUG_CACHE) {
            Debug.println("> AspectJAdaptor.storeClass() bundle=" + this.symbolicName + ", url=" + uRL + ", name=" + string + ", clazz=" + clazz);
        }
        boolean bl = false;
        this.initialize();
        if (this.cachingService != null) {
            if (this.weavingService != null && this.weavingService.generatedClassesExistFor((ClassLoader)this.baseLoader, string)) {
                this.weavingService.flushGeneratedClasses((ClassLoader)this.baseLoader);
                if (Debug.DEBUG_CACHE) {
                    Debug.println("- AspectJAdaptor.storeClass() generatedClassesExistFor=true");
                }
            } else {
                bl = this.cachingService.storeClass("", uRL, clazz, byArray);
                if (!bl && Debug.DEBUG_CACHE) {
                    Debug.println("E AspectJHook.storeClass() bundle=" + this.symbolicName + ", name=" + string);
                }
            }
        }
        if (Debug.DEBUG_CACHE) {
            Debug.println("< AspectJAdaptor.storeClass() stored=" + bl);
        }
        return bl;
    }

    public String toString() {
        return "AspectJAdaptor[" + this.symbolicName + "]";
    }

    public byte[] weaveClass(String string, byte[] byArray) {
        if (Debug.DEBUG_WEAVE) {
            Debug.println("> AspectJAdaptor.weaveClass() bundle=" + this.symbolicName + ", name=" + string + ", bytes=" + byArray.length);
        }
        byte[] byArray2 = null;
        this.initialize();
        if (this.weavingService != null) {
            try {
                byArray2 = this.weavingService.preProcess(string, byArray, (ClassLoader)this.baseLoader);
            }
            catch (IOException iOException) {
                throw new ClassFormatError(iOException.toString());
            }
        }
        if (Debug.DEBUG_WEAVE) {
            Debug.println("< AspectJAdaptor.weaveClass() newBytes=" + byArray2);
        }
        return byArray2;
    }

    private static class ThreadLocalSet
    extends ThreadLocal {
        private ThreadLocalSet() {
        }

        public boolean contains(Object object) {
            Set set = (Set)this.get();
            return set.contains(object);
        }

        public void put(Object object) {
            Set set = (Set)this.get();
            if (set.contains(object)) {
                throw new RuntimeException(object.toString());
            }
            set.add(object);
        }

        public void remove(Object object) {
            Set set = (Set)this.get();
            if (!set.contains(object)) {
                throw new RuntimeException(object.toString());
            }
            set.remove(object);
        }

        protected Object initialValue() {
            return new HashSet();
        }
    }
}

