/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.program;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.photon.OS;

public final class Program {
    String name;
    String extension;
    String command;

    Program() {
    }

    public static Program findProgram(String extension) {
        if (extension == null) {
            SWT.error(4);
        }
        if (extension.length() == 0) {
            return null;
        }
        String[][] table = Program.loadAssociationTable();
        if (table == null) {
            return null;
        }
        int i = 0;
        while (i < table.length) {
            String[] entry = table[i];
            if (entry == null) break;
            String[] exts = Program.expandExtensions(entry[0]);
            int j = 0;
            while (j < exts.length) {
                String ext = exts[j];
                if (ext == null) break;
                if (ext.endsWith(extension)) {
                    Program program = new Program();
                    program.extension = ext;
                    program.command = entry[1];
                    String name = entry[1];
                    int index = name.indexOf(32);
                    if (index != -1) {
                        name = name.substring(0, index);
                    }
                    program.name = name;
                    return program;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public static String[] getExtensions() {
        String[][] table = Program.loadAssociationTable();
        if (table == null) {
            return new String[0];
        }
        int count = 0;
        String[] extensions = new String[50];
        int i = 0;
        while (i < table.length) {
            String[] entry = table[i];
            if (entry == null) break;
            String[] exts = Program.expandExtensions(entry[0]);
            int j = 0;
            while (j < exts.length) {
                String ext = exts[j];
                if (ext == null) break;
                if (count == extensions.length) {
                    String[] newExtensions = new String[count + 50];
                    System.arraycopy(extensions, 0, newExtensions, 0, count);
                    extensions = newExtensions;
                }
                extensions[count++] = ext;
                ++j;
            }
            ++i;
        }
        if (count != extensions.length) {
            String[] newExtensions = new String[count];
            System.arraycopy(extensions, 0, newExtensions, 0, count);
            extensions = newExtensions;
        }
        return extensions;
    }

    public static Program[] getPrograms() {
        String[][] table = Program.loadAssociationTable();
        if (table == null) {
            return new Program[0];
        }
        int count = 0;
        Program[] programs = new Program[50];
        int i = 0;
        while (i < table.length) {
            String[] entry = table[i];
            if (entry == null) break;
            String[] extensions = Program.expandExtensions(entry[0]);
            int j = 0;
            while (j < extensions.length) {
                String extension = extensions[j];
                if (extension == null) break;
                Program program = new Program();
                program.extension = extension;
                program.command = entry[1];
                String name = entry[1];
                int index = name.indexOf(32);
                if (index != -1) {
                    name = name.substring(0, index);
                }
                program.name = name;
                if (count == programs.length) {
                    Program[] newPrograms = new Program[count + 50];
                    System.arraycopy(programs, 0, newPrograms, 0, count);
                    programs = newPrograms;
                }
                programs[count++] = program;
                ++j;
            }
            ++i;
        }
        if (count != programs.length) {
            Program[] newPrograms = new Program[count];
            System.arraycopy(programs, 0, newPrograms, 0, count);
            programs = newPrograms;
        }
        return programs;
    }

    public static boolean launch(String fileName) {
        int index;
        if (fileName == null) {
            SWT.error(4);
        }
        if ((index = fileName.lastIndexOf(46)) == -1) {
            return false;
        }
        String extension = fileName.substring(index, fileName.length());
        Program program = Program.findProgram(extension);
        if (program != null && program.execute(fileName)) {
            return true;
        }
        try {
            Compatibility.exec(fileName);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    static String[] expandExtensions(String ext) {
        int start = 0;
        int index = 0;
        int count = 0;
        int length = ext.length();
        String[] extensions = new String[5];
        while (index < length) {
            index = ext.indexOf(124, start);
            if (index == -1) {
                index = length;
            }
            String extension = ext.substring(start, index).trim();
            start = index + 1;
            int bracketStart = extension.indexOf(91);
            if (bracketStart != -1) {
                int bracketEnd = extension.indexOf(93, bracketStart);
                if (bracketEnd == -1) continue;
                String prefix = extension.substring(0, bracketStart);
                String suffix = extension.substring(bracketEnd + 1, extension.length());
                String chars = extension.substring(bracketStart + 1, bracketEnd);
                int i = 0;
                while (i < chars.length()) {
                    if (count == extensions.length) {
                        String[] newExtensions = new String[count + 5];
                        System.arraycopy(extensions, 0, newExtensions, 0, count);
                        extensions = newExtensions;
                    }
                    extensions[count++] = String.valueOf(prefix) + chars.charAt(i) + suffix;
                    ++i;
                }
                continue;
            }
            if (count == extensions.length) {
                String[] newExtensions = new String[count + 5];
                System.arraycopy(extensions, 0, newExtensions, 0, count);
                extensions = newExtensions;
            }
            extensions[count++] = extension;
        }
        return extensions;
    }

    /*
     * Loose catch block
     */
    static String[][] loadAssociationTable() {
        String line;
        int length;
        int ptr;
        byte[] buffer;
        FileInputStream is;
        block24: {
            block23: {
                is = null;
                buffer = Converter.wcsToMbcs(null, "HOME", true);
                ptr = OS.getenv(buffer);
                if (ptr != 0) break block23;
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
                return null;
            }
            length = OS.strlen(ptr);
            if (length != 0) break block24;
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
            return null;
        }
        buffer = new byte[length];
        OS.memmove(buffer, ptr, length);
        String home = new String(Converter.mbcsToWcs(null, buffer));
        is = new FileInputStream(String.valueOf(home) + "/.ph/pfm/associate.003");
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        int count = 0;
        String[][] table = new String[50][];
        while ((line = reader.readLine()) != null) {
            int start;
            int tabIndex;
            if (line.trim().startsWith("#") || (tabIndex = line.indexOf(9, start = 0)) == -1) continue;
            String extension = line.substring(start, tabIndex);
            start = tabIndex + 1;
            if ((tabIndex = line.indexOf(9, start)) == -1) continue;
            String command = line.substring(start, tabIndex);
            if (count == table.length) {
                String[][] newTable = new String[table.length + 50][];
                System.arraycopy(table, 0, newTable, 0, table.length);
                table = newTable;
            }
            String[] entry = new String[]{extension, command};
            table[count++] = entry;
        }
        String[][] stringArray = table;
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException iOException) {}
        return stringArray;
        catch (IOException iOException) {
            try {}
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException3) {}
        }
        return null;
    }

    public boolean execute(String fileName) {
        if (fileName == null) {
            SWT.error(4);
        }
        int index = -1;
        String prefix = this.command;
        String suffix = "";
        String location = "";
        String[] locations = new String[]{"file://$PWD/@", "$PWD/@", "@"};
        int i = 0;
        while (i < locations.length) {
            location = locations[i];
            index = this.command.indexOf(location);
            if (index != -1) break;
            ++i;
        }
        if (index != -1) {
            int start = 0;
            prefix = this.command.substring(start, index);
            start = index + location.length() + 1;
            if (start < this.command.length()) {
                suffix = this.command.substring(start, this.command.length());
            }
        }
        try {
            Compatibility.exec(String.valueOf(prefix) + " " + fileName + " " + suffix);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public ImageData getImageData() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Program) {
            Program program = (Program)other;
            return this.extension.equals(program.extension) && this.name.equals(program.name) && this.command.equals(program.command);
        }
        return false;
    }

    public int hashCode() {
        return this.extension.hashCode() ^ this.name.hashCode() ^ this.command.hashCode();
    }

    public String toString() {
        return "Program {" + this.name + "}";
    }
}

