/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.cleanup;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;

public class CleanUpOptions {
    private final Map fOptions;
    public static final String TRUE = "true";
    public static final String FALSE = "false";

    protected CleanUpOptions(Map options) {
        this.fOptions = options;
    }

    public CleanUpOptions() {
        this.fOptions = new Hashtable();
    }

    public boolean isEnabled(String key) {
        Assert.isLegal((key != null ? 1 : 0) != 0);
        Object value = this.fOptions.get(key);
        return TRUE == value || TRUE.equals(value);
    }

    public String getValue(String key) {
        Assert.isLegal((key != null ? 1 : 0) != 0);
        String value = (String)this.fOptions.get(key);
        Assert.isLegal((value != null ? 1 : 0) != 0);
        return value;
    }

    public void setOption(String key, String value) {
        Assert.isLegal((key != null ? 1 : 0) != 0);
        Assert.isLegal((value != null ? 1 : 0) != 0);
        this.fOptions.put(key, value);
    }

    public Set getKeys() {
        return Collections.unmodifiableSet(this.fOptions.keySet());
    }
}

