/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.navigator.CommonNavigatorMessages;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.ReusableViewerLabel;
import org.eclipse.ui.internal.navigator.extensions.ExtensionPriorityComparator;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptor;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentExtension;
import org.eclipse.ui.navigator.ICommonLabelProvider;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorContentExtension;

public class NavigatorContentServiceLabelProvider
extends EventManager
implements ILabelProvider,
IColorProvider,
IFontProvider,
ITreePathLabelProvider,
ITableLabelProvider,
ILabelProviderListener,
DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private final NavigatorContentService contentService;
    private final boolean isContentServiceSelfManaged;
    private final ReusableViewerLabel reusableLabel = new ReusableViewerLabel();

    public NavigatorContentServiceLabelProvider(NavigatorContentService aContentService) {
        this.contentService = aContentService;
        this.isContentServiceSelfManaged = false;
    }

    public Image getImage(Object anElement) {
        return this.getColumnImage(anElement, -1);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Set contentExtensions = this.contentService.findContentExtensionsByTriggerPoint(element);
        Image image = null;
        Iterator itr = contentExtensions.iterator();
        while (itr.hasNext() && image == null) {
            image = this.findImage((NavigatorContentExtension)itr.next(), element, columnIndex);
        }
        return image;
    }

    public String getText(Object anElement) {
        return this.getColumnText(anElement, -1);
    }

    public String getColumnText(Object anElement, int aColumn) {
        ILabelProvider[] labelProviders = this.contentService.findRelevantLabelProviders(anElement);
        String text = null;
        int i = 0;
        while (i < labelProviders.length) {
            text = labelProviders[i] instanceof ITableLabelProvider && aColumn != -1 ? ((ITableLabelProvider)labelProviders[i]).getColumnText(anElement, aColumn) : labelProviders[i].getText(anElement);
            if (text != null) {
                return text;
            }
            ++i;
        }
        return NLS.bind((String)CommonNavigatorMessages.NavigatorContentServiceLabelProvider_Error_no_label_provider_for_0_, (Object)this.makeSmallString(anElement));
    }

    public StyledString getStyledText(Object anElement) {
        TreeSet<INavigatorContentExtension> extensions = new TreeSet<INavigatorContentExtension>(ExtensionPriorityComparator.INSTANCE);
        NavigatorContentDescriptor ncd = this.contentService.getSourceOfContribution(anElement);
        if (ncd != null) {
            extensions.add(this.contentService.getExtension(ncd));
        }
        Set possibleChildDescriptors = this.contentService.findContentExtensionsWithPossibleChild(anElement, true);
        Iterator iter = possibleChildDescriptors.iterator();
        while (iter.hasNext()) {
            INavigatorContentExtension ext = (INavigatorContentExtension)iter.next();
            extensions.add(ext);
        }
        StyledString text = null;
        Iterator itr = extensions.iterator();
        while (itr.hasNext() && text == null) {
            text = this.findStyledText((NavigatorContentExtension)itr.next(), anElement);
        }
        return text == null ? new StyledString(NLS.bind((String)CommonNavigatorMessages.NavigatorContentServiceLabelProvider_Error_no_label_provider_for_0_, (Object)this.makeSmallString(anElement))) : text;
    }

    private StyledString findStyledText(NavigatorContentExtension foundExtension, Object anElement) {
        INavigatorContentDescriptor foundDescriptor;
        ICommonLabelProvider labelProvider = foundExtension.getLabelProvider();
        if (labelProvider instanceof DelegatingStyledCellLabelProvider.IStyledLabelProvider) {
            StyledString styledText = ((DelegatingStyledCellLabelProvider.IStyledLabelProvider)labelProvider).getStyledText(anElement);
            if (styledText != null && styledText.length() > 0) {
                return styledText;
            }
        } else {
            String text = labelProvider.getText(anElement);
            if (text != null) {
                return new StyledString(text);
            }
        }
        if ((foundDescriptor = foundExtension.getDescriptor()).getOverriddenDescriptor() != null) {
            return this.findStyledText(this.contentService.getExtension(foundDescriptor.getOverriddenDescriptor()), anElement);
        }
        return null;
    }

    private String makeSmallString(Object obj) {
        String str;
        if (obj == null) {
            return "null";
        }
        int len = (str = obj.toString()).length();
        return str.substring(0, len < 50 ? len : 49);
    }

    private Image findImage(NavigatorContentExtension foundExtension, Object anElement, int aColumn) {
        INavigatorContentDescriptor foundDescriptor;
        Image image = null;
        ICommonLabelProvider provider = foundExtension.getLabelProvider();
        image = provider instanceof ITableLabelProvider && aColumn >= 0 ? ((ITableLabelProvider)provider).getColumnImage(anElement, aColumn) : provider.getImage(anElement);
        if (image == null && (foundDescriptor = foundExtension.getDescriptor()).getOverriddenDescriptor() != null) {
            return this.findImage(this.contentService.getExtension(foundDescriptor.getOverriddenDescriptor()), anElement, aColumn);
        }
        return image;
    }

    public Font getFont(Object anElement) {
        ILabelProvider[] labelProviders = this.contentService.findRelevantLabelProviders(anElement);
        int i = 0;
        while (i < labelProviders.length) {
            IFontProvider fontProvider;
            Font font;
            ILabelProvider provider = labelProviders[i];
            if (provider instanceof IFontProvider && (font = (fontProvider = (IFontProvider)provider).getFont(anElement)) != null) {
                return font;
            }
            ++i;
        }
        return null;
    }

    public Color getForeground(Object anElement) {
        ILabelProvider[] labelProviders = this.contentService.findRelevantLabelProviders(anElement);
        int i = 0;
        while (i < labelProviders.length) {
            IColorProvider colorProvider;
            Color color;
            ILabelProvider provider = labelProviders[i];
            if (provider instanceof IColorProvider && (color = (colorProvider = (IColorProvider)provider).getForeground(anElement)) != null) {
                return color;
            }
            ++i;
        }
        return null;
    }

    public Color getBackground(Object anElement) {
        ILabelProvider[] labelProviders = this.contentService.findRelevantLabelProviders(anElement);
        int i = 0;
        while (i < labelProviders.length) {
            IColorProvider colorProvider;
            Color color;
            ILabelProvider provider = labelProviders[i];
            if (provider instanceof IColorProvider && (color = (colorProvider = (IColorProvider)provider).getBackground(anElement)) != null) {
                return color;
            }
            ++i;
        }
        return null;
    }

    public boolean isLabelProperty(Object anElement, String aProperty) {
        boolean result = false;
        ILabelProvider[] labelProviders = this.contentService.findRelevantLabelProviders(anElement);
        int i = 0;
        while (i < labelProviders.length && !result) {
            result = labelProviders[i].isLabelProperty(anElement, aProperty);
            ++i;
        }
        return result;
    }

    public void addListener(ILabelProviderListener aListener) {
        this.addListenerObject(aListener);
    }

    public void removeListener(ILabelProviderListener aListener) {
        this.removeListenerObject(aListener);
    }

    public void dispose() {
        if (this.isContentServiceSelfManaged) {
            this.contentService.dispose();
        }
    }

    protected void fireLabelProviderChanged(final LabelProviderChangedEvent event) {
        Object[] theListeners = this.getListeners();
        int i = 0;
        while (i < theListeners.length) {
            final ILabelProviderListener l = (ILabelProviderListener)theListeners[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.labelProviderChanged(event);
                }
            });
            ++i;
        }
    }

    public void updateLabel(ViewerLabel label, TreePath elementPath) {
        Set contentExtensions = this.contentService.findContentExtensionsByTriggerPoint(elementPath.getLastSegment());
        this.reusableLabel.reset(label);
        Iterator itr = contentExtensions.iterator();
        while (!(!itr.hasNext() || this.reusableLabel.isValid() && this.reusableLabel.hasChanged())) {
            this.findUpdateLabel((NavigatorContentExtension)itr.next(), this.reusableLabel, elementPath);
        }
        this.reusableLabel.fill(label);
    }

    private void findUpdateLabel(NavigatorContentExtension foundExtension, ReusableViewerLabel label, TreePath elementPath) {
        ICommonLabelProvider labelProvider = foundExtension.getLabelProvider();
        if (labelProvider instanceof ITreePathLabelProvider) {
            ITreePathLabelProvider tplp = (ITreePathLabelProvider)labelProvider;
            tplp.updateLabel((ViewerLabel)label, elementPath);
        } else {
            label.setImage(labelProvider.getImage(elementPath.getLastSegment()));
            label.setText(labelProvider.getText(elementPath.getLastSegment()));
        }
        if (this.shouldContinue(label, foundExtension)) {
            this.findUpdateLabel(this.contentService.getExtension(foundExtension.getDescriptor().getOverriddenDescriptor()), label, elementPath);
        }
    }

    private boolean shouldContinue(ReusableViewerLabel label, NavigatorContentExtension foundExtension) {
        if (foundExtension.getDescriptor().getOverriddenDescriptor() != null) {
            return !label.isValid() || !label.hasChanged();
        }
        return false;
    }

    public void labelProviderChanged(LabelProviderChangedEvent event) {
        this.fireLabelProviderChanged(event);
    }
}

