/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk.scheduler;

import java.util.ArrayList;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.AutomaticUpdater;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUIProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.ui.actions.UpdateAction;
import org.eclipse.equinox.internal.provisional.p2.ui.model.IUElementListRoot;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.PlannerResolutionOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.PlanValidator;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policy;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

final class AutomaticUpdateAction
extends UpdateAction {
    final AutomaticUpdater automaticUpdater;
    private boolean suppressWizard = false;
    private PlannerResolutionOperation resolvedOperation;
    private ProvUIProvisioningListener profileListener;
    private boolean alreadyOpen = false;

    AutomaticUpdateAction(AutomaticUpdater automaticUpdater, ISelectionProvider selectionProvider, String profileId, PlannerResolutionOperation op, IUElementListRoot root, ArrayList initialSelections) {
        super(new Policy(), selectionProvider, profileId, false);
        ProvUI.addProvisioningListener((ProvUIProvisioningListener)this.createProfileListener());
        this.resolvedOperation = op;
        this.automaticUpdater = automaticUpdater;
        this.root = root;
        this.initialSelections = initialSelections;
    }

    private ProvUIProvisioningListener createProfileListener() {
        this.profileListener = new ProvUIProvisioningListener(4){

            protected void profileChanged(String profileId) {
                String id = AutomaticUpdateAction.this.getProfileId(false);
                if (id == "_SELF_") {
                    try {
                        IProfile profile = ProvisioningUtil.getProfile((String)"_SELF_");
                        id = profile.getProfileId();
                    }
                    catch (ProvisionException provisionException) {
                        id = null;
                    }
                }
                if (profileId.equals(id)) {
                    AutomaticUpdateAction.this.resolvedOperation = null;
                    AutomaticUpdateAction.this.automaticUpdater.validateUpdates();
                }
            }
        };
        return this.profileListener;
    }

    protected void run(final IInstallableUnit[] ius, final String id) {
        if (this.resolvedOperation != null && this.resolvedOperation.getProvisioningPlan() != null) {
            if (PlatformUI.isWorkbenchRunning()) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (AutomaticUpdateAction.this.validatePlan(AutomaticUpdateAction.this.resolvedOperation.getProvisioningPlan())) {
                            AutomaticUpdateAction.this.performAction(ius, id, AutomaticUpdateAction.this.resolvedOperation);
                        }
                    }
                });
            }
        } else {
            super.run(ius, id);
        }
    }

    void suppressWizard(boolean suppress) {
        this.suppressWizard = suppress;
    }

    protected int performAction(IInstallableUnit[] ius, String targetProfileId, PlannerResolutionOperation resolution) {
        if (this.suppressWizard) {
            this.automaticUpdater.setUpdateAffordanceState(resolution != null && resolution.getResolutionResult().getSummaryStatus().isOK());
            return 0;
        }
        if (this.alreadyOpen) {
            return 1;
        }
        this.alreadyOpen = true;
        int retCode = super.performAction(ius, targetProfileId, resolution);
        this.alreadyOpen = false;
        return retCode;
    }

    protected PlanValidator getPlanValidator() {
        return new PlanValidator(){

            public boolean continueWorkingWithPlan(ProvisioningPlan plan, Shell shell) {
                if (AutomaticUpdateAction.this.automaticUpdater.alreadyValidated) {
                    return true;
                }
                if (plan != null) {
                    boolean noError;
                    if (plan.getStatus().getSeverity() == 8) {
                        return false;
                    }
                    boolean bl = noError = plan.getStatus().getSeverity() != 4;
                    if (AutomaticUpdateAction.this.automaticUpdater.updateAffordance == null) {
                        AutomaticUpdateAction.this.automaticUpdater.createUpdateAffordance();
                    }
                    AutomaticUpdateAction.this.automaticUpdater.setUpdateAffordanceState(noError);
                    if (noError && AutomaticUpdateAction.this.automaticUpdater.popup == null) {
                        AutomaticUpdateAction.this.automaticUpdater.createUpdatePopup();
                    }
                }
                return false;
            }
        };
    }

    public void dispose() {
        if (this.profileListener != null) {
            ProvUI.removeProvisioningListener((ProvUIProvisioningListener)this.profileListener);
        }
        this.profileListener = null;
    }
}

