/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TabFolder;

public class TabItem
extends Item {
    TabFolder parent;
    Control control;
    String toolTipText;
    int imageHandle;
    int textHandle;
    int contentHandle;

    public TabItem(TabFolder parent, int style) {
        super(parent, style);
        this.parent = parent;
        parent.createItem(this, parent.getItemCount());
    }

    public TabItem(TabFolder parent, int style, int index) {
        super(parent, style);
        this.parent = parent;
        parent.createItem(this, index);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createHandle() {
        this.handle = OS.gcnew_TabItem();
        if (this.handle == 0) {
            this.error(2);
        }
        this.imageHandle = OS.gcnew_Image();
        if (this.imageHandle == 0) {
            this.error(2);
        }
        OS.Image_Stretch(this.imageHandle, 0);
        int thickness = OS.gcnew_Thickness(0.0, 0.0, 3.0, 0.0);
        if (thickness == 0) {
            this.error(2);
        }
        OS.FrameworkElement_Margin(this.imageHandle, thickness);
        OS.GCHandle_Free(thickness);
        OS.UIElement_Visibility(this.imageHandle, (byte)2);
        this.textHandle = OS.gcnew_AccessText();
        if (this.textHandle == 0) {
            this.error(2);
        }
        OS.FrameworkElement_VerticalAlignment(this.textHandle, 1);
        int panel = OS.gcnew_StackPanel();
        if (panel == 0) {
            this.error(2);
        }
        OS.StackPanel_Orientation(panel, 0);
        thickness = OS.gcnew_Thickness(1.0, 1.0, 1.0, 1.0);
        if (thickness == 0) {
            this.error(2);
        }
        OS.FrameworkElement_Margin(panel, thickness);
        OS.GCHandle_Free(thickness);
        int children = OS.Panel_Children(panel);
        OS.UIElementCollection_Add(children, this.imageHandle);
        OS.UIElementCollection_Add(children, this.textHandle);
        OS.HeaderedContentControl_Header(this.handle, panel);
        OS.GCHandle_Free(children);
        OS.GCHandle_Free(panel);
        this.contentHandle = OS.gcnew_Canvas();
        if (this.contentHandle == 0) {
            this.error(2);
        }
        OS.ContentControl_Content(this.handle, this.contentHandle);
    }

    void deregister() {
        this.display.removeWidget(this.handle);
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Rectangle getBounds() {
        this.checkWidget();
        int topHandle = this.handle;
        int point = OS.gcnew_Point(0.0, 0.0);
        if (point == 0) {
            this.error(2);
        }
        int location = OS.UIElement_TranslatePoint(topHandle, point, this.parent.handle);
        int x = (int)OS.Point_X(location);
        int y = (int)OS.Point_Y(location);
        OS.GCHandle_Free(point);
        OS.GCHandle_Free(location);
        int width = (int)OS.FrameworkElement_ActualWidth(topHandle);
        int height = (int)OS.FrameworkElement_ActualHeight(topHandle);
        return new Rectangle(x, y, width, height);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public TabFolder getParent() {
        this.checkWidget();
        return this.parent;
    }

    Control getWidgetControl() {
        return this.parent;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    void HandleSizeChanged(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        if (this.control == null) {
            return;
        }
        this.control.setBounds(this.parent.getClientArea());
    }

    void hookEvents() {
        super.hookEvents();
        int handler = OS.gcnew_SizeChangedEventHandler(this.jniRef, "HandleSizeChanged");
        OS.FrameworkElement_SizeChanged(this.contentHandle, handler);
        OS.GCHandle_Free(handler);
    }

    void register() {
        this.display.addWidget(this.handle, this);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.handle != 0) {
            OS.GCHandle_Free(this.handle);
        }
        this.handle = 0;
        this.parent = null;
        if (this.textHandle != 0) {
            OS.GCHandle_Free(this.textHandle);
        }
        this.textHandle = 0;
        if (this.imageHandle != 0) {
            OS.GCHandle_Free(this.imageHandle);
        }
        this.imageHandle = 0;
        if (this.contentHandle != 0) {
            OS.GCHandle_Free(this.contentHandle);
        }
        this.contentHandle = 0;
    }

    void releaseParent() {
        super.releaseParent();
        int index = this.parent.indexOf(this);
        if (index == this.parent.getSelectionIndex() && this.control != null) {
            this.control.setVisible(false);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.control = null;
        this.toolTipText = null;
    }

    public void setControl(Control control) {
        int selectionIndex;
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if (this.control != null && this.control.isDisposed()) {
            this.control = null;
        }
        Control oldControl = this.control;
        Control newControl = control;
        this.control = control;
        int index = this.parent.indexOf(this);
        if (index != (selectionIndex = this.parent.getSelectionIndex()) && newControl != null) {
            Control selectedControl;
            if (selectionIndex != -1 && (selectedControl = this.parent.getItem(selectionIndex).getControl()) == newControl) {
                return;
            }
            newControl.setVisible(false);
            return;
        }
        if (newControl != null) {
            newControl.setBounds(this.parent.getClientArea());
            newControl.setVisible(true);
        }
        if (oldControl != null) {
            oldControl.setVisible(false);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        super.setImage(image);
        OS.Image_Source(this.imageHandle, image != null ? image.handle : 0);
        OS.UIElement_Visibility(this.imageHandle, image != null ? (byte)0 : 2);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        super.setText(string);
        int strPtr = this.createDotNetString(string, true);
        if (strPtr == 0) {
            this.error(2);
        }
        OS.AccessText_Text(this.textHandle, strPtr);
        OS.GCHandle_Free(strPtr);
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        if (string != null && string.length() == 0) {
            string = null;
        }
        int strPtr = this.createDotNetString(string, false);
        int header = OS.HeaderedContentControl_Header(this.handle);
        OS.FrameworkElement_ToolTip(header, strPtr);
        if (strPtr != 0) {
            OS.GCHandle_Free(strPtr);
        }
        OS.GCHandle_Free(header);
    }
}

