/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.win32.Win32;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Shell
extends Decorations {
    Control lastActive;
    boolean closing;
    boolean moved;
    boolean resized;
    boolean opened;
    boolean fullScreen;
    boolean modified;
    boolean center;
    int oldX;
    int oldY;
    int oldWidth;
    int oldHeight;
    int oldWindowStyle;
    int oldWindowState;

    public Shell() {
        this((Display)null);
    }

    public Shell(int style) {
        this((Display)null, style);
    }

    public Shell(Display display) {
        this(display, 1264);
    }

    public Shell(Display display, int style) {
        this(display, null, style, 0, false);
    }

    Shell(Display display, Shell parent, int style, int handle, boolean embedded) {
        this.checkSubclass();
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        if (parent != null && parent.isDisposed()) {
            this.error(5);
        }
        this.center = parent != null && (style & 0x10000000) != 0;
        this.style = Shell.checkStyle(parent, style);
        this.parent = parent;
        this.display = display;
        if (handle != 0) {
            if (embedded) {
                this.handle = handle;
            } else {
                this.shellHandle = handle;
            }
        }
        this.createWidget();
    }

    public Shell(Shell parent) {
        this(parent, 2144);
    }

    public Shell(Shell parent, int style) {
        this(parent != null ? parent.display : null, parent, style, 0, false);
    }

    public static Shell wpf_new(Display display, int handle) {
        return new Shell(display, null, 8, handle, true);
    }

    public static Shell internal_new(Display display, int handle) {
        handle = OS.GCHandle_ToHandle(handle);
        return new Shell(display, null, 8, handle, false);
    }

    static int checkStyle(Shell parent, int style) {
        style = Decorations.checkStyle(style);
        int mask = 229376;
        if (((style &= 0xBFFFFFFF) & 0x10000000) != 0) {
            style &= 0xEFFFFFFF;
            if (((style |= parent == null ? 1264 : 2144) & mask) == 0) {
                style |= parent == null ? 65536 : 32768;
            }
        }
        int bits = style & ~mask;
        if ((style & 0x20000) != 0) {
            return bits | 0x20000;
        }
        if ((style & 0x10000) != 0) {
            return bits | 0x10000;
        }
        if ((style & 0x8000) != 0) {
            return bits | 0x8000;
        }
        return bits;
    }

    public void addShellListener(ShellListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(21, typedListener);
        this.addListener(19, typedListener);
        this.addListener(20, typedListener);
        this.addListener(26, typedListener);
        this.addListener(27, typedListener);
    }

    void addWidget() {
        if ((this.style & 0x4000) != 0) {
            return;
        }
        if (this.parent != null) {
            if ((this.parent.style & 0x4000) != 0) {
                return;
            }
            OS.Window_Owner(this.shellHandle, ((Shell)this.parent).shellHandle);
        }
    }

    void bringToTop() {
        if ((this.style & 0x4000) != 0) {
            return;
        }
        OS.Window_Activate(this.shellHandle);
    }

    void center() {
        if (this.parent == null) {
            return;
        }
        Rectangle rect = this.getBounds();
        Rectangle parentRect = this.display.map((Control)this.parent, null, this.parent.getClientArea());
        int x = Math.max(parentRect.x, parentRect.x + (parentRect.width - rect.width) / 2);
        int y = Math.max(parentRect.y, parentRect.y + (parentRect.height - rect.height) / 2);
        Rectangle monitorRect = this.parent.getMonitor().getClientArea();
        x = x + rect.width > monitorRect.x + monitorRect.width ? Math.max(monitorRect.x, monitorRect.x + monitorRect.width - rect.width) : Math.max(x, monitorRect.x);
        y = y + rect.height > monitorRect.y + monitorRect.height ? Math.max(monitorRect.y, monitorRect.y + monitorRect.height - rect.height) : Math.max(y, monitorRect.y);
        this.setLocation(x, y);
    }

    void checkOpened() {
        if (!this.opened) {
            this.resized = false;
        }
    }

    public void close() {
        this.checkWidget();
        this.closeWidget();
    }

    void createHandle() {
        if (this.shellHandle != 0) {
            this.scrolledHandle = OS.ContentControl_Content(this.shellHandle);
            if (this.scrolledHandle == 0) {
                this.error(2);
            }
            int children = OS.Panel_Children(this.scrolledHandle);
            this.handle = OS.UIElementCollection_default(children, 0);
            if (this.handle == 0) {
                this.error(2);
            }
            OS.GCHandle_Free(children);
            return;
        }
        this.state |= 2;
        if ((this.style & 0x4000) != 0) {
            this.shellHandle = OS.gcnew_Popup();
            if (this.shellHandle == 0) {
                this.error(2);
            }
            if ((this.style & 8) != 0) {
                OS.Popup_AllowsTransparency(this.shellHandle, true);
            }
            OS.KeyboardNavigation_SetTabNavigation(this.shellHandle, 3);
            boolean scrolled = (this.style & 0x300) != 0;
            this.createHandle(scrolled, true);
            OS.Popup_Child(this.shellHandle, super.topHandle());
            OS.Popup_IsOpen(this.shellHandle, true);
            OS.Popup_IsOpen(this.shellHandle, false);
            return;
        }
        this.shellHandle = OS.gcnew_Window();
        if (this.shellHandle == 0) {
            this.error(2);
        }
        if ((this.style & 8) != 0) {
            OS.Window_AllowsTransparency(this.shellHandle, true);
        }
        OS.Window_ShowInTaskbar(this.shellHandle, false);
        OS.Window_ResizeMode(this.shellHandle, 0);
        OS.Window_WindowStyle(this.shellHandle, 0);
        OS.FrameworkElement_Width(this.shellHandle, 0.0);
        OS.FrameworkElement_Height(this.shellHandle, 0.0);
        OS.Window_Show(this.shellHandle);
        OS.Window_Hide(this.shellHandle);
        Rectangle bounds = this.getMonitor().getBounds();
        OS.FrameworkElement_Width(this.shellHandle, bounds.width * 5 / 8);
        OS.FrameworkElement_Height(this.shellHandle, bounds.height * 5 / 8);
        int windowStyle = 0;
        int resizeMode = 0;
        if ((this.style & 8) == 0) {
            if ((this.style & 4) != 0) {
                windowStyle = 3;
            } else if ((this.style & 0x4F0) != 0) {
                windowStyle = 1;
            }
            if ((this.style & 0x10) != 0) {
                resizeMode |= 2;
            }
        }
        OS.Window_ShowInTaskbar(this.shellHandle, this.parent == null);
        OS.Window_ResizeMode(this.shellHandle, resizeMode);
        OS.Window_WindowStyle(this.shellHandle, windowStyle);
        OS.KeyboardNavigation_SetTabNavigation(this.shellHandle, 3);
        boolean scrolled = (this.style & 0x300) != 0;
        this.createHandle(scrolled, true);
        OS.ContentControl_Content(this.shellHandle, super.topHandle());
    }

    void createWidget() {
        super.createWidget();
        this.display.addShell(this);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        if ((this.style & 0x4000) != 0) {
            return new Rectangle(x, y, width, height);
        }
        this.updateLayout(this.shellHandle);
        int clientX = (int)OS.Window_Left(this.shellHandle);
        int clientY = (int)OS.Window_Top(this.shellHandle);
        int w = (int)OS.FrameworkElement_ActualWidth(this.shellHandle);
        int h = (int)OS.FrameworkElement_ActualHeight(this.shellHandle);
        int clientWidth = (int)OS.FrameworkElement_ActualWidth(this.handle);
        int clientHeight = (int)OS.FrameworkElement_ActualHeight(this.handle);
        int point = OS.gcnew_Point(clientX, clientY);
        int result = OS.Visual_PointFromScreen(this.shellHandle, point);
        OS.GCHandle_Free(point);
        clientX = -((int)OS.Point_X(result));
        clientY = -((int)OS.Point_Y(result));
        OS.GCHandle_Free(result);
        return new Rectangle(x -= clientX, y -= clientY, width += w - clientWidth, height += h - clientHeight);
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.shellHandle);
    }

    void destroyWidget() {
        if (this.shellHandle != 0 && !this.closing) {
            if ((this.style & 0x4000) != 0) {
                OS.Popup_IsOpen(this.shellHandle, false);
            } else {
                OS.Window_Close(this.shellHandle);
            }
        }
        this.releaseHandle();
    }

    public void dispose() {
        super.dispose();
    }

    Control findBackgroundControl() {
        return this.background != -1 || this.backgroundImage != null ? this : null;
    }

    Control findThemeControl() {
        return null;
    }

    public void forceActive() {
        this.checkWidget();
        if (!this.isVisible()) {
            return;
        }
        if ((this.style & 0x4000) != 0) {
            return;
        }
        OS.Window_Activate(this.shellHandle);
    }

    public int getAlpha() {
        this.checkWidget();
        return 255;
    }

    public Rectangle getBounds() {
        int y;
        int x;
        this.checkWidget();
        if ((this.style & 0x4000) != 0) {
            x = (int)OS.Popup_HorizontalOffset(this.shellHandle);
            y = (int)OS.Popup_VerticalOffset(this.shellHandle);
        } else {
            x = (int)OS.Window_Left(this.shellHandle);
            y = (int)OS.Window_Top(this.shellHandle);
        }
        int renderSize = OS.UIElement_RenderSize(this.shellHandle);
        int width = (int)OS.Size_Width(renderSize);
        int height = (int)OS.Size_Height(renderSize);
        OS.GCHandle_Free(renderSize);
        return new Rectangle(x, y, width, height);
    }

    public boolean getFullScreen() {
        this.checkWidget();
        return this.fullScreen;
    }

    public int getImeInputMode() {
        this.checkWidget();
        return 32;
    }

    public Point getLocation() {
        int y;
        int x;
        this.checkWidget();
        if ((this.style & 0x4000) != 0) {
            x = (int)OS.Popup_HorizontalOffset(this.shellHandle);
            y = (int)OS.Popup_VerticalOffset(this.shellHandle);
        } else {
            x = (int)OS.Window_Left(this.shellHandle);
            y = (int)OS.Window_Top(this.shellHandle);
        }
        return new Point(x, y);
    }

    public boolean getMaximized() {
        this.checkWidget();
        return !this.fullScreen && super.getMaximized();
    }

    public Point getMinimumSize() {
        this.checkWidget();
        int width = (int)OS.FrameworkElement_MinWidth(this.shellHandle);
        int height = (int)OS.FrameworkElement_MinHeight(this.shellHandle);
        return new Point(width, height);
    }

    public boolean getModified() {
        this.checkWidget();
        return this.modified;
    }

    public Region getRegion() {
        this.checkWidget();
        return this.region;
    }

    public Shell getShell() {
        this.checkWidget();
        return this;
    }

    public boolean getVisible() {
        this.checkWidget();
        if ((this.style & 0x4000) != 0) {
            return OS.Popup_IsOpen(this.shellHandle);
        }
        return super.getVisible();
    }

    public Shell[] getShells() {
        this.checkWidget();
        int count = 0;
        Shell[] shells = this.display.getShells();
        int i = 0;
        while (i < shells.length) {
            Composite shell = shells[i];
            while ((shell = shell.parent) != null && shell != this) {
            }
            if (shell == this) {
                ++count;
            }
            ++i;
        }
        int index = 0;
        Shell[] result = new Shell[count];
        int i2 = 0;
        while (i2 < shells.length) {
            Composite shell = shells[i2];
            while ((shell = shell.parent) != null && shell != this) {
            }
            if (shell == this) {
                result[index++] = shells[i2];
            }
            ++i2;
        }
        return result;
    }

    Composite findDeferredControl() {
        return this.layoutCount > 0 ? this : null;
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled();
    }

    void hookEvents() {
        super.hookEvents();
        int handler = OS.gcnew_SizeChangedEventHandler(this.jniRef, "HandleSizeChanged");
        OS.FrameworkElement_SizeChanged(this.shellHandle, handler);
        OS.GCHandle_Free(handler);
        if ((this.style & 0x4000) != 0) {
            handler = OS.gcnew_EventHandler(this.jniRef, "HandleClosed");
            OS.Popup_Closed(this.shellHandle, handler);
            OS.GCHandle_Free(handler);
            handler = OS.gcnew_KeyboardFocusChangedEventHandler(this.jniRef, "HandlePreviewGotKeyboardFocusActivate");
            OS.UIElement_PreviewGotKeyboardFocus(this.shellHandle, handler);
            OS.GCHandle_Free(handler);
            handler = OS.gcnew_KeyboardFocusChangedEventHandler(this.jniRef, "HandleLostKeyboardFocusDeactivate");
            OS.UIElement_LostKeyboardFocus(this.shellHandle, handler);
            OS.GCHandle_Free(handler);
        } else {
            handler = OS.gcnew_CancelEventHandler(this.jniRef, "HandleClosing");
            OS.Window_Closing(this.shellHandle, handler);
            OS.GCHandle_Free(handler);
            handler = OS.gcnew_EventHandler(this.jniRef, "HandleActivated");
            OS.Window_Activated(this.shellHandle, handler);
            OS.GCHandle_Free(handler);
            handler = OS.gcnew_EventHandler(this.jniRef, "HandleDeactivated");
            OS.Window_Deactivated(this.shellHandle, handler);
            OS.GCHandle_Free(handler);
            handler = OS.gcnew_EventHandler(this.jniRef, "HandleLocationChanged");
            OS.Window_LocationChanged(this.shellHandle, handler);
            OS.GCHandle_Free(handler);
        }
    }

    void HandleActivated(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        this.sendEvent(26);
        if (this.isDisposed()) {
            return;
        }
        this.restoreFocus();
    }

    void HandleClosed(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        this.closing = true;
        this.sendEvent(21);
        this.closing = false;
    }

    void HandleClosing(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        this.closing = true;
        boolean doit = false;
        if (this.isEnabled()) {
            Event event = new Event();
            this.sendEvent(21, event);
            boolean bl = doit = event.doit || this.isDisposed();
        }
        if (doit) {
            if (this.shellHandle != 0) {
                OS.Window_Owner(this.shellHandle, 0);
            }
            if (!this.isDisposed()) {
                this.release(false);
            }
        } else {
            OS.CancelEventArgs_Cancel(e, true);
        }
        this.closing = false;
    }

    void HandleDeactivated(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        this.sendEvent(27);
        if (this.isDisposed()) {
            return;
        }
        this.saveFocus();
    }

    void HandleLocationChanged(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        int x = (int)OS.Window_Left(this.shellHandle);
        int y = (int)OS.Window_Top(this.shellHandle);
        if (!this.moved || this.oldX != x || this.oldY != y) {
            this.moved = true;
            this.oldX = x;
            this.oldY = y;
            this.sendEvent(10);
        }
    }

    void HandleLostKeyboardFocusDeactivate(int sender, int e) {
        if (this.isDisposed()) {
            return;
        }
        if (OS.UIElement_IsKeyboardFocusWithin(this.handle)) {
            return;
        }
        this.sendEvent(27);
    }

    void HandleMouseLeave(int sender, int e) {
        super.HandleMouseLeave(sender, e);
        if (!this.checkEvent(e)) {
            return;
        }
        this.display.mouseControl = null;
    }

    void HandlePreviewGotKeyboardFocusActivate(int sender, int e) {
        if (this.isDisposed()) {
            return;
        }
        if (!OS.UIElement_IsKeyboardFocusWithin(this.handle)) {
            return;
        }
        this.sendEvent(26);
    }

    void HandleSizeChanged(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        int width = (int)OS.FrameworkElement_ActualWidth(this.shellHandle);
        int height = (int)OS.FrameworkElement_ActualHeight(this.shellHandle);
        if (!this.resized || this.oldWidth != width || this.oldHeight != height) {
            this.resized = true;
            this.oldWidth = width;
            this.oldHeight = height;
            this.sendEvent(11);
            if (this.isDisposed()) {
                return;
            }
            if (this.layout != null) {
                this.markLayout(false, false);
                this.updateLayout(false, false);
            }
        }
    }

    public void open() {
        this.checkWidget();
        this.bringToTop();
        if (this.isDisposed()) {
            return;
        }
        this.setVisible(true);
        if (this.isDisposed()) {
            return;
        }
        if (!this.restoreFocus() && !this.traverseGroup(true)) {
            this.setFocus();
        }
    }

    public boolean print(GC gc) {
        this.checkWidget();
        if (gc == null) {
            this.error(4);
        }
        if (gc.isDisposed()) {
            this.error(5);
        }
        return false;
    }

    void register() {
        super.register();
        this.display.addWidget(this.shellHandle, this);
    }

    void releaseChildren(boolean destroy) {
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (shell != null && !shell.isDisposed()) {
                shell.release((this.style & 0x4000) != 0);
            }
            ++i;
        }
        super.releaseChildren(destroy);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.shellHandle != 0) {
            OS.GCHandle_Free(this.shellHandle);
        }
        this.shellHandle = 0;
    }

    void releaseParent() {
    }

    void releaseWidget() {
        super.releaseWidget();
        this.display.clearModal(this);
        this.display.removeShell(this);
    }

    public void removeShellListener(ShellListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(21, listener);
        this.eventTable.unhook(19, listener);
        this.eventTable.unhook(20, listener);
        this.eventTable.unhook(26, listener);
        this.eventTable.unhook(27, listener);
    }

    public void setActive() {
        this.checkWidget();
        if (!this.isVisible()) {
            return;
        }
        this.bringToTop();
    }

    void setActiveControl(Control control) {
        if (control != null && control.isDisposed()) {
            control = null;
        }
        if (this.lastActive != null && this.lastActive.isDisposed()) {
            this.lastActive = null;
        }
        if (this.lastActive == control) {
            return;
        }
        Control[] activate = control == null ? new Control[]{} : control.getPath();
        Control[] deactivate = this.lastActive == null ? new Control[]{} : this.lastActive.getPath();
        this.lastActive = control;
        int index = 0;
        int length = Math.min(activate.length, deactivate.length);
        while (index < length) {
            if (activate[index] != deactivate[index]) break;
            ++index;
        }
        int i = deactivate.length - 1;
        while (i >= index) {
            if (!deactivate[i].isDisposed()) {
                deactivate[i].sendEvent(27);
            }
            --i;
        }
        i = activate.length - 1;
        while (i >= index) {
            if (!activate[i].isDisposed()) {
                activate[i].sendEvent(26);
            }
            --i;
        }
    }

    public void setAlpha(int alpha) {
        this.checkWidget();
    }

    int setBounds(int x, int y, int width, int height, int flags) {
        if (this.fullScreen) {
            this.setFullScreen(false);
        }
        int result = 0;
        if ((flags & 0x2000) != 0) {
            int currentY;
            int currentX;
            if ((this.style & 0x4000) != 0) {
                currentX = (int)OS.Popup_HorizontalOffset(this.shellHandle);
                currentY = (int)OS.Popup_VerticalOffset(this.shellHandle);
            } else {
                currentX = (int)OS.Window_Left(this.shellHandle);
                currentY = (int)OS.Window_Top(this.shellHandle);
            }
            if (currentX != x || currentY != y) {
                this.moved = true;
                this.oldX = x;
                this.oldY = currentY;
                if ((this.style & 0x4000) != 0) {
                    OS.Popup_HorizontalOffset(this.shellHandle, x);
                    this.oldY = y;
                    OS.Popup_VerticalOffset(this.shellHandle, y);
                } else {
                    OS.Window_Left(this.shellHandle, x);
                    this.oldY = y;
                    OS.Window_Top(this.shellHandle, y);
                }
                this.sendEvent(10);
                if (this.isDisposed()) {
                    return 0;
                }
                result |= 0x2000;
            }
        }
        if ((flags & 0x4000) != 0) {
            int currentWidth = (int)OS.FrameworkElement_ActualWidth(this.shellHandle);
            int currentHeight = (int)OS.FrameworkElement_ActualHeight(this.shellHandle);
            if (currentWidth != width || currentHeight != height) {
                this.resized = true;
                this.oldWidth = width;
                this.oldHeight = currentHeight;
                OS.FrameworkElement_Width(this.shellHandle, width);
                this.oldHeight = height;
                OS.FrameworkElement_Height(this.shellHandle, height);
                this.sendEvent(11);
                if (this.isDisposed()) {
                    return 0;
                }
                result |= 0x4000;
                if (this.layout != null) {
                    this.markLayout(false, false);
                    this.updateLayout(false, false);
                }
            }
        }
        return result;
    }

    void setClipping() {
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if (enabled == this.getEnabled()) {
            return;
        }
        super.setEnabled(enabled);
        if ((this.style & 0x4000) != 0) {
            return;
        }
        if (enabled && OS.Window_IsActive(this.shellHandle) && !this.restoreFocus()) {
            this.traverseGroup(true);
        }
    }

    public void setFullScreen(boolean fullScreen) {
        this.checkWidget();
        if (this.fullScreen == fullScreen) {
            return;
        }
        if (fullScreen) {
            this.oldWindowStyle = OS.Window_WindowStyle(this.shellHandle);
            this.oldWindowState = OS.Window_WindowState(this.shellHandle);
            boolean visible = this.getVisible();
            OS.Window_Hide(this.shellHandle);
            OS.Window_WindowStyle(this.shellHandle, 0);
            if (visible) {
                OS.Window_Show(this.shellHandle);
            }
            OS.Window_WindowState(this.shellHandle, 2);
        } else {
            OS.Window_WindowStyle(this.shellHandle, this.oldWindowStyle);
            OS.Window_WindowState(this.shellHandle, this.oldWindowState);
            this.oldWindowState = 0;
            this.oldWindowStyle = 0;
        }
        this.fullScreen = fullScreen;
    }

    public void setImeInputMode(int mode) {
        this.checkWidget();
    }

    public void setMinimumSize(int width, int height) {
        this.checkWidget();
        int widthLimit = 0;
        int heightLimit = 0;
        int trim = 1248;
        if ((this.style & 8) == 0) {
            // empty if block
        }
        int minWidth = Math.max(widthLimit, width);
        int minHeight = Math.max(heightLimit, height);
        OS.FrameworkElement_MinWidth(this.shellHandle, minWidth);
        OS.FrameworkElement_MinHeight(this.shellHandle, minHeight);
    }

    public void setMinimumSize(Point size) {
        this.checkWidget();
        if (size == null) {
            this.error(4);
        }
        this.setMinimumSize(size.x, size.y);
    }

    public void setModified(boolean modified) {
        this.checkWidget();
        this.modified = modified;
    }

    void setParent() {
    }

    public void setRegion(Region region) {
        this.checkWidget();
        if ((this.style & 8) == 0) {
            return;
        }
        super.setRegion(region);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (this.getVisible() == visible) {
            return;
        }
        int mask = 229376;
        if ((this.style & mask) != 0) {
            if (visible) {
                this.display.setModalShell(this);
            } else {
                this.display.clearModal(this);
            }
        } else {
            this.updateModal();
        }
        if (visible) {
            if (this.center && !this.moved) {
                this.center();
                if (this.isDisposed()) {
                    return;
                }
            }
            if ((this.style & 0x4000) != 0) {
                OS.Popup_IsOpen(this.shellHandle, visible);
            } else {
                OS.Window_Show(this.shellHandle);
            }
            this.opened = true;
            if (!this.moved) {
                this.moved = true;
                Point location = this.getLocation();
                this.oldX = location.x;
                this.oldY = location.y;
                this.sendEvent(10);
                if (this.isDisposed()) {
                    return;
                }
            }
            if (!this.resized) {
                this.resized = true;
                Point size = this.getSize();
                this.oldWidth = size.x;
                this.oldHeight = size.y;
                this.sendEvent(11);
                if (this.isDisposed()) {
                    return;
                }
                if (this.layout != null) {
                    this.markLayout(false, false);
                    this.updateLayout(false, false);
                }
            }
        } else if (!this.closing) {
            if ((this.style & 0x4000) != 0) {
                OS.Popup_IsOpen(this.shellHandle, visible);
            } else {
                OS.Window_Hide(this.shellHandle);
            }
        }
    }

    int topHandle() {
        return this.shellHandle;
    }

    boolean traverseEscape() {
        if (this.parent == null) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        this.close();
        return true;
    }

    void updateModal() {
        int source = OS.PresentationSource_FromVisual(this.handle);
        if (source != 0) {
            int hwnd = OS.HwndSource_Handle(source);
            Win32.EnableWindow(OS.IntPtr_ToInt32(hwnd), this.isActive());
            OS.GCHandle_Free(hwnd);
            OS.GCHandle_Free(source);
        }
    }
}

