/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Combo
extends Composite {
    int textHandle;
    boolean ignoreSelection;
    public static final int LIMIT = Integer.MAX_VALUE;

    public Combo(Composite parent, int style) {
        super(parent, Combo.checkStyle(style));
        this.style |= 0x100;
    }

    Control[] _getChildren() {
        return new Control[0];
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int itemHandle = OS.gcnew_ComboBoxItem();
        int strPtr = this.createDotNetString(string, false);
        OS.ContentControl_Content(itemHandle, strPtr);
        OS.GCHandle_Free(strPtr);
        int itemCollection = OS.ItemsControl_Items(this.handle);
        OS.ItemCollection_Add(itemCollection, itemHandle);
        OS.GCHandle_Free(itemCollection);
        OS.GCHandle_Free(itemHandle);
    }

    public void add(String string, int index) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (index < 0) {
            this.error(5);
        }
        int items = OS.ItemsControl_Items(this.handle);
        int count = OS.ItemCollection_Count(items);
        OS.GCHandle_Free(items);
        if (index > count) {
            this.error(5);
        }
        int itemHandle = OS.gcnew_ComboBoxItem();
        int strPtr = this.createDotNetString(string, false);
        OS.ContentControl_Content(itemHandle, strPtr);
        OS.GCHandle_Free(strPtr);
        int itemCollection = OS.ItemsControl_Items(this.handle);
        OS.ItemCollection_Insert(itemCollection, index, itemHandle);
        OS.GCHandle_Free(itemCollection);
        OS.GCHandle_Free(itemHandle);
    }

    void addChild(Control control) {
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(25, typedListener);
    }

    void addWidget() {
        super.addWidget();
        if ((this.style & 8) == 0) {
            this.updateLayout(this.handle);
            int name = this.createDotNetString("PART_EditableTextBox", false);
            int template = OS.Control_Template(this.handle);
            this.textHandle = OS.FrameworkTemplate_FindName(template, name, this.handle);
            OS.GCHandle_Free(name);
            OS.GCHandle_Free(template);
        }
    }

    int backgroundProperty() {
        return OS.Control_BackgroundProperty();
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    static int checkStyle(int style) {
        style &= 0xFFFFF7FF;
        style &= 0xFFFFFCFF;
        if (((style = Combo.checkBits(style, 4, 64, 0, 0, 0, 0)) & 0x40) != 0) {
            return style & 0xFFFFFFF7;
        }
        return style;
    }

    public void clearSelection() {
        this.checkWidget();
        if ((this.style & 8) == 0) {
            OS.TextBox_Select(this.textHandle, 0, 0);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int availSize;
        this.checkWidget();
        this.ignoreSelection = true;
        int itemCount = this.getItemCount();
        int text = 0;
        if (this.textHandle != 0) {
            text = OS.TextBox_Text(this.textHandle);
        }
        int selectedIndex = OS.Selector_SelectedIndex(this.handle);
        int width = wHint;
        int height = hHint;
        if (wHint == -1) {
            width = Integer.MAX_VALUE;
        }
        if (hHint == -1) {
            height = Integer.MAX_VALUE;
        }
        if ((availSize = OS.gcnew_Size(width = Math.max(0, width), height = Math.max(0, height))) == 0) {
            this.error(2);
        }
        double requestWidth = OS.FrameworkElement_Width(this.handle);
        double requestHeight = OS.FrameworkElement_Height(this.handle);
        int widthDP = OS.FrameworkElement_WidthProperty();
        int heightDP = OS.FrameworkElement_HeightProperty();
        OS.DependencyObject_ClearValue(this.handle, widthDP);
        OS.DependencyObject_ClearValue(this.handle, heightDP);
        OS.UIElement_Measure(this.handle, availSize);
        int size = OS.UIElement_DesiredSize(this.handle);
        width = (int)OS.Size_Width(size);
        height = (int)OS.Size_Height(size);
        OS.GCHandle_Free(size);
        int i = 0;
        while (i < itemCount) {
            OS.Selector_SelectedIndex(this.handle, i);
            this.updateLayout(this.handle);
            OS.UIElement_Measure(this.handle, availSize);
            size = OS.UIElement_DesiredSize(this.handle);
            width = Math.max(width, (int)OS.Size_Width(size));
            height = Math.max(height, (int)OS.Size_Height(size));
            OS.GCHandle_Free(size);
            ++i;
        }
        OS.GCHandle_Free(availSize);
        OS.FrameworkElement_Width(this.handle, requestWidth);
        OS.FrameworkElement_Height(this.handle, requestHeight);
        OS.Selector_SelectedIndex(this.handle, selectedIndex);
        if (this.textHandle != 0) {
            OS.TextBox_Text(this.textHandle, text);
            OS.GCHandle_Free(text);
        }
        OS.GCHandle_Free(widthDP);
        OS.GCHandle_Free(heightDP);
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        this.ignoreSelection = false;
        return new Point(width, height);
    }

    public void copy() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        OS.TextBoxBase_Copy(this.textHandle);
    }

    void createHandle() {
        this.handle = OS.gcnew_ComboBox();
        if (this.handle == 0) {
            this.error(2);
        }
        if ((this.style & 8) == 0) {
            OS.ComboBox_IsEditable(this.handle, true);
            OS.ItemsControl_IsTextSearchEnabled(this.handle, false);
        }
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        OS.TextBoxBase_Cut(this.textHandle);
    }

    public void deselect(int index) {
        this.checkWidget();
        this.ignoreSelection = true;
        int selected = OS.Selector_SelectedIndex(this.handle);
        if (selected == index) {
            OS.Selector_SelectedIndex(this.handle, -1);
        }
        this.ignoreSelection = false;
    }

    public void deselectAll() {
        this.checkWidget();
        this.ignoreSelection = true;
        OS.Selector_SelectedIndex(this.handle, -1);
        this.ignoreSelection = false;
    }

    public String getItem(int index) {
        this.checkWidget();
        int count = this.getItemCount();
        if (index < 0 || index >= count) {
            this.error(6);
        }
        int itemCollection = OS.ItemsControl_Items(this.handle);
        int comboBoxItem = OS.ItemCollection_GetItemAt(itemCollection, index);
        OS.GCHandle_Free(itemCollection);
        int content = OS.ContentControl_Content(comboBoxItem);
        String string = Combo.createJavaString(content);
        OS.GCHandle_Free(comboBoxItem);
        OS.GCHandle_Free(content);
        return string;
    }

    public int getItemCount() {
        this.checkWidget();
        int itemCollection = OS.ItemsControl_Items(this.handle);
        int count = OS.ItemCollection_Count(itemCollection);
        OS.GCHandle_Free(itemCollection);
        return count;
    }

    public int getItemHeight() {
        this.checkWidget();
        int result = 0;
        return result;
    }

    public String[] getItems() {
        this.checkWidget();
        int count = this.getItemCount();
        String[] result = new String[count];
        int i = 0;
        while (i < count) {
            result[i] = this.getItem(i);
            ++i;
        }
        return result;
    }

    public boolean getListVisible() {
        this.checkWidget();
        return OS.ComboBox_IsDropDownOpen(this.handle);
    }

    String getNameText() {
        return this.getText();
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Point getSelection() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return new Point(0, 0);
        }
        int start = OS.TextBox_SelectionStart(this.textHandle);
        int length = OS.TextBox_SelectionLength(this.textHandle);
        return new Point(start, start + length);
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return OS.Selector_SelectedIndex(this.handle);
    }

    public String getText() {
        String text;
        this.checkWidget();
        if ((this.style & 8) != 0) {
            int item = OS.ComboBox_SelectionBoxItem(this.handle);
            text = Combo.createJavaString(item);
            OS.GCHandle_Free(item);
        } else {
            int content = OS.TextBox_Text(this.textHandle);
            text = Combo.createJavaString(content);
            OS.GCHandle_Free(content);
        }
        return text;
    }

    public int getTextHeight() {
        this.checkWidget();
        if (this.textHandle != 0) {
            return (int)OS.FrameworkElement_ActualHeight(this.textHandle);
        }
        return 0;
    }

    public int getTextLimit() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return LIMIT;
        }
        return OS.TextBox_MaxLength(this.textHandle);
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        return 0;
    }

    void HandleSelectionChanged(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        if (!this.ignoreSelection) {
            this.postEvent(13);
        }
    }

    void HandlePreviewExecutedRoutedEvent(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        int command = OS.ExecutedRoutedEventArgs_Command(e);
        boolean doVerify = false;
        String input = null;
        int paste = OS.ApplicationCommands_Paste();
        int cut = OS.ApplicationCommands_Cut();
        int redo = OS.ApplicationCommands_Redo();
        int undo = OS.ApplicationCommands_Undo();
        int backspace = OS.EditingCommands_Backspace();
        int delete = OS.EditingCommands_Delete();
        int deleteNext = OS.EditingCommands_DeleteNextWord();
        int deletePrevious = OS.EditingCommands_DeletePreviousWord();
        if (OS.Object_Equals(command, paste)) {
            doVerify = true;
            int clipboardText = OS.Clipboard_GetText();
            input = Combo.createJavaString(clipboardText);
            OS.GCHandle_Free(clipboardText);
        } else if (OS.Object_Equals(command, cut)) {
            doVerify = true;
            int content = OS.TextBox_SelectedText(this.textHandle);
            input = Combo.createJavaString(content);
            OS.GCHandle_Free(content);
        } else if (OS.Object_Equals(command, redo)) {
            OS.ExecutedRoutedEventArgs_Handled(e, true);
        } else if (OS.Object_Equals(command, undo)) {
            OS.ExecutedRoutedEventArgs_Handled(e, true);
        } else if (OS.Object_Equals(command, backspace)) {
            doVerify = true;
            input = "";
        } else if (OS.Object_Equals(command, delete)) {
            doVerify = true;
            input = "";
        } else if (OS.Object_Equals(command, deleteNext)) {
            OS.ExecutedRoutedEventArgs_Handled(e, true);
        } else if (OS.Object_Equals(command, deletePrevious)) {
            OS.ExecutedRoutedEventArgs_Handled(e, true);
        }
        OS.GCHandle_Free(paste);
        OS.GCHandle_Free(cut);
        OS.GCHandle_Free(redo);
        OS.GCHandle_Free(undo);
        OS.GCHandle_Free(backspace);
        OS.GCHandle_Free(delete);
        OS.GCHandle_Free(deleteNext);
        OS.GCHandle_Free(deletePrevious);
        OS.GCHandle_Free(command);
        if (!this.hooks(25)) {
            return;
        }
        if (!doVerify) {
            return;
        }
        String text = this.verifyText(input);
        if (text != null && !text.equals(input)) {
            int strPtr = this.createDotNetString(text, false);
            OS.TextBox_SelectedText(this.textHandle, strPtr);
            OS.GCHandle_Free(strPtr);
            int start = OS.TextBox_SelectionStart(this.textHandle);
            int length = OS.TextBox_SelectionLength(this.textHandle);
            OS.TextBox_Select(this.textHandle, start + length, 0);
            OS.TextBox_SelectionLength(this.textHandle, 0);
            text = null;
        }
        if (text == null) {
            OS.ExecutedRoutedEventArgs_Handled(e, true);
        }
    }

    void HandlePreviewKeyDown(int sender, int e) {
        super.HandlePreviewKeyDown(sender, e);
        if (!this.checkEvent(e)) {
            return;
        }
        int key = OS.KeyEventArgs_Key(e);
        if (key == 6) {
            this.postEvent(14);
        }
    }

    void HandlePreviewTextInput(int sender, int e) {
        super.HandlePreviewTextInput(sender, e);
        if (!this.checkEvent(e)) {
            return;
        }
        int textPtr = OS.TextCompositionEventArgs_Text(e);
        String input = Combo.createJavaString(textPtr);
        OS.GCHandle_Free(textPtr);
        String text = this.verifyText(input);
        if (text != null && !text.equals(input)) {
            textPtr = this.createDotNetString(text, false);
            OS.TextBox_SelectedText(this.textHandle, textPtr);
            OS.GCHandle_Free(textPtr);
            int start = OS.TextBox_SelectionStart(this.textHandle);
            int length = OS.TextBox_SelectionLength(this.textHandle);
            OS.TextBox_Select(this.textHandle, start + length, 0);
            OS.TextBox_SelectionLength(this.textHandle, 0);
            text = null;
        }
        if (text == null) {
            OS.TextCompositionEventArgs_Handled(e, true);
        }
    }

    void HandleTextChanged(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        this.sendEvent(24);
    }

    void hookEvents() {
        super.hookEvents();
        int handler = OS.gcnew_SelectionChangedEventHandler(this.jniRef, "HandleSelectionChanged");
        OS.Selector_SelectionChanged(this.handle, handler);
        OS.GCHandle_Free(handler);
        if (this.textHandle != 0) {
            handler = OS.gcnew_ExecutedRoutedEventHandler(this.jniRef, "HandlePreviewExecutedRoutedEvent");
            if (handler == 0) {
                this.error(2);
            }
            OS.CommandManager_AddPreviewExecutedHandler(this.textHandle, handler);
            OS.GCHandle_Free(handler);
            handler = OS.gcnew_TextChangedEventHandler(this.jniRef, "HandleTextChanged");
            if (handler == 0) {
                this.error(2);
            }
            OS.TextBoxBase_TextChanged(this.textHandle, handler);
            OS.GCHandle_Free(handler);
        }
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int start) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int count = this.getItemCount();
        if (start < 0 || start >= count) {
            return -1;
        }
        start = Math.max(start, 0);
        int strPtr = this.createDotNetString(string, false);
        int itemCollection = OS.ItemsControl_Items(this.handle);
        int index = -1;
        while (start < count && index == -1) {
            int item = OS.ItemCollection_GetItemAt(itemCollection, start);
            int itemContent = OS.ContentControl_Content(item);
            OS.GCHandle_Free(item);
            if (itemContent != 0 && OS.Object_Equals(itemContent, strPtr)) {
                index = start;
            }
            OS.GCHandle_Free(itemContent);
            ++start;
        }
        OS.GCHandle_Free(strPtr);
        OS.GCHandle_Free(itemCollection);
        return index;
    }

    public void paste() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        OS.TextBoxBase_Paste(this.textHandle);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.textHandle != 0) {
            OS.GCHandle_Free(this.textHandle);
        }
        this.textHandle = 0;
    }

    public void remove(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.getItemCount()) {
            this.error(6);
        }
        int itemCollection = OS.ItemsControl_Items(this.handle);
        OS.ItemCollection_RemoveAt(itemCollection, index);
        OS.GCHandle_Free(itemCollection);
    }

    public void remove(int start, int end) {
        this.checkWidget();
        int count = this.getItemCount();
        if (start < 0 || start >= count) {
            this.error(6);
        }
        if (end < 0 || end >= count) {
            this.error(6);
        }
        int itemCollection = OS.ItemsControl_Items(this.handle);
        int i = end;
        while (i >= start) {
            OS.ItemCollection_RemoveAt(itemCollection, i);
            --i;
        }
        OS.GCHandle_Free(itemCollection);
    }

    public void remove(String string) {
        int index;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((index = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(index);
    }

    public void removeAll() {
        this.checkWidget();
        int itemCollection = OS.ItemsControl_Items(this.handle);
        this.ignoreSelection = true;
        OS.ItemCollection_Clear(itemCollection);
        this.ignoreSelection = false;
        OS.GCHandle_Free(itemCollection);
    }

    void removeChild(Control control) {
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, listener);
    }

    public void select(int index) {
        this.checkWidget();
        int itemCollection = OS.ItemsControl_Items(this.handle);
        int count = OS.ItemCollection_Count(itemCollection);
        OS.GCHandle_Free(itemCollection);
        if (index >= 0 && index < count) {
            this.ignoreSelection = true;
            OS.Selector_SelectedIndex(this.handle, index);
            this.ignoreSelection = false;
        }
    }

    void setForegroundBrush(int brush) {
        if (brush != 0) {
            OS.Control_Foreground(this.handle, brush);
        } else {
            int property = OS.Control_ForegroundProperty();
            OS.DependencyObject_ClearValue(this.handle, property);
            OS.GCHandle_Free(property);
        }
    }

    public void setItem(int index, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (index < 0 || index >= this.getItemCount()) {
            this.error(6);
        }
        int itemCollection = OS.ItemsControl_Items(this.handle);
        int item = OS.ItemCollection_GetItemAt(itemCollection, index);
        OS.GCHandle_Free(itemCollection);
        int strPtr = this.createDotNetString(string, false);
        OS.ContentControl_Content(item, strPtr);
        OS.GCHandle_Free(strPtr);
        OS.GCHandle_Free(item);
    }

    public void setItems(String[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        int i = 0;
        while (i < items.length) {
            if (items[i] == null) {
                this.error(5);
            }
            ++i;
        }
        int itemCollection = OS.ItemsControl_Items(this.handle);
        this.ignoreSelection = true;
        OS.ItemCollection_Clear(itemCollection);
        int i2 = 0;
        while (i2 < items.length) {
            int itemHandle = OS.gcnew_ComboBoxItem();
            int strPtr = this.createDotNetString(items[i2], false);
            OS.ContentControl_Content(itemHandle, strPtr);
            OS.GCHandle_Free(strPtr);
            OS.ItemCollection_Add(itemCollection, itemHandle);
            OS.GCHandle_Free(itemHandle);
            ++i2;
        }
        this.ignoreSelection = false;
        OS.GCHandle_Free(itemCollection);
    }

    public void setListVisible(boolean visible) {
        this.checkWidget();
        OS.ComboBox_IsDropDownOpen(this.handle, visible);
    }

    public void setOrientation(int orientation) {
        this.checkWidget();
        int flowDirection = orientation == 0x4000000 ? 1 : 0;
        OS.FrameworkElement_FlowDirection(this.handle, flowDirection);
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        if (selection == null) {
            this.error(4);
        }
        int start = selection.x;
        int length = selection.y - selection.x;
        OS.TextBox_SelectionLength(this.textHandle, length);
        OS.TextBox_SelectionStart(this.textHandle, start);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 8) != 0) {
            int index = this.indexOf(string);
            if (index != -1) {
                this.select(index);
            }
            return;
        }
        int strPtr = this.createDotNetString(string, false);
        OS.TextBox_Text(this.textHandle, strPtr);
        OS.GCHandle_Free(strPtr);
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            this.error(7);
        }
        if ((this.style & 8) != 0) {
            return;
        }
        OS.TextBox_MaxLength(this.textHandle, limit);
    }

    public void setVisibleItemCount(int count) {
        this.checkWidget();
    }

    String verifyText(String text) {
        int start = OS.TextBox_SelectionStart(this.textHandle);
        int length = OS.TextBox_SelectionLength(this.textHandle);
        Event event = new Event();
        event.text = text;
        event.start = start;
        event.end = start + length + 1;
        this.sendEvent(25, event);
        if (!event.doit) {
            return null;
        }
        return event.text;
    }
}

