/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.engine;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.equinox.internal.p2.engine.ProfileXMLConstants;
import org.eclipse.equinox.internal.p2.metadata.repository.io.MetadataWriter;
import org.eclipse.equinox.internal.p2.persistence.XMLWriter;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;

public class ProfileWriter
extends MetadataWriter
implements ProfileXMLConstants {
    public ProfileWriter(OutputStream output, XMLWriter.ProcessingInstruction[] processingInstructions) throws IOException {
        super(output, processingInstructions);
    }

    public void writeProfile(IProfile profile) {
        this.start("profile");
        this.attribute("id", profile.getProfileId());
        this.attribute("timestamp", Long.toString(profile.getTimestamp()));
        IProfile parentProfile = profile.getParentProfile();
        if (parentProfile != null) {
            this.attribute("parentId", parentProfile.getProfileId());
        }
        this.writeProperties(profile.getLocalProperties());
        Collector collector = profile.query((Query)InstallableUnitQuery.ANY, new Collector(), null);
        ArrayList ius = new ArrayList(collector.toCollection());
        Collections.sort(ius, new Comparator(){

            public int compare(Object o1, Object o2) {
                IInstallableUnit iu1 = (IInstallableUnit)o1;
                IInstallableUnit iu2 = (IInstallableUnit)o2;
                int IdCompare = iu1.getId().compareTo(iu2.getId());
                if (IdCompare != 0) {
                    return IdCompare;
                }
                return iu1.getVersion().compareTo((Object)iu2.getVersion());
            }
        });
        this.writeInstallableUnits(ius.iterator(), ius.size());
        this.writeInstallableUnitsProperties(ius.iterator(), ius.size(), profile);
        this.end("profile");
        this.flush();
    }

    private void writeInstallableUnitsProperties(Iterator it, int size, IProfile profile) {
        if (size == 0) {
            return;
        }
        this.start("iusProperties");
        this.attribute("size", size);
        while (it.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)it.next();
            Map properties = profile.getInstallableUnitProperties(iu);
            if (properties.isEmpty()) continue;
            this.start("iuProperties");
            this.attribute("id", iu.getId());
            this.attribute("version", iu.getVersion().toString());
            this.writeProperties(properties);
            this.end("iuProperties");
        }
        this.end("iusProperties");
    }
}

